/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.regex.Pattern;

class ExportTestFunctions
implements CompilerPass {
    private static final Pattern TEST_FUNCTIONS_NAME_PATTERN = Pattern.compile("^(?:((\\w+\\.)+prototype\\.)*(setUpPage|setUp|shouldRunTests|tearDown|tearDownPage|test[\\w\\$]+))$");
    private AbstractCompiler compiler;
    private final String exportSymbolFunction;
    private final String exportPropertyFunction;

    ExportTestFunctions(AbstractCompiler compiler, String exportSymbolFunction, String exportPropertyFunction) {
        Preconditions.checkNotNull((Object)compiler);
        this.compiler = compiler;
        this.exportSymbolFunction = exportSymbolFunction;
        this.exportPropertyFunction = exportPropertyFunction;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, new ExportTestFunctionsNodes());
    }

    private void exportTestFunctionAsSymbol(String testFunctionName, Node node, Node scriptNode) {
        Node exportCallTarget = NodeUtil.newQName(this.compiler, this.exportSymbolFunction, node, testFunctionName);
        Node call = IR.call(exportCallTarget, new Node[0]);
        if (exportCallTarget.isName()) {
            call.putBooleanProp(50, true);
        }
        call.addChildToBack(IR.string(testFunctionName));
        call.addChildToBack(NodeUtil.newQName(this.compiler, testFunctionName, node, testFunctionName));
        Node expression = IR.exprResult(call);
        scriptNode.addChildAfter(expression, node);
        this.compiler.reportCodeChange();
    }

    private void exportTestFunctionAsProperty(String fullyQualifiedFunctionName, Node parent, Node node, Node scriptNode) {
        String testFunctionName = NodeUtil.getPrototypePropertyName(node.getFirstChild());
        String objectName = fullyQualifiedFunctionName.substring(0, fullyQualifiedFunctionName.lastIndexOf(46));
        String exportCallStr = SimpleFormat.format("%s(%s, '%s', %s);", this.exportPropertyFunction, objectName, testFunctionName, fullyQualifiedFunctionName);
        Node exportCall = this.compiler.parseSyntheticCode(exportCallStr).removeChildren();
        exportCall.useSourceInfoFromForTree(scriptNode);
        scriptNode.addChildAfter(exportCall, parent);
        this.compiler.reportCodeChange();
    }

    private static boolean isTestFunction(String functionName) {
        return functionName != null && TEST_FUNCTIONS_NAME_PATTERN.matcher(functionName).matches();
    }

    private class ExportTestFunctionsNodes
    extends NodeTraversal.AbstractShallowCallback {
        private ExportTestFunctionsNodes() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            block10: {
                block8: {
                    Node functionNode;
                    String functionName;
                    block9: {
                        if (parent == null) {
                            return;
                        }
                        if (!parent.isScript()) break block8;
                        if (!NodeUtil.isFunctionDeclaration(n)) break block9;
                        String functionName2 = NodeUtil.getFunctionName(n);
                        if (ExportTestFunctions.isTestFunction(functionName2)) {
                            ExportTestFunctions.this.exportTestFunctionAsSymbol(functionName2, n, parent);
                        }
                        break block10;
                    }
                    if (!this.isNameDeclaredFunction(n) || !ExportTestFunctions.isTestFunction(functionName = NodeUtil.getFunctionName(functionNode = n.getFirstChild().getFirstChild()))) break block10;
                    ExportTestFunctions.this.exportTestFunctionAsSymbol(functionName, n, parent);
                    break block10;
                }
                if (NodeUtil.isExprAssign(parent) && !n.getLastChild().isAssign()) {
                    String functionName;
                    Node grandparent = parent.getParent();
                    if (grandparent != null && grandparent.isScript() && ExportTestFunctions.isTestFunction(functionName = n.getFirstChild().getQualifiedName())) {
                        ExportTestFunctions.this.exportTestFunctionAsProperty(functionName, parent, n, grandparent);
                    }
                } else if (n.isObjectLit() && this.isCallTargetQName(n.getParent(), "goog.testing.testSuite")) {
                    for (Node c : n.children()) {
                        if (c.isStringKey() && !c.isQuotedString()) {
                            c.setQuotedString();
                            ExportTestFunctions.this.compiler.reportCodeChange();
                            continue;
                        }
                        if (!c.isMemberFunctionDef()) continue;
                        this.rewriteMemberDefInObjLit(c, n);
                    }
                }
            }
        }

        private void rewriteMemberDefInObjLit(Node memberDef, Node objLit) {
            String name = memberDef.getString();
            Node stringKey = IR.stringKey(name, memberDef.getFirstChild().detachFromParent());
            objLit.replaceChild(memberDef, stringKey);
            stringKey.setQuotedString();
            ExportTestFunctions.this.compiler.reportCodeChange();
        }

        private boolean isCallTargetQName(Node n, String qname) {
            return n.isCall() && n.getFirstChild().matchesQualifiedName(qname);
        }

        private boolean isNameDeclaredFunction(Node node) {
            if (!NodeUtil.isNameDeclaration(node)) {
                return false;
            }
            Node grandchild = node.getFirstChild().getFirstChild();
            return grandchild != null && grandchild.isFunction();
        }
    }
}

