/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

final class ControlFlowAnalysis
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private ControlFlowGraph<Node> cfg;
    private Map<Node, Integer> astPosition;
    private Map<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>, Integer> nodePriorities;
    private final Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> priorityComparator = new Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>(){

        @Override
        public int compare(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> a, DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> b) {
            return (Integer)ControlFlowAnalysis.this.astPosition.get(a.getValue()) - (Integer)ControlFlowAnalysis.this.astPosition.get(b.getValue());
        }
    };
    private int astPositionCounter;
    private int priorityCounter;
    private final boolean shouldTraverseFunctionsAndClasses;
    private final boolean edgeAnnotations;
    private Node root;
    private final Deque<Node> exceptionHandler = new ArrayDeque<Node>();
    private final Multimap<Node, Node> finallyMap = HashMultimap.create();

    ControlFlowAnalysis(AbstractCompiler compiler, boolean shouldTraverseFunctionsAndClasses, boolean edgeAnnotations) {
        this.compiler = compiler;
        this.shouldTraverseFunctionsAndClasses = shouldTraverseFunctionsAndClasses;
        this.edgeAnnotations = edgeAnnotations;
    }

    ControlFlowGraph<Node> getCfg() {
        return this.cfg;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument((boolean)NodeUtil.isValidCfgRoot(root), (String)"Unexpected control flow graph root %s", (Object[])new Object[]{root});
        this.root = root;
        this.astPositionCounter = 0;
        this.astPosition = new HashMap<Node, Integer>();
        this.nodePriorities = new HashMap<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>, Integer>();
        this.cfg = new AstControlFlowGraph(ControlFlowAnalysis.computeFallThrough(root), this.nodePriorities, this.edgeAnnotations);
        NodeTraversal.traverseEs6(this.compiler, root, this);
        this.astPosition.put(null, ++this.astPositionCounter);
        this.priorityCounter = 0;
        DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> entry = this.cfg.getEntry();
        this.prioritizeFromEntryNode(entry);
        if (this.shouldTraverseFunctionsAndClasses) {
            for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> diGraphNode : this.cfg.getDirectedGraphNodes()) {
                Node value = (Node)diGraphNode.getValue();
                if (value == null || !value.isFunction()) continue;
                Preconditions.checkState((!this.nodePriorities.containsKey(diGraphNode) || diGraphNode == entry ? 1 : 0) != 0);
                this.prioritizeFromEntryNode(diGraphNode);
            }
        }
        for (DiGraph.DiGraphNode diGraphNode : this.cfg.getDirectedGraphNodes()) {
            if (this.nodePriorities.containsKey(diGraphNode)) continue;
            this.nodePriorities.put(diGraphNode, ++this.priorityCounter);
        }
        this.nodePriorities.put(this.cfg.getImplicitReturn(), ++this.priorityCounter);
    }

    private void prioritizeFromEntryNode(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> entry) {
        PriorityQueue<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> worklist = new PriorityQueue<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>(10, this.priorityComparator);
        worklist.add(entry);
        while (!worklist.isEmpty()) {
            DiGraph.DiGraphNode current = (DiGraph.DiGraphNode)worklist.remove();
            if (this.nodePriorities.containsKey(current)) continue;
            this.nodePriorities.put(current, ++this.priorityCounter);
            List successors = this.cfg.getDirectedSuccNodes(current);
            worklist.addAll(successors);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        this.astPosition.put(n, this.astPositionCounter++);
        switch (n.getType()) {
            case 158: {
                return this.shouldTraverseFunctionsAndClasses;
            }
            case 105: {
                if (this.shouldTraverseFunctionsAndClasses || n == this.cfg.getEntry().getValue()) {
                    this.exceptionHandler.push(n);
                    return true;
                }
                return false;
            }
            case 77: {
                this.exceptionHandler.push(n);
                return true;
            }
        }
        if (parent != null) {
            switch (parent.getType()) {
                case 115: 
                case 163: {
                    return n == parent.getLastChild();
                }
                case 114: {
                    return n != parent.getFirstChild().getNext();
                }
                case 108: 
                case 110: 
                case 111: 
                case 113: 
                case 119: 
                case 120: 
                case 126: {
                    return n != parent.getFirstChild();
                }
                case 105: {
                    return n == parent.getLastChild();
                }
                case 4: 
                case 49: 
                case 116: 
                case 117: 
                case 118: 
                case 130: 
                case 149: 
                case 162: {
                    return false;
                }
                case 77: {
                    if ((NodeUtil.hasFinally(parent) || n != NodeUtil.getCatchBlock(parent)) && !NodeUtil.isTryFinallyNode(parent, n)) break;
                    Preconditions.checkState((this.exceptionHandler.peek() == parent ? 1 : 0) != 0);
                    this.exceptionHandler.pop();
                }
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 108: {
                this.handleIf(n);
                return;
            }
            case 113: {
                this.handleWhile(n);
                return;
            }
            case 114: {
                this.handleDo(n);
                return;
            }
            case 115: 
            case 163: {
                this.handleFor(n);
                return;
            }
            case 110: {
                this.handleSwitch(n);
                return;
            }
            case 111: {
                this.handleCase(n);
                return;
            }
            case 112: {
                this.handleDefault(n);
                return;
            }
            case 125: 
            case 132: {
                this.handleStmtList(n);
                return;
            }
            case 105: {
                this.handleFunction(n);
                return;
            }
            case 130: {
                this.handleExpr(n);
                return;
            }
            case 49: {
                this.handleThrow(n);
                return;
            }
            case 77: {
                this.handleTry(n);
                return;
            }
            case 120: {
                this.handleCatch(n);
                return;
            }
            case 116: {
                this.handleBreak(n);
                return;
            }
            case 117: {
                this.handleContinue(n);
                return;
            }
            case 4: {
                this.handleReturn(n);
                return;
            }
            case 119: {
                this.handleWith(n);
                return;
            }
            case 126: {
                return;
            }
        }
        this.handleStmt(n);
    }

    private void handleIf(Node node) {
        Node thenBlock = node.getFirstChild().getNext();
        Node elseBlock = thenBlock.getNext();
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(thenBlock));
        if (elseBlock == null) {
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
        } else {
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFallThrough(elseBlock));
        }
        this.connectToPossibleExceptionHandler(node, NodeUtil.getConditionExpression(node));
    }

    private void handleWhile(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(node.getFirstChild().getNext()));
        this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
        this.connectToPossibleExceptionHandler(node, NodeUtil.getConditionExpression(node));
    }

    private void handleDo(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(node.getFirstChild()));
        this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
        this.connectToPossibleExceptionHandler(node, NodeUtil.getConditionExpression(node));
    }

    private void handleFor(Node forNode) {
        if (NodeUtil.isForIn(forNode) || forNode.isForOf()) {
            Node item = forNode.getFirstChild();
            Node collection = item.getNext();
            Node body = collection.getNext();
            this.createEdge(collection, ControlFlowGraph.Branch.UNCOND, forNode);
            this.createEdge(forNode, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(body));
            this.createEdge(forNode, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(forNode, this));
            this.connectToPossibleExceptionHandler(forNode, collection);
        } else {
            Node init = forNode.getFirstChild();
            Node cond = init.getNext();
            Node iter = cond.getNext();
            Node body = iter.getNext();
            this.createEdge(init, ControlFlowGraph.Branch.UNCOND, forNode);
            this.createEdge(forNode, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(body));
            if (!cond.isEmpty()) {
                this.createEdge(forNode, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(forNode, this));
            }
            this.createEdge(iter, ControlFlowGraph.Branch.UNCOND, forNode);
            this.connectToPossibleExceptionHandler(init, init);
            this.connectToPossibleExceptionHandler(forNode, cond);
            this.connectToPossibleExceptionHandler(iter, iter);
        }
    }

    private void handleSwitch(Node node) {
        Node next = ControlFlowAnalysis.getNextSiblingOfType(node.getFirstChild().getNext(), 111, 124);
        if (next != null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, next);
        } else if (node.getFirstChild().getNext() != null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getFirstChild().getNext());
        } else {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        }
        this.connectToPossibleExceptionHandler(node, node.getFirstChild());
    }

    private void handleCase(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, node.getFirstChild().getNext());
        Node next = ControlFlowAnalysis.getNextSiblingOfType(node.getNext(), 111);
        if (next != null) {
            Preconditions.checkState((boolean)next.isCase());
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, next);
        } else {
            Node parent = node.getParent();
            Node deflt = ControlFlowAnalysis.getNextSiblingOfType(parent.getFirstChild().getNext(), 112);
            if (deflt != null) {
                this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, deflt);
            } else {
                this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
            }
        }
        this.connectToPossibleExceptionHandler(node, node.getFirstChild());
    }

    private void handleDefault(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getFirstChild());
    }

    private void handleWith(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getLastChild());
        this.connectToPossibleExceptionHandler(node, node.getFirstChild());
    }

    private void handleStmtList(Node node) {
        Node child;
        Node parent = node.getParent();
        if (node.isBlock() && parent != null && parent.isTry() && NodeUtil.getCatchBlock(parent) == node && !NodeUtil.hasCatchHandler(node)) {
            return;
        }
        for (child = node.getFirstChild(); child != null && child.isFunction(); child = child.getNext()) {
        }
        if (child != null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFallThrough(child));
        } else {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        }
        if (parent != null) {
            switch (parent.getType()) {
                case 77: 
                case 111: 
                case 112: {
                    break;
                }
                default: {
                    if (!node.isBlock() || !node.isSyntheticBlock()) break;
                    this.createEdge(node, ControlFlowGraph.Branch.SYN_BLOCK, ControlFlowAnalysis.computeFollowNode(node, this));
                }
            }
        }
    }

    private void handleFunction(Node node) {
        Preconditions.checkState((boolean)node.isFunction());
        Preconditions.checkState((node.getChildCount() == 3 ? 1 : 0) != 0);
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFallThrough(node.getLastChild()));
        Preconditions.checkState((this.exceptionHandler.peek() == node ? 1 : 0) != 0);
        this.exceptionHandler.pop();
    }

    private void handleExpr(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        this.connectToPossibleExceptionHandler(node, node);
    }

    private void handleThrow(Node node) {
        this.connectToPossibleExceptionHandler(node, node);
    }

    private void handleTry(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getFirstChild());
    }

    private void handleCatch(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getLastChild());
    }

    private void handleBreak(Node node) {
        String label = null;
        if (node.hasChildren()) {
            label = node.getFirstChild().getString();
        }
        Node previous = null;
        Node parent = node.getParent();
        Node cur = node;
        Node lastJump = node;
        while (!ControlFlowAnalysis.isBreakTarget(cur, label)) {
            if (cur.isTry() && NodeUtil.hasFinally(cur) && cur.getLastChild() != previous) {
                if (lastJump == node) {
                    this.createEdge(lastJump, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFallThrough(cur.getLastChild()));
                } else {
                    this.finallyMap.put((Object)lastJump, (Object)ControlFlowAnalysis.computeFallThrough(cur.getLastChild()));
                }
                lastJump = cur;
            }
            if (parent == null) {
                if (this.compiler.isIdeMode()) {
                    return;
                }
                throw new IllegalStateException("Cannot find break target.");
            }
            previous = cur;
            cur = parent;
            parent = parent.getParent();
        }
        if (lastJump == node) {
            this.createEdge(lastJump, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(cur, this));
        } else {
            this.finallyMap.put((Object)lastJump, (Object)ControlFlowAnalysis.computeFollowNode(cur, this));
        }
    }

    private void handleContinue(Node node) {
        String label = null;
        if (node.hasChildren()) {
            label = node.getFirstChild().getString();
        }
        Node previous = null;
        Node parent = node.getParent();
        Node cur = node;
        Node lastJump = node;
        while (!ControlFlowAnalysis.isContinueTarget(cur, parent, label)) {
            if (cur.isTry() && NodeUtil.hasFinally(cur) && cur.getLastChild() != previous) {
                if (lastJump == node) {
                    this.createEdge(lastJump, ControlFlowGraph.Branch.UNCOND, cur.getLastChild());
                } else {
                    this.finallyMap.put((Object)lastJump, (Object)ControlFlowAnalysis.computeFallThrough(cur.getLastChild()));
                }
                lastJump = cur;
            }
            Preconditions.checkState((parent != null ? 1 : 0) != 0, (Object)"Cannot find continue target.");
            previous = cur;
            cur = parent;
            parent = parent.getParent();
        }
        Node iter = cur;
        if (cur.getChildCount() == 4) {
            iter = cur.getFirstChild().getNext().getNext();
        }
        if (lastJump == node) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, iter);
        } else {
            this.finallyMap.put((Object)lastJump, (Object)iter);
        }
    }

    private void handleReturn(Node node) {
        Node lastJump = null;
        for (Node curHandler : this.exceptionHandler) {
            if (curHandler.isFunction()) break;
            if (!NodeUtil.hasFinally(curHandler)) continue;
            if (lastJump == null) {
                this.createEdge(node, ControlFlowGraph.Branch.UNCOND, curHandler.getLastChild());
            } else {
                this.finallyMap.put(lastJump, (Object)ControlFlowAnalysis.computeFallThrough(curHandler.getLastChild()));
            }
            lastJump = curHandler;
        }
        if (node.hasChildren()) {
            this.connectToPossibleExceptionHandler(node, node.getFirstChild());
        }
        if (lastJump == null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, null);
        } else {
            this.finallyMap.put(lastJump, null);
        }
    }

    private void handleStmt(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        this.connectToPossibleExceptionHandler(node, node);
    }

    static Node computeFollowNode(Node node, ControlFlowAnalysis cfa) {
        return ControlFlowAnalysis.computeFollowNode(node, node, cfa);
    }

    static Node computeFollowNode(Node node) {
        return ControlFlowAnalysis.computeFollowNode(node, node, null);
    }

    private static Node computeFollowNode(Node fromNode, Node node, ControlFlowAnalysis cfa) {
        Node nextSibling;
        Node parent = node.getParent();
        if (parent == null || parent.isFunction() || cfa != null && node == cfa.root) {
            return null;
        }
        switch (parent.getType()) {
            case 108: {
                return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
            }
            case 111: 
            case 112: {
                if (parent.getNext() != null) {
                    if (parent.getNext().isCase()) {
                        return parent.getNext().getFirstChild().getNext();
                    }
                    if (parent.getNext().isDefaultCase()) {
                        return parent.getNext().getFirstChild();
                    }
                    throw new IllegalStateException("Not reachable");
                }
                return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
            }
            case 115: 
            case 163: {
                if (parent.isForOf() || NodeUtil.isForIn(parent)) {
                    return parent;
                }
                return parent.getFirstChild().getNext().getNext();
            }
            case 113: 
            case 114: {
                return parent;
            }
            case 77: {
                if (parent.getFirstChild() == node) {
                    if (NodeUtil.hasFinally(parent)) {
                        return ControlFlowAnalysis.computeFallThrough(parent.getLastChild());
                    }
                    return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
                }
                if (NodeUtil.getCatchBlock(parent) == node) {
                    if (NodeUtil.hasFinally(parent)) {
                        return ControlFlowAnalysis.computeFallThrough(node.getNext());
                    }
                    return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
                }
                if (parent.getLastChild() != node) break;
                if (cfa != null) {
                    for (Node finallyNode : cfa.finallyMap.get((Object)parent)) {
                        cfa.createEdge(fromNode, ControlFlowGraph.Branch.ON_EX, finallyNode);
                    }
                }
                return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
            }
        }
        for (nextSibling = node.getNext(); nextSibling != null && nextSibling.isFunction(); nextSibling = nextSibling.getNext()) {
        }
        if (nextSibling != null) {
            return ControlFlowAnalysis.computeFallThrough(nextSibling);
        }
        return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
    }

    static Node computeFallThrough(Node n) {
        switch (n.getType()) {
            case 114: {
                return ControlFlowAnalysis.computeFallThrough(n.getFirstChild());
            }
            case 115: 
            case 163: {
                if (n.isForOf() || NodeUtil.isForIn(n)) {
                    return n.getFirstChild().getNext();
                }
                return ControlFlowAnalysis.computeFallThrough(n.getFirstChild());
            }
            case 126: {
                return ControlFlowAnalysis.computeFallThrough(n.getLastChild());
            }
        }
        return n;
    }

    private void createEdge(Node fromNode, ControlFlowGraph.Branch branch, Node toNode) {
        this.cfg.createNode(fromNode);
        this.cfg.createNode(toNode);
        this.cfg.connectIfNotFound(fromNode, branch, toNode);
    }

    private void connectToPossibleExceptionHandler(Node cfgNode, Node target) {
        if (ControlFlowAnalysis.mayThrowException(target) && !this.exceptionHandler.isEmpty()) {
            Node lastJump = cfgNode;
            for (Node handler : this.exceptionHandler) {
                if (handler.isFunction()) {
                    return;
                }
                Preconditions.checkState((boolean)handler.isTry());
                Node catchBlock = NodeUtil.getCatchBlock(handler);
                boolean lastJumpInCatchBlock = false;
                for (Node ancestor : lastJump.getAncestors()) {
                    if (ancestor == handler) break;
                    if (ancestor != catchBlock) continue;
                    lastJumpInCatchBlock = true;
                    break;
                }
                if (!NodeUtil.hasCatchHandler(catchBlock) || lastJumpInCatchBlock) {
                    if (lastJump == cfgNode) {
                        this.createEdge(cfgNode, ControlFlowGraph.Branch.ON_EX, handler.getLastChild());
                    } else {
                        this.finallyMap.put((Object)lastJump, (Object)handler.getLastChild());
                    }
                } else {
                    if (lastJump == cfgNode) {
                        this.createEdge(cfgNode, ControlFlowGraph.Branch.ON_EX, catchBlock);
                        return;
                    }
                    this.finallyMap.put((Object)lastJump, (Object)catchBlock);
                }
                lastJump = handler;
            }
        }
    }

    private static Node getNextSiblingOfType(Node first, int ... types) {
        for (Node c = first; c != null; c = c.getNext()) {
            for (int type : types) {
                if (c.getType() != type) continue;
                return c;
            }
        }
        return null;
    }

    public static boolean isBreakTarget(Node target, String label) {
        return ControlFlowAnalysis.isBreakStructure(target, label != null) && ControlFlowAnalysis.matchLabel(target.getParent(), label);
    }

    private static boolean isContinueTarget(Node target, Node parent, String label) {
        return ControlFlowAnalysis.isContinueStructure(target) && ControlFlowAnalysis.matchLabel(parent, label);
    }

    private static boolean matchLabel(Node target, String label) {
        if (label == null) {
            return true;
        }
        while (target.isLabel()) {
            if (target.getFirstChild().getString().equals(label)) {
                return true;
            }
            target = target.getParent();
        }
        return false;
    }

    public static boolean mayThrowException(Node n) {
        switch (n.getType()) {
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 49: 
            case 51: 
            case 52: 
            case 86: 
            case 102: 
            case 103: 
            case 176: {
                return true;
            }
            case 105: {
                return false;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (ControlFlowGraph.isEnteringNewCfgNode(c) || !ControlFlowAnalysis.mayThrowException(c)) continue;
            return true;
        }
        return false;
    }

    static boolean isBreakStructure(Node n, boolean labeled) {
        switch (n.getType()) {
            case 110: 
            case 113: 
            case 114: 
            case 115: 
            case 163: {
                return true;
            }
            case 77: 
            case 108: 
            case 125: {
                return labeled;
            }
        }
        return false;
    }

    static boolean isContinueStructure(Node n) {
        switch (n.getType()) {
            case 113: 
            case 114: 
            case 115: 
            case 163: {
                return true;
            }
        }
        return false;
    }

    static Node getExceptionHandler(Node n) {
        Node cur = n;
        while (!cur.isScript() && !cur.isFunction()) {
            Node catchNode = ControlFlowAnalysis.getCatchHandlerForBlock(cur);
            if (catchNode != null) {
                return catchNode;
            }
            cur = cur.getParent();
        }
        return null;
    }

    static Node getCatchHandlerForBlock(Node block) {
        if (block.isBlock() && block.getParent().isTry() && block.getParent().getFirstChild() == block) {
            for (Node s = block.getNext(); s != null; s = s.getNext()) {
                if (!NodeUtil.hasCatchHandler(s)) continue;
                return s.getFirstChild();
            }
        }
        return null;
    }

    private static class AstControlFlowGraph
    extends ControlFlowGraph<Node> {
        private final Map<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>, Integer> priorities;

        private AstControlFlowGraph(Node entry, Map<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>, Integer> priorities, boolean edgeAnnotations) {
            super(entry, true, edgeAnnotations);
            this.priorities = priorities;
        }

        @Override
        public Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> getOptionalNodeComparator(boolean isForward) {
            if (isForward) {
                return new Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>(){

                    @Override
                    public int compare(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> n1, DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> n2) {
                        return AstControlFlowGraph.this.getPosition(n1) - AstControlFlowGraph.this.getPosition(n2);
                    }
                };
            }
            return new Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>(){

                @Override
                public int compare(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> n1, DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> n2) {
                    return AstControlFlowGraph.this.getPosition(n2) - AstControlFlowGraph.this.getPosition(n1);
                }
            };
        }

        private int getPosition(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> n) {
            Integer priority = this.priorities.get(n);
            Preconditions.checkNotNull((Object)priority);
            return priority;
        }
    }
}

