/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

final class ClosureRewriteModule
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    static final DiagnosticType INVALID_MODULE_IDENTIFIER = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_MODULE_IDENTIFIER", "Module idenifiers must be string literals");
    static final DiagnosticType INVALID_REQUIRE_IDENTIFIER = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_REQUIRE_IDENTIFIER", "goog.require parameter must be a string literal.");
    static final DiagnosticType INVALID_GET_IDENTIFIER = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_GET_IDENTIFIER", "goog.module.get parameter must be a string literal.");
    static final DiagnosticType INVALID_GET_CALL_SCOPE = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_GET_CALL_SCOPE", "goog.module.get can not be called in global scope.");
    static final DiagnosticType INVALID_GET_ALIAS = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_GET_ALIAS", "goog.module.get should not be aliased.");
    private final AbstractCompiler compiler;
    private ModuleDescription current = null;

    ClosureRewriteModule(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        for (Node c = root.getFirstChild(); c != null; c = c.getNext()) {
            Preconditions.checkState((boolean)c.isScript());
            this.hotSwapScript(c, null);
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (ClosureRewriteModule.isModuleFile(n) || ClosureRewriteModule.isLoadModuleCall(n)) {
            this.enterModule(n);
        }
        if (ClosureRewriteModule.isGetModuleCall(n)) {
            this.rewriteGetModuleCall(t, n);
        }
        if (this.inModule()) {
            switch (n.getType()) {
                case 132: {
                    this.current.moduleScope = t.getScope();
                    break;
                }
                case 125: {
                    if (this.current.moduleScopeRoot != parent || !parent.isFunction()) break;
                    this.current.moduleScope = t.getScope();
                    break;
                }
                case 86: {
                    if (!ClosureRewriteModule.isGetModuleCallAlias(n)) break;
                    this.rewriteGetModuleCallAlias(t, n);
                    break;
                }
                default: {
                    if (this.current.moduleScopeRoot != parent || !parent.isBlock()) break;
                    this.current.moduleScope = t.getScope();
                }
            }
        }
        return true;
    }

    private static boolean isCallTo(Node n, String qname) {
        return n.isCall() && n.getFirstChild().matchesQualifiedName(qname);
    }

    private static boolean isLoadModuleCall(Node n) {
        return ClosureRewriteModule.isCallTo(n, "goog.loadModule");
    }

    private static boolean isGetModuleCall(Node n) {
        return ClosureRewriteModule.isCallTo(n, "goog.module.get");
    }

    private void rewriteGetModuleCall(NodeTraversal t, Node n) {
        Node namespace = n.getFirstChild().getNext();
        if (!namespace.isString()) {
            t.report(namespace, INVALID_GET_IDENTIFIER, new String[0]);
            return;
        }
        if (!this.inModule() && t.inGlobalScope()) {
            t.report(namespace, INVALID_GET_CALL_SCOPE, new String[0]);
            return;
        }
        Node replacement = NodeUtil.newQName(this.compiler, namespace.getString());
        replacement.srcrefTree(namespace);
        n.getParent().replaceChild(n, replacement);
        this.compiler.reportCodeChange();
    }

    private void rewriteGetModuleCallAlias(NodeTraversal t, Node n) {
        Preconditions.checkArgument((boolean)NodeUtil.isExprAssign(n.getParent()));
        Preconditions.checkArgument((boolean)n.getFirstChild().isName());
        Preconditions.checkArgument((boolean)ClosureRewriteModule.isGetModuleCall(n.getLastChild()));
        this.rewriteGetModuleCall(t, n.getLastChild());
        String aliasName = n.getFirstChild().getQualifiedName();
        Var alias = t.getScope().getVar(aliasName);
        if (alias == null) {
            t.report(n, INVALID_GET_ALIAS, new String[0]);
            return;
        }
        Node forwardDeclareCall = NodeUtil.getRValueOfLValue(alias.getNode());
        if (forwardDeclareCall == null || !ClosureRewriteModule.isCallTo(forwardDeclareCall, "goog.forwardDeclare") || forwardDeclareCall.getChildCount() != 2) {
            t.report(n, INVALID_GET_ALIAS, new String[0]);
            return;
        }
        Node argument = forwardDeclareCall.getLastChild();
        if (!argument.isString() || !n.getLastChild().matchesQualifiedName(argument.getString())) {
            t.report(n, INVALID_GET_ALIAS, new String[0]);
            return;
        }
        Node replacement = NodeUtil.newQName(this.compiler, argument.getString());
        replacement.srcrefTree(forwardDeclareCall);
        forwardDeclareCall.getParent().replaceChild(forwardDeclareCall, replacement);
        n.getParent().detachFromParent();
        this.compiler.reportCodeChange();
    }

    private static boolean isModuleFile(Node n) {
        return n.isScript() && n.hasChildren() && ClosureRewriteModule.isGoogModuleCall(n.getFirstChild());
    }

    private void enterModule(Node n) {
        this.current = new ModuleDescription(n);
    }

    private boolean inModule() {
        return this.current != null;
    }

    private static boolean isGoogModuleCall(Node n) {
        if (NodeUtil.isExprCall(n)) {
            Node target = n.getFirstChild().getFirstChild();
            return target.matchesQualifiedName("goog.module");
        }
        return false;
    }

    private static boolean isGetModuleCallAlias(Node n) {
        return NodeUtil.isExprAssign(n.getParent()) && n.getFirstChild().isName() && ClosureRewriteModule.isGetModuleCall(n.getLastChild());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!this.inModule()) {
            return;
        }
        switch (n.getType()) {
            case 130: {
                if (!ClosureRewriteModule.isCallTo(n.getFirstChild(), "goog.module.declareLegacyNamespace")) break;
                n.detachFromParent();
                break;
            }
            case 37: {
                if (ClosureRewriteModule.isCallTo(n, "goog.module")) {
                    this.recordAndUpdateModule(t, n);
                    break;
                }
                if (ClosureRewriteModule.isCallTo(n, "goog.require")) {
                    this.recordRequire(t, n);
                    break;
                }
                if (!ClosureRewriteModule.isLoadModuleCall(n)) break;
                this.rewriteModuleAsScope(n);
                break;
            }
            case 33: {
                if (!ClosureRewriteModule.isExportPropAssign(n)) break;
                Node rhs = parent.getLastChild();
                this.maybeUpdateExportDeclToNode(t, parent, rhs);
                break;
            }
            case 38: {
                if (!n.getString().equals("exports")) break;
                this.current.exports.add(n);
                if (!ClosureRewriteModule.isAssignTarget(n)) break;
                this.maybeUpdateExportObjectDecl(t, n);
                break;
            }
            case 132: {
                this.rewriteModuleAsScope(n);
                break;
            }
            case 4: {
                if (parent != this.current.moduleStatementRoot) break;
                n.detachFromParent();
            }
        }
    }

    private void maybeUpdateExportObjectDecl(NodeTraversal t, Node n) {
        Node parent = n.getParent();
        Node rhs = parent.getLastChild();
        this.maybeUpdateExportDeclToNode(t, parent, rhs);
        if (rhs.isObjectLit()) {
            for (Node c = rhs.getFirstChild(); c != null; c = c.getNext()) {
                if (!c.isStringKey()) continue;
                Node value = c.getFirstChild();
                this.maybeUpdateExportDeclToNode(t, c, value);
            }
        }
    }

    private void maybeUpdateExportDeclToNode(NodeTraversal t, Node target, Node value) {
        JSDocInfo info;
        if (value.isName()) {
            JSDocInfo info2;
            Scope varScope;
            Scope currentScope = t.getScope();
            Var v = t.getScope().getVar(value.getString());
            if (v != null && (varScope = v.getScope()).getDepth() == currentScope.getDepth() && (info2 = v.getJSDocInfo()) != null && info2.hasTypedefType()) {
                JSDocInfoBuilder builder = JSDocInfoBuilder.copyFrom(info2);
                target.setJSDocInfo(builder.build());
                return;
            }
        }
        if ((info = target.getJSDocInfo()) != null && info.isConstructorOrInterface() || ClosureRewriteModule.isCallTo(value, "goog.defineClass")) {
            return;
        }
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(info);
        builder.recordConstancy();
        target.setJSDocInfo(builder.build());
    }

    private static boolean isExportPropAssign(Node n) {
        Preconditions.checkState((boolean)n.isGetProp());
        Node target = n.getFirstChild();
        return ClosureRewriteModule.isAssignTarget(n) && target.isName() && target.getString().equals("exports");
    }

    private static boolean isAssignTarget(Node n) {
        Node parent = n.getParent();
        return parent.isAssign() && parent.getFirstChild() == n;
    }

    private void recordAndUpdateModule(NodeTraversal t, Node call) {
        Node idNode = call.getLastChild();
        if (!idNode.isString()) {
            t.report(idNode, INVALID_MODULE_IDENTIFIER, new String[0]);
            return;
        }
        this.current.moduleNamespace = idNode.getString();
        this.current.moduleDecl = call;
        Node target = call.getFirstChild();
        target.getLastChild().setString("provide");
        this.current.provides.add(call);
    }

    private void recordRequire(NodeTraversal t, Node call) {
        Node idNode = call.getLastChild();
        if (!idNode.isString()) {
            t.report(idNode, INVALID_REQUIRE_IDENTIFIER, new String[0]);
            return;
        }
        this.current.requires.add(call);
    }

    private void updateRequires(List<Node> requires) {
        for (Node node : requires) {
            this.updateRequire(node);
        }
    }

    private void updateRequire(Node call) {
        Node idNode = call.getLastChild();
        String namespace = idNode.getString();
        if (this.current.requireInsertNode == null) {
            this.current.requireInsertNode = this.getInsertRoot(call);
        }
        Node replacement = NodeUtil.newQName(this.compiler, namespace).srcrefTree(call);
        call.getParent().replaceChild(call, replacement);
        Node require = IR.exprResult(call).srcref(call);
        Node insertAt = this.current.requireInsertNode;
        insertAt.getParent().addChildBefore(require, insertAt);
    }

    private List<String> collectRoots(ModuleDescription module) {
        ArrayList<String> result = new ArrayList<String>();
        for (Node n : module.provides) {
            result.add(this.getRootName(n.getFirstChild().getNext()));
        }
        for (Node n : module.requires) {
            result.add(this.getRootName(n.getFirstChild().getNext()));
        }
        return result;
    }

    private String getRootName(Node n) {
        String qname = n.getString();
        int endPos = qname.indexOf(46);
        return endPos == -1 ? qname : qname.substring(0, endPos);
    }

    private void rewriteModuleAsScope(Node root) {
        Node moduleRoot = this.current.moduleStatementRoot;
        Node srcref = this.current.moduleDecl != null ? this.current.moduleDecl : root;
        ImmutableSet roots = ImmutableSet.copyOf(this.collectRoots(this.current));
        this.updateRootShadows(this.current.moduleScope, (ImmutableSet<String>)roots);
        this.updateRequires(this.current.requires);
        this.updateExports(this.current.exports);
        Node block = IR.block();
        Node scope = IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("scope")), IR.function(IR.name(""), IR.paramList(), block))).srcrefTree(srcref);
        Node fromNode = this.skipHeaderNodes(moduleRoot);
        Preconditions.checkNotNull((Object)fromNode);
        this.moveChildrenAfter(fromNode, block);
        moduleRoot.addChildAfter(scope, fromNode);
        if (root.isCall()) {
            Node expr = root.getParent();
            Preconditions.checkState((boolean)expr.isExprResult(), (Object)expr);
            expr.getParent().addChildrenAfter(moduleRoot.removeChildren(), expr);
            expr.detachFromParent();
        }
        this.compiler.reportCodeChange();
        this.current = null;
    }

    private void updateExports(List<Node> exports) {
        for (Node n : exports) {
            Node replacement = NodeUtil.newQName(this.compiler, this.current.moduleNamespace);
            replacement.srcrefTree(n);
            n.getParent().replaceChild(n, replacement);
        }
    }

    private void updateRootShadows(Scope s, ImmutableSet<String> roots) {
        final HashMap<String, String> nameMap = new HashMap<String, String>();
        for (String root : roots) {
            if (s.getOwnSlot(root) == null) continue;
            nameMap.put(root, root + "_module");
        }
        if (nameMap.isEmpty()) {
            return;
        }
        NodeTraversal.traverseEs6(this.compiler, s.getRootNode(), new NodeTraversal.AbstractPostOrderCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                String rename;
                if (n.isName() && (rename = (String)nameMap.get(n.getString())) != null) {
                    n.setString(rename);
                }
            }
        });
    }

    private Node getModuleScopeRootForLoadModuleCall(Node n) {
        Preconditions.checkState((boolean)n.isCall());
        Node fn = n.getLastChild();
        Preconditions.checkState((boolean)fn.isFunction());
        return fn.getLastChild();
    }

    private Node getModuleStatementRootForLoadModuleCall(Node n) {
        Node scopeRoot = this.getModuleScopeRootForLoadModuleCall(n);
        if (scopeRoot.isFunction()) {
            return scopeRoot.getLastChild();
        }
        return scopeRoot;
    }

    private Node skipHeaderNodes(Node script) {
        Node lastHeaderNode = null;
        for (Node child = script.getFirstChild(); child != null && this.isHeaderNode(child); child = child.getNext()) {
            lastHeaderNode = child;
        }
        return lastHeaderNode;
    }

    private boolean isHeaderNode(Node n) {
        if (n.isEmpty()) {
            return true;
        }
        if (NodeUtil.isExprCall(n)) {
            Node target = n.getFirstChild().getFirstChild();
            return target.matchesQualifiedName("goog.module") || target.matchesQualifiedName("goog.provide") || target.matchesQualifiedName("goog.require") || target.matchesQualifiedName("goog.setTestOnly");
        }
        return false;
    }

    private void moveChildrenAfter(Node fromNode, Node targetBlock) {
        Node parent = fromNode.getParent();
        while (fromNode.getNext() != null) {
            Node child = parent.removeChildAfter(fromNode);
            targetBlock.addChildToBack(child);
        }
    }

    private Node getInsertRoot(Node n) {
        while (n.getParent() != this.current.moduleStatementRoot) {
            n = n.getParent();
        }
        return n;
    }

    private class ModuleDescription {
        Node moduleDecl;
        String moduleNamespace = "";
        Node requireInsertNode = null;
        final Node moduleScopeRoot;
        final Node moduleStatementRoot;
        final List<Node> requires = new ArrayList<Node>();
        final List<Node> provides = new ArrayList<Node>();
        final List<Node> exports = new ArrayList<Node>();
        public Scope moduleScope = null;

        ModuleDescription(Node n) {
            if (ClosureRewriteModule.isLoadModuleCall(n)) {
                this.moduleScopeRoot = ClosureRewriteModule.this.getModuleScopeRootForLoadModuleCall(n);
                this.moduleStatementRoot = ClosureRewriteModule.this.getModuleStatementRootForLoadModuleCall(n);
            } else {
                this.moduleScopeRoot = n;
                this.moduleStatementRoot = n;
            }
        }
    }
}

