/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.javascript.jscomp.newtypes.PersistentMap;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;

final class ClojurePersistentHashMap<K, V>
extends PersistentMap<K, V> {
    private static Method assoc;
    private static Method without;
    private final Map map;

    private ClojurePersistentHashMap(Map m) {
        this.map = m;
    }

    public static <K, V> PersistentMap<K, V> create(Class<? extends Map> cls) {
        try {
            assoc = cls.getDeclaredMethod("assoc", Object.class, Object.class);
            without = cls.getDeclaredMethod("without", Object.class);
            Map m = (Map)cls.getDeclaredField("EMPTY").get(null);
            return new ClojurePersistentHashMap<K, V>(m);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PersistentMap<K, V> with(K key, V value) {
        try {
            Map m = (Map)assoc.invoke((Object)this.map, key, value);
            return new ClojurePersistentHashMap<K, V>(m);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PersistentMap<K, V> without(K key) {
        try {
            Map m = (Map)without.invoke((Object)this.map, key);
            return new ClojurePersistentHashMap<K, V>(m);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ClojurePersistentHashMap) {
            ClojurePersistentHashMap pm = (ClojurePersistentHashMap)o;
            return this.map.equals(pm.map);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

