/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SourcePosition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JSDocInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LazilyInitializedInfo info = null;
    private LazilyInitializedDocumentation documentation = null;
    private Visibility visibility = null;
    private int bitset = 0;
    private JSTypeExpression type = null;
    private JSTypeExpression thisType = null;
    private boolean inlineType = false;
    private boolean includeDocumentation = false;
    private int originalCommentPosition;
    private static final int MASK_FLAGS = 0x3FFFFFFF;
    private static final int MASK_CONSTANT = 1;
    private static final int MASK_CONSTRUCTOR = 2;
    private static final int MASK_DEFINE = 4;
    private static final int MASK_HIDDEN = 8;
    private static final int MASK_PRESERVETRY = 16;
    private static final int MASK_UNUSED_1 = 32;
    private static final int MASK_OVERRIDE = 64;
    private static final int MASK_NOALIAS = 128;
    private static final int MASK_DEPRECATED = 256;
    private static final int MASK_INTERFACE = 512;
    private static final int MASK_EXPORT = 1024;
    private static final int MASK_FILEOVERVIEW = 4096;
    private static final int MASK_IMPLICITCAST = 8192;
    private static final int MASK_NOSIDEEFFECTS = 16384;
    private static final int MASK_EXTERNS = 32768;
    private static final int MASK_UNUSED_2 = 65536;
    private static final int MASK_NOCOMPILE = 131072;
    private static final int MASK_CONSISTIDGEN = 262144;
    private static final int MASK_IDGEN = 524288;
    private static final int MASK_EXPOSE = 0x100000;
    private static final int MASK_UNRESTRICTED = 0x200000;
    private static final int MASK_STRUCT = 0x400000;
    private static final int MASK_DICT = 0x800000;
    private static final int MASK_STALBEIDGEN = 0x1000000;
    private static final int MASK_MAPPEDIDGEN = 0x2000000;
    private static final int MASK_NOCOLLAPSE = 0x4000000;
    private static final int MASK_TYPEFIELD = -536870912;
    private static final int TYPEFIELD_TYPE = 0x20000000;
    private static final int TYPEFIELD_RETURN = 0x40000000;
    private static final int TYPEFIELD_ENUM = 0x60000000;
    private static final int TYPEFIELD_TYPEDEF = Integer.MIN_VALUE;

    JSDocInfo(boolean includeDocumentation) {
        this.includeDocumentation = includeDocumentation;
    }

    JSDocInfo() {
    }

    public JSDocInfo clone() {
        JSDocInfo other = new JSDocInfo();
        other.info = this.info == null ? null : this.info.clone();
        other.documentation = this.documentation;
        other.visibility = this.visibility;
        other.bitset = this.bitset;
        other.type = this.type;
        other.thisType = this.thisType;
        other.includeDocumentation = this.includeDocumentation;
        other.originalCommentPosition = this.originalCommentPosition;
        return other;
    }

    @VisibleForTesting
    public static boolean areEquivalent(JSDocInfo jsDoc1, JSDocInfo jsDoc2) {
        if (jsDoc1 == null && jsDoc2 == null) {
            return true;
        }
        if (jsDoc1 == null || jsDoc2 == null) {
            return false;
        }
        if (!Objects.equals(jsDoc1.getParameterNames(), jsDoc2.getParameterNames())) {
            return false;
        }
        for (String param : jsDoc1.getParameterNames()) {
            if (Objects.equals(jsDoc1.getParameterType(param), jsDoc2.getParameterType(param))) continue;
            return false;
        }
        return Objects.equals(jsDoc1.getAuthors(), jsDoc2.getAuthors()) && Objects.equals(jsDoc1.getBaseType(), jsDoc2.getBaseType()) && Objects.equals(jsDoc1.getBlockDescription(), jsDoc2.getBlockDescription()) && Objects.equals(jsDoc1.getFileOverview(), jsDoc2.getFileOverview()) && Objects.equals(jsDoc1.getImplementedInterfaces(), jsDoc2.getImplementedInterfaces()) && Objects.equals(jsDoc1.getEnumParameterType(), jsDoc2.getEnumParameterType()) && Objects.equals(jsDoc1.getExtendedInterfaces(), jsDoc2.getExtendedInterfaces()) && Objects.equals(jsDoc1.getLendsName(), jsDoc2.getLendsName()) && Objects.equals(jsDoc1.getLicense(), jsDoc2.getLicense()) && Objects.equals(jsDoc1.getMarkers(), jsDoc2.getMarkers()) && Objects.equals(jsDoc1.getMeaning(), jsDoc2.getMeaning()) && Objects.equals(jsDoc1.getModifies(), jsDoc2.getModifies()) && Objects.equals(jsDoc1.getOriginalCommentString(), jsDoc2.getOriginalCommentString()) && Objects.equals(jsDoc1.getReferences(), jsDoc2.getReferences()) && Objects.equals(jsDoc1.getReturnDescription(), jsDoc2.getReturnDescription()) && Objects.equals(jsDoc1.getReturnType(), jsDoc2.getReturnType()) && Objects.equals(jsDoc1.getSuppressions(), jsDoc2.getSuppressions()) && Objects.equals(jsDoc1.getTemplateTypeNames(), jsDoc2.getTemplateTypeNames()) && Objects.equals(jsDoc1.getThisType(), jsDoc2.getThisType()) && Objects.equals(jsDoc1.getThrownTypes(), jsDoc2.getThrownTypes()) && Objects.equals(jsDoc1.getTypedefType(), jsDoc2.getTypedefType()) && Objects.equals(jsDoc1.getType(), jsDoc2.getType()) && Objects.equals(jsDoc1.getVersion(), jsDoc2.getVersion()) && Objects.equals((Object)jsDoc1.getVisibility(), (Object)jsDoc2.getVisibility()) && jsDoc1.bitset == jsDoc2.bitset;
    }

    boolean isDocumentationIncluded() {
        return this.includeDocumentation;
    }

    void setConsistentIdGenerator(boolean value) {
        this.setFlag(value, 262144);
    }

    void setStableIdGenerator(boolean value) {
        this.setFlag(value, 0x1000000);
    }

    void setMappedIdGenerator(boolean value) {
        this.setFlag(value, 0x2000000);
    }

    void setConstant(boolean value) {
        this.setFlag(value, 1);
    }

    void setConstructor(boolean value) {
        this.setFlag(value, 2);
    }

    void setUnrestricted() {
        this.setFlag(true, 0x200000);
    }

    void setStruct() {
        this.setFlag(true, 0x400000);
    }

    void setDict() {
        this.setFlag(true, 0x800000);
    }

    void setDefine(boolean value) {
        this.setFlag(value, 4);
    }

    void setHidden(boolean value) {
        this.setFlag(value, 8);
    }

    void setShouldPreserveTry(boolean value) {
        this.setFlag(value, 16);
    }

    void setOverride(boolean value) {
        this.setFlag(value, 64);
    }

    void setNoAlias(boolean value) {
        this.setFlag(value, 128);
    }

    void setDeprecated(boolean value) {
        this.setFlag(value, 256);
    }

    void setInterface(boolean value) {
        this.setFlag(value, 512);
    }

    void setExport(boolean value) {
        this.setFlag(value, 1024);
    }

    void setExpose(boolean value) {
        this.setFlag(value, 0x100000);
    }

    void setIdGenerator(boolean value) {
        this.setFlag(value, 524288);
    }

    void setImplicitCast(boolean value) {
        this.setFlag(value, 8192);
    }

    void setNoSideEffects(boolean value) {
        this.setFlag(value, 16384);
    }

    void setExterns(boolean value) {
        this.setFlag(value, 32768);
    }

    void setNoCompile(boolean value) {
        this.setFlag(value, 131072);
    }

    void setNoCollapse(boolean value) {
        this.setFlag(value, 0x4000000);
    }

    private void setFlag(boolean value, int mask) {
        this.bitset = value ? (this.bitset |= mask) : (this.bitset &= ~mask);
    }

    public boolean isConsistentIdGenerator() {
        return this.getFlag(262144);
    }

    public boolean isStableIdGenerator() {
        return this.getFlag(0x1000000);
    }

    public boolean isMappedIdGenerator() {
        return this.getFlag(0x2000000);
    }

    public boolean isConstant() {
        return this.getFlag(1) || this.isDefine();
    }

    public boolean isConstructor() {
        return this.getFlag(2);
    }

    public boolean makesUnrestricted() {
        return this.getFlag(0x200000);
    }

    public boolean makesStructs() {
        return this.getFlag(0x400000);
    }

    public boolean makesDicts() {
        return this.getFlag(0x800000);
    }

    public boolean isDefine() {
        return this.getFlag(4);
    }

    public boolean isHidden() {
        return this.getFlag(8);
    }

    public boolean shouldPreserveTry() {
        return this.getFlag(16);
    }

    public boolean isOverride() {
        return this.getFlag(64);
    }

    public boolean isNoAlias() {
        return this.getFlag(128);
    }

    public boolean isDeprecated() {
        return this.getFlag(256);
    }

    public boolean isInterface() {
        return this.getFlag(512);
    }

    public boolean isExport() {
        return this.getFlag(1024);
    }

    public boolean isExpose() {
        return this.getFlag(0x100000);
    }

    public boolean isIdGenerator() {
        return this.getFlag(524288);
    }

    public boolean isImplicitCast() {
        return this.getFlag(8192);
    }

    public boolean isNoSideEffects() {
        return this.getFlag(16384);
    }

    public boolean isExterns() {
        return this.getFlag(32768);
    }

    public boolean isNoCompile() {
        return this.getFlag(131072);
    }

    public boolean isNoCollapse() {
        return this.getFlag(0x4000000);
    }

    public boolean containsDeclaration() {
        return this.hasType() || this.hasReturnType() || this.hasEnumParameterType() || this.hasTypedefType() || this.hasThisType() || this.getParameterCount() > 0 || this.getFlag(25543);
    }

    public boolean containsFunctionDeclaration() {
        boolean hasFunctionType = this.hasType() && this.getType().getRoot().isFunction();
        return hasFunctionType || this.hasReturnType() || this.hasThisType() || this.getParameterCount() > 0 || this.getFlag(2) || this.getFlag(16384) && (!this.hasType() || hasFunctionType);
    }

    private boolean getFlag(int mask) {
        return (this.bitset & mask) != 0;
    }

    void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    private void lazyInitInfo() {
        if (this.info == null) {
            this.info = new LazilyInitializedInfo();
        }
    }

    private boolean lazyInitDocumentation() {
        if (!this.includeDocumentation) {
            return false;
        }
        if (this.documentation == null) {
            this.documentation = new LazilyInitializedDocumentation();
        }
        return true;
    }

    Marker addMarker() {
        if (!this.lazyInitDocumentation()) {
            return null;
        }
        if (this.documentation.markers == null) {
            this.documentation.markers = new ArrayList<Marker>();
        }
        Marker marker = new Marker();
        this.documentation.markers.add(marker);
        return marker;
    }

    boolean setDeprecationReason(String reason) {
        this.lazyInitInfo();
        if (this.info.deprecated != null) {
            return false;
        }
        this.info.deprecated = reason;
        return true;
    }

    void addSuppression(String suppression) {
        this.lazyInitInfo();
        this.info.suppressions = this.info.suppressions == null ? ImmutableSet.of((Object)suppression) : new ImmutableSet.Builder().addAll(this.info.suppressions).add((Object)suppression).build();
    }

    boolean setSuppressions(Set<String> suppressions) {
        this.lazyInitInfo();
        if (this.info.suppressions != null) {
            return false;
        }
        this.info.suppressions = ImmutableSet.copyOf(suppressions);
        return true;
    }

    boolean setModifies(Set<String> modifies) {
        this.lazyInitInfo();
        if (this.info.modifies != null) {
            return false;
        }
        this.info.modifies = ImmutableSet.copyOf(modifies);
        return true;
    }

    boolean documentVersion(String version) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.version != null) {
            return false;
        }
        this.documentation.version = version;
        return true;
    }

    boolean documentReference(String reference) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.sees == null) {
            this.documentation.sees = new ArrayList<String>();
        }
        this.documentation.sees.add(reference);
        return true;
    }

    boolean documentAuthor(String author) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.authors == null) {
            this.documentation.authors = new ArrayList<String>();
        }
        this.documentation.authors.add(author);
        return true;
    }

    boolean documentThrows(JSTypeExpression type, String throwsDescription) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.throwsDescriptions == null) {
            this.documentation.throwsDescriptions = new LinkedHashMap<JSTypeExpression, String>();
        }
        if (!this.documentation.throwsDescriptions.containsKey(type)) {
            this.documentation.throwsDescriptions.put(type, throwsDescription);
            return true;
        }
        return false;
    }

    boolean documentParam(String parameter, String description) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.parameters == null) {
            this.documentation.parameters = new LinkedHashMap<String, String>();
        }
        if (!this.documentation.parameters.containsKey(parameter)) {
            this.documentation.parameters.put(parameter, description);
            return true;
        }
        return false;
    }

    boolean documentBlock(String description) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.blockDescription != null) {
            return false;
        }
        this.documentation.blockDescription = description;
        return true;
    }

    boolean documentFileOverview(String description) {
        this.setFlag(true, 4096);
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.fileOverview != null) {
            return false;
        }
        this.documentation.fileOverview = description;
        return true;
    }

    boolean documentReturn(String description) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.returnDescription != null) {
            return false;
        }
        this.documentation.returnDescription = description;
        return true;
    }

    boolean declareParam(JSTypeExpression jsType, String parameter) {
        this.lazyInitInfo();
        if (this.info.parameters == null) {
            this.info.parameters = new LinkedHashMap<String, JSTypeExpression>();
        }
        if (!this.info.parameters.containsKey(parameter)) {
            this.info.parameters.put(parameter, jsType);
            return true;
        }
        return false;
    }

    boolean declareTemplateTypeName(String newTemplateTypeName) {
        this.lazyInitInfo();
        if (this.isTypeTransformationName(newTemplateTypeName) || this.hasTypedefType()) {
            return false;
        }
        if (this.info.templateTypeNames == null) {
            this.info.templateTypeNames = new ArrayList<String>();
        } else if (this.info.templateTypeNames.contains(newTemplateTypeName)) {
            return false;
        }
        this.info.templateTypeNames.add(newTemplateTypeName);
        return true;
    }

    private boolean isTemplateTypeName(String name) {
        if (this.info.templateTypeNames == null) {
            return false;
        }
        return this.info.templateTypeNames.contains(name);
    }

    private boolean isTypeTransformationName(String name) {
        if (this.info.typeTransformations == null) {
            return false;
        }
        return this.info.typeTransformations.containsKey(name);
    }

    boolean declareTypeTransformation(String newName, Node expr) {
        this.lazyInitInfo();
        if (this.isTemplateTypeName(newName)) {
            return false;
        }
        if (this.info.typeTransformations == null) {
            this.info.typeTransformations = new LinkedHashMap<String, Node>();
        } else if (this.info.typeTransformations.containsKey(newName)) {
            return false;
        }
        this.info.typeTransformations.put(newName, expr);
        return true;
    }

    boolean declareThrows(JSTypeExpression jsType) {
        this.lazyInitInfo();
        if (this.info.thrownTypes == null) {
            this.info.thrownTypes = new ArrayList<JSTypeExpression>();
        }
        this.info.thrownTypes.add(jsType);
        return true;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public JSTypeExpression getParameterType(String parameter) {
        if (this.info == null || this.info.parameters == null) {
            return null;
        }
        return this.info.parameters.get(parameter);
    }

    public boolean hasParameter(String parameter) {
        if (this.info == null || this.info.parameters == null) {
            return false;
        }
        return this.info.parameters.containsKey(parameter);
    }

    public boolean hasParameterType(String parameter) {
        return this.getParameterType(parameter) != null;
    }

    public Set<String> getParameterNames() {
        if (this.info == null || this.info.parameters == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(this.info.parameters.keySet());
    }

    public int getParameterCount() {
        if (this.info == null || this.info.parameters == null) {
            return 0;
        }
        return this.info.parameters.size();
    }

    void setType(JSTypeExpression type) {
        this.setType(type, 0x20000000);
    }

    void setInlineType() {
        this.inlineType = true;
    }

    void setReturnType(JSTypeExpression type) {
        this.setType(type, 0x40000000);
    }

    void setEnumParameterType(JSTypeExpression type) {
        this.setType(type, 0x60000000);
    }

    boolean declareTypedefType(JSTypeExpression type) {
        if (this.getTemplateTypeNames().isEmpty()) {
            this.setType(type, Integer.MIN_VALUE);
            return true;
        }
        return false;
    }

    private void setType(JSTypeExpression type, int mask) {
        if ((this.bitset & 0xE0000000) != 0) {
            throw new IllegalStateException("API tried to add two incompatible type tags. This should have been blocked and emitted a warning.");
        }
        this.bitset = this.bitset & 0x3FFFFFFF | mask;
        this.type = type;
    }

    public List<JSTypeExpression> getThrownTypes() {
        if (this.info == null || this.info.thrownTypes == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.info.thrownTypes);
    }

    public boolean hasType() {
        return this.hasType(0x20000000);
    }

    public boolean hasEnumParameterType() {
        return this.hasType(0x60000000);
    }

    public boolean hasTypedefType() {
        return this.hasType(Integer.MIN_VALUE);
    }

    public boolean hasReturnType() {
        return this.hasType(0x40000000);
    }

    private boolean hasType(int mask) {
        return (this.bitset & 0xE0000000) == mask;
    }

    public boolean hasTypeInformation() {
        return (this.bitset & 0xE0000000) != 0;
    }

    public JSTypeExpression getType() {
        return this.getType(0x20000000);
    }

    public boolean isInlineType() {
        return this.inlineType;
    }

    public JSTypeExpression getReturnType() {
        return this.getType(0x40000000);
    }

    public JSTypeExpression getEnumParameterType() {
        return this.getType(0x60000000);
    }

    public JSTypeExpression getTypedefType() {
        return this.getType(Integer.MIN_VALUE);
    }

    private JSTypeExpression getType(int typefield) {
        if ((0xE0000000 & this.bitset) == typefield) {
            return this.type;
        }
        return null;
    }

    public JSTypeExpression getThisType() {
        return this.thisType;
    }

    void setThisType(JSTypeExpression type) {
        this.thisType = type;
    }

    public boolean hasThisType() {
        return this.thisType != null;
    }

    void setBaseType(JSTypeExpression type) {
        this.lazyInitInfo();
        this.info.baseType = type;
    }

    public JSTypeExpression getBaseType() {
        return this.info == null ? null : this.info.baseType;
    }

    public String getDescription() {
        return this.info == null ? null : this.info.description;
    }

    void setDescription(String desc) {
        this.lazyInitInfo();
        this.info.description = desc;
    }

    public String getMeaning() {
        return this.info == null ? null : this.info.meaning;
    }

    void setMeaning(String meaning) {
        this.lazyInitInfo();
        this.info.meaning = meaning;
    }

    public String getLendsName() {
        return this.info == null ? null : this.info.lendsName;
    }

    void setLendsName(String name) {
        this.lazyInitInfo();
        this.info.lendsName = name;
    }

    public boolean isNgInject() {
        return this.info != null && this.info.isBitSet(0);
    }

    void setNgInject(boolean ngInject) {
        this.lazyInitInfo();
        this.info.setBit(0, ngInject);
    }

    public boolean isJaggerInject() {
        return this.info != null && this.info.isBitSet(2);
    }

    void setJaggerInject(boolean jaggerInject) {
        this.lazyInitInfo();
        this.info.setBit(2, jaggerInject);
    }

    public boolean isJaggerProvide() {
        return this.info != null && this.info.isBitSet(5);
    }

    void setJaggerProvide(boolean jaggerProvide) {
        this.lazyInitInfo();
        this.info.setBit(5, jaggerProvide);
    }

    public boolean isJaggerProvidePromise() {
        return this.info != null && this.info.isBitSet(4);
    }

    void setJaggerProvidePromise(boolean jaggerProvidePromise) {
        this.lazyInitInfo();
        this.info.setBit(4, jaggerProvidePromise);
    }

    public boolean isJaggerModule() {
        return this.info != null && this.info.isBitSet(3);
    }

    void setJaggerModule(boolean jaggerModule) {
        this.lazyInitInfo();
        this.info.setBit(3, jaggerModule);
    }

    public boolean isWizaction() {
        return this.info != null && this.info.isBitSet(1);
    }

    void setWizaction(boolean wizaction) {
        this.lazyInitInfo();
        this.info.setBit(1, wizaction);
    }

    public boolean isDisposes() {
        return this.info == null ? false : this.info.disposedParameters != null;
    }

    boolean setDisposedParameter(String parameterName) {
        this.lazyInitInfo();
        if (this.info.disposedParameters == null) {
            this.info.disposedParameters = new HashSet<String>();
        }
        if (this.info.disposedParameters.contains(parameterName)) {
            return false;
        }
        this.info.disposedParameters.add(parameterName);
        return true;
    }

    public boolean disposesOf(String parameterName) {
        return this.isDisposes() && this.info.disposedParameters.contains(parameterName);
    }

    public String getLicense() {
        return this.info == null ? null : this.info.license;
    }

    void setLicense(String license) {
        this.lazyInitInfo();
        this.info.license = license;
    }

    public String toString() {
        return "JSDocInfo";
    }

    @VisibleForTesting
    public String toStringVerbose() {
        return MoreObjects.toStringHelper((Object)this).add("bitset", this.bitset == 0 ? null : Integer.toHexString(this.bitset)).add("documentation", (Object)this.documentation).add("info", (Object)this.info).add("originalComment", (Object)this.getOriginalCommentString()).add("thisType", (Object)this.thisType).add("type", (Object)this.type).add("visibility", (Object)this.visibility).omitNullValues().toString();
    }

    public boolean hasBaseType() {
        return this.getBaseType() != null;
    }

    boolean addImplementedInterface(JSTypeExpression interfaceName) {
        this.lazyInitInfo();
        if (this.info.implementedInterfaces == null) {
            this.info.implementedInterfaces = new ArrayList<JSTypeExpression>(2);
        }
        if (this.info.implementedInterfaces.contains(interfaceName)) {
            return false;
        }
        this.info.implementedInterfaces.add(interfaceName);
        return true;
    }

    public List<JSTypeExpression> getImplementedInterfaces() {
        if (this.info == null || this.info.implementedInterfaces == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.info.implementedInterfaces);
    }

    public int getImplementedInterfaceCount() {
        if (this.info == null || this.info.implementedInterfaces == null) {
            return 0;
        }
        return this.info.implementedInterfaces.size();
    }

    boolean addExtendedInterface(JSTypeExpression type) {
        this.lazyInitInfo();
        if (this.info.extendedInterfaces == null) {
            this.info.extendedInterfaces = new ArrayList<JSTypeExpression>(2);
        }
        if (this.info.extendedInterfaces.contains(type)) {
            return false;
        }
        this.info.extendedInterfaces.add(type);
        return true;
    }

    public List<JSTypeExpression> getExtendedInterfaces() {
        if (this.info == null || this.info.extendedInterfaces == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.info.extendedInterfaces);
    }

    public int getExtendedInterfacesCount() {
        if (this.info == null || this.info.extendedInterfaces == null) {
            return 0;
        }
        return this.info.extendedInterfaces.size();
    }

    public String getDeprecationReason() {
        return this.info == null ? null : this.info.deprecated;
    }

    public Set<String> getSuppressions() {
        ImmutableSet<String> suppressions = this.info == null ? null : this.info.suppressions;
        return suppressions == null ? Collections.emptySet() : suppressions;
    }

    public Set<String> getModifies() {
        ImmutableSet<String> modifies = this.info == null ? null : this.info.modifies;
        return modifies == null ? Collections.emptySet() : modifies;
    }

    public boolean hasDescriptionForParameter(String name) {
        if (this.documentation == null || this.documentation.parameters == null) {
            return false;
        }
        return this.documentation.parameters.containsKey(name);
    }

    public String getDescriptionForParameter(String name) {
        if (this.documentation == null || this.documentation.parameters == null) {
            return null;
        }
        return this.documentation.parameters.get(name);
    }

    public Collection<String> getAuthors() {
        return this.documentation == null ? null : this.documentation.authors;
    }

    public Collection<String> getReferences() {
        return this.documentation == null ? null : this.documentation.sees;
    }

    public String getVersion() {
        return this.documentation == null ? null : this.documentation.version;
    }

    public String getReturnDescription() {
        return this.documentation == null ? null : this.documentation.returnDescription;
    }

    public String getBlockDescription() {
        return this.documentation == null ? null : this.documentation.blockDescription;
    }

    public boolean hasFileOverview() {
        return this.getFlag(4096);
    }

    public String getFileOverview() {
        return this.documentation == null ? null : this.documentation.fileOverview;
    }

    public Collection<Marker> getMarkers() {
        return this.documentation == null || this.documentation.markers == null ? ImmutableList.of() : this.documentation.markers;
    }

    public ImmutableList<String> getTemplateTypeNames() {
        if (this.info == null || this.info.templateTypeNames == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.info.templateTypeNames);
    }

    public ImmutableMap<String, Node> getTypeTransformations() {
        if (this.info == null || this.info.typeTransformations == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.info.typeTransformations);
    }

    public Collection<Node> getTypeNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (this.type != null) {
            nodes.add(this.type.getRoot());
        }
        if (this.thisType != null) {
            nodes.add(this.thisType.getRoot());
        }
        if (this.info != null) {
            if (this.info.baseType != null) {
                nodes.add(this.info.baseType.getRoot());
            }
            if (this.info.extendedInterfaces != null) {
                for (JSTypeExpression interfaceType : this.info.extendedInterfaces) {
                    nodes.add(interfaceType.getRoot());
                }
            }
            if (this.info.implementedInterfaces != null) {
                for (JSTypeExpression interfaceType : this.info.implementedInterfaces) {
                    nodes.add(interfaceType.getRoot());
                }
            }
            if (this.info.parameters != null) {
                for (JSTypeExpression parameterType : this.info.parameters.values()) {
                    if (parameterType == null) continue;
                    nodes.add(parameterType.getRoot());
                }
            }
            if (this.info.thrownTypes != null) {
                for (JSTypeExpression thrownType : this.info.thrownTypes) {
                    if (thrownType == null) continue;
                    nodes.add(thrownType.getRoot());
                }
            }
        }
        return nodes;
    }

    public boolean hasModifies() {
        return this.info != null && this.info.modifies != null;
    }

    public String getOriginalCommentString() {
        return this.documentation == null ? null : this.documentation.sourceComment;
    }

    void setOriginalCommentString(String sourceComment) {
        if (!this.lazyInitDocumentation()) {
            return;
        }
        this.documentation.sourceComment = sourceComment;
    }

    public int getOriginalCommentPosition() {
        return this.originalCommentPosition;
    }

    void setOriginalCommentPosition(int position) {
        this.originalCommentPosition = position;
    }

    public static final class Marker {
        private TrimmedStringPosition annotation = null;
        private TrimmedStringPosition name = null;
        private SourcePosition<Node> nameNode = null;
        private StringPosition description = null;
        private TypePosition type = null;

        public StringPosition getAnnotation() {
            return this.annotation;
        }

        void setAnnotation(TrimmedStringPosition p) {
            this.annotation = p;
        }

        @Deprecated
        public StringPosition getName() {
            return this.name;
        }

        void setName(TrimmedStringPosition p) {
            this.name = p;
        }

        public SourcePosition<Node> getNameNode() {
            return this.nameNode;
        }

        void setNameNode(SourcePosition<Node> p) {
            this.nameNode = p;
        }

        public StringPosition getDescription() {
            return this.description;
        }

        void setDescription(StringPosition p) {
            this.description = p;
        }

        public TypePosition getType() {
            return this.type;
        }

        void setType(TypePosition p) {
            this.type = p;
        }
    }

    public static class TypePosition
    extends SourcePosition<Node> {
        private boolean brackets = false;

        public boolean hasBrackets() {
            return this.brackets;
        }

        void setHasBrackets(boolean newVal) {
            this.brackets = newVal;
        }
    }

    public static class NamePosition
    extends SourcePosition<Node> {
    }

    static class TrimmedStringPosition
    extends StringPosition {
        TrimmedStringPosition() {
        }

        @Override
        public void setItem(String item) {
            Preconditions.checkArgument((item.charAt(0) != ' ' && item.charAt(item.length() - 1) != ' ' ? 1 : 0) != 0, (Object)"String has leading or trailing whitespace");
            super.setItem(item);
        }
    }

    public static class StringPosition
    extends SourcePosition<String> {
    }

    private static final class LazilyInitializedDocumentation {
        String sourceComment = null;
        List<Marker> markers = null;
        Map<String, String> parameters = null;
        Map<JSTypeExpression, String> throwsDescriptions = null;
        String blockDescription = null;
        String fileOverview = null;
        String returnDescription = null;
        String version = null;
        List<String> authors = null;
        List<String> sees = null;

        private LazilyInitializedDocumentation() {
        }
    }

    private static final class LazilyInitializedInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        JSTypeExpression baseType = null;
        List<JSTypeExpression> extendedInterfaces = null;
        List<JSTypeExpression> implementedInterfaces = null;
        Map<String, JSTypeExpression> parameters = null;
        List<JSTypeExpression> thrownTypes = null;
        List<String> templateTypeNames = null;
        Set<String> disposedParameters = null;
        Map<String, Node> typeTransformations = null;
        String description = null;
        String meaning = null;
        String deprecated = null;
        String license = null;
        ImmutableSet<String> suppressions = null;
        ImmutableSet<String> modifies = null;
        String lendsName = null;
        private int propertyBitField = 0;

        private LazilyInitializedInfo() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("bitfield", this.propertyBitField == 0 ? null : Integer.toHexString(this.propertyBitField)).add("baseType", (Object)this.baseType).add("extendedInterfaces", this.extendedInterfaces).add("implementedInterfaces", this.implementedInterfaces).add("parameters", this.parameters).add("thrownTypes", this.thrownTypes).add("templateTypeNames", this.templateTypeNames).add("disposedParameters", this.disposedParameters).add("typeTransformations", this.typeTransformations).add("description", (Object)this.description).add("meaning", (Object)this.meaning).add("deprecated", (Object)this.deprecated).add("license", (Object)this.license).add("suppressions", this.suppressions).add("lendsName", (Object)this.lendsName).omitNullValues().toString();
        }

        protected LazilyInitializedInfo clone() {
            LazilyInitializedInfo other = new LazilyInitializedInfo();
            other.baseType = this.baseType;
            other.extendedInterfaces = this.extendedInterfaces == null ? null : new ArrayList<JSTypeExpression>(this.extendedInterfaces);
            other.implementedInterfaces = this.implementedInterfaces == null ? null : new ArrayList<JSTypeExpression>(this.implementedInterfaces);
            other.parameters = this.parameters == null ? null : new LinkedHashMap<String, JSTypeExpression>(this.parameters);
            other.thrownTypes = this.thrownTypes == null ? null : new ArrayList<JSTypeExpression>(this.thrownTypes);
            other.templateTypeNames = this.templateTypeNames == null ? null : new ArrayList<String>(this.templateTypeNames);
            other.disposedParameters = this.disposedParameters == null ? null : new HashSet<String>(this.disposedParameters);
            other.typeTransformations = this.typeTransformations == null ? null : new LinkedHashMap<String, Node>(this.typeTransformations);
            other.description = this.description;
            other.meaning = this.meaning;
            other.deprecated = this.deprecated;
            other.license = this.license;
            other.suppressions = this.suppressions == null ? null : ImmutableSet.copyOf(this.suppressions);
            other.modifies = this.modifies == null ? null : ImmutableSet.copyOf(this.modifies);
            other.lendsName = this.lendsName;
            other.propertyBitField = this.propertyBitField;
            return other;
        }

        void setBit(int bitIndex, boolean value) {
            int mask = this.getMaskForBitIndex(bitIndex);
            this.propertyBitField = value ? (this.propertyBitField |= mask) : (this.propertyBitField ^= mask);
        }

        boolean isBitSet(int bitIndex) {
            int mask = this.getMaskForBitIndex(bitIndex);
            return (mask & this.propertyBitField) != 0;
        }

        private int getMaskForBitIndex(int bitIndex) {
            Preconditions.checkArgument((bitIndex >= 0 ? 1 : 0) != 0, (Object)"Bit index should be non-negative integer");
            return 1 << bitIndex;
        }
    }

    class Property {
        static final int NG_INJECT = 0;
        static final int WIZ_ACTION = 1;
        static final int JAGGER_INJECT = 2;
        static final int JAGGER_MODULE = 3;
        static final int JAGGER_PROVIDE_PROMISE = 4;
        static final int JAGGER_PROVIDE = 5;

        Property() {
        }
    }

    public static enum Visibility {
        PRIVATE,
        PACKAGE,
        PROTECTED,
        PUBLIC,
        INHERITED;

    }
}

