/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.refactoring.ApplySuggestedFixes;
import com.google.javascript.refactoring.RefactoringDriver;
import com.google.javascript.refactoring.RefasterJsScanner;
import com.google.javascript.refactoring.SuggestedFix;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.BooleanOptionHandler;

final class RefasterJs {
    @Option(name="--help", hidden=true, handler=BooleanOptionHandler.class, usage="Show instructions for how to use RefasterJS")
    private boolean displayHelp = false;
    @Option(name="--inputs", usage="List of input files for the refactoring.")
    private List<String> inputs = new ArrayList<String>();
    @Option(name="--externs", usage="List of externs files to use in the compilation.")
    private List<String> externs = new ArrayList<String>();
    @Option(name="--refasterjs_template", usage="Location of the JS file to use as the RefasterJS template.")
    private String refasterJsTemplate = null;
    @Option(name="--include_default_externs", usage="Whether to include the standard JavaScript externs. Defaults to true.")
    private boolean includeDefaultExterns = true;
    @Option(name="--dry_run", usage="Use this to display what changes would be made without applying the changes.")
    private boolean dryRun = false;

    RefasterJs() {
    }

    private void doMain(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser((Object)this);
        parser.parseArgument(args);
        if (this.displayHelp) {
            CmdLineParser p = new CmdLineParser((Object)this);
            p.printUsage((OutputStream)System.out);
            return;
        }
        Preconditions.checkArgument((!this.inputs.isEmpty() ? 1 : 0) != 0, (Object)"At least one input must be provided in the --inputs flag.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.refasterJsTemplate) ? 1 : 0) != 0, (Object)"--refasterjs_template must be provided");
        for (String input : this.inputs) {
            Preconditions.checkArgument((boolean)new File(input).exists(), (String)"Input file %s does not exist.", (Object[])new Object[]{input});
        }
        RefasterJsScanner scanner = new RefasterJsScanner();
        scanner.loadRefasterJsTemplate(this.refasterJsTemplate);
        RefactoringDriver driver = new RefactoringDriver.Builder(scanner).addExterns((List<SourceFile>)(this.includeDefaultExterns ? CommandLineRunner.getDefaultExterns() : ImmutableList.of())).addExternsFromFile(this.externs).addInputsFromFile(this.inputs).build();
        List<SuggestedFix> fixes = driver.drive();
        if (this.dryRun) {
            System.out.println("SuggestedFixes: " + fixes);
        } else {
            ApplySuggestedFixes.applySuggestedFixesToFiles(fixes);
        }
    }

    public static void main(String[] args) throws Exception {
        new RefasterJs().doMain(args);
    }
}

