/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.Node;

public class QualifiedName {
    ImmutableList<String> parts;

    private QualifiedName(ImmutableList<String> parts) {
        this.parts = parts;
    }

    public QualifiedName(String s) {
        this.parts = ImmutableList.of((Object)s);
    }

    public static QualifiedName join(QualifiedName lhs, QualifiedName rhs) {
        return new QualifiedName((ImmutableList<String>)ImmutableList.builder().addAll(lhs.parts).addAll(rhs.parts).build());
    }

    public static QualifiedName fromNode(Node qnameNode) {
        if (qnameNode == null || !qnameNode.isQualifiedName()) {
            return null;
        }
        return qnameNode.isName() ? new QualifiedName(qnameNode.getString()) : new QualifiedName((ImmutableList<String>)ImmutableList.copyOf((Iterable)Splitter.on((char)'.').split((CharSequence)qnameNode.getQualifiedName())));
    }

    public static QualifiedName fromQname(String qname) {
        return qname.contains(".") ? new QualifiedName((ImmutableList<String>)ImmutableList.copyOf((Iterable)Splitter.on((char)'.').split((CharSequence)qname))) : new QualifiedName(qname);
    }

    public boolean isIdentifier() {
        return this.parts.size() == 1;
    }

    public QualifiedName getAllButLeftmost() {
        Preconditions.checkArgument((!this.isIdentifier() ? 1 : 0) != 0);
        return new QualifiedName((ImmutableList<String>)this.parts.subList(1, this.parts.size()));
    }

    public String getLeftmostName() {
        return (String)this.parts.get(0);
    }

    public QualifiedName getAllButRightmost() {
        Preconditions.checkArgument((!this.isIdentifier() ? 1 : 0) != 0);
        return new QualifiedName((ImmutableList<String>)this.parts.subList(0, this.parts.size() - 1));
    }

    public String getRightmostName() {
        return (String)this.parts.get(this.parts.size() - 1);
    }

    public String toString() {
        return this.isIdentifier() ? ((String)this.parts.get(0)).toString() : this.parts.toString();
    }
}

