/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.NominalType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FunctionTypeBuilder {
    private final List<JSType> requiredFormals = new ArrayList<JSType>();
    private final List<JSType> optionalFormals = new ArrayList<JSType>();
    private final Map<String, JSType> outerVars = new HashMap<String, JSType>();
    private JSType restFormals = null;
    private JSType returnType = null;
    private boolean loose = false;
    private NominalType nominalType;
    private NominalType receiverType;
    private ImmutableList<String> typeParameters;

    static FunctionTypeBuilder qmarkFunctionBuilder() {
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        builder.addRestFormals(JSType.UNKNOWN);
        builder.addRetType(JSType.UNKNOWN);
        return builder;
    }

    public FunctionTypeBuilder addReqFormal(JSType t) throws WrongParameterOrderException {
        if (!this.optionalFormals.isEmpty() || this.restFormals != null) {
            throw new WrongParameterOrderException("Cannot add required formal after optional or rest args");
        }
        this.requiredFormals.add(t);
        return this;
    }

    public FunctionTypeBuilder addOptFormal(JSType t) throws WrongParameterOrderException {
        if (this.restFormals != null) {
            throw new WrongParameterOrderException("Cannot add optional formal after rest args");
        }
        if (t == null) {
            this.optionalFormals.add(null);
        } else if (t.isBottom()) {
            this.optionalFormals.add(JSType.BOTTOM);
        } else {
            this.optionalFormals.add(JSType.join(t, JSType.UNDEFINED));
        }
        return this;
    }

    public FunctionTypeBuilder addOuterVarPrecondition(String name, JSType t) {
        this.outerVars.put(name, t);
        return this;
    }

    public FunctionTypeBuilder addRestFormals(JSType t) {
        this.restFormals = t;
        return this;
    }

    public FunctionTypeBuilder addRetType(JSType t) {
        this.returnType = t;
        return this;
    }

    public FunctionTypeBuilder addLoose() {
        this.loose = true;
        return this;
    }

    public FunctionTypeBuilder addNominalType(NominalType cl) {
        this.nominalType = cl;
        return this;
    }

    public FunctionTypeBuilder addTypeParameters(ImmutableList<String> typeParameters) {
        this.typeParameters = typeParameters;
        return this;
    }

    public FunctionTypeBuilder addReceiverType(NominalType cl) {
        this.receiverType = cl;
        return this;
    }

    public DeclaredFunctionType buildDeclaration() {
        Preconditions.checkState((!this.loose ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.outerVars.isEmpty());
        return DeclaredFunctionType.make(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.receiverType, this.typeParameters);
    }

    public FunctionType buildFunction() {
        FunctionType result = FunctionType.normalized(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.receiverType, this.outerVars, this.typeParameters, this.loose);
        result.checkValid();
        return result;
    }

    public JSType buildType() {
        return JSType.fromFunctionType(this.buildFunction());
    }

    static class WrongParameterOrderException
    extends RuntimeException {
        WrongParameterOrderException(String message) {
            super(message);
        }
    }
}

