/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.Scope;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.rhino.Node;
import java.util.Set;

class ContinueFuzzer
extends AbstractFuzzer {
    ContinueFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected boolean isEnough(int budget) {
        Scope scope = this.context.scopeManager.localScope();
        if (scope.loopNesting > 0) {
            return budget >= 1;
        }
        return false;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        Node node = new Node(117);
        Scope localScope = this.context.scopeManager.localScope();
        double toLabel = this.getOwnConfig().get("toLabel").getAsDouble();
        if (budget > 1 && !localScope.loopLabels.isEmpty() && this.context.random.nextDouble() < toLabel) {
            node.addChildToBack(Node.newString(153, localScope.randomLabelForContinue(this.context.random)));
        }
        return node;
    }

    @Override
    protected String getConfigName() {
        return "continue";
    }
}

