/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FunctionType {
    private final ImmutableList<JSType> requiredFormals;
    private final ImmutableList<JSType> optionalFormals;
    private final JSType restFormals;
    private final JSType returnType;
    private final boolean isLoose;
    private final ImmutableMap<String, JSType> outerVarPreconditions;
    private final NominalType nominalType;
    private final ImmutableList<String> typeParameters;
    public static final FunctionType TOP_FUNCTION = new FunctionType(null, null, null, null, null, null, null, false);
    public static final FunctionType LOOSE_TOP_FUNCTION = new FunctionType(null, null, null, null, null, null, null, true);
    static final FunctionType QMARK_FUNCTION = FunctionType.normalized(null, null, JSType.UNKNOWN, JSType.UNKNOWN, null, null, null, true);

    private FunctionType(ImmutableList<JSType> requiredFormals, ImmutableList<JSType> optionalFormals, JSType restFormals, JSType retType, NominalType nominalType, ImmutableMap<String, JSType> outerVars, ImmutableList<String> typeParameters, boolean isLoose) {
        this.requiredFormals = requiredFormals;
        this.optionalFormals = optionalFormals;
        this.restFormals = restFormals;
        this.returnType = retType;
        this.nominalType = nominalType;
        this.outerVarPreconditions = outerVars;
        this.typeParameters = typeParameters;
        this.isLoose = isLoose;
    }

    void checkValid() {
        if (this.isTopFunction()) {
            return;
        }
        for (JSType formal : this.requiredFormals) {
            Preconditions.checkState((formal != null ? 1 : 0) != 0);
        }
        for (JSType formal : this.optionalFormals) {
            Preconditions.checkState((formal != null ? 1 : 0) != 0);
        }
        Preconditions.checkState((this.returnType != null ? 1 : 0) != 0);
    }

    public boolean isLoose() {
        return this.isLoose;
    }

    FunctionType withLoose() {
        if (this.isTopFunction()) {
            return LOOSE_TOP_FUNCTION;
        }
        return new FunctionType(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.outerVarPreconditions, this.typeParameters, true);
    }

    static FunctionType normalized(List<JSType> requiredFormals, List<JSType> optionalFormals, JSType restFormals, JSType retType, NominalType nominalType, Map<String, JSType> outerVars, ImmutableList<String> typeParameters, boolean isLoose) {
        if (requiredFormals == null) {
            requiredFormals = ImmutableList.of();
        }
        if (optionalFormals == null) {
            optionalFormals = ImmutableList.of();
        }
        if (outerVars == null) {
            outerVars = ImmutableMap.of();
        }
        if (restFormals != null) {
            for (int i = optionalFormals.size() - 1; i >= 0 && restFormals.equals(optionalFormals.get(i)); --i) {
                optionalFormals.remove(i);
            }
        }
        return new FunctionType((ImmutableList<JSType>)ImmutableList.copyOf((Collection)requiredFormals), (ImmutableList<JSType>)ImmutableList.copyOf((Collection)optionalFormals), restFormals, retType, nominalType, (ImmutableMap<String, JSType>)ImmutableMap.copyOf((Map)outerVars), typeParameters, isLoose);
    }

    @VisibleForTesting
    static JSType makeJSType(ImmutableList<JSType> requiredFormals, ImmutableList<JSType> optionalFormals, JSType restFormals, JSType retType) {
        return JSType.fromFunctionType(FunctionType.normalized(requiredFormals, optionalFormals, restFormals, retType, null, null, null, false));
    }

    public boolean isTopFunction() {
        if (this.requiredFormals == null) {
            Preconditions.checkState((this == TOP_FUNCTION || this == LOOSE_TOP_FUNCTION ? 1 : 0) != 0);
        }
        return this == TOP_FUNCTION || this == LOOSE_TOP_FUNCTION;
    }

    public boolean isConstructor() {
        return this.nominalType != null && !this.nominalType.isInterface();
    }

    boolean isInterfaceDefinition() {
        return this.nominalType != null && this.nominalType.isInterface();
    }

    public JSType getFormalType(int argpos) {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        this.checkValid();
        int numReqFormals = this.requiredFormals.size();
        if (argpos < numReqFormals) {
            Preconditions.checkState((null != this.requiredFormals.get(argpos) ? 1 : 0) != 0);
            return (JSType)this.requiredFormals.get(argpos);
        }
        if (argpos < numReqFormals + this.optionalFormals.size()) {
            Preconditions.checkState((null != this.optionalFormals.get(argpos - numReqFormals) ? 1 : 0) != 0);
            return (JSType)this.optionalFormals.get(argpos - numReqFormals);
        }
        return this.restFormals;
    }

    public JSType getReturnType() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        if (this.isConstructor()) {
            return this.getTypeOfThis();
        }
        return this.returnType;
    }

    public JSType getOuterVarPrecondition(String name) {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return (JSType)this.outerVarPreconditions.get((Object)name);
    }

    public int getMinArity() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return this.requiredFormals.size();
    }

    public int getMaxArity() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        if (this.restFormals != null) {
            return Integer.MAX_VALUE;
        }
        return this.requiredFormals.size() + this.optionalFormals.size();
    }

    public JSType getTypeOfThis() {
        Preconditions.checkNotNull((Object)this.nominalType);
        return JSType.fromObjectType(ObjectType.fromNominalType(this.nominalType));
    }

    public JSType createConstructorObject() {
        Preconditions.checkState((this.nominalType != null ? 1 : 0) != 0);
        return this.nominalType.createConstructorObject(this);
    }

    private static JSType nullAcceptingJoin(JSType t1, JSType t2) {
        Preconditions.checkArgument((t1 != null || t2 != null ? 1 : 0) != 0);
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return JSType.join(t1, t2);
    }

    private static JSType nullAcceptingMeet(JSType t1, JSType t2) {
        Preconditions.checkArgument((t1 != null || t2 != null ? 1 : 0) != 0);
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return JSType.meet(t1, t2);
    }

    private static FunctionType looseJoin(FunctionType f1, FunctionType f2) {
        Preconditions.checkArgument((f1.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int minRequiredArity = Math.min(f1.getMinArity(), f2.getMinArity());
        for (int i = 0; i < minRequiredArity; ++i) {
            builder.addReqFormal(FunctionType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = minRequiredArity; i < maxTotalArity; ++i) {
            builder.addOptFormal(FunctionType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        return builder.addRetType(FunctionType.nullAcceptingJoin(f1.returnType, f2.returnType)).addLoose().buildFunction();
    }

    public boolean isSubtypeOf(FunctionType other) {
        int i;
        if (other.isTopFunction()) {
            return true;
        }
        if (this.isTopFunction()) {
            return false;
        }
        if (this.isGeneric()) {
            return true;
        }
        Preconditions.checkState((!other.isGeneric() ? 1 : 0) != 0);
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        for (i = 0; i < other.requiredFormals.size(); ++i) {
            JSType formalType = other.getFormalType(i);
            builder.addReqFormal(formalType.isUnknown() ? JSType.BOTTOM : formalType);
        }
        for (int j = 0; j < other.optionalFormals.size(); ++j) {
            JSType formalType = other.getFormalType(i + j);
            builder.addOptFormal(formalType.isUnknown() ? JSType.BOTTOM : formalType);
        }
        if (other.restFormals != null) {
            JSType formalType = other.restFormals;
            builder.addOptFormal(formalType.isUnknown() ? JSType.BOTTOM : formalType);
        }
        if (this.returnType.isUnknown()) {
            builder.addRetType(JSType.UNKNOWN);
        } else {
            builder.addRetType(other.returnType);
        }
        if (other.isLoose()) {
            builder.addLoose();
        }
        builder.addNominalType(other.nominalType);
        FunctionType newOther = builder.buildFunction();
        return newOther.equals(FunctionType.join(this, newOther));
    }

    static FunctionType join(FunctionType f1, FunctionType f2) {
        if (f1 == null) {
            return f2;
        }
        if (f2 == null || f1.equals(f2)) {
            return f1;
        }
        if (f1.isTopFunction() || f2.isTopFunction()) {
            return TOP_FUNCTION;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseJoin(f1, f2);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int maxRequiredArity = Math.max(f1.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < maxRequiredArity; ++i) {
            JSType reqFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i), f2.getFormalType(i));
            builder.addReqFormal(reqFormal);
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = maxRequiredArity; i < maxTotalArity; ++i) {
            JSType optFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i), f2.getFormalType(i));
            builder.addOptFormal(optFormal);
        }
        if (f1.restFormals != null && f2.restFormals != null) {
            builder.addRestFormals(FunctionType.nullAcceptingMeet(f1.restFormals, f2.restFormals));
        }
        builder.addRetType(JSType.join(f1.returnType, f2.returnType));
        return builder.buildFunction();
    }

    FunctionType specialize(FunctionType other) {
        if (other == null) {
            return null;
        }
        if (!this.isLoose() && other.isLoose()) {
            return this;
        }
        return FunctionType.meet(this, other);
    }

    static FunctionType meet(FunctionType f1, FunctionType f2) {
        if (f1 == null || f2 == null) {
            return null;
        }
        if (f1.isTopFunction()) {
            return f2;
        }
        if (f2.isTopFunction() || f1.equals(f2)) {
            return f1;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseJoin(f1, f2);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int minRequiredArity = Math.min(f1.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < minRequiredArity; ++i) {
            builder.addReqFormal(FunctionType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = minRequiredArity; i < maxTotalArity; ++i) {
            builder.addOptFormal(FunctionType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        if (f1.restFormals != null || f2.restFormals != null) {
            builder.addRestFormals(FunctionType.nullAcceptingJoin(f1.restFormals, f2.restFormals));
        }
        builder.addRetType(JSType.meet(f1.returnType, f2.returnType));
        return builder.buildFunction();
    }

    boolean isLooseSubtypeOf(FunctionType f2) {
        Preconditions.checkState((this.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        if (this.isTopFunction() || f2.isTopFunction()) {
            return true;
        }
        int maxRequiredArity = Math.max(this.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < maxRequiredArity; ++i) {
            if (!JSType.meet(this.getFormalType(i), f2.getFormalType(i)).isBottom()) continue;
            return false;
        }
        return this.getReturnType().isBottom() || f2.getReturnType().isBottom() || !JSType.meet(this.getReturnType(), f2.getReturnType()).isBottom();
    }

    public boolean isGeneric() {
        return this.typeParameters != null;
    }

    public List<String> getTypeParameters() {
        return this.typeParameters;
    }

    boolean unifyWith(FunctionType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        Preconditions.checkState((this.nominalType == null ? 1 : 0) != 0);
        Preconditions.checkState((this.typeParameters == null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.outerVarPreconditions.isEmpty());
        if (this.requiredFormals.size() != other.requiredFormals.size()) {
            return false;
        }
        UnmodifiableIterator thisReqFormals = this.requiredFormals.iterator();
        UnmodifiableIterator otherReqFormals = other.requiredFormals.iterator();
        while (thisReqFormals.hasNext()) {
            JSType otherReqFormal;
            JSType reqFormal = (JSType)thisReqFormals.next();
            if (reqFormal.unifyWith(otherReqFormal = (JSType)otherReqFormals.next(), typeParameters, typeMultimap)) continue;
            return false;
        }
        if (this.optionalFormals.size() != other.optionalFormals.size()) {
            return false;
        }
        UnmodifiableIterator thisOptFormals = this.optionalFormals.iterator();
        UnmodifiableIterator otherOptFormals = other.optionalFormals.iterator();
        while (thisOptFormals.hasNext()) {
            JSType otherOptFormal;
            JSType optFormal = (JSType)thisOptFormals.next();
            if (optFormal.unifyWith(otherOptFormal = (JSType)otherOptFormals.next(), typeParameters, typeMultimap)) continue;
            return false;
        }
        if (this.restFormals == null && other.restFormals != null || this.restFormals != null && other.restFormals == null) {
            return false;
        }
        if (this.restFormals != null && !this.restFormals.unifyWith(other.restFormals, typeParameters, typeMultimap)) {
            return false;
        }
        return this.returnType.unifyWith(other.returnType, typeParameters, typeMultimap);
    }

    private FunctionType applyInstantiation(boolean keepTypeParams, Map<String, JSType> typeMap) {
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        for (JSType reqFormal : this.requiredFormals) {
            builder.addReqFormal(reqFormal.substituteGenerics(typeMap));
        }
        for (JSType optFormal : this.optionalFormals) {
            builder.addOptFormal(optFormal.substituteGenerics(typeMap));
        }
        if (this.restFormals != null) {
            builder.addRestFormals(this.restFormals.substituteGenerics(typeMap));
        }
        builder.addRetType(this.returnType.substituteGenerics(typeMap));
        if (this.isLoose) {
            builder.addLoose();
        }
        if (this.nominalType != null) {
            builder.addNominalType(this.nominalType.instantiateGenerics(typeMap));
        }
        for (String var : this.outerVarPreconditions.keySet()) {
            builder.addOuterVarPrecondition(var, (JSType)this.outerVarPreconditions.get((Object)var));
        }
        if (keepTypeParams) {
            builder.addTypeParameters(this.typeParameters);
        }
        return builder.buildFunction();
    }

    FunctionType substituteGenerics(Map<String, JSType> concreteTypes) {
        Preconditions.checkState((boolean)this.outerVarPreconditions.isEmpty());
        ImmutableMap typeMap = concreteTypes;
        if (this.typeParameters != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String typeParam : concreteTypes.keySet()) {
                if (this.typeParameters.contains((Object)typeParam)) continue;
                builder.put((Object)typeParam, concreteTypes.get(typeParam));
            }
            typeMap = builder.build();
        }
        return this.applyInstantiation(true, (Map<String, JSType>)typeMap);
    }

    public FunctionType instantiateGenerics(Map<String, JSType> typeMap) {
        for (String typeParam : typeMap.keySet()) {
            Preconditions.checkState((boolean)this.typeParameters.contains((Object)typeParam));
        }
        return this.applyInstantiation(false, typeMap);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(obj instanceof FunctionType), (String)"obj is: %s", (Object[])new Object[]{obj});
        FunctionType f2 = (FunctionType)obj;
        return Objects.equal(this.requiredFormals, f2.requiredFormals) && Objects.equal(this.optionalFormals, f2.optionalFormals) && Objects.equal((Object)this.restFormals, (Object)f2.restFormals) && Objects.equal((Object)this.returnType, (Object)f2.returnType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType});
    }

    public String toString() {
        if (this.isTopFunction()) {
            return "TOP_FUNCTION" + (this.isLoose ? " (loose)" : "");
        }
        LinkedList formals = Lists.newLinkedList();
        if (this.nominalType != null) {
            formals.add("new:" + this.nominalType.getName());
        }
        for (JSType formal : this.requiredFormals) {
            formals.add(formal.toString());
        }
        for (JSType formal : this.optionalFormals) {
            formals.add(formal.toString() + "=");
        }
        if (this.restFormals != null) {
            formals.add("..." + this.restFormals.toString());
        }
        String result = "function (" + Joiner.on((String)", ").join((Iterable)formals) + ")";
        if (this.returnType != null) {
            result = result + ": " + this.returnType.toString();
        }
        return result + (this.isLoose ? " (loose)" : "") + (this.outerVarPreconditions.isEmpty() ? "" : "\tFV:" + this.outerVarPreconditions);
    }
}

