/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;

class PeepholeFoldWithTypes
extends AbstractPeepholeOptimization {
    PeepholeFoldWithTypes() {
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        switch (subtree.getType()) {
            case 32: {
                return this.tryFoldTypeof(subtree);
            }
        }
        return subtree;
    }

    private Node tryFoldTypeof(Node typeofNode) {
        Preconditions.checkArgument((boolean)typeofNode.isTypeOf());
        Preconditions.checkArgument((typeofNode.getFirstChild() != null ? 1 : 0) != 0);
        Node argumentNode = typeofNode.getFirstChild();
        if (!NodeUtil.isLiteralValue(argumentNode, true) && !this.mayHaveSideEffects(argumentNode)) {
            JSType argumentType = argumentNode.getJSType();
            String typeName = null;
            if (argumentType != null) {
                if (argumentType.isObject() || argumentType.isNullType()) {
                    typeName = "object";
                } else if (argumentType.isStringValueType()) {
                    typeName = "string";
                } else if (argumentType.isNumberValueType()) {
                    typeName = "number";
                } else if (argumentType.isBooleanValueType()) {
                    typeName = "boolean";
                } else if (argumentType.isVoidType()) {
                    typeName = "undefined";
                } else if (argumentType.isUnionType()) {
                    typeName = null;
                }
                if (typeName != null) {
                    Node newNode = IR.string(typeName);
                    typeofNode.getParent().replaceChild(typeofNode, newNode);
                    this.reportCodeChange();
                    return newNode;
                }
            }
        }
        return typeofNode;
    }
}

