/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TemplateType;
import java.io.Serializable;
import java.util.Iterator;

public class TemplateTypeMap
implements Serializable {
    private final ImmutableList<TemplateType> templateKeys;
    private final ImmutableList<JSType> templateValues;
    final JSTypeRegistry registry;

    TemplateTypeMap(JSTypeRegistry registry, ImmutableList<TemplateType> templateKeys, ImmutableList<JSType> templateValues) {
        Preconditions.checkNotNull(templateKeys);
        Preconditions.checkNotNull(templateValues);
        this.registry = registry;
        this.templateKeys = templateKeys;
        int nKeys = templateKeys.size();
        this.templateValues = templateValues.size() > nKeys ? templateValues.subList(0, nKeys) : templateValues;
    }

    public ImmutableList<TemplateType> getTemplateKeys() {
        return this.templateKeys;
    }

    public boolean hasTemplateKey(TemplateType templateKey) {
        for (TemplateType entry : this.templateKeys) {
            if (entry != templateKey) continue;
            return true;
        }
        return false;
    }

    int numUnfilledTemplateKeys() {
        return this.templateKeys.size() - this.templateValues.size();
    }

    ImmutableList<TemplateType> getUnfilledTemplateKeys() {
        return this.templateKeys.subList(this.templateValues.size(), this.templateKeys.size());
    }

    public boolean hasTemplateType(TemplateType key) {
        return this.getTemplateTypeInternal(key) != null;
    }

    public JSType getTemplateType(TemplateType key) {
        JSType templateType = this.getTemplateTypeInternal(key);
        return templateType == null ? this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE) : templateType;
    }

    public TemplateType getTemplateTypeKeyByName(String keyName) {
        for (TemplateType key : this.templateKeys) {
            if (!key.getReferenceName().equals(keyName)) continue;
            return key;
        }
        return null;
    }

    private JSType getTemplateTypeInternal(TemplateType key) {
        TemplateType item;
        int index = 0;
        Iterator i$ = this.templateKeys.iterator();
        while (i$.hasNext() && (item = (TemplateType)i$.next()) != key) {
            ++index;
        }
        if (index < 0 || index >= this.templateValues.size()) {
            return null;
        }
        return (JSType)this.templateValues.get(index);
    }

    public boolean checkEquivalenceHelper(TemplateTypeMap that, EquivalenceMethod eqMethod) {
        int thisNumKeys = this.templateKeys.size();
        int thatNumKeys = that.getTemplateKeys().size();
        for (int i = 0; i < Math.min(thisNumKeys, thatNumKeys); ++i) {
            JSType thatTemplateType;
            JSType thisTemplateType = this.getTemplateType((TemplateType)this.templateKeys.get(i));
            if (thisTemplateType.checkEquivalenceHelper(thatTemplateType = that.getTemplateType((TemplateType)that.getTemplateKeys().get(i)), eqMethod)) continue;
            return false;
        }
        return thisNumKeys == thatNumKeys || eqMethod == EquivalenceMethod.INVARIANT;
    }

    TemplateTypeMap extendKeys(ImmutableList<TemplateType> newKeys) {
        return this.registry.createTemplateTypeMap(this.concatImmutableLists(this.templateKeys, newKeys), this.templateValues);
    }

    TemplateTypeMap extendValues(ImmutableList<JSType> newValues) {
        int numUnfilledKeys = this.numUnfilledTemplateKeys();
        if (numUnfilledKeys < newValues.size()) {
            newValues = newValues.subList(0, numUnfilledKeys);
        }
        return this.registry.createTemplateTypeMap(this.templateKeys, this.concatImmutableLists(this.templateValues, newValues));
    }

    private <T> ImmutableList<T> concatImmutableLists(ImmutableList<T> first, ImmutableList<T> second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(first);
        builder.addAll(second);
        return builder.build();
    }

    boolean hasAnyTemplateTypesInternal() {
        for (JSType templateValue : this.templateValues) {
            if (!templateValue.hasAnyTemplateTypes()) continue;
            return true;
        }
        return false;
    }
}

