/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ReplaceIdGenerators
implements CompilerPass {
    static final DiagnosticType NON_GLOBAL_ID_GENERATOR_CALL = DiagnosticType.error("JSC_NON_GLOBAL_ID_GENERATOR_CALL", "Id generator call must be in the global scope");
    static final DiagnosticType CONDITIONAL_ID_GENERATOR_CALL = DiagnosticType.error("JSC_CONDITIONAL_ID_GENERATOR_CALL", "Id generator call must be unconditional");
    static final DiagnosticType CONFLICTING_GENERATOR_TYPE = DiagnosticType.error("JSC_CONFLICTING_ID_GENERATOR_TYPE", "Id generator can only be consistent or inconsistent");
    private final AbstractCompiler compiler;
    private final Map<String, NameSupplier> nameGenerators;
    private final Map<String, NameSupplier> consistNameGenerators;
    private final Map<String, Map<String, String>> consistNameMap;
    private final Map<String, List<Replacement>> idGeneratorMaps;
    private final boolean generatePseudoNames;

    public ReplaceIdGenerators(AbstractCompiler compiler, Set<String> idGens, boolean generatePseudoNames) {
        this.compiler = compiler;
        this.generatePseudoNames = generatePseudoNames;
        this.nameGenerators = Maps.newLinkedHashMap();
        this.consistNameGenerators = Maps.newLinkedHashMap();
        this.idGeneratorMaps = Maps.newLinkedHashMap();
        this.consistNameMap = Maps.newLinkedHashMap();
        if (idGens != null) {
            for (String gen : idGens) {
                this.nameGenerators.put(gen, this.createNameSupplier());
                this.idGeneratorMaps.put(gen, Lists.newLinkedList());
            }
        }
    }

    private NameSupplier createNameSupplier() {
        if (this.generatePseudoNames) {
            return new PseudoNameSuppier();
        }
        return new ObfuscatedNameSuppier();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new GatherGenerators());
        if (!this.nameGenerators.isEmpty() || !this.consistNameGenerators.isEmpty()) {
            NodeTraversal.traverse(this.compiler, root, new ReplaceGenerators());
        }
    }

    public String getIdGeneratorMap() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<Replacement>> entry : this.idGeneratorMaps.entrySet()) {
            sb.append("[");
            sb.append(entry.getKey());
            sb.append("]\n\n");
            for (Replacement replacement : entry.getValue()) {
                sb.append(replacement.toString());
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static class Replacement {
        private final String name;
        private final String sourceName;
        private final int lineNumber;

        private Replacement(String name, String sourceName, int lineNumber) {
            this.name = name;
            this.sourceName = sourceName;
            this.lineNumber = lineNumber;
        }

        public String toString() {
            return this.name + ":" + this.sourceName + ":" + this.lineNumber;
        }
    }

    private class ReplaceGenerators
    extends NodeTraversal.AbstractPostOrderCallback {
        private ReplaceGenerators() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node id;
            if (!n.isCall()) {
                return;
            }
            String callName = n.getFirstChild().getQualifiedName();
            boolean consistent = false;
            NameSupplier nameGenerator = (NameSupplier)ReplaceIdGenerators.this.nameGenerators.get(callName);
            if (nameGenerator == null) {
                nameGenerator = (NameSupplier)ReplaceIdGenerators.this.consistNameGenerators.get(callName);
                consistent = true;
            }
            if (nameGenerator == null) {
                return;
            }
            if (!t.inGlobalScope() && !consistent) {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, NON_GLOBAL_ID_GENERATOR_CALL, new String[0]));
                return;
            }
            if (!consistent) {
                for (Node ancestor : n.getAncestors()) {
                    if (!NodeUtil.isControlStructure(ancestor)) continue;
                    ReplaceIdGenerators.this.compiler.report(t.makeError(n, CONDITIONAL_ID_GENERATOR_CALL, new String[0]));
                    return;
                }
            }
            if (!(id = n.getFirstChild().getNext()).isString()) {
                return;
            }
            List idGeneratorMap = (List)ReplaceIdGenerators.this.idGeneratorMaps.get(callName);
            String rename = null;
            if (consistent) {
                Map entry = (Map)ReplaceIdGenerators.this.consistNameMap.get(callName);
                rename = (String)entry.get(id.getString());
                if (rename == null) {
                    rename = nameGenerator.getName(id.getString());
                    entry.put(id.getString(), rename);
                }
            } else {
                rename = nameGenerator.getName(id.getString());
            }
            parent.replaceChild(n, IR.string(rename));
            idGeneratorMap.add(new Replacement(rename, t.getSourceName(), t.getLineNumber()));
            ReplaceIdGenerators.this.compiler.reportCodeChange();
        }
    }

    private class GatherGenerators
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherGenerators() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo doc = n.getJSDocInfo();
            if (doc == null) {
                return;
            }
            if (!doc.isConsistentIdGenerator() && !doc.isIdGenerator()) {
                return;
            }
            if (doc.isConsistentIdGenerator() && doc.isIdGenerator()) {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, CONFLICTING_GENERATOR_TYPE, new String[0]));
            }
            String name = null;
            if (n.isAssign()) {
                name = n.getFirstChild().getQualifiedName();
            } else if (n.isVar()) {
                name = n.getFirstChild().getString();
            } else if (n.isFunction() && (name = n.getFirstChild().getString()).isEmpty()) {
                return;
            }
            if (doc.isConsistentIdGenerator()) {
                ReplaceIdGenerators.this.consistNameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier());
                ReplaceIdGenerators.this.consistNameMap.put(name, Maps.newLinkedHashMap());
            } else {
                ReplaceIdGenerators.this.nameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier());
            }
            ReplaceIdGenerators.this.idGeneratorMaps.put(name, Lists.newArrayList());
        }
    }

    private static class PseudoNameSuppier
    implements NameSupplier {
        private int counter = 0;

        private PseudoNameSuppier() {
        }

        @Override
        public String getName(String name) {
            return name + "$" + this.counter++;
        }
    }

    private static class ObfuscatedNameSuppier
    implements NameSupplier {
        private final NameGenerator generator = new NameGenerator(Collections.<String>emptySet(), "", null);

        private ObfuscatedNameSuppier() {
        }

        @Override
        public String getName(String name) {
            return this.generator.generateNextName();
        }
    }

    private static interface NameSupplier {
        public String getName(String var1);
    }
}

