/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.StaticReference;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import com.google.javascript.rhino.jstype.UnionType;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class PrototypeObjectType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final Map<String, Property> properties = Maps.newTreeMap();
    private final boolean nativeType;
    private ObjectType implicitPrototypeFallback;
    private boolean prettyPrint = false;
    private static final int MAX_PRETTY_PRINTED_PROPERTIES = 4;

    PrototypeObjectType(JSTypeRegistry registry, String className, ObjectType implicitPrototype) {
        this(registry, className, implicitPrototype, false);
    }

    PrototypeObjectType(JSTypeRegistry registry, String className, ObjectType implicitPrototype, boolean nativeType) {
        super(registry);
        this.className = className;
        this.nativeType = nativeType;
        if (nativeType || implicitPrototype != null) {
            this.setImplicitPrototype(implicitPrototype);
        } else {
            this.setImplicitPrototype(registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE));
        }
    }

    @Override
    public StaticSlot<JSType> getSlot(String name) {
        StaticSlot<JSType> prop;
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null && (prop = implicitPrototype.getSlot(name)) != null) {
            return prop;
        }
        for (ObjectType interfaceType : this.getCtorExtendedInterfaces()) {
            StaticSlot<JSType> prop2 = interfaceType.getSlot(name);
            if (prop2 == null) continue;
            return prop2;
        }
        return null;
    }

    @Override
    public int getPropertiesCount() {
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype == null) {
            return this.properties.size();
        }
        int localCount = 0;
        for (String property : this.properties.keySet()) {
            if (implicitPrototype.hasProperty(property)) continue;
            ++localCount;
        }
        return implicitPrototype.getPropertiesCount() + localCount;
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.isUnknownType() || this.getSlot(propertyName) != null;
    }

    @Override
    public boolean hasOwnProperty(String propertyName) {
        return this.properties.get(propertyName) != null;
    }

    @Override
    public Set<String> getOwnPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public boolean isPropertyTypeDeclared(String property) {
        StaticSlot<JSType> slot = this.getSlot(property);
        if (slot == null) {
            return false;
        }
        return !slot.isTypeInferred();
    }

    @Override
    void collectPropertyNames(Set<String> props) {
        for (String prop : this.properties.keySet()) {
            props.add(prop);
        }
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null) {
            implicitPrototype.collectPropertyNames(props);
        }
    }

    @Override
    public boolean isPropertyTypeInferred(String property) {
        StaticSlot<JSType> slot = this.getSlot(property);
        if (slot == null) {
            return false;
        }
        return slot.isTypeInferred();
    }

    @Override
    public JSType getPropertyType(String property) {
        StaticSlot<JSType> slot = this.getSlot(property);
        if (slot == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return slot.getType();
    }

    @Override
    public boolean isPropertyInExterns(String propertyName) {
        Property p = this.properties.get(propertyName);
        if (p != null) {
            return p.isFromExterns();
        }
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null) {
            return implicitPrototype.isPropertyInExterns(propertyName);
        }
        return false;
    }

    @Override
    boolean defineProperty(String name, JSType type, boolean inferred, Node propertyNode) {
        if (this.hasOwnDeclaredProperty(name)) {
            return false;
        }
        Property newProp = new Property(name, type, inferred, propertyNode);
        Property oldProp = this.properties.get(name);
        if (oldProp != null) {
            newProp.docInfo = oldProp.docInfo;
        }
        this.properties.put(name, newProp);
        return true;
    }

    @Override
    public boolean removeProperty(String name) {
        return this.properties.remove(name) != null;
    }

    @Override
    public Node getPropertyNode(String propertyName) {
        Property p = this.properties.get(propertyName);
        if (p != null) {
            return p.propertyNode;
        }
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null) {
            return implicitPrototype.getPropertyNode(propertyName);
        }
        return null;
    }

    @Override
    public JSDocInfo getOwnPropertyJSDocInfo(String propertyName) {
        Property p = this.properties.get(propertyName);
        if (p != null) {
            return p.docInfo;
        }
        return null;
    }

    @Override
    public void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
        if (info != null) {
            Property property;
            if (!this.properties.containsKey(propertyName)) {
                this.defineInferredProperty(propertyName, this.getPropertyType(propertyName), null);
            }
            if ((property = this.properties.get(propertyName)) != null) {
                property.docInfo = info;
            }
        }
    }

    @Override
    public boolean matchesNumberContext() {
        return this.isNumberObjectType() || this.isDateType() || this.isBooleanObjectType() || this.isStringObjectType() || this.hasOverridenNativeProperty("valueOf");
    }

    @Override
    public boolean matchesStringContext() {
        return this.isTheObjectType() || this.isStringObjectType() || this.isDateType() || this.isRegexpType() || this.isArrayType() || this.isNumberObjectType() || this.isBooleanObjectType() || this.hasOverridenNativeProperty("toString");
    }

    private boolean hasOverridenNativeProperty(String propertyName) {
        if (this.isNative()) {
            return false;
        }
        JSType propertyType = this.getPropertyType(propertyName);
        ObjectType nativeType = this.isFunctionType() ? this.registry.getNativeObjectType(JSTypeNative.FUNCTION_PROTOTYPE) : this.registry.getNativeObjectType(JSTypeNative.OBJECT_PROTOTYPE);
        JSType nativePropertyType = nativeType.getPropertyType(propertyName);
        return propertyType != nativePropertyType;
    }

    @Override
    public JSType unboxesTo() {
        if (this.isStringObjectType()) {
            return this.getNativeType(JSTypeNative.STRING_TYPE);
        }
        if (this.isBooleanObjectType()) {
            return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }
        if (this.isNumberObjectType()) {
            return this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }
        return super.unboxesTo();
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public boolean canBeCalled() {
        return this.isRegexpType();
    }

    boolean isNative() {
        return this.nativeType;
    }

    public String toString() {
        if (this.hasReferenceName()) {
            return this.getReferenceName();
        }
        if (this.prettyPrint) {
            TreeSet propertyNames = Sets.newTreeSet();
            for (ObjectType current = this; current != null && !((ObjectType)current).isNativeObjectType() && propertyNames.size() <= 4; current = ((ObjectType)current).getImplicitPrototype()) {
                propertyNames.addAll(((ObjectType)current).getOwnPropertyNames());
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            int i = 0;
            for (String property : propertyNames) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(property);
                sb.append(": ");
                sb.append(this.getPropertyType(property).toString());
                if (++i != 4) continue;
                sb.append(", ...");
                break;
            }
            sb.append("}");
            return sb.toString();
        }
        return "{...}";
    }

    void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.implicitPrototypeFallback;
    }

    final void setImplicitPrototype(ObjectType implicitPrototype) {
        Preconditions.checkState((!this.hasCachedValues() ? 1 : 0) != 0);
        this.implicitPrototypeFallback = implicitPrototype;
    }

    @Override
    public String getReferenceName() {
        if (this.className != null) {
            return this.className;
        }
        return null;
    }

    @Override
    public boolean hasReferenceName() {
        return this.className != null;
    }

    @Override
    public boolean isSubtype(JSType that) {
        FunctionType thatCtor;
        if (JSType.isSubtype(this, that)) {
            return true;
        }
        if (that instanceof UnionType) {
            return false;
        }
        if (that instanceof RecordType) {
            return RecordType.isSubtype(this, (RecordType)that);
        }
        ObjectType thatObj = that.toObjectType();
        FunctionType functionType = thatCtor = thatObj == null ? null : thatObj.getConstructor();
        if (thatCtor != null && ((JSType)thatCtor).isInterface()) {
            Iterable<ObjectType> thisInterfaces = this.getCtorImplementedInterfaces();
            for (ObjectType thisInterface : thisInterfaces) {
                if (!thisInterface.isSubtype(that)) continue;
                return true;
            }
        }
        if (this.getConstructor() != null && this.getConstructor().isInterface()) {
            for (ObjectType thisInterface : this.getCtorExtendedInterfaces()) {
                if (!thisInterface.isSubtype(that)) continue;
                return true;
            }
        }
        if (this.isUnknownType() || this.implicitPrototypeChainIsUnknown()) {
            return true;
        }
        return this.isImplicitPrototype(thatObj);
    }

    private boolean implicitPrototypeChainIsUnknown() {
        for (ObjectType p = this.getImplicitPrototype(); p != null; p = p.getImplicitPrototype()) {
            if (!p.isUnknownType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCachedValues() {
        return super.hasCachedValues();
    }

    @Override
    public boolean isNativeObjectType() {
        return this.nativeType;
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> scope) {
        this.setResolvedTypeInternal(this);
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null) {
            this.implicitPrototypeFallback = (ObjectType)implicitPrototype.resolve(t, scope);
        }
        for (Property prop : this.properties.values()) {
            prop.type = PrototypeObjectType.safeResolve(prop.type, t, scope);
        }
        return this;
    }

    private static final class Property
    implements Serializable,
    StaticSlot<JSType>,
    StaticReference<JSType> {
        private static final long serialVersionUID = 1L;
        private String name;
        private JSType type;
        private final boolean inferred;
        private final Node propertyNode;
        private JSDocInfo docInfo = null;

        private Property(String name, JSType type, boolean inferred, Node propertyNode) {
            this.name = name;
            this.type = type;
            this.inferred = inferred;
            this.propertyNode = propertyNode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Node getNode() {
            return this.propertyNode;
        }

        @Override
        public StaticSourceFile getSourceFile() {
            return this.propertyNode == null ? null : this.propertyNode.getStaticSourceFile();
        }

        public Property getSymbol() {
            return this;
        }

        public Property getDeclaration() {
            return this.propertyNode == null ? null : this;
        }

        @Override
        public JSType getType() {
            return this.type;
        }

        @Override
        public boolean isTypeInferred() {
            return this.inferred;
        }

        boolean isFromExterns() {
            return this.propertyNode == null ? false : this.propertyNode.isFromExterns();
        }
    }
}

