/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;

public class InstanceObjectType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private final FunctionType constructor;

    InstanceObjectType(JSTypeRegistry registry, FunctionType constructor) {
        this(registry, constructor, false);
    }

    InstanceObjectType(JSTypeRegistry registry, FunctionType constructor, boolean isNativeType) {
        super(registry, null, null, isNativeType);
        Preconditions.checkNotNull((Object)constructor);
        this.constructor = constructor;
    }

    @Override
    public String getReferenceName() {
        return this.getConstructor().getReferenceName();
    }

    @Override
    public boolean hasReferenceName() {
        return this.getConstructor().hasReferenceName();
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.getConstructor().getPrototype();
    }

    @Override
    public FunctionType getConstructor() {
        return this.constructor;
    }

    @Override
    boolean defineProperty(String name, JSType type, boolean inferred, Node propertyNode) {
        ObjectType proto = this.getImplicitPrototype();
        if (proto != null && proto.hasOwnDeclaredProperty(name)) {
            return false;
        }
        return super.defineProperty(name, type, inferred, propertyNode);
    }

    @Override
    public String toString() {
        if (this.constructor.hasReferenceName()) {
            return this.constructor.getReferenceName();
        }
        return super.toString();
    }

    @Override
    boolean isTheObjectType() {
        return this.getConstructor().isNative() && "Object".equals(this.getReferenceName());
    }

    @Override
    public boolean isInstanceType() {
        return true;
    }

    @Override
    public boolean isArrayType() {
        return this.getConstructor().isNative() && "Array".equals(this.getReferenceName());
    }

    @Override
    public boolean isStringObjectType() {
        return this.getConstructor().isNative() && "String".equals(this.getReferenceName());
    }

    @Override
    public boolean isBooleanObjectType() {
        return this.getConstructor().isNative() && "Boolean".equals(this.getReferenceName());
    }

    @Override
    public boolean isNumberObjectType() {
        return this.getConstructor().isNative() && "Number".equals(this.getReferenceName());
    }

    @Override
    public boolean isDateType() {
        return this.getConstructor().isNative() && "Date".equals(this.getReferenceName());
    }

    @Override
    public boolean isRegexpType() {
        return this.getConstructor().isNative() && "RegExp".equals(this.getReferenceName());
    }

    @Override
    public boolean isNominalType() {
        return this.hasReferenceName();
    }

    @Override
    public boolean isEquivalentTo(JSType that) {
        ObjectType thatObj;
        if (this == that) {
            return true;
        }
        if (this.isNominalType() && (thatObj = ObjectType.cast(that)) != null && thatObj.isNominalType()) {
            return this.getReferenceName().equals(thatObj.getReferenceName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hasReferenceName()) {
            return this.getReferenceName().hashCode();
        }
        return super.hashCode();
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.getConstructor().getImplementedInterfaces();
    }

    @Override
    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return this.getConstructor().getExtendedInterfaces();
    }
}

