/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class UnfoldCompoundAssignments
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;

    public UnfoldCompoundAssignments(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node node, Node parent) {
        switch (node.getType()) {
            case 102: 
            case 103: {
                this.unfoldIncrDecr(node, node.getType() == 102);
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                this.unfoldCompoundAssignment(node);
            }
        }
    }

    private void unfoldIncrDecr(Node node, boolean isIncrement) {
        Preconditions.checkArgument((this.isPrefix(node) || this.valueIsDiscarded(node) ? 1 : 0) != 0, (Object)"Unfolding postfix ++/-- requires that the result be ignored.");
        Node lhs = node.getFirstChild().cloneTree();
        Preconditions.checkArgument((!NodeUtil.mayHaveSideEffects(lhs) ? 1 : 0) != 0, (Object)"Cannot unfold compound assignment if LHS can have side effects");
        if (isIncrement) {
            lhs = new Node(28, lhs);
        }
        node.setType(86);
        Node rhs = new Node(isIncrement ? 21 : 22, lhs, Node.newNumber(1.0));
        rhs.copyInformationFromForTree(node);
        node.addChildToBack(rhs);
        this.compiler.reportCodeChange();
    }

    private boolean valueIsDiscarded(Node node) {
        Node parent = node.getParent();
        switch (parent.getType()) {
            case 130: {
                return true;
            }
            case 85: {
                return parent.getFirstChild() == node;
            }
            case 115: {
                Preconditions.checkArgument((!NodeUtil.isForIn(parent) ? 1 : 0) != 0, (Object)"Error: the child of a FOR-IN cannot be an INC or DEC");
                return parent.getChildAtIndex(2) == node;
            }
        }
        return false;
    }

    private boolean isPrefix(Node node) {
        Preconditions.checkArgument((node.getType() == 102 || node.getType() == 103 ? 1 : 0) != 0, (Object)"isPrefix can only be called on INC and DEC nodes");
        return node.getIntProp(32) == 0;
    }

    private void unfoldCompoundAssignment(Node node) {
        Node lhs = node.getFirstChild();
        Preconditions.checkArgument((!NodeUtil.mayHaveSideEffects(lhs) ? 1 : 0) != 0, (Object)"Cannot unfold compound assignment if LHS can have side effects");
        Node newRhs = node.cloneTree();
        newRhs.setType(NodeUtil.getOpFromAssignmentOp(node));
        node.replaceChildAfter(lhs, newRhs);
        node.setType(86);
        this.compiler.reportCodeChange();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized(), (Object)"UnfoldCompoundAssignments requires a normalized AST");
        NodeTraversal.traverse(this.compiler, root, this);
    }
}

