/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.mozilla.rhino.ErrorReporter;
import com.google.javascript.jscomp.mozilla.rhino.EvaluatorException;
import com.google.javascript.jscomp.mozilla.rhino.ScriptRuntime;
import java.util.Map;
import java.util.regex.Pattern;

class RhinoErrorReporter {
    static final DiagnosticType PARSE_ERROR = DiagnosticType.error("JSC_PARSE_ERROR", "Parse error. {0}");
    static final DiagnosticType TYPE_PARSE_ERROR = DiagnosticType.warning("JSC_TYPE_PARSE_ERROR", "{0}");
    static final DiagnosticType EXTRA_FILEOVERVIEW = DiagnosticType.warning("JSC_EXTRA_FILEOVERVIEW", "Parse error. {0}");
    static final DiagnosticType TRAILING_COMMA = DiagnosticType.error("JSC_TRAILING_COMMA", "Parse error. Internet Explorer has a non-standard intepretation of trailing commas. Arrays will have the wrong length and objects will not parse at all.");
    static final DiagnosticType DUPLICATE_PARAM = DiagnosticType.error("JSC_DUPLICATE_PARAM", "Parse error. {0}");
    static final DiagnosticType BAD_JSDOC_ANNOTATION = DiagnosticType.warning("JSC_BAD_JSDOC_ANNOTATION", "Parse error. {0}");
    private final Map<Pattern, DiagnosticType> typeMap;
    private final AbstractCompiler compiler;

    private Pattern replacePlaceHolders(String s) {
        s = Pattern.quote(s);
        return Pattern.compile(s.replaceAll("\\{\\d+\\}", "\\\\E.*\\\\Q"));
    }

    private RhinoErrorReporter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.typeMap = ImmutableMap.of((Object)this.replacePlaceHolders(com.google.javascript.rhino.ScriptRuntime.getMessage0("msg.jsdoc.fileoverview.extra")), (Object)EXTRA_FILEOVERVIEW, (Object)this.replacePlaceHolders(ScriptRuntime.getMessage0("msg.extra.trailing.comma")), (Object)TRAILING_COMMA, (Object)this.replacePlaceHolders(ScriptRuntime.getMessage0("msg.dup.parms")), (Object)DUPLICATE_PARAM, (Object)this.replacePlaceHolders(com.google.javascript.rhino.ScriptRuntime.getMessage0("msg.bad.jsdoc.tag")), (Object)BAD_JSDOC_ANNOTATION, (Object)Pattern.compile("^Bad type annotation.*"), (Object)TYPE_PARSE_ERROR);
    }

    public static ErrorReporter forNewRhino(AbstractCompiler compiler) {
        return new NewRhinoErrorReporter(compiler);
    }

    public static com.google.javascript.rhino.ErrorReporter forOldRhino(AbstractCompiler compiler) {
        return new OldRhinoErrorReporter(compiler);
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.compiler.report(this.makeError(message, sourceName, line, lineOffset, CheckLevel.WARNING));
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.compiler.report(this.makeError(message, sourceName, line, lineOffset, CheckLevel.ERROR));
    }

    private JSError makeError(String message, String sourceName, int line, int lineOffset, CheckLevel defaultLevel) {
        for (Map.Entry<Pattern, DiagnosticType> entry : this.typeMap.entrySet()) {
            if (!entry.getKey().matcher(message).matches()) continue;
            return JSError.make(sourceName, line, lineOffset, entry.getValue(), message);
        }
        return JSError.make(sourceName, line, lineOffset, defaultLevel, PARSE_ERROR, message);
    }

    private static class NewRhinoErrorReporter
    extends RhinoErrorReporter
    implements ErrorReporter {
        private NewRhinoErrorReporter(AbstractCompiler compiler) {
            super(compiler);
        }

        @Override
        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }
    }

    private static class OldRhinoErrorReporter
    extends RhinoErrorReporter
    implements com.google.javascript.rhino.ErrorReporter {
        private OldRhinoErrorReporter(AbstractCompiler compiler) {
            super(compiler);
        }

        @Override
        public com.google.javascript.rhino.EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new com.google.javascript.rhino.EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }
    }
}

