/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class NodeUtil {
    static final long MAX_POSITIVE_INTEGER_NUMBER = (long)Math.pow(2.0, 53.0);
    static final String JSC_PROPERTY_NAME_FN = "JSCompiler_renameProperty";
    private static final Set<String> CONSTRUCTORS_WITHOUT_SIDE_EFFECTS = new HashSet<String>(Arrays.asList("Array", "Date", "Error", "Object", "RegExp", "XMLHttpRequest"));
    private static final Set<String> BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS = ImmutableSet.of((Object)"Object", (Object)"Array", (Object)"String", (Object)"Number", (Object)"Boolean", (Object)"RegExp", (Object[])new String[]{"Error"});
    private static final Set<String> OBJECT_METHODS_WITHOUT_SIDEEFFECTS = ImmutableSet.of((Object)"toString", (Object)"valueOf");
    private static final Set<String> REGEXP_METHODS = ImmutableSet.of((Object)"test", (Object)"exec");
    private static final Set<String> STRING_REGEXP_METHODS = ImmutableSet.of((Object)"match", (Object)"replace", (Object)"search", (Object)"split");
    static final NumbericResultPredicate NUMBERIC_RESULT_PREDICATE = new NumbericResultPredicate();
    static final BooleanResultPredicate BOOLEAN_RESULT_PREDICATE = new BooleanResultPredicate();
    static final MayBeStringResultPredicate MAY_BE_STRING_PREDICATE = new MayBeStringResultPredicate();
    static final Predicate<Node> MATCH_NOT_FUNCTION = new MatchNotFunction();

    private NodeUtil() {
    }

    static TernaryValue getImpureBooleanValue(Node n) {
        switch (n.getType()) {
            case 85: 
            case 86: {
                return NodeUtil.getImpureBooleanValue(n.getLastChild());
            }
            case 26: {
                TernaryValue value = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return value.not();
            }
            case 101: {
                TernaryValue lhs = NodeUtil.getImpureBooleanValue(n.getFirstChild());
                TernaryValue rhs = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return lhs.and(rhs);
            }
            case 100: {
                TernaryValue lhs = NodeUtil.getImpureBooleanValue(n.getFirstChild());
                TernaryValue rhs = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return lhs.or(rhs);
            }
            case 98: {
                TernaryValue trueValue = NodeUtil.getImpureBooleanValue(n.getFirstChild().getNext());
                TernaryValue falseValue = NodeUtil.getImpureBooleanValue(n.getLastChild());
                if (trueValue.equals((Object)falseValue)) {
                    return trueValue;
                }
                return TernaryValue.UNKNOWN;
            }
            case 63: 
            case 64: {
                return TernaryValue.TRUE;
            }
            case 122: {
                return TernaryValue.FALSE;
            }
        }
        return NodeUtil.getPureBooleanValue(n);
    }

    static TernaryValue getPureBooleanValue(Node n) {
        switch (n.getType()) {
            case 40: {
                return TernaryValue.forBoolean(n.getString().length() > 0);
            }
            case 39: {
                return TernaryValue.forBoolean(n.getDouble() != 0.0);
            }
            case 26: {
                return NodeUtil.getPureBooleanValue(n.getLastChild()).not();
            }
            case 41: 
            case 43: {
                return TernaryValue.FALSE;
            }
            case 122: {
                if (NodeUtil.mayHaveSideEffects(n.getFirstChild())) break;
                return TernaryValue.FALSE;
            }
            case 38: {
                String name = n.getString();
                if ("undefined".equals(name) || "NaN".equals(name)) {
                    return TernaryValue.FALSE;
                }
                if (!"Infinity".equals(name)) break;
                return TernaryValue.TRUE;
            }
            case 44: 
            case 47: {
                return TernaryValue.TRUE;
            }
            case 63: 
            case 64: {
                if (NodeUtil.mayHaveSideEffects(n)) break;
                return TernaryValue.TRUE;
            }
        }
        return TernaryValue.UNKNOWN;
    }

    static String getStringValue(Node n) {
        switch (n.getType()) {
            case 40: {
                return n.getString();
            }
            case 38: {
                String name = n.getString();
                if (!"undefined".equals(name) && !"Infinity".equals(name) && !"NaN".equals(name)) break;
                return name;
            }
            case 39: {
                return NodeUtil.getStringValue(n.getDouble());
            }
            case 41: 
            case 43: 
            case 44: {
                return Node.tokenToName(n.getType());
            }
            case 122: {
                return "undefined";
            }
            case 26: {
                TernaryValue child = NodeUtil.getPureBooleanValue(n.getFirstChild());
                if (child == TernaryValue.UNKNOWN) break;
                return child.toBoolean(true) ? "false" : "true";
            }
            case 63: {
                return NodeUtil.arrayToString(n);
            }
            case 64: {
                return "[object Object]";
            }
        }
        return null;
    }

    static String getStringValue(double value) {
        long longValue = (long)value;
        if ((double)longValue == value) {
            return Long.toString(longValue);
        }
        return Double.toString(value);
    }

    static String getArrayElementStringValue(Node n) {
        return NodeUtil.isNullOrUndefined(n) || n.getType() == 124 ? "" : NodeUtil.getStringValue(n);
    }

    static String arrayToString(Node literal) {
        Node first = literal.getFirstChild();
        StringBuilder result = new StringBuilder();
        int nextSlot = 0;
        boolean nextSkipSlot = false;
        for (Node n = first; n != null; n = n.getNext()) {
            String childValue = NodeUtil.getArrayElementStringValue(n);
            if (childValue == null) {
                return null;
            }
            if (n != first) {
                result.append(',');
            }
            result.append(childValue);
            ++nextSlot;
        }
        return result.toString();
    }

    static Double getNumberValue(Node n) {
        switch (n.getType()) {
            case 44: {
                return 1.0;
            }
            case 41: 
            case 43: {
                return 0.0;
            }
            case 39: {
                return n.getDouble();
            }
            case 122: {
                if (NodeUtil.mayHaveSideEffects(n.getFirstChild())) {
                    return null;
                }
                return Double.NaN;
            }
            case 38: {
                String name = n.getString();
                if (name.equals("undefined")) {
                    return Double.NaN;
                }
                if (name.equals("NaN")) {
                    return Double.NaN;
                }
                if (name.equals("Infinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                return null;
            }
            case 29: {
                if (n.getChildCount() == 1 && n.getFirstChild().getType() == 38 && n.getFirstChild().getString().equals("Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                return null;
            }
            case 26: {
                TernaryValue child = NodeUtil.getPureBooleanValue(n.getFirstChild());
                if (child == TernaryValue.UNKNOWN) break;
                return child.toBoolean(true) ? 0.0 : 1.0;
            }
            case 40: {
                return NodeUtil.getStringNumberValue(n.getString());
            }
            case 63: 
            case 64: {
                String value = NodeUtil.getStringValue(n);
                return value != null ? NodeUtil.getStringNumberValue(value) : null;
            }
        }
        return null;
    }

    static Double getStringNumberValue(String rawJsString) {
        if (rawJsString.contains("\u000b")) {
            return null;
        }
        String s = NodeUtil.trimJsWhiteSpace(rawJsString);
        if (s.length() == 0) {
            return 0.0;
        }
        if (s.length() > 2 && s.charAt(0) == '0' && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
            try {
                return Integer.parseInt(s.substring(2), 16);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        if (!(s.length() <= 3 || s.charAt(0) != '-' && s.charAt(0) != '+' || s.charAt(1) != '0' || s.charAt(2) != 'x' && s.charAt(2) != 'X')) {
            return null;
        }
        if (s.equals("infinity") || s.equals("-infinity") || s.equals("+infinity")) {
            return null;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    static String trimJsWhiteSpace(String s) {
        int end;
        int start = 0;
        for (end = s.length(); end > 0 && NodeUtil.isStrWhiteSpaceChar(s.charAt(end - 1)) == TernaryValue.TRUE; --end) {
        }
        while (start < end && NodeUtil.isStrWhiteSpaceChar(s.charAt(start)) == TernaryValue.TRUE) {
            ++start;
        }
        return s.substring(start, end);
    }

    static TernaryValue isStrWhiteSpaceChar(int c) {
        switch (c) {
            case 11: {
                return TernaryValue.UNKNOWN;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: 
            case 160: 
            case 8232: 
            case 8233: 
            case 65279: {
                return TernaryValue.TRUE;
            }
        }
        return Character.getType(c) == 12 ? TernaryValue.TRUE : TernaryValue.FALSE;
    }

    static String getFunctionName(Node n) {
        Node parent = n.getParent();
        String name = n.getFirstChild().getString();
        switch (parent.getType()) {
            case 38: {
                return parent.getString();
            }
            case 86: {
                return parent.getFirstChild().getQualifiedName();
            }
        }
        return name != null && name.length() != 0 ? name : null;
    }

    public static String getNearestFunctionName(Node n) {
        String name = NodeUtil.getFunctionName(n);
        if (name != null) {
            return name;
        }
        Node parent = n.getParent();
        switch (parent.getType()) {
            case 40: 
            case 147: 
            case 148: {
                return parent.getString();
            }
            case 39: {
                return NodeUtil.getStringValue(parent);
            }
        }
        return null;
    }

    static boolean isImmutableValue(Node n) {
        switch (n.getType()) {
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                return true;
            }
            case 26: {
                return NodeUtil.isImmutableValue(n.getFirstChild());
            }
            case 29: 
            case 122: {
                return NodeUtil.isImmutableValue(n.getFirstChild());
            }
            case 38: {
                String name = n.getString();
                return "undefined".equals(name) || "Infinity".equals(name) || "NaN".equals(name);
            }
        }
        return false;
    }

    public static boolean isSymmetricOperation(Node n) {
        switch (n.getType()) {
            case 12: 
            case 13: 
            case 23: 
            case 45: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRelationalOperation(Node n) {
        switch (n.getType()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public static int getInverseOperator(int type) {
        switch (type) {
            case 16: {
                return 14;
            }
            case 14: {
                return 16;
            }
            case 17: {
                return 15;
            }
            case 15: {
                return 17;
            }
        }
        return -1;
    }

    static boolean isLiteralValue(Node n, boolean includeFunctions) {
        switch (n.getType()) {
            case 63: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (child.getType() == 124 || NodeUtil.isLiteralValue(child, includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case 47: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (NodeUtil.isLiteralValue(child, includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case 64: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (NodeUtil.isLiteralValue(child.getFirstChild(), includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case 105: {
                return includeFunctions && !NodeUtil.isFunctionDeclaration(n);
            }
        }
        return NodeUtil.isImmutableValue(n);
    }

    static boolean isValidDefineValue(Node val, Set<String> defines) {
        switch (val.getType()) {
            case 39: 
            case 40: 
            case 43: 
            case 44: {
                return true;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 45: 
            case 46: {
                return NodeUtil.isValidDefineValue(val.getFirstChild(), defines) && NodeUtil.isValidDefineValue(val.getLastChild(), defines);
            }
            case 26: 
            case 28: 
            case 29: {
                return NodeUtil.isValidDefineValue(val.getFirstChild(), defines);
            }
            case 33: 
            case 38: {
                if (!val.isQualifiedName()) break;
                return defines.contains(val.getQualifiedName());
            }
        }
        return false;
    }

    static boolean isEmptyBlock(Node block) {
        if (block.getType() != 125) {
            return false;
        }
        for (Node n = block.getFirstChild(); n != null; n = n.getNext()) {
            if (n.getType() == 124) continue;
            return false;
        }
        return true;
    }

    static boolean isSimpleOperator(Node n) {
        return NodeUtil.isSimpleOperatorType(n.getType());
    }

    static boolean isSimpleOperatorType(int type) {
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 45: 
            case 46: 
            case 52: 
            case 85: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    public static Node newExpr(Node child) {
        Node expr = new Node(130, child).copyInformationFrom(child);
        return expr;
    }

    static boolean mayEffectMutableState(Node n) {
        return NodeUtil.mayEffectMutableState(n, null);
    }

    static boolean mayEffectMutableState(Node n, AbstractCompiler compiler) {
        return NodeUtil.checkForStateChangeHelper(n, true, compiler);
    }

    static boolean mayHaveSideEffects(Node n) {
        return NodeUtil.mayHaveSideEffects(n, null);
    }

    static boolean mayHaveSideEffects(Node n, AbstractCompiler compiler) {
        return NodeUtil.checkForStateChangeHelper(n, false, compiler);
    }

    private static boolean checkForStateChangeHelper(Node n, boolean checkForNewObjects, AbstractCompiler compiler) {
        switch (n.getType()) {
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 77: 
            case 83: 
            case 98: 
            case 100: 
            case 101: 
            case 108: 
            case 110: 
            case 124: 
            case 125: 
            case 130: {
                break;
            }
            case 49: {
                return true;
            }
            case 64: {
                if (checkForNewObjects) {
                    return true;
                }
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    if (!NodeUtil.checkForStateChangeHelper(c.getFirstChild(), checkForNewObjects, compiler)) continue;
                    return true;
                }
                return false;
            }
            case 47: 
            case 63: {
                if (!checkForNewObjects) break;
                return true;
            }
            case 38: 
            case 118: {
                if (n.getFirstChild() == null) break;
                return true;
            }
            case 105: {
                return checkForNewObjects || !NodeUtil.isFunctionExpression(n);
            }
            case 30: {
                if (checkForNewObjects) {
                    return true;
                }
                if (!NodeUtil.constructorCallHasSideEffects(n)) break;
                return true;
            }
            case 37: {
                if (!NodeUtil.functionCallHasSideEffects(n, compiler)) break;
                return true;
            }
            default: {
                if (NodeUtil.isSimpleOperatorType(n.getType())) break;
                if (NodeUtil.isAssignmentOp(n)) {
                    Node assignTarget = n.getFirstChild();
                    if (NodeUtil.isName(assignTarget)) {
                        return true;
                    }
                    if (NodeUtil.checkForStateChangeHelper(n.getFirstChild(), checkForNewObjects, compiler) || NodeUtil.checkForStateChangeHelper(n.getLastChild(), checkForNewObjects, compiler)) {
                        return true;
                    }
                    if (NodeUtil.isGet(assignTarget)) {
                        Node current = assignTarget.getFirstChild();
                        if (NodeUtil.evaluatesToLocalValue(current)) {
                            return false;
                        }
                        while (NodeUtil.isGet(current)) {
                            current = current.getFirstChild();
                        }
                        return !NodeUtil.isLiteralValue(current, true);
                    }
                    return !NodeUtil.isLiteralValue(assignTarget, true);
                }
                return true;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.checkForStateChangeHelper(c, checkForNewObjects, compiler)) continue;
            return true;
        }
        return false;
    }

    static boolean constructorCallHasSideEffects(Node callNode) {
        return NodeUtil.constructorCallHasSideEffects(callNode, null);
    }

    static boolean constructorCallHasSideEffects(Node callNode, AbstractCompiler compiler) {
        if (callNode.getType() != 30) {
            throw new IllegalStateException("Expected NEW node, got " + Token.name(callNode.getType()));
        }
        if (callNode.isNoSideEffectsCall()) {
            return false;
        }
        Node nameNode = callNode.getFirstChild();
        return nameNode.getType() != 38 || !CONSTRUCTORS_WITHOUT_SIDE_EFFECTS.contains(nameNode.getString());
    }

    static boolean functionCallHasSideEffects(Node callNode) {
        return NodeUtil.functionCallHasSideEffects(callNode, null);
    }

    static boolean functionCallHasSideEffects(Node callNode, @Nullable AbstractCompiler compiler) {
        if (callNode.getType() != 37) {
            throw new IllegalStateException("Expected CALL node, got " + Token.name(callNode.getType()));
        }
        if (callNode.isNoSideEffectsCall()) {
            return false;
        }
        Node nameNode = callNode.getFirstChild();
        if (nameNode.getType() == 38) {
            String name = nameNode.getString();
            if (BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS.contains(name)) {
                return false;
            }
        } else if (nameNode.getType() == 33) {
            if (callNode.hasOneChild() && OBJECT_METHODS_WITHOUT_SIDEEFFECTS.contains(nameNode.getLastChild().getString())) {
                return false;
            }
            if (callNode.isOnlyModifiesThisCall() && NodeUtil.evaluatesToLocalValue(nameNode.getFirstChild())) {
                return false;
            }
            if (nameNode.getFirstChild().getType() == 38 && "Math.floor".equals(nameNode.getQualifiedName())) {
                return false;
            }
            if (compiler != null && !compiler.hasRegExpGlobalReferences()) {
                Node param;
                if (nameNode.getFirstChild().getType() == 47 && REGEXP_METHODS.contains(nameNode.getLastChild().getString())) {
                    return false;
                }
                if (nameNode.getFirstChild().getType() == 40 && STRING_REGEXP_METHODS.contains(nameNode.getLastChild().getString()) && (param = nameNode.getNext()) != null && (param.getType() == 40 || param.getType() == 47)) {
                    return false;
                }
            }
        }
        return true;
    }

    static boolean callHasLocalResult(Node n) {
        Preconditions.checkState((n.getType() == 37 ? 1 : 0) != 0);
        return (n.getSideEffectFlags() & 0x10) > 0;
    }

    static boolean newHasLocalResult(Node n) {
        Preconditions.checkState((n.getType() == 30 ? 1 : 0) != 0);
        return n.isOnlyModifiesThisCall();
    }

    static boolean nodeTypeMayHaveSideEffects(Node n) {
        return NodeUtil.nodeTypeMayHaveSideEffects(n, null);
    }

    static boolean nodeTypeMayHaveSideEffects(Node n, AbstractCompiler compiler) {
        if (NodeUtil.isAssignmentOp(n)) {
            return true;
        }
        switch (n.getType()) {
            case 31: 
            case 49: 
            case 102: 
            case 103: {
                return true;
            }
            case 37: {
                return NodeUtil.functionCallHasSideEffects(n, compiler);
            }
            case 30: {
                return NodeUtil.constructorCallHasSideEffects(n, compiler);
            }
            case 38: {
                return n.hasChildren();
            }
        }
        return false;
    }

    static boolean canBeSideEffected(Node n) {
        Set<String> emptySet = Collections.emptySet();
        return NodeUtil.canBeSideEffected(n, emptySet);
    }

    static boolean canBeSideEffected(Node n, Set<String> knownConstants) {
        switch (n.getType()) {
            case 30: 
            case 37: {
                return true;
            }
            case 38: {
                return !NodeUtil.isConstantName(n) && !knownConstants.contains(n.getString());
            }
            case 33: 
            case 35: {
                return true;
            }
            case 105: {
                Preconditions.checkState((boolean)NodeUtil.isFunctionExpression(n));
                return false;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.canBeSideEffected(c, knownConstants)) continue;
            return true;
        }
        return false;
    }

    static int precedence(int type) {
        switch (type) {
            case 85: {
                return 0;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return 1;
            }
            case 98: {
                return 2;
            }
            case 100: {
                return 3;
            }
            case 101: {
                return 4;
            }
            case 9: {
                return 5;
            }
            case 10: {
                return 6;
            }
            case 11: {
                return 7;
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                return 8;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 51: 
            case 52: {
                return 9;
            }
            case 18: 
            case 19: 
            case 20: {
                return 10;
            }
            case 21: 
            case 22: {
                return 11;
            }
            case 23: 
            case 24: 
            case 25: {
                return 12;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 102: 
            case 103: 
            case 122: {
                return 13;
            }
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 63: 
            case 64: 
            case 105: 
            case 124: {
                return 15;
            }
        }
        throw new Error("Unknown precedence for " + Node.tokenToName(type) + " (type " + type + ")");
    }

    static boolean valueCheck(Node n, Predicate<Node> p) {
        switch (n.getType()) {
            case 85: 
            case 86: {
                return NodeUtil.valueCheck(n.getLastChild(), p);
            }
            case 100: 
            case 101: {
                return NodeUtil.valueCheck(n.getFirstChild(), p) && NodeUtil.valueCheck(n.getLastChild(), p);
            }
            case 98: {
                return NodeUtil.valueCheck(n.getFirstChild().getNext(), p) && NodeUtil.valueCheck(n.getLastChild(), p);
            }
        }
        return p.apply((Object)n);
    }

    static boolean isNumericResult(Node n) {
        return NodeUtil.valueCheck(n, NUMBERIC_RESULT_PREDICATE);
    }

    static boolean isNumericResultHelper(Node n) {
        switch (n.getType()) {
            case 21: {
                return !NodeUtil.mayBeString(n.getFirstChild()) && !NodeUtil.mayBeString(n.getLastChild());
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 39: 
            case 102: 
            case 103: {
                return true;
            }
            case 38: {
                String name = n.getString();
                if (name.equals("NaN")) {
                    return true;
                }
                return name.equals("Infinity");
            }
        }
        return false;
    }

    static boolean isBooleanResult(Node n) {
        return NodeUtil.valueCheck(n, BOOLEAN_RESULT_PREDICATE);
    }

    static boolean isBooleanResultHelper(Node n) {
        switch (n.getType()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    static boolean isUndefined(Node n) {
        switch (n.getType()) {
            case 122: {
                return true;
            }
            case 38: {
                return n.getString().equals("undefined");
            }
        }
        return false;
    }

    static boolean isNull(Node n) {
        return n.getType() == 41;
    }

    static boolean isNullOrUndefined(Node n) {
        return NodeUtil.isNull(n) || NodeUtil.isUndefined(n);
    }

    static boolean mayBeString(Node n) {
        return NodeUtil.mayBeString(n, true);
    }

    static boolean mayBeString(Node n, boolean recurse) {
        if (recurse) {
            return NodeUtil.valueCheck(n, MAY_BE_STRING_PREDICATE);
        }
        return NodeUtil.mayBeStringHelper(n);
    }

    static boolean mayBeStringHelper(Node n) {
        return !NodeUtil.isNumericResult(n) && !NodeUtil.isBooleanResult(n) && !NodeUtil.isUndefined(n) && !NodeUtil.isNull(n);
    }

    static boolean isAssociative(int type) {
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 23: 
            case 100: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    static boolean isCommutative(int type) {
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    static boolean isAssignmentOp(Node n) {
        switch (n.getType()) {
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return true;
            }
        }
        return false;
    }

    static int getOpFromAssignmentOp(Node n) {
        switch (n.getType()) {
            case 87: {
                return 9;
            }
            case 88: {
                return 10;
            }
            case 89: {
                return 11;
            }
            case 90: {
                return 18;
            }
            case 91: {
                return 19;
            }
            case 92: {
                return 20;
            }
            case 93: {
                return 21;
            }
            case 94: {
                return 22;
            }
            case 95: {
                return 23;
            }
            case 96: {
                return 24;
            }
            case 97: {
                return 25;
            }
        }
        throw new IllegalArgumentException("Not an assiment op");
    }

    static boolean isExpressionNode(Node n) {
        return n.getType() == 130;
    }

    static boolean containsFunction(Node n) {
        return NodeUtil.containsType(n, 105);
    }

    static boolean referencesThis(Node n) {
        Node start = NodeUtil.isFunction(n) ? n.getLastChild() : n;
        return NodeUtil.containsType(start, 42, MATCH_NOT_FUNCTION);
    }

    static boolean isGet(Node n) {
        return n.getType() == 33 || n.getType() == 35;
    }

    static boolean isGetProp(Node n) {
        return n.getType() == 33;
    }

    static boolean isName(Node n) {
        return n.getType() == 38;
    }

    static boolean isNew(Node n) {
        return n.getType() == 30;
    }

    static boolean isVar(Node n) {
        return n.getType() == 118;
    }

    static boolean isVarDeclaration(Node n) {
        return n.getType() == 38 && n.getParent().getType() == 118;
    }

    static Node getAssignedValue(Node n) {
        Preconditions.checkState((boolean)NodeUtil.isName(n));
        Node parent = n.getParent();
        if (NodeUtil.isVar(parent)) {
            return n.getFirstChild();
        }
        if (NodeUtil.isAssign(parent) && parent.getFirstChild() == n) {
            return n.getNext();
        }
        return null;
    }

    static boolean isString(Node n) {
        return n.getType() == 40;
    }

    static boolean isExprAssign(Node n) {
        return n.getType() == 130 && n.getFirstChild().getType() == 86;
    }

    static boolean isAssign(Node n) {
        return n.getType() == 86;
    }

    static boolean isExprCall(Node n) {
        return n.getType() == 130 && n.getFirstChild().getType() == 37;
    }

    static boolean isForIn(Node n) {
        return n.getType() == 115 && n.getChildCount() == 3;
    }

    static boolean isLoopStructure(Node n) {
        switch (n.getType()) {
            case 113: 
            case 114: 
            case 115: {
                return true;
            }
        }
        return false;
    }

    static Node getLoopCodeBlock(Node n) {
        switch (n.getType()) {
            case 113: 
            case 115: {
                return n.getLastChild();
            }
            case 114: {
                return n.getFirstChild();
            }
        }
        return null;
    }

    static boolean isWithinLoop(Node n) {
        for (Node parent : n.getAncestors()) {
            if (NodeUtil.isLoopStructure(parent)) {
                return true;
            }
            if (!NodeUtil.isFunction(parent)) continue;
            break;
        }
        return false;
    }

    static boolean isControlStructure(Node n) {
        switch (n.getType()) {
            case 77: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 119: 
            case 120: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    static boolean isControlStructureCodeBlock(Node parent, Node n) {
        switch (parent.getType()) {
            case 113: 
            case 115: 
            case 119: 
            case 126: {
                return parent.getLastChild() == n;
            }
            case 114: {
                return parent.getFirstChild() == n;
            }
            case 108: {
                return parent.getFirstChild() != n;
            }
            case 77: {
                return parent.getFirstChild() == n || parent.getLastChild() == n;
            }
            case 120: {
                return parent.getLastChild() == n;
            }
            case 110: 
            case 111: {
                return parent.getFirstChild() != n;
            }
            case 112: {
                return true;
            }
        }
        Preconditions.checkState((boolean)NodeUtil.isControlStructure(parent));
        return false;
    }

    static Node getConditionExpression(Node n) {
        switch (n.getType()) {
            case 108: 
            case 113: {
                return n.getFirstChild();
            }
            case 114: {
                return n.getLastChild();
            }
            case 115: {
                switch (n.getChildCount()) {
                    case 3: {
                        return null;
                    }
                    case 4: {
                        return n.getFirstChild().getNext();
                    }
                }
                throw new IllegalArgumentException("malformed 'for' statement " + n);
            }
            case 111: {
                return null;
            }
        }
        throw new IllegalArgumentException(n + " does not have a condition.");
    }

    static boolean isStatementBlock(Node n) {
        return n.getType() == 132 || n.getType() == 125;
    }

    static boolean isStatement(Node n) {
        return NodeUtil.isStatementParent(n.getParent());
    }

    static boolean isStatementParent(Node parent) {
        Preconditions.checkState((parent != null ? 1 : 0) != 0);
        switch (parent.getType()) {
            case 125: 
            case 126: 
            case 132: {
                return true;
            }
        }
        return false;
    }

    static boolean isSwitchCase(Node n) {
        return n.getType() == 111 || n.getType() == 112;
    }

    static boolean isReferenceName(Node n) {
        return NodeUtil.isName(n) && !n.getString().isEmpty();
    }

    static boolean isLabelName(Node n) {
        return n != null && n.getType() == 153;
    }

    static boolean isTryFinallyNode(Node parent, Node child) {
        return parent.getType() == 77 && parent.getChildCount() == 3 && child == parent.getLastChild();
    }

    static boolean isTryCatchNodeContainer(Node n) {
        Node parent = n.getParent();
        return parent.getType() == 77 && parent.getFirstChild().getNext() == n;
    }

    static void removeChild(Node parent, Node node) {
        if (NodeUtil.isTryFinallyNode(parent, node)) {
            if (NodeUtil.hasCatchHandler(NodeUtil.getCatchBlock(parent))) {
                parent.removeChild(node);
            } else {
                node.detachChildren();
            }
        } else if (node.getType() == 120) {
            Node tryNode = node.getParent().getParent();
            Preconditions.checkState((boolean)NodeUtil.hasFinally(tryNode));
            node.detachFromParent();
        } else if (NodeUtil.isTryCatchNodeContainer(node)) {
            Node tryNode = node.getParent();
            Preconditions.checkState((boolean)NodeUtil.hasFinally(tryNode));
            node.detachChildren();
        } else if (node.getType() == 125) {
            node.detachChildren();
        } else if (NodeUtil.isStatementBlock(parent) || NodeUtil.isSwitchCase(node)) {
            parent.removeChild(node);
        } else if (parent.getType() == 118) {
            if (parent.hasMoreThanOneChild()) {
                parent.removeChild(node);
            } else {
                parent.removeChild(node);
                NodeUtil.removeChild(parent.getParent(), parent);
            }
        } else if (parent.getType() == 126 && node == parent.getLastChild()) {
            parent.removeChild(node);
            NodeUtil.removeChild(parent.getParent(), parent);
        } else if (parent.getType() == 115 && parent.getChildCount() == 4) {
            parent.replaceChild(node, new Node(124));
        } else {
            throw new IllegalStateException("Invalid attempt to remove node: " + node.toString() + " of " + parent.toString());
        }
    }

    static void maybeAddFinally(Node tryNode) {
        Preconditions.checkState((tryNode.getType() == 77 ? 1 : 0) != 0);
        if (!NodeUtil.hasFinally(tryNode)) {
            tryNode.addChildrenToBack(new Node(125).copyInformationFrom(tryNode));
        }
    }

    static boolean tryMergeBlock(Node block) {
        Preconditions.checkState((block.getType() == 125 ? 1 : 0) != 0);
        Node parent = block.getParent();
        if (NodeUtil.isStatementBlock(parent)) {
            Node previous = block;
            while (block.hasChildren()) {
                Node child = block.removeFirstChild();
                parent.addChildAfter(child, previous);
                previous = child;
            }
            parent.removeChild(block);
            return true;
        }
        return false;
    }

    static boolean isCall(Node n) {
        return n.getType() == 37;
    }

    static boolean isCallOrNew(Node node) {
        return NodeUtil.isCall(node) || NodeUtil.isNew(node);
    }

    static boolean isFunction(Node n) {
        return n.getType() == 105;
    }

    static Node getFunctionBody(Node fn) {
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(fn));
        return fn.getLastChild();
    }

    static boolean isThis(Node node) {
        return node.getType() == 42;
    }

    static boolean isArrayLiteral(Node node) {
        return node.getType() == 63;
    }

    static boolean containsCall(Node n) {
        return NodeUtil.containsType(n, 37);
    }

    static boolean isFunctionDeclaration(Node n) {
        return n.getType() == 105 && NodeUtil.isStatement(n);
    }

    static boolean isHoistedFunctionDeclaration(Node n) {
        return NodeUtil.isFunctionDeclaration(n) && (n.getParent().getType() == 132 || n.getParent().getParent().getType() == 105);
    }

    static boolean isFunctionExpression(Node n) {
        return n.getType() == 105 && !NodeUtil.isStatement(n);
    }

    static boolean isEmptyFunctionExpression(Node node) {
        return NodeUtil.isFunctionExpression(node) && NodeUtil.isEmptyBlock(node.getLastChild());
    }

    static boolean isVarArgsFunction(Node function) {
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(function));
        return NodeUtil.isNameReferenced(function.getLastChild(), "arguments", MATCH_NOT_FUNCTION);
    }

    static boolean isObjectCallMethod(Node callNode, String methodName) {
        Node last;
        Node functionIndentifyingExpression;
        if (callNode.getType() == 37 && NodeUtil.isGet(functionIndentifyingExpression = callNode.getFirstChild()) && (last = functionIndentifyingExpression.getLastChild()) != null && last.getType() == 40) {
            String propName = last.getString();
            return propName.equals(methodName);
        }
        return false;
    }

    static boolean isFunctionObjectCall(Node callNode) {
        return NodeUtil.isObjectCallMethod(callNode, "call");
    }

    static boolean isFunctionObjectApply(Node callNode) {
        return NodeUtil.isObjectCallMethod(callNode, "apply");
    }

    static boolean isFunctionObjectCallOrApply(Node callNode) {
        return NodeUtil.isFunctionObjectCall(callNode) || NodeUtil.isFunctionObjectApply(callNode);
    }

    static boolean isSimpleFunctionObjectCall(Node callNode) {
        return NodeUtil.isFunctionObjectCall(callNode) && callNode.getFirstChild().getFirstChild().getType() == 38;
    }

    static boolean isVarOrSimpleAssignLhs(Node n, Node parent) {
        return parent.getType() == 86 && parent.getFirstChild() == n || parent.getType() == 118;
    }

    static boolean isLValue(Node node) {
        int nType = node.getType();
        Preconditions.checkArgument((nType == 38 || nType == 33 || nType == 35 ? 1 : 0) != 0);
        Node parent = node.getParent();
        return NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == node || NodeUtil.isForIn(parent) && parent.getFirstChild() == node || NodeUtil.isVar(parent) || parent.getType() == 105 && parent.getFirstChild() == node || parent.getType() == 103 || parent.getType() == 102 || parent.getType() == 83 || parent.getType() == 120;
    }

    static boolean isObjectLitKey(Node node, Node parent) {
        switch (node.getType()) {
            case 40: {
                return parent.getType() == 64;
            }
            case 147: 
            case 148: {
                return true;
            }
        }
        return false;
    }

    static String getObjectLitKeyName(Node key) {
        switch (key.getType()) {
            case 40: 
            case 147: 
            case 148: {
                return key.getString();
            }
        }
        throw new IllegalStateException("Unexpected node type: " + key);
    }

    static JSType getObjectLitKeyTypeFromValueType(Node key, JSType valueType) {
        if (valueType != null) {
            switch (key.getType()) {
                case 147: {
                    if (valueType.isFunctionType()) {
                        FunctionType fntype = (FunctionType)valueType;
                        valueType = fntype.getReturnType();
                        break;
                    }
                    return null;
                }
                case 148: {
                    if (valueType.isFunctionType()) {
                        FunctionType fntype = (FunctionType)valueType;
                        Node param = fntype.getParametersNode().getFirstChild();
                        valueType = param.getJSType();
                        break;
                    }
                    return null;
                }
            }
        }
        return valueType;
    }

    static boolean isGetOrSetKey(Node node) {
        switch (node.getType()) {
            case 147: 
            case 148: {
                return true;
            }
        }
        return false;
    }

    static String opToStr(int operator) {
        switch (operator) {
            case 9: {
                return "|";
            }
            case 100: {
                return "||";
            }
            case 10: {
                return "^";
            }
            case 101: {
                return "&&";
            }
            case 11: {
                return "&";
            }
            case 45: {
                return "===";
            }
            case 12: {
                return "==";
            }
            case 26: {
                return "!";
            }
            case 13: {
                return "!=";
            }
            case 46: {
                return "!==";
            }
            case 18: {
                return "<<";
            }
            case 51: {
                return "in";
            }
            case 15: {
                return "<=";
            }
            case 14: {
                return "<";
            }
            case 20: {
                return ">>>";
            }
            case 19: {
                return ">>";
            }
            case 17: {
                return ">=";
            }
            case 16: {
                return ">";
            }
            case 23: {
                return "*";
            }
            case 24: {
                return "/";
            }
            case 25: {
                return "%";
            }
            case 27: {
                return "~";
            }
            case 21: {
                return "+";
            }
            case 22: {
                return "-";
            }
            case 28: {
                return "+";
            }
            case 29: {
                return "-";
            }
            case 86: {
                return "=";
            }
            case 87: {
                return "|=";
            }
            case 88: {
                return "^=";
            }
            case 89: {
                return "&=";
            }
            case 90: {
                return "<<=";
            }
            case 91: {
                return ">>=";
            }
            case 92: {
                return ">>>=";
            }
            case 93: {
                return "+=";
            }
            case 94: {
                return "-=";
            }
            case 95: {
                return "*=";
            }
            case 96: {
                return "/=";
            }
            case 97: {
                return "%=";
            }
            case 122: {
                return "void";
            }
            case 32: {
                return "typeof";
            }
            case 52: {
                return "instanceof";
            }
        }
        return null;
    }

    static String opToStrNoFail(int operator) {
        String res = NodeUtil.opToStr(operator);
        if (res == null) {
            throw new Error("Unknown op " + operator + ": " + Token.name(operator));
        }
        return res;
    }

    static boolean containsType(Node node, int type, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.has(node, new MatchNodeType(type), traverseChildrenPred);
    }

    static boolean containsType(Node node, int type) {
        return NodeUtil.containsType(node, type, (Predicate<Node>)Predicates.alwaysTrue());
    }

    static void redeclareVarsInsideBranch(Node branch) {
        Collection<Node> vars = NodeUtil.getVarsDeclaredInBranch(branch);
        if (vars.isEmpty()) {
            return;
        }
        Node parent = NodeUtil.getAddingRoot(branch);
        for (Node nameNode : vars) {
            Node var = new Node(118, Node.newString(38, nameNode.getString()).copyInformationFrom(nameNode)).copyInformationFrom(nameNode);
            NodeUtil.copyNameAnnotations(nameNode, var.getFirstChild());
            parent.addChildToFront(var);
        }
    }

    static void copyNameAnnotations(Node source, Node destination) {
        if (source.getBooleanProp(43)) {
            destination.putBooleanProp(43, true);
        }
    }

    private static Node getAddingRoot(Node n) {
        Node addingRoot = null;
        Node ancestor = n;
        while (null != (ancestor = ancestor.getParent())) {
            int type = ancestor.getType();
            if (type == 132) {
                addingRoot = ancestor;
                break;
            }
            if (type != 105) continue;
            addingRoot = ancestor.getLastChild();
            break;
        }
        Preconditions.checkState((addingRoot.getType() == 125 || addingRoot.getType() == 132 ? 1 : 0) != 0);
        Preconditions.checkState((addingRoot.getFirstChild() == null || addingRoot.getFirstChild().getType() != 132 ? 1 : 0) != 0);
        return addingRoot;
    }

    public static Node newFunctionNode(String name, List<Node> params, Node body, int lineno, int charno) {
        Node parameterParen = new Node(83, lineno, charno);
        for (Node param : params) {
            parameterParen.addChildToBack(param);
        }
        Node function = new Node(105, lineno, charno);
        function.addChildrenToBack(Node.newString(38, name, lineno, charno));
        function.addChildToBack(parameterParen);
        function.addChildToBack(body);
        return function;
    }

    public static Node newQualifiedNameNode(CodingConvention convention, String name, int lineno, int charno) {
        int endPos = name.indexOf(46);
        if (endPos == -1) {
            return NodeUtil.newName(convention, name, lineno, charno);
        }
        Node node = NodeUtil.newName(convention, name.substring(0, endPos), lineno, charno);
        do {
            int startPos;
            String part = (endPos = name.indexOf(46, startPos = endPos + 1)) == -1 ? name.substring(startPos) : name.substring(startPos, endPos);
            Node propNode = Node.newString(40, part, lineno, charno);
            if (convention.isConstantKey(part)) {
                propNode.putBooleanProp(43, true);
            }
            node = new Node(33, node, propNode, lineno, charno);
        } while (endPos != -1);
        return node;
    }

    static Node newQualifiedNameNode(CodingConvention convention, String name, Node basisNode, String originalName) {
        Node node = NodeUtil.newQualifiedNameNode(convention, name, -1, -1);
        NodeUtil.setDebugInformation(node, basisNode, originalName);
        return node;
    }

    public static Node getRootOfQualifiedName(Node qName) {
        Node current = qName;
        int type;
        while ((type = current.getType()) != 38 && type != 42) {
            Preconditions.checkState((type == 33 ? 1 : 0) != 0);
            current = current.getFirstChild();
        }
        return current;
    }

    static void setDebugInformation(Node node, Node basisNode, String originalName) {
        node.copyInformationFromForTree(basisNode);
        node.putProp(40, originalName);
    }

    private static Node newName(CodingConvention convention, String name, int lineno, int charno) {
        Node nameNode = Node.newString(38, name, lineno, charno);
        if (convention.isConstant(name)) {
            nameNode.putBooleanProp(43, true);
        }
        return nameNode;
    }

    static Node newName(CodingConvention convention, String name, Node basisNode) {
        Node nameNode = Node.newString(38, name);
        if (convention.isConstantKey(name)) {
            nameNode.putBooleanProp(43, true);
        }
        nameNode.copyInformationFrom(basisNode);
        return nameNode;
    }

    static Node newName(CodingConvention convention, String name, Node basisNode, String originalName) {
        Node nameNode = NodeUtil.newName(convention, name, basisNode);
        nameNode.putProp(40, originalName);
        return nameNode;
    }

    static boolean isLatin(String s) {
        char LARGEST_BASIC_LATIN = '\u007f';
        int len = s.length();
        for (int index = 0; index < len; ++index) {
            char c = s.charAt(index);
            if (c <= LARGEST_BASIC_LATIN) continue;
            return false;
        }
        return true;
    }

    static boolean isValidPropertyName(String name) {
        return TokenStream.isJSIdentifier(name) && !TokenStream.isKeyword(name) && NodeUtil.isLatin(name);
    }

    public static Collection<Node> getVarsDeclaredInBranch(Node root) {
        VarCollector collector = new VarCollector();
        NodeUtil.visitPreOrder(root, collector, MATCH_NOT_FUNCTION);
        return collector.vars.values();
    }

    static boolean isPrototypePropertyDeclaration(Node n) {
        if (!NodeUtil.isExprAssign(n)) {
            return false;
        }
        return NodeUtil.isPrototypeProperty(n.getFirstChild().getFirstChild());
    }

    static boolean isPrototypeProperty(Node n) {
        String lhsString = n.getQualifiedName();
        if (lhsString == null) {
            return false;
        }
        int prototypeIdx = lhsString.indexOf(".prototype.");
        return prototypeIdx != -1;
    }

    static Node getPrototypeClassName(Node qName) {
        Node cur = qName;
        while (NodeUtil.isGetProp(cur)) {
            if (cur.getLastChild().getString().equals("prototype")) {
                return cur.getFirstChild();
            }
            cur = cur.getFirstChild();
        }
        return null;
    }

    static String getPrototypePropertyName(Node qName) {
        String qNameStr = qName.getQualifiedName();
        int prototypeIdx = qNameStr.lastIndexOf(".prototype.");
        int memberIndex = prototypeIdx + ".prototype".length() + 1;
        return qNameStr.substring(memberIndex);
    }

    static Node newUndefinedNode(Node srcReferenceNode) {
        Node node = new Node(122, Node.newNumber(0.0));
        if (srcReferenceNode != null) {
            node.copyInformationFromForTree(srcReferenceNode);
        }
        return node;
    }

    static Node newVarNode(String name, Node value) {
        Node nodeName = Node.newString(38, name);
        if (value != null) {
            Preconditions.checkState((value.getNext() == null ? 1 : 0) != 0);
            nodeName.addChildToBack(value);
            nodeName.copyInformationFrom(value);
        }
        Node var = new Node(118, nodeName).copyInformationFrom(nodeName);
        return var;
    }

    static int getNodeTypeReferenceCount(Node node, int type, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.getCount(node, new MatchNodeType(type), traverseChildrenPred);
    }

    static boolean isNameReferenced(Node node, String name, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.has(node, new MatchNameNode(name), traverseChildrenPred);
    }

    static boolean isNameReferenced(Node node, String name) {
        return NodeUtil.isNameReferenced(node, name, (Predicate<Node>)Predicates.alwaysTrue());
    }

    static int getNameReferenceCount(Node node, String name) {
        return NodeUtil.getCount(node, new MatchNameNode(name), (Predicate<Node>)Predicates.alwaysTrue());
    }

    static boolean has(Node node, Predicate<Node> pred, Predicate<Node> traverseChildrenPred) {
        if (pred.apply((Object)node)) {
            return true;
        }
        if (!traverseChildrenPred.apply((Object)node)) {
            return false;
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.has(c, pred, traverseChildrenPred)) continue;
            return true;
        }
        return false;
    }

    static int getCount(Node n, Predicate<Node> pred, Predicate<Node> traverseChildrenPred) {
        int total = 0;
        if (pred.apply((Object)n)) {
            ++total;
        }
        if (traverseChildrenPred.apply((Object)n)) {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                total += NodeUtil.getCount(c, pred, traverseChildrenPred);
            }
        }
        return total;
    }

    static void visitPreOrder(Node node, Visitor vistor, Predicate<Node> traverseChildrenPred) {
        vistor.visit(node);
        if (traverseChildrenPred.apply((Object)node)) {
            for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
                NodeUtil.visitPreOrder(c, vistor, traverseChildrenPred);
            }
        }
    }

    static void visitPostOrder(Node node, Visitor vistor, Predicate<Node> traverseChildrenPred) {
        if (traverseChildrenPred.apply((Object)node)) {
            for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
                NodeUtil.visitPostOrder(c, vistor, traverseChildrenPred);
            }
        }
        vistor.visit(node);
    }

    static boolean hasFinally(Node n) {
        Preconditions.checkArgument((n.getType() == 77 ? 1 : 0) != 0);
        return n.getChildCount() == 3;
    }

    static Node getCatchBlock(Node n) {
        Preconditions.checkArgument((n.getType() == 77 ? 1 : 0) != 0);
        return n.getFirstChild().getNext();
    }

    static boolean hasCatchHandler(Node n) {
        Preconditions.checkArgument((n.getType() == 125 ? 1 : 0) != 0);
        return n.hasChildren() && n.getFirstChild().getType() == 120;
    }

    public static Node getFunctionParameters(Node fnNode) {
        Preconditions.checkArgument((fnNode.getType() == 105 ? 1 : 0) != 0);
        return fnNode.getFirstChild().getNext();
    }

    static boolean isConstantName(Node node) {
        return node.getBooleanProp(43);
    }

    static boolean isConstantByConvention(CodingConvention convention, Node node, Node parent) {
        String name = node.getString();
        if (parent.getType() == 33 && node == parent.getLastChild()) {
            return convention.isConstantKey(name);
        }
        if (NodeUtil.isObjectLitKey(node, parent)) {
            return convention.isConstantKey(name);
        }
        return convention.isConstant(name);
    }

    static JSDocInfo getInfoForNameNode(Node nameNode) {
        JSDocInfo info = null;
        Node parent = null;
        if (nameNode != null) {
            info = nameNode.getJSDocInfo();
            parent = nameNode.getParent();
        }
        if (info == null && parent != null && (parent.getType() == 118 && parent.hasOneChild() || parent.getType() == 105)) {
            info = parent.getJSDocInfo();
        }
        return info;
    }

    public static JSDocInfo getFunctionJSDocInfo(Node n) {
        Preconditions.checkState((n.getType() == 105 ? 1 : 0) != 0);
        JSDocInfo fnInfo = n.getJSDocInfo();
        if (fnInfo == null && NodeUtil.isFunctionExpression(n)) {
            Node parent = n.getParent();
            if (parent.getType() == 86) {
                fnInfo = parent.getJSDocInfo();
            } else if (parent.getType() == 38) {
                fnInfo = parent.getParent().getJSDocInfo();
            }
        }
        return fnInfo;
    }

    public static String getSourceName(Node n) {
        String sourceName = null;
        while (sourceName == null && n != null) {
            sourceName = n.getSourceFileName();
            n = n.getParent();
        }
        return sourceName;
    }

    public static StaticSourceFile getSourceFile(Node n) {
        StaticSourceFile sourceName = null;
        while (sourceName == null && n != null) {
            sourceName = n.getStaticSourceFile();
            n = n.getParent();
        }
        return sourceName;
    }

    public static InputId getInputId(Node n) {
        while (n != null && n.getType() != 132) {
            n = n.getParent();
        }
        return n != null && n.getType() == 132 ? n.getInputId() : null;
    }

    static Node newCallNode(Node callTarget, Node ... parameters) {
        boolean isFreeCall = !NodeUtil.isGet(callTarget);
        Node call = new Node(37, callTarget);
        call.putBooleanProp(50, isFreeCall);
        for (Node parameter : parameters) {
            call.addChildToBack(parameter);
        }
        return call;
    }

    static boolean evaluatesToLocalValue(Node value) {
        return NodeUtil.evaluatesToLocalValue(value, (Predicate<Node>)Predicates.alwaysFalse());
    }

    static boolean evaluatesToLocalValue(Node value, Predicate<Node> locals) {
        switch (value.getType()) {
            case 86: {
                return NodeUtil.isImmutableValue(value.getLastChild()) || locals.apply((Object)value) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 85: {
                return NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 100: 
            case 101: {
                return NodeUtil.evaluatesToLocalValue(value.getFirstChild(), locals) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 98: {
                return NodeUtil.evaluatesToLocalValue(value.getFirstChild().getNext(), locals) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 102: 
            case 103: {
                if (value.getBooleanProp(32)) {
                    return NodeUtil.evaluatesToLocalValue(value.getFirstChild(), locals);
                }
                return true;
            }
            case 42: {
                return locals.apply((Object)value);
            }
            case 38: {
                return NodeUtil.isImmutableValue(value) || locals.apply((Object)value);
            }
            case 33: 
            case 35: {
                return locals.apply((Object)value);
            }
            case 37: {
                return NodeUtil.callHasLocalResult(value) || NodeUtil.isToStringMethodCall(value) || locals.apply((Object)value);
            }
            case 30: {
                return NodeUtil.newHasLocalResult(value) || locals.apply((Object)value);
            }
            case 47: 
            case 63: 
            case 64: 
            case 105: {
                return true;
            }
            case 31: 
            case 51: {
                return true;
            }
        }
        if (NodeUtil.isAssignmentOp(value) || NodeUtil.isSimpleOperator(value) || NodeUtil.isImmutableValue(value)) {
            return true;
        }
        throw new IllegalStateException("Unexpected expression node" + value + "\n parent:" + value.getParent());
    }

    private static Node getNthSibling(Node first, int index) {
        Node sibling;
        for (sibling = first; index != 0 && sibling != null; sibling = sibling.getNext(), --index) {
        }
        return sibling;
    }

    static Node getArgumentForFunction(Node function, int index) {
        Preconditions.checkState((boolean)NodeUtil.isFunction(function));
        return NodeUtil.getNthSibling(function.getFirstChild().getNext().getFirstChild(), index);
    }

    static Node getArgumentForCallOrNew(Node call, int index) {
        Preconditions.checkState((boolean)NodeUtil.isCallOrNew(call));
        return NodeUtil.getNthSibling(call.getFirstChild().getNext(), index);
    }

    private static boolean isToStringMethodCall(Node call) {
        Node getNode = call.getFirstChild();
        if (NodeUtil.isGet(getNode)) {
            Node propNode = getNode.getLastChild();
            return NodeUtil.isString(propNode) && "toString".equals(propNode.getString());
        }
        return false;
    }

    static JSDocInfo getBestJSDocInfo(Node n) {
        JSDocInfo info = n.getJSDocInfo();
        if (info == null) {
            Node parent = n.getParent();
            if (parent == null) {
                return null;
            }
            int parentType = parent.getType();
            if (parentType == 38) {
                info = parent.getJSDocInfo();
                if (info == null && parent.getParent().hasOneChild()) {
                    info = parent.getParent().getJSDocInfo();
                }
            } else if (parentType == 86) {
                info = parent.getJSDocInfo();
            } else if (NodeUtil.isObjectLitKey(parent, parent.getParent())) {
                info = parent.getJSDocInfo();
            }
        }
        return info;
    }

    static Node getBestLValue(Node n) {
        Node parent = n.getParent();
        int parentType = parent.getType();
        boolean isFunctionDeclaration = NodeUtil.isFunctionDeclaration(n);
        if (isFunctionDeclaration) {
            return n.getFirstChild();
        }
        if (parentType == 38) {
            return parent;
        }
        if (parentType == 86) {
            return parent.getFirstChild();
        }
        if (NodeUtil.isObjectLitKey(parent, parent.getParent())) {
            return parent;
        }
        return null;
    }

    static String getBestLValueName(@Nullable Node lValue) {
        if (lValue == null || lValue.getParent() == null) {
            return null;
        }
        if (NodeUtil.isObjectLitKey(lValue, lValue.getParent())) {
            String ownerName;
            Node owner = NodeUtil.getBestLValue(lValue.getParent());
            if (owner != null && (ownerName = NodeUtil.getBestLValueName(owner)) != null) {
                return ownerName + "." + NodeUtil.getObjectLitKeyName(lValue);
            }
            return null;
        }
        return lValue.getQualifiedName();
    }

    static interface Visitor {
        public void visit(Node var1);
    }

    static class MatchShallowStatement
    implements Predicate<Node> {
        MatchShallowStatement() {
        }

        public boolean apply(Node n) {
            Node parent = n.getParent();
            return n.getType() == 125 || !NodeUtil.isFunction(n) && (parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent));
        }
    }

    static class MatchNotFunction
    implements Predicate<Node> {
        MatchNotFunction() {
        }

        public boolean apply(Node n) {
            return !NodeUtil.isFunction(n);
        }
    }

    static class MatchDeclaration
    implements Predicate<Node> {
        MatchDeclaration() {
        }

        public boolean apply(Node n) {
            return NodeUtil.isFunctionDeclaration(n) || n.getType() == 118;
        }
    }

    static class MatchNodeType
    implements Predicate<Node> {
        final int type;

        MatchNodeType(int type) {
            this.type = type;
        }

        public boolean apply(Node n) {
            return n.getType() == this.type;
        }
    }

    private static class MatchNameNode
    implements Predicate<Node> {
        final String name;

        MatchNameNode(String name) {
            this.name = name;
        }

        public boolean apply(Node n) {
            return n.getType() == 38 && n.getString().equals(this.name);
        }
    }

    private static class VarCollector
    implements Visitor {
        final Map<String, Node> vars = Maps.newLinkedHashMap();

        private VarCollector() {
        }

        @Override
        public void visit(Node n) {
            String name;
            Node parent;
            if (n.getType() == 38 && (parent = n.getParent()) != null && parent.getType() == 118 && !this.vars.containsKey(name = n.getString())) {
                this.vars.put(name, n);
            }
        }
    }

    static class MayBeStringResultPredicate
    implements Predicate<Node> {
        MayBeStringResultPredicate() {
        }

        public boolean apply(Node n) {
            return NodeUtil.mayBeStringHelper(n);
        }
    }

    static class BooleanResultPredicate
    implements Predicate<Node> {
        BooleanResultPredicate() {
        }

        public boolean apply(Node n) {
            return NodeUtil.isBooleanResultHelper(n);
        }
    }

    static class NumbericResultPredicate
    implements Predicate<Node> {
        NumbericResultPredicate() {
        }

        public boolean apply(Node n) {
            return NodeUtil.isNumericResultHelper(n);
        }
    }
}

