/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ValueType;
import com.google.javascript.rhino.jstype.Visitor;

public final class NumberType
extends ValueType {
    NumberType(JSTypeRegistry registry) {
        super(registry);
    }

    @Override
    JSTypeClass getTypeClass() {
        return JSTypeClass.NUMBER;
    }

    @Override
    public Tri testForEquality(JSType that) {
        Tri result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        if (that.isUnknownType() || that.isSubtypeOf(this.getNativeType(JSTypeNative.OBJECT_TYPE)) || that.isSubtypeOf(this.getNativeType(JSTypeNative.NUMBER_TYPE)) || that.isSubtypeOf(this.getNativeType(JSTypeNative.STRING_TYPE)) || that.isSubtypeOf(this.getNativeType(JSTypeNative.BOOLEAN_TYPE)) || that.isSubtypeOf(this.getNativeType(JSTypeNative.BIGINT_TYPE))) {
            return Tri.UNKNOWN;
        }
        return Tri.FALSE;
    }

    @Override
    public boolean isNumberValueType() {
        return true;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "number";
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.BOTH;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseNumberType();
    }

    @Override
    public JSType autoboxesTo() {
        return this.getNativeType(JSTypeNative.NUMBER_OBJECT_TYPE);
    }
}

