/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import org.jspecify.nullness.Nullable;

public class NominalTypeBuilder {
    private final FunctionType constructor;
    private final ObjectType instance;
    private final ObjectType prototype;

    public NominalTypeBuilder(FunctionType constructor, ObjectType instance) {
        this.constructor = constructor;
        this.instance = instance;
        this.prototype = constructor.getPrototypeProperty();
    }

    public void declarePrototypeProperty(String name, JSType type, Node defSite) {
        this.prototype.defineDeclaredProperty(name, type, defSite);
    }

    public void declareInstanceProperty(String name, JSType type, Node defSite) {
        this.instance.defineDeclaredProperty(name, type, defSite);
    }

    public void declareConstructorProperty(String name, JSType type, Node defSite) {
        this.constructor.defineDeclaredProperty(name, type, defSite);
    }

    public @Nullable NominalTypeBuilder superClass() {
        FunctionType ctor = this.instance.getSuperClassConstructor();
        if (ctor == null) {
            return null;
        }
        return new NominalTypeBuilder(ctor, ctor.getInstanceType());
    }

    public FunctionType constructor() {
        return this.constructor;
    }

    public ObjectType instance() {
        return this.instance;
    }

    public ObjectType prototypeOrInstance() {
        return this.prototype;
    }
}

