/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.InvalidatingTypes;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.serialization.JSTypeReconserializer;
import com.google.javascript.jscomp.serialization.SerializationOptions;
import com.google.javascript.jscomp.serialization.StringPool;
import com.google.javascript.jscomp.serialization.TypePointers;
import com.google.javascript.jscomp.serialization.TypePool;
import com.google.javascript.jscomp.serialization.TypeProto;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

@GwtIncompatible
final class SerializeTypesToPointers {
    private final AbstractCompiler compiler;
    private final JSTypeReconserializer jstypeReconserializer;
    private final LinkedHashSet<String> propertiesReferencedInAst;
    private final IdentityHashMap<JSType, Integer> typePointersByJstype = new IdentityHashMap();
    private static final Gson GSON = new Gson();
    private @Nullable TypePool typePool = null;

    private SerializeTypesToPointers(AbstractCompiler compiler, JSTypeReconserializer jstypeReconserializer, LinkedHashSet<String> propertiesReferencedInAst) {
        this.compiler = compiler;
        this.jstypeReconserializer = jstypeReconserializer;
        this.propertiesReferencedInAst = propertiesReferencedInAst;
    }

    static SerializeTypesToPointers create(AbstractCompiler compiler, StringPool.Builder stringPoolBuilder, SerializationOptions serializationOptions) {
        InvalidatingTypes invalidatingTypes = new InvalidatingTypes.Builder(compiler.getTypeRegistry()).addAllTypeMismatches(compiler.getTypeMismatches()).build();
        LinkedHashSet<String> propertiesReferencedInAst = new LinkedHashSet<String>();
        JSTypeReconserializer jsTypeReconserializer = JSTypeReconserializer.create(compiler.getTypeRegistry(), invalidatingTypes, stringPoolBuilder, propertiesReferencedInAst::contains, serializationOptions);
        return new SerializeTypesToPointers(compiler, jsTypeReconserializer, propertiesReferencedInAst);
    }

    void gatherTypesOnAst(Node root) {
        Preconditions.checkState((this.typePool == null ? 1 : 0) != 0, (Object)"Cannot call process() twice");
        NodeTraversal.traverse(this.compiler, root, new PropertySearchCallback());
        NodeTraversal.traverse(this.compiler, root, new TypeSearchCallback());
        for (TypeMismatch mismatch : this.compiler.getTypeMismatches()) {
            this.jstypeReconserializer.serializeType(mismatch.getFound());
            this.jstypeReconserializer.serializeType(mismatch.getRequired());
        }
        this.typePool = this.jstypeReconserializer.generateTypePool();
        this.logSerializationDebugInfo(this.jstypeReconserializer, this.typePool);
    }

    IdentityHashMap<JSType, Integer> getTypePointersByJstype() {
        return this.typePointersByJstype;
    }

    TypePool getTypePool() {
        return this.typePool;
    }

    private void logSerializationDebugInfo(JSTypeReconserializer serializer, TypePool typePool) {
        try (LogFile log = this.compiler.createOrReopenLog(this.getClass(), "object_uuids.log", new String[0]);){
            if (log.isLogging()) {
                ImmutableMap allSerializedTypes = serializer.getColorIdToJSTypeMapForDebugging().asMap();
                log.logJson(new StreamObjectUuidsJson((ImmutableMap<String, Collection<JSType>>)allSerializedTypes));
            }
        }
        log = this.compiler.createOrReopenLog(this.getClass(), "mismatches.log", new String[0]);
        try {
            log.log(() -> GSON.toJson(this.logTypeMismatches(this.compiler.getTypeMismatches(), serializer, typePool)));
        }
        finally {
            if (log != null) {
                log.close();
            }
        }
    }

    private ImmutableSortedSet<TypeMismatchJson> logTypeMismatches(Iterable<TypeMismatch> typeMismatches, JSTypeReconserializer serializer, TypePool typePool) {
        return (ImmutableSortedSet)Streams.stream(typeMismatches).map(mismatch -> TypeMismatchJson.create(mismatch, serializer, typePool)).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
    }

    private final class PropertySearchCallback
    implements NodeTraversal.Callback {
        private PropertySearchCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isScript() || !NodeUtil.isFromTypeSummary(n);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case GETPROP: 
                case OPTCHAIN_GETPROP: {
                    SerializeTypesToPointers.this.propertiesReferencedInAst.add(n.getString());
                    break;
                }
                case STRING_KEY: 
                case MEMBER_FUNCTION_DEF: 
                case MEMBER_FIELD_DEF: 
                case GETTER_DEF: 
                case SETTER_DEF: {
                    if (n.isQuotedStringKey()) break;
                    SerializeTypesToPointers.this.propertiesReferencedInAst.add(n.getString());
                    break;
                }
            }
        }
    }

    private final class TypeSearchCallback
    implements NodeTraversal.Callback {
        private TypeSearchCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isScript() || !NodeUtil.isFromTypeSummary(n);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isRoot()) {
                return;
            }
            JSType type = n.getJSType();
            if (type != null) {
                SerializeTypesToPointers.this.typePointersByJstype.computeIfAbsent(type, SerializeTypesToPointers.this.jstypeReconserializer::serializeType);
            }
        }
    }

    private static class StreamObjectUuidsJson
    implements LogFile.StreamedJsonProducer {
        private final ImmutableMap<String, Collection<JSType>> allSerializedTypes;

        StreamObjectUuidsJson(ImmutableMap<String, Collection<JSType>> allSerializedTypes) {
            this.allSerializedTypes = allSerializedTypes;
        }

        @Override
        public void writeJson(JsonWriter jsonWriter) throws IOException {
            jsonWriter.beginObject();
            for (Map.Entry entry : this.allSerializedTypes.entrySet()) {
                jsonWriter.name((String)entry.getKey());
                jsonWriter.beginArray();
                ArrayList<String> jstypes = new ArrayList<String>();
                for (JSType jstype : (Collection)entry.getValue()) {
                    jstypes.add(jstype.toString());
                }
                Collections.sort(jstypes);
                for (String typeName : jstypes) {
                    jsonWriter.value(typeName);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
    }

    private static final class TypeMismatchJson
    implements Comparable<TypeMismatchJson> {
        final String location;
        final String foundColorId;
        final String requiredColorId;

        TypeMismatchJson(TypeMismatch x, ColorId found, ColorId required) {
            this.location = x.getLocation().getLocation();
            this.foundColorId = found.toString();
            this.requiredColorId = required.toString();
        }

        static TypeMismatchJson create(TypeMismatch x, JSTypeReconserializer serializer, TypePool typePool) {
            int foundPointer = serializer.serializeType(x.getFound());
            int requiredPointer = serializer.serializeType(x.getRequired());
            return new TypeMismatchJson(x, TypeMismatchJson.typePointerToId(foundPointer, typePool), TypeMismatchJson.typePointerToId(requiredPointer, typePool));
        }

        private static ColorId typePointerToId(int poolOffset, TypePool typePool) {
            if (TypePointers.isAxiomatic(poolOffset)) {
                return ((Color)TypePointers.OFFSET_TO_AXIOMATIC_COLOR.get(poolOffset)).getId();
            }
            TypeProto typeProto = typePool.getTypeList().get(TypePointers.trimOffset(poolOffset));
            switch (typeProto.getKindCase()) {
                case UNION: {
                    return ColorId.union((Set)typeProto.getUnion().getUnionMemberList().stream().map(pointer -> TypeMismatchJson.typePointerToId(pointer, typePool)).collect(ImmutableSet.toImmutableSet()));
                }
                case OBJECT: {
                    return ColorId.fromBytes(typeProto.getObject().getUuid());
                }
            }
            throw new AssertionError((Object)("Unrecognized TypeProto " + typeProto));
        }

        @Override
        public int compareTo(TypeMismatchJson x) {
            return ComparisonChain.start().compare((Comparable)((Object)this.foundColorId), (Comparable)((Object)x.foundColorId)).compare((Comparable)((Object)this.requiredColorId), (Comparable)((Object)x.requiredColorId)).compare((Comparable)((Object)this.location), (Comparable)((Object)x.location)).result();
        }
    }
}

