/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.instrumentation.reporter;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.instrumentation.reporter.ReportDecoder;
import com.google.javascript.jscomp.instrumentation.reporter.proto.FileProfile;
import com.google.javascript.jscomp.instrumentation.reporter.proto.InstrumentationPoint;
import com.google.javascript.jscomp.instrumentation.reporter.proto.InstrumentationPointStats;
import com.google.javascript.jscomp.instrumentation.reporter.proto.ReportProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@GwtIncompatible
final class ProfilingReport {
    public static String createTabSeparatedProfilingReport(Map<String, InstrumentationPoint> instrumentationMapping, ImmutableList<Map<String, Long>> allInstrumentationReports) {
        List profiles = allInstrumentationReports.stream().map(report -> ReportDecoder.decodeReport(instrumentationMapping, report)).collect(Collectors.toList());
        Map metrics = instrumentationMapping.values().stream().collect(Collectors.toMap(Function.identity(), point -> new InstrumentationPointMetrics()));
        for (ReportProfile profile : profiles) {
            for (FileProfile fileProfile : profile.getFileProfileList()) {
                for (InstrumentationPointStats pointStats : fileProfile.getInstrumentationPointsStatsList()) {
                    InstrumentationPointMetrics metric = metrics.get(pointStats.getPoint());
                    metric.totalTimesExecuted += pointStats.getTimesExecuted();
                    ++metric.numberOfReports;
                }
            }
        }
        ArrayList result = new ArrayList(metrics.entrySet());
        Collections.sort(result, Comparator.comparing(point -> ((InstrumentationPoint)point.getKey()).getFileName()).thenComparingLong(point -> -((InstrumentationPointMetrics)point.getValue()).totalTimesExecuted).thenComparingInt(point -> ((InstrumentationPoint)point.getKey()).getLineNumber()).thenComparingInt(point -> ((InstrumentationPoint)point.getKey()).getType().getNumber()));
        ArrayList<ImmutableList> output = new ArrayList<ImmutableList>();
        output.add(ImmutableList.of((Object)"File", (Object)"Function name", (Object)"Line", (Object)"Type", (Object)"Total executed", (Object)"Reports occured"));
        for (Map.Entry entry : result) {
            output.add(ImmutableList.of((Object)((InstrumentationPoint)entry.getKey()).getFileName(), (Object)((InstrumentationPoint)entry.getKey()).getFunctionName(), (Object)String.valueOf(((InstrumentationPoint)entry.getKey()).getLineNumber()), (Object)((InstrumentationPoint)entry.getKey()).getType().name(), (Object)String.valueOf(((InstrumentationPointMetrics)entry.getValue()).totalTimesExecuted), (Object)String.valueOf(((InstrumentationPointMetrics)entry.getValue()).numberOfReports)));
        }
        return output.stream().map(row -> String.join((CharSequence)"\t", row)).collect(Collectors.joining("\n"));
    }

    private ProfilingReport() {
    }

    private static class InstrumentationPointMetrics {
        private long totalTimesExecuted = 0L;
        private int numberOfReports = 0;

        private InstrumentationPointMetrics() {
        }
    }
}

