/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.ijs.ClassUtil;
import com.google.javascript.jscomp.ijs.FileInfo;
import com.google.javascript.jscomp.ijs.JsdocUtil;
import com.google.javascript.jscomp.ijs.PotentialDeclaration;
import com.google.javascript.jscomp.ijs.ProcessConstJsdocCallback;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.jstype.JSType;
import java.util.Comparator;
import java.util.List;
import org.jspecify.nullness.Nullable;

public class ConvertToTypedInterface
implements CompilerPass {
    static final DiagnosticType CONSTANT_WITH_SUGGESTED_TYPE = DiagnosticType.warning("JSC_CONSTANT_WITH_SUGGESTED_TYPE", "Constants in top-level should have types explicitly specified.\nYou may want specify this type as:\t@const '{'{0}'}'");
    static final DiagnosticType CONSTANT_WITHOUT_EXPLICIT_TYPE = DiagnosticType.warning("JSC_CONSTANT_WITHOUT_EXPLICIT_TYPE", "Constants in top-level should have types explicitly specified.");
    static final DiagnosticType GOOG_SCOPE_HIDDEN_TYPE = DiagnosticType.warning("JSC_GOOG_SCOPE_HIDDEN_TYPE", "Found a goog.scope local type declaration.\nIf you can't yet migrate this file to goog.module, use a /** @private */ declaration within the goog.provide namespace.");
    private static final ImmutableSet<String> CALLS_TO_PRESERVE = ImmutableSet.of((Object)"Polymer", (Object)"goog.addSingletonGetter", (Object)"goog.define", (Object)"goog.forwardDeclare", (Object)"goog.module", (Object)"goog.module.declareLegacyNamespace", (Object[])new String[]{"goog.declareModuleId", "goog.provide", "goog.require", "goog.requireType"});
    private final AbstractCompiler compiler;

    public ConvertToTypedInterface(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    private static void maybeReport(AbstractCompiler compiler, Node node, DiagnosticType diagnostic, String ... fillers) {
        String sourceName = NodeUtil.getSourceName(node);
        if (sourceName.endsWith("_test.js") || sourceName.endsWith("_test.closure.js")) {
            return;
        }
        compiler.report(JSError.make(node, diagnostic, fillers));
    }

    private static void maybeWarnForConstWithoutExplicitType(AbstractCompiler compiler, PotentialDeclaration decl) {
        if (decl.isConstToBeInferred() && !decl.getLhs().isFromExterns() && !JsdocUtil.isPrivate(decl.getJsDoc())) {
            Node nameNode = decl.getLhs();
            if (nameNode.getJSType() == null) {
                ConvertToTypedInterface.maybeReport(compiler, nameNode, CONSTANT_WITHOUT_EXPLICIT_TYPE, new String[0]);
            } else {
                ConvertToTypedInterface.maybeReport(compiler, nameNode, CONSTANT_WITH_SUGGESTED_TYPE, nameNode.getJSType().toAnnotationString(JSType.Nullability.EXPLICIT));
            }
        }
    }

    @Override
    public void process(Node externs, Node root) {
        for (Node script = root.getFirstChild(); script != null; script = script.getNext()) {
            this.processFile(script);
        }
    }

    private void processFile(Node scriptNode) {
        Preconditions.checkArgument((boolean)scriptNode.isScript());
        String sourceFileName = scriptNode.getSourceFileName();
        if (AbstractCompiler.isFillFileName(sourceFileName)) {
            scriptNode.detach();
            return;
        }
        FileInfo currentFile = new FileInfo();
        NodeTraversal.traverse(this.compiler, scriptNode, new RemoveNonDeclarations());
        NodeTraversal.traverse(this.compiler, scriptNode, new PropagateConstJsdoc(currentFile));
        new SimplifyDeclarations(this.compiler, currentFile).simplifyAll();
    }

    private static @Nullable Var findNameDeclaration(Scope scope, Node rhs) {
        if (!rhs.isName()) {
            return null;
        }
        return (Var)scope.getVar(rhs.getString());
    }

    private static class RemoveNonDeclarations
    implements NodeTraversal.Callback {
        private static final QualifiedName GOOG_SCOPE = QualifiedName.of("goog.scope");

        private RemoveNonDeclarations() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case FUNCTION: {
                    Node body;
                    if (!(ClassUtil.isConstructor(n) && ClassUtil.hasNamedClass(n) || (body = n.getLastChild()).isBlock() && !body.hasChildren())) {
                        t.reportCodeChange(body);
                        body.replaceWith(IR.block().srcref(body));
                        NodeUtil.markFunctionsDeleted(body, t.getCompiler());
                    }
                    return true;
                }
                case MEMBER_FIELD_DEF: {
                    if (ClassUtil.isMemberFieldDefInsideClassWithName(n)) {
                        return true;
                    }
                    NodeUtil.deleteNode(n, t.getCompiler());
                    return false;
                }
                case EXPR_RESULT: {
                    Node expr = n.getFirstChild();
                    switch (expr.getToken()) {
                        case CALL: {
                            Node callee = expr.getFirstChild();
                            Preconditions.checkState((!GOOG_SCOPE.matches(callee) ? 1 : 0) != 0);
                            if (CALLS_TO_PRESERVE.contains((Object)callee.getQualifiedName())) {
                                return true;
                            }
                            NodeUtil.deleteNode(n, t.getCompiler());
                            return false;
                        }
                        case ASSIGN: {
                            Node lhs = expr.getFirstChild();
                            if (!lhs.isQualifiedName() || lhs.isName() && !t.inGlobalScope() && !t.inModuleScope() || !ClassUtil.isThisPropInsideClassWithName(lhs) && !t.inGlobalHoistScope() && !t.inModuleHoistScope()) {
                                NodeUtil.deleteNode(n, t.getCompiler());
                                return false;
                            }
                            return true;
                        }
                        case GETPROP: {
                            if (!expr.isQualifiedName() || expr.getJSDocInfo() == null) {
                                NodeUtil.deleteNode(n, t.getCompiler());
                                return false;
                            }
                            return true;
                        }
                    }
                    NodeUtil.deleteNode(n, t.getCompiler());
                    return false;
                }
                case COMPUTED_PROP: {
                    if (!NodeUtil.isLhsByDestructuring(n.getSecondChild())) {
                        NodeUtil.deleteNode(n, t.getCompiler());
                    }
                    return false;
                }
                case COMPUTED_FIELD_DEF: {
                    NodeUtil.deleteNode(n, t.getCompiler());
                    return false;
                }
                case THROW: 
                case RETURN: 
                case BREAK: 
                case CONTINUE: 
                case DEBUGGER: 
                case EMPTY: {
                    if (NodeUtil.isStatementParent(parent)) {
                        NodeUtil.deleteNode(n, t.getCompiler());
                    }
                    return false;
                }
                case LABEL: 
                case IF: 
                case SWITCH: 
                case CASE: 
                case WHILE: {
                    NodeUtil.deleteNode(n.getFirstChild(), t.getCompiler());
                    return true;
                }
                case TRY: 
                case DO: {
                    NodeUtil.deleteNode(n.getSecondChild(), t.getCompiler());
                    return true;
                }
                case FOR: {
                    NodeUtil.deleteNode(n.getSecondChild(), t.getCompiler());
                }
                case FOR_OF: 
                case FOR_AWAIT_OF: 
                case FOR_IN: {
                    NodeUtil.deleteNode(n.getSecondChild(), t.getCompiler());
                    Node initializer = n.removeFirstChild();
                    if (initializer.isVar()) {
                        n.getLastChild().addChildToFront(initializer);
                    }
                    return true;
                }
                case CONST: 
                case LET: {
                    if (!t.inGlobalScope() && !t.inModuleScope()) {
                        NodeUtil.removeChild(parent, n);
                        t.reportCodeChange(parent);
                        return false;
                    }
                    return true;
                }
                case VAR: {
                    if (!t.inGlobalHoistScope() && !t.inModuleHoistScope()) {
                        NodeUtil.removeChild(parent, n);
                        t.reportCodeChange(parent);
                        return false;
                    }
                    return true;
                }
                case MODULE_BODY: 
                case CLASS: 
                case DEFAULT_CASE: 
                case BLOCK: 
                case EXPORT: 
                case IMPORT: {
                    return true;
                }
            }
            Preconditions.checkState((!NodeUtil.isStatement(n) ? 1 : 0) != 0, (Object)((Object)n.getToken()));
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case LABEL: 
                case IF: 
                case SWITCH: 
                case CASE: 
                case WHILE: 
                case TRY: 
                case DO: 
                case FOR: 
                case FOR_OF: 
                case FOR_AWAIT_OF: 
                case FOR_IN: 
                case DEFAULT_CASE: {
                    if (!n.hasParent()) break;
                    Node children = n.removeChildren();
                    parent.addChildrenAfter(children, n);
                    n.detach();
                    t.reportCodeChange();
                    break;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    RemoveNonDeclarations.splitNameDeclarationsAndRemoveDestructuring(n, t);
                    break;
                }
                case BLOCK: {
                    if (parent.isFunction()) break;
                    parent.addChildrenAfter(n.removeChildren(), n);
                    n.detach();
                    t.reportCodeChange(parent);
                    break;
                }
            }
        }

        static void splitNameDeclarationsAndRemoveDestructuring(Node n, NodeTraversal t) {
            Node statement;
            Preconditions.checkArgument((boolean)NodeUtil.isNameDeclaration(n));
            JSDocInfo sharedJsdoc = n.getJSDocInfo();
            boolean isExport = n.getParent().isExport();
            Node node = statement = isExport ? n.getParent() : n;
            while (n.hasChildren()) {
                Node lhsToSplit = n.getLastChild();
                JSDocInfo nameJsdoc = lhsToSplit.getJSDocInfo();
                lhsToSplit.setJSDocInfo(null);
                JSDocInfo mergedJsdoc = JsdocUtil.mergeJsdocs(sharedJsdoc, nameJsdoc);
                if (n.hasOneChild()) {
                    n.setJSDocInfo(mergedJsdoc);
                    return;
                }
                Node rhs = lhsToSplit.hasChildren() ? lhsToSplit.removeFirstChild() : null;
                Node newDeclaration = NodeUtil.newDeclaration(lhsToSplit.detach(), rhs, n.getToken()).srcref(n);
                newDeclaration.setJSDocInfo(mergedJsdoc);
                if (isExport) {
                    newDeclaration = IR.export(newDeclaration).srcref(statement);
                }
                newDeclaration.insertAfter(statement);
                t.reportCodeChange();
            }
        }
    }

    private static class PropagateConstJsdoc
    extends ProcessConstJsdocCallback {
        PropagateConstJsdoc(FileInfo currentFile) {
            super(currentFile);
        }

        @Override
        protected void processConstWithRhs(NodeTraversal t, Node nameNode) {
            Preconditions.checkArgument((nameNode.isQualifiedName() || nameNode.isStringKey() || nameNode.isDestructuringLhs() || nameNode.isMemberFieldDef() ? 1 : 0) != 0, (Object)nameNode);
            Node jsdocNode = NodeUtil.getBestJSDocInfoNode(nameNode);
            JSDocInfo originalJsdoc = jsdocNode.getJSDocInfo();
            Node rhs = NodeUtil.getRValueOfLValue(nameNode);
            JSDocInfo newJsdoc = JsdocUtil.getJSDocForRhs(rhs, originalJsdoc);
            if (newJsdoc == null && ClassUtil.isThisPropInsideClassWithName(nameNode)) {
                Var decl = ConvertToTypedInterface.findNameDeclaration(t.getScope(), rhs);
                newJsdoc = JsdocUtil.getJSDocForName(decl, originalJsdoc);
            }
            if (newJsdoc != null) {
                jsdocNode.setJSDocInfo(newJsdoc);
                t.reportCodeChange();
            }
        }
    }

    private static class SimplifyDeclarations {
        private final AbstractCompiler compiler;
        private final FileInfo currentFile;
        static final Comparator<String> SHORT_TO_LONG = Comparator.comparing(SimplifyDeclarations::countDots);
        static final Comparator<PotentialDeclaration> DECLARATIONS_FIRST = Comparator.comparing(decl -> {
            JSDocInfo jsdoc = decl.getJsDoc();
            if (jsdoc == null) {
                return TypingLevel.NO_JSDOC;
            }
            if (jsdoc.getTypeNodes().isEmpty()) {
                return TypingLevel.UNTYPED_JSDOC_DECLARATION;
            }
            return TypingLevel.TYPED_JSDOC_DECLARATION;
        });

        static int countDots(String name) {
            int count = 0;
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) != '.') continue;
                ++count;
            }
            return count;
        }

        SimplifyDeclarations(AbstractCompiler compiler, FileInfo currentFile) {
            this.compiler = compiler;
            this.currentFile = currentFile;
        }

        private void removeDuplicateDeclarations() {
            for (String name : this.currentFile.getDeclarations().keySet()) {
                if (name.startsWith("this.")) continue;
                List declList = this.currentFile.getDeclarations().get((Object)name);
                declList.sort(DECLARATIONS_FIRST);
                while (declList.size() > 1) {
                    PotentialDeclaration decl = (PotentialDeclaration)declList.remove(1);
                    decl.remove(this.compiler);
                }
            }
        }

        void simplifyAll() {
            this.removeDuplicateDeclarations();
            Iterable seenNames = this.currentFile.getDeclarations().keySet().stream().sorted(SHORT_TO_LONG)::iterator;
            for (String name : seenNames) {
                for (PotentialDeclaration decl : this.currentFile.getDeclarations().get((Object)name)) {
                    this.processDeclaration(name, decl);
                }
            }
        }

        private void processDeclaration(String name, PotentialDeclaration decl) {
            if (this.shouldRemove(name, decl)) {
                decl.remove(this.compiler);
                return;
            }
            if (decl.breakDownDestructure(this.compiler)) {
                ConvertToTypedInterface.maybeReport(this.compiler, decl.getLhs(), CONSTANT_WITHOUT_EXPLICIT_TYPE, new String[0]);
            }
            if (decl.getRhs() != null && decl.getRhs().isFunction()) {
                this.processFunction(decl.getRhs());
            } else if (decl.getRhs() != null && SimplifyDeclarations.isClass(decl.getRhs())) {
                this.processClass(decl.getRhs());
            }
            this.setUndeclaredToUnusableType(decl);
            decl.simplify(this.compiler);
        }

        private void processClass(Node n) {
            Preconditions.checkArgument((boolean)SimplifyDeclarations.isClass(n));
            Node member = n.getLastChild().getFirstChild();
            while (member != null) {
                Node next = member.getNext();
                switch (member.getToken()) {
                    case MEMBER_FIELD_DEF: {
                        break;
                    }
                    case EMPTY: {
                        NodeUtil.deleteNode(member, this.compiler);
                        break;
                    }
                    case MEMBER_FUNCTION_DEF: 
                    case STRING_KEY: 
                    case GETTER_DEF: 
                    case SETTER_DEF: {
                        this.processFunction(member.getLastChild());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)(member.getToken() + " should not be handled by processClass"));
                    }
                }
                member = next;
            }
        }

        private void processFunction(Node n) {
            Preconditions.checkArgument((boolean)n.isFunction());
            this.processFunctionParameters(n.getSecondChild());
        }

        private void processFunctionParameters(Node paramList) {
            Preconditions.checkArgument((boolean)paramList.isParamList());
            for (Node arg = paramList.getFirstChild(); arg != null; arg = arg.getNext()) {
                if (!arg.isDefaultValue()) continue;
                Node rhs = arg.getLastChild();
                rhs.replaceWith(NodeUtil.newUndefinedNode(rhs));
                this.compiler.reportChangeToEnclosingScope(arg);
            }
        }

        private static boolean isClass(Node n) {
            return n.isClass() || NodeUtil.isCallTo(n, "goog.defineClass");
        }

        private static String rootName(String qualifiedName) {
            int dotIndex = qualifiedName.indexOf(46);
            if (dotIndex == -1) {
                return qualifiedName;
            }
            return qualifiedName.substring(0, dotIndex);
        }

        private boolean shouldRemove(String name, PotentialDeclaration decl) {
            if (decl.isDetached()) {
                return true;
            }
            if (SimplifyDeclarations.rootName(name).startsWith("$jscomp")) {
                if (decl.getRhs() != null && decl.getRhs().isClass() || decl.getJsDoc() != null && decl.getJsDoc().containsTypeDefinition()) {
                    ConvertToTypedInterface.maybeReport(this.compiler, decl.getLhs(), GOOG_SCOPE_HIDDEN_TYPE, new String[0]);
                }
                return true;
            }
            return !name.startsWith("this.") && !decl.isDefiniteDeclaration(this.compiler) && !decl.getLhs().isMemberFieldDef() && !this.currentFile.isPrefixProvided(name) && !this.currentFile.isStrictPrefixDeclared(name);
        }

        private void setUndeclaredToUnusableType(PotentialDeclaration decl) {
            Node nameNode = decl.getLhs();
            JSDocInfo jsdoc = decl.getJsDoc();
            if (decl.shouldPreserve() || NodeUtil.isNamespaceDecl(nameNode) || decl.getRhs() != null && NodeUtil.isCallTo(decl.getRhs(), "Symbol") || jsdoc != null && jsdoc.containsDeclaration() && !decl.isConstToBeInferred()) {
                return;
            }
            ConvertToTypedInterface.maybeWarnForConstWithoutExplicitType(this.compiler, decl);
            Node jsdocNode = NodeUtil.getBestJSDocInfoNode(nameNode);
            jsdocNode.setJSDocInfo(JsdocUtil.getUnusableTypeJSDoc(jsdoc));
        }

        static enum TypingLevel {
            TYPED_JSDOC_DECLARATION,
            UNTYPED_JSDOC_DECLARATION,
            NO_JSDOC;

        }
    }
}

