/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import org.jspecify.nullness.Nullable;

public class CheckTypeSummaryWarningsGuard
extends WarningsGuard {
    private final CheckLevel level;

    public CheckTypeSummaryWarningsGuard(CheckLevel level) {
        this.level = level;
    }

    @Override
    public @Nullable CheckLevel level(JSError error) {
        Preconditions.checkNotNull((Object)error);
        if (!this.shouldDemoteIfTypeSummary(error)) {
            return null;
        }
        if (this.inTypeSummary(error)) {
            return this.level;
        }
        return null;
    }

    @Override
    protected int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_BY_ALLOWLIST.getValue();
    }

    private boolean inTypeSummary(JSError error) {
        return error.getSourceName() != null && error.getSourceName().endsWith(".i.js");
    }

    private boolean shouldDemoteIfTypeSummary(JSError error) {
        return !error.getType().equals(ClosurePrimitiveErrors.DUPLICATE_NAMESPACE_AND_MODULE);
    }
}

