/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.bundle;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorFormat;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.bundle.Source;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;

@Immutable
@GwtIncompatible
public abstract class CompilerBasedTransformer
implements Source.Transformer {
    private final CompilerSupplier compilerSupplier;

    public CompilerBasedTransformer(CompilerSupplier compilerSupplier) {
        this.compilerSupplier = (CompilerSupplier)Preconditions.checkNotNull((Object)compilerSupplier);
    }

    public abstract Optional<String> getRuntime();

    public abstract String getTranformationName();

    @Override
    public Source transform(Source input) {
        CompileResult result = this.compilerSupplier.compile(input.path(), input.code());
        if (!result.errors.isEmpty()) {
            MessageFormatter formatter = ErrorFormat.SOURCELESS.toFormatter(null, false);
            StringBuilder message = new StringBuilder().append(this.getTranformationName()).append(" failed.\n");
            for (JSError error : result.errors) {
                message.append(formatter.formatError(error));
            }
            throw new IllegalStateException(message.toString());
        }
        if (!result.transformed) {
            return input;
        }
        Source.Builder builder = input.toBuilder().setCode(result.source).setSourceMap(result.sourceMap);
        if (this.getRuntime().isPresent()) {
            builder.addRuntime(this.compilerSupplier.runtime(this.getRuntime().get()));
        }
        return builder.build();
    }

    @Immutable
    public static class CompilerSupplier {
        protected static final SourceFile EXTERNS = SourceFile.fromCode("externs.js", "function Symbol() {}");
        protected static final SourceFile EMPTY = SourceFile.fromCode("empty.js", "");
        protected static final DiagnosticGroup ES5_WARNINGS = new DiagnosticGroup(new DiagnosticType[]{DiagnosticType.error("JSC_CANNOT_CONVERT", "")});

        public CompileResult compile(Path path, String code) {
            Compiler compiler = this.compiler();
            Result result = compiler.compile(EXTERNS, SourceFile.fromCode(path.toString(), code), this.options());
            String source = compiler.toSource();
            StringBuilder sourceMap = new StringBuilder();
            if (result.sourceMap != null) {
                try {
                    result.sourceMap.appendTo(sourceMap, path.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            boolean transformed = this.transformed(result);
            return new CompileResult(source, result.errors, transformed, transformed ? sourceMap.toString() : "");
        }

        public boolean transformed(Result result) {
            return result.transpiledFiles;
        }

        public String runtime(String library) {
            Compiler compiler = this.compiler();
            CompilerOptions options = this.options();
            options.setForceLibraryInjection((Iterable<String>)ImmutableList.of((Object)library));
            compiler.compile(EXTERNS, EMPTY, options);
            return compiler.toSource();
        }

        protected Compiler compiler() {
            return new Compiler();
        }

        protected CompilerOptions options() {
            CompilerOptions options = new CompilerOptions();
            this.setOptions(options);
            return options;
        }

        protected void setOptions(CompilerOptions options) {
            options.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5);
            options.setQuoteKeywordProperties(true);
            options.setSkipNonTranspilationPasses(true);
            options.setVariableRenaming(VariableRenamingPolicy.OFF);
            options.setPropertyRenaming(PropertyRenamingPolicy.OFF);
            options.setWrapGoogModulesForWhitespaceOnly(false);
            options.setPrettyPrint(true);
            options.setSourceMapOutputPath("/dev/null");
            options.setSourceMapIncludeSourcesContent(true);
            options.setWarningLevel(ES5_WARNINGS, CheckLevel.OFF);
        }
    }

    public static class CompileResult {
        public final String source;
        public final ImmutableList<JSError> errors;
        public final boolean transformed;
        public final String sourceMap;

        public CompileResult(String source, ImmutableList<JSError> errors, boolean transformed, String sourceMap) {
            this.source = (String)Preconditions.checkNotNull((Object)source);
            this.errors = (ImmutableList)Preconditions.checkNotNull(errors);
            this.transformed = transformed;
            this.sourceMap = (String)Preconditions.checkNotNull((Object)sourceMap);
        }
    }
}

