/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TypeInference;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.JSTypeResolver;
import java.util.Comparator;
import java.util.LinkedHashMap;
import org.jspecify.nullness.Nullable;

class TypeInferencePass {
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private TypedScope topScope;
    private final TypedScopeCreator scopeCreator;
    private final CodingConvention.AssertionFunctionLookup assertionFunctionLookup;
    private final @Nullable LinkedHashMap<Integer, HashMultiset<Token>> stepCountHistogram;

    TypeInferencePass(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, TypedScopeCreator scopeCreator) {
        this.compiler = compiler;
        this.registry = compiler.getTypeRegistry();
        this.reverseInterpreter = reverseInterpreter;
        this.scopeCreator = scopeCreator;
        this.assertionFunctionLookup = CodingConvention.AssertionFunctionLookup.of(compiler.getCodingConvention().getAssertionFunctions());
        this.stepCountHistogram = compiler.isDebugLoggingEnabled() ? new LinkedHashMap() : null;
    }

    TypedScope inferAllScopes(Node inferenceRoot) {
        try (JSTypeResolver.Closer closer = this.registry.getResolver().openForDefinition();){
            Preconditions.checkState((boolean)inferenceRoot.isRoot());
            Preconditions.checkState((inferenceRoot.getParent() == null ? 1 : 0) != 0);
            Preconditions.checkState((this.topScope == null ? 1 : 0) != 0);
            this.topScope = this.scopeCreator.createScope(inferenceRoot, (AbstractScope)null);
            NodeTraversal.builder().setCompiler(this.compiler).setCallback(new FirstScopeBuildingCallback()).setScopeCreator(this.scopeCreator).traverseWithScope(inferenceRoot, this.topScope);
            this.scopeCreator.resolveWeakImportsPreResolution();
        }
        this.scopeCreator.finishAndFreeze();
        NodeTraversal.builder().setCompiler(this.compiler).setCallback(new SecondScopeBuildingCallback()).setScopeCreator(this.scopeCreator).traverseWithScope(inferenceRoot, this.topScope);
        JSType unknownType = this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        for (TypedVar var : this.scopeCreator.getAllSymbols()) {
            if (var.getType() != null) continue;
            var.setType(unknownType);
        }
        if (this.stepCountHistogram != null) {
            try (LogFile histogram = this.compiler.createOrReopenLog(this.getClass(), "step_histogram.log", new String[0]);){
                histogram.log("step_count token population");
                int[] totals = new int[]{0, 0};
                this.stepCountHistogram.keySet().stream().sorted(Comparator.naturalOrder().reversed()).forEach(stepCount -> this.stepCountHistogram.get(stepCount).entrySet().stream().sorted(Comparator.comparingInt(Multiset.Entry::getCount)).forEach(e -> {
                    totals[0] = totals[0] + stepCount * e.getCount();
                    totals[1] = totals[1] + e.getCount();
                    histogram.log("%s %s %s", stepCount, e.getElement(), e.getCount());
                }));
                histogram.log("%s TOTAL %s", totals[0], totals[1]);
            }
        }
        return this.topScope;
    }

    private void inferScope(Node n, TypedScope scope) {
        ControlFlowGraph<Node> cfg = this.computeCfg(n);
        TypeInference typeInference = new TypeInference(this.compiler, cfg, this.reverseInterpreter, scope, this.scopeCreator, this.assertionFunctionLookup);
        typeInference.analyze();
        if (this.stepCountHistogram != null) {
            for (DiGraph.DiGraphNode diGraphNode : cfg.getNodes()) {
                if (diGraphNode == cfg.getImplicitReturn()) continue;
                DataFlowAnalysis.LinearFlowState state = (DataFlowAnalysis.LinearFlowState)diGraphNode.getAnnotation();
                this.stepCountHistogram.computeIfAbsent(state.getStepCount(), k -> HashMultiset.create()).add((Object)((Node)diGraphNode.getValue()).getToken());
            }
        }
    }

    private ControlFlowGraph<Node> computeCfg(Node n) {
        return ControlFlowAnalysis.builder().setCompiler(this.compiler).setCfgRoot(n).setIncludeEdgeAnnotations(true).computeCfg();
    }

    private static class FirstScopeBuildingCallback
    extends NodeTraversal.AbstractScopedCallback {
        private FirstScopeBuildingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            t.getTypedScope();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }

    private class SecondScopeBuildingCallback
    extends NodeTraversal.AbstractScopedCallback {
        private SecondScopeBuildingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            TypedScope scope = t.getTypedScope();
            if (scope.isCfgRootScope() && !scope.isModuleScope()) {
                TypeInferencePass.this.inferScope(t.getCurrentNode(), scope);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }
}

