/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.DestructuredTarget;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.InvocationTemplateTypeMatcher;
import com.google.javascript.jscomp.JsIterables;
import com.google.javascript.jscomp.LinkedFlowScope;
import com.google.javascript.jscomp.ModuleImportResolver;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Promises;
import com.google.javascript.jscomp.ScopedName;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeTransformation;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Outcome;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeReplacer;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

class TypeInference
extends DataFlowAnalysis<Node, FlowScope> {
    static final DiagnosticType FUNCTION_LITERAL_UNDEFINED_THIS = DiagnosticType.warning("JSC_FUNCTION_LITERAL_UNDEFINED_THIS", "Function literal argument refers to undefined this argument");
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private final FlowScope bottomScope;
    private final TypedScope containerScope;
    private final TypedScopeCreator scopeCreator;
    private final CodingConvention.AssertionFunctionLookup assertionFunctionLookup;
    private final ModuleImportResolver moduleImportResolver;
    private final ArrayDeque<OptChainInfo> optChainArrayDeque = new ArrayDeque();
    private final Set<TypedScope> inferredUnboundVars = new LinkedHashSet<TypedScope>();
    private final ObjectType unknownType;
    private final JSType numberAdditionSupertype;
    private static final String GOOG_REQUIREDYNAMIC_NAME = "goog.requireDynamic";
    private static final ImmutableSet<Token> TOKENS_ALLOWING_NULL_TYPES = Sets.immutableEnumSet((Enum)Token.NAME, (Enum[])new Token[]{Token.CALL, Token.NEW});

    TypeInference(AbstractCompiler compiler, ControlFlowGraph<Node> cfg, ReverseAbstractInterpreter reverseInterpreter, TypedScope syntacticScope, TypedScopeCreator scopeCreator, CodingConvention.AssertionFunctionLookup assertionFunctionLookup) {
        super(cfg);
        Preconditions.checkArgument((syntacticScope.getRootNode() == cfg.getEntry().getValue() ? 1 : 0) != 0, (String)"Expected syntactic scope to be rooted at CFG root node of %s, but instead got syntactic scope root node of %s", cfg.getEntry(), (Object)syntacticScope.getRootNode());
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
        this.registry = (JSTypeRegistry)Preconditions.checkNotNull((Object)compiler.getTypeRegistry());
        this.reverseInterpreter = (ReverseAbstractInterpreter)Preconditions.checkNotNull((Object)reverseInterpreter);
        this.moduleImportResolver = new ModuleImportResolver(compiler.getModuleMap(), scopeCreator.getNodeToScopeMapper(), this.registry);
        this.containerScope = syntacticScope;
        this.scopeCreator = (TypedScopeCreator)Preconditions.checkNotNull((Object)scopeCreator);
        this.assertionFunctionLookup = (CodingConvention.AssertionFunctionLookup)Preconditions.checkNotNull((Object)assertionFunctionLookup);
        this.unknownType = this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
        this.numberAdditionSupertype = this.registry.getNativeType(JSTypeNative.NUMBER_ADDITION_SUPERTYPE);
        this.bottomScope = LinkedFlowScope.createEntryLattice(compiler, TypedScope.createLatticeBottom(syntacticScope.getRootNode()));
    }

    @CheckReturnValue
    private FlowScope inferDeclarativelyUnboundVarsWithoutTypes(FlowScope flow) {
        TypedScope scope = (TypedScope)flow.getDeclarationScope();
        if (!this.inferredUnboundVars.add(scope)) {
            return flow;
        }
        for (TypedVar var : scope.getDeclarativelyUnboundVarsWithoutTypes()) {
            if (this.isUnflowable(var)) continue;
            flow = flow.inferSlotType(var.getName(), this.getNativeType(JSTypeNative.VOID_TYPE));
        }
        return flow;
    }

    private FlowScope inferParameters(FlowScope entryFlowScope) {
        FunctionType functionType;
        UnmodifiableIterator parameterTypes;
        Node functionNode = this.containerScope.getRootNode();
        if (!functionNode.isFunction()) {
            return entryFlowScope;
        }
        if (NodeUtil.isBundledGoogModuleCall(functionNode.getParent())) {
            return entryFlowScope;
        }
        Node astParameters = functionNode.getSecondChild();
        Node iifeArgumentNode = null;
        if (NodeUtil.isInvocationTarget(functionNode)) {
            iifeArgumentNode = functionNode.getNext();
        }
        FunctionType.Parameter parameter = (parameterTypes = (functionType = JSType.toMaybeFunctionType(functionNode.getJSType())).getParameters().iterator()).hasNext() ? (FunctionType.Parameter)parameterTypes.next() : null;
        for (Node astParamItr = astParameters.getFirstChild(); astParamItr != null; astParamItr = astParamItr.getNext()) {
            Node astParam = astParamItr;
            if (iifeArgumentNode != null && iifeArgumentNode.isSpread()) {
                iifeArgumentNode = null;
            }
            JSType inferredType = this.getJSType(astParam);
            if (iifeArgumentNode != null) {
                if (iifeArgumentNode.getJSType() != null) {
                    inferredType = iifeArgumentNode.getJSType();
                }
            } else if (parameter != null && parameter.getJSType() != null) {
                inferredType = parameter.getJSType();
            }
            Node defaultValue = null;
            if (astParam.isDefaultValue()) {
                defaultValue = astParam.getSecondChild();
                entryFlowScope = this.traverse(defaultValue, entryFlowScope);
                astParam = astParam.getFirstChild();
            } else if (astParam.isRest()) {
                astParam = astParam.getOnlyChild();
                inferredType = this.registry.createTemplatizedType(this.registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE), inferredType);
            }
            if (defaultValue != null) {
                inferredType = this.registry.createUnionType(inferredType.restrictByNotUndefined(), this.getJSType(defaultValue));
            }
            entryFlowScope = astParam.isDestructuringPattern() ? this.updateDestructuringParameter(astParam, inferredType, entryFlowScope) : this.updateNamedParameter(astParam, defaultValue != null, inferredType, entryFlowScope);
            parameter = parameterTypes.hasNext() ? (FunctionType.Parameter)parameterTypes.next() : null;
            iifeArgumentNode = iifeArgumentNode != null ? iifeArgumentNode.getNext() : null;
        }
        return entryFlowScope;
    }

    @CheckReturnValue
    private FlowScope updateDestructuringParameter(Node pattern, JSType inferredType, FlowScope entryFlowScope) {
        entryFlowScope = this.traverseDestructuringPatternHelper(pattern, entryFlowScope, inferredType, (scope, lvalue, type) -> {
            TypedVar var = this.containerScope.getVar(lvalue.getString());
            Preconditions.checkNotNull((Object)var);
            if (var.isTypeInferred()) {
                var.setType(type);
                lvalue.setJSType(type);
            }
            if (lvalue.getParent().isDefaultValue()) {
                scope = this.updateScopeForAssignment(scope, lvalue, type, AssignmentType.ASSIGN);
            }
            return scope;
        });
        return entryFlowScope;
    }

    @CheckReturnValue
    private FlowScope updateNamedParameter(Node paramName, boolean hasDefaultValue, JSType inferredType, FlowScope entryFlowScope) {
        TypedVar var = this.containerScope.getVar(paramName.getString());
        Preconditions.checkNotNull((Object)var, (String)"Missing var for parameter %s", (Object)paramName);
        paramName.setJSType(inferredType);
        if (var.isTypeInferred()) {
            var.setType(inferredType);
        } else if (hasDefaultValue) {
            entryFlowScope = this.redeclareSimpleVar(entryFlowScope, paramName, inferredType);
        }
        return entryFlowScope;
    }

    @Override
    FlowScope createInitialEstimateLattice() {
        return this.bottomScope;
    }

    @Override
    FlowScope createEntryLattice() {
        FlowScope entryScope = this.inferDeclarativelyUnboundVarsWithoutTypes(LinkedFlowScope.createEntryLattice(this.compiler, this.containerScope));
        return this.inferParameters(entryScope);
    }

    @Override
    @CheckReturnValue
    FlowScope flowThrough(Node n, FlowScope input) {
        if (input == this.bottomScope) {
            return input;
        }
        Node root = NodeUtil.getEnclosingScopeRoot(n);
        Module module = ModuleImportResolver.getModuleFromScopeRoot(this.compiler.getModuleMap(), this.compiler, root);
        TypedScope syntacticBlockScope = this.scopeCreator.createScope(root);
        if (module != null && module.metadata().isEs6Module()) {
            this.moduleImportResolver.declareEsModuleImports(module, syntacticBlockScope, this.compiler.getInput(NodeUtil.getInputId(n)));
        }
        FlowScope output = input.withSyntacticScope(syntacticBlockScope);
        output = this.inferDeclarativelyUnboundVarsWithoutTypes(output);
        output = this.traverse(n, output);
        this.updateModuleScope(module, syntacticBlockScope);
        return output;
    }

    private void updateModuleScope(Module module, TypedScope syntacticBlockScope) {
        if (module == null) {
            return;
        }
        switch (module.metadata().moduleType()) {
            case ES6_MODULE: {
                this.moduleImportResolver.updateEsModuleNamespaceType(syntacticBlockScope.getVar("*exports*").getType().toObjectType(), module, syntacticBlockScope);
                return;
            }
            case GOOG_MODULE: 
            case LEGACY_GOOG_MODULE: {
                QualifiedName moduleQname;
                TypedVar exportsVar = (TypedVar)Preconditions.checkNotNull((Object)syntacticBlockScope.getVar("exports"), (String)"Missing exports var for %s", (Object)module.metadata());
                JSType exportsType = exportsVar.getType() != null ? exportsVar.getType() : this.unknownType;
                Node rootNode = syntacticBlockScope.getRootNode();
                if (rootNode.isModuleBody()) {
                    rootNode.setJSType(exportsType);
                } else {
                    Preconditions.checkState((boolean)rootNode.isBlock(), (Object)rootNode);
                    Node paramList = NodeUtil.getFunctionParameters(rootNode.getParent());
                    paramList.getOnlyChild().setJSType(exportsType);
                }
                if (!module.metadata().isLegacyGoogModule() || exportsVar.getType() == null) break;
                String moduleId = module.closureNamespace();
                TypedScope globalScope = (TypedScope)syntacticBlockScope.getGlobalScope();
                TypedVar globalVar = globalScope.getVar(moduleId);
                if (globalVar.isTypeInferred()) {
                    globalVar.setType(exportsType);
                }
                if (!(moduleQname = QualifiedName.of(moduleId)).isSimple()) {
                    ObjectType parentObjectType;
                    JSType parentType = globalScope.lookupQualifiedName(moduleQname.getOwner());
                    ObjectType objectType = parentObjectType = parentType != null ? parentType.toMaybeObjectType() : null;
                    if (parentObjectType != null && !parentObjectType.isPropertyTypeDeclared(moduleQname.getComponent())) {
                        parentObjectType.defineInferredProperty(moduleQname.getComponent(), exportsType, exportsVar.getNode());
                    }
                }
                return;
            }
        }
    }

    @Override
    final boolean isForward() {
        return true;
    }

    @Override
    final boolean isBranched() {
        return true;
    }

    @Override
    DataFlowAnalysis.FlowJoiner<FlowScope> createFlowJoiner() {
        return new LinkedFlowScope.FlowScopeJoinOp(this.compiler);
    }

    @Override
    DataFlowAnalysis.FlowBrancher<FlowScope> createFlowBrancher(final Node source, final FlowScope output) {
        return new DataFlowAnalysis.FlowBrancher<FlowScope>(){
            @Nullable Node condition = null;
            @Nullable FlowScope conditionFlowScope = null;
            @Nullable BooleanOutcomePair conditionOutcomes = null;

            @Override
            public FlowScope branchFlow(ControlFlowGraph.Branch branch) {
                switch (branch) {
                    case ON_TRUE: {
                        if (NodeUtil.isEnhancedFor(source)) {
                            return TypeInference.this.initializeEnhancedForScope(source, output);
                        }
                    }
                    case ON_FALSE: {
                        if (this.condition == null) {
                            if (source.isCase()) {
                                this.condition = source;
                                this.conditionFlowScope = TypeInference.this.traverse(this.condition.getFirstChild(), output);
                            } else {
                                this.condition = NodeUtil.getConditionExpression(source);
                                if (this.condition == null) {
                                    return output;
                                }
                            }
                        }
                        if (this.condition.isAnd() || this.condition.isOr()) {
                            if (this.conditionOutcomes == null) {
                                this.conditionOutcomes = this.condition.isAnd() ? TypeInference.this.traverseAnd(this.condition, output) : TypeInference.this.traverseOr(this.condition, output);
                            }
                            return TypeInference.this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(this.condition, this.conditionOutcomes.getOutcomeFlowScope(this.condition.getToken(), branch == ControlFlowGraph.Branch.ON_TRUE), Outcome.forBoolean(branch.equals((Object)ControlFlowGraph.Branch.ON_TRUE)));
                        }
                        if (this.conditionFlowScope == null) {
                            this.conditionFlowScope = TypeInference.this.traverse(this.condition, output);
                        }
                        return TypeInference.this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(this.condition, this.conditionFlowScope, Outcome.forBoolean(branch.equals((Object)ControlFlowGraph.Branch.ON_TRUE)));
                    }
                }
                return output;
            }
        };
    }

    private FlowScope traverse(Node n, FlowScope scope) {
        boolean isTypeable = true;
        switch (n.getToken()) {
            case ASSIGN: {
                scope = this.traverseAssign(n, scope);
                break;
            }
            case NAME: {
                scope = this.traverseName(n, scope);
                break;
            }
            case OPTCHAIN_GETPROP: 
            case OPTCHAIN_CALL: 
            case OPTCHAIN_GETELEM: {
                scope = this.traverseOptChain(n, scope);
                break;
            }
            case GETPROP: {
                scope = this.traverseGetProp(n, scope);
                break;
            }
            case CLASS: {
                scope = this.traverseClass(n, scope);
                break;
            }
            case ASSIGN_AND: 
            case ASSIGN_OR: {
                scope = this.traverseShortCircuitingBinOpAssignment(n, scope);
                break;
            }
            case AND: {
                scope = this.traverseAnd(n, scope).getJoinedFlowScope();
                break;
            }
            case OR: {
                scope = this.traverseOr(n, scope).getJoinedFlowScope();
                break;
            }
            case ASSIGN_COALESCE: 
            case COALESCE: {
                scope = this.traverseNullishCoalesce(n, scope);
                break;
            }
            case HOOK: {
                scope = this.traverseHook(n, scope);
                break;
            }
            case OBJECTLIT: {
                scope = this.traverseObjectLiteral(n, scope);
                break;
            }
            case CALL: {
                scope = this.traverseCall(n, scope);
                break;
            }
            case NEW: {
                scope = this.traverseNew(n, scope);
                break;
            }
            case NEW_TARGET: {
                this.traverseNewTarget(n);
                break;
            }
            case ASSIGN_ADD: 
            case ADD: {
                scope = this.traverseAdd(n, scope);
                break;
            }
            case POS: {
                scope = this.traverseUnaryPlus(n, scope);
                break;
            }
            case NEG: 
            case BITNOT: 
            case DEC: 
            case INC: {
                scope = this.traverseBigIntCompatibleUnaryOperator(n, scope);
                break;
            }
            case ARRAYLIT: {
                scope = this.traverseArrayLiteral(n, scope);
                break;
            }
            case THIS: {
                n.setJSType(scope.getTypeOfThis());
                break;
            }
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_BITAND: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITOR: 
            case ASSIGN_MUL: 
            case ASSIGN_SUB: 
            case ASSIGN_EXPONENT: {
                scope = this.traverseAssignOp(n, scope);
                break;
            }
            case ASSIGN_URSH: {
                scope = this.traverseAssignUnsignedRightShift(n, scope);
                break;
            }
            case BITAND: 
            case BITXOR: 
            case BITOR: 
            case LSH: 
            case RSH: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: 
            case EXPONENT: {
                scope = this.traverseBigIntCompatibleBinaryOperator(n, scope);
                break;
            }
            case URSH: {
                scope = this.traverseUnsignedRightShift(n, scope);
                break;
            }
            case COMMA: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getJSType(n.getLastChild()));
                break;
            }
            case TEMPLATELIT: 
            case TYPEOF: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.STRING_TYPE));
                break;
            }
            case TEMPLATELIT_SUB: 
            case THROW: 
            case ITER_SPREAD: 
            case OBJECT_SPREAD: 
            case IMPORT: 
            case IMPORT_SPECS: 
            case IMPORT_STAR: {
                scope = this.traverseChildren(n, scope);
                isTypeable = false;
                break;
            }
            case IMPORT_SPEC: {
                this.traverseImportSpec(scope, n);
                isTypeable = false;
                break;
            }
            case TAGGED_TEMPLATELIT: {
                scope = this.traverseTaggedTemplateLit(n, scope);
                break;
            }
            case DELPROP: 
            case LT: 
            case LE: 
            case GT: 
            case GE: 
            case NOT: 
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: 
            case INSTANCEOF: 
            case IN: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
                break;
            }
            case GETELEM: {
                scope = this.traverseGetElem(n, scope);
                break;
            }
            case EXPR_RESULT: {
                Node getprop;
                ObjectType ownerType;
                scope = this.traverseChildren(n, scope);
                if (n.getFirstChild().isGetProp() && (ownerType = ObjectType.cast(this.getJSType((getprop = n.getFirstChild()).getFirstChild()).restrictByNotNullOrUndefined())) != null) {
                    this.ensurePropertyDeclaredHelper(getprop, ownerType, scope);
                }
                isTypeable = false;
                break;
            }
            case SWITCH: {
                scope = this.traverse(n.getFirstChild(), scope);
                isTypeable = false;
                break;
            }
            case RETURN: {
                scope = this.traverseReturn(n, scope);
                isTypeable = false;
                break;
            }
            case YIELD: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                scope = this.traverseDeclaration(n, scope);
                isTypeable = false;
                break;
            }
            case CATCH: {
                scope = this.traverseCatch(n, scope);
                isTypeable = false;
                break;
            }
            case CAST: {
                scope = this.traverseChildren(n, scope);
                JSDocInfo info = n.getJSDocInfo();
                Preconditions.checkNotNull((Object)info, (Object)"CAST node should always have JSDocInfo");
                if (info.hasType()) {
                    n.setJSType(info.getType().evaluate(scope.getDeclarationScope(), this.registry).resolve(this.registry.getErrorReporter()));
                    break;
                }
                n.setJSType(this.unknownType);
                break;
            }
            case SUPER: {
                this.traverseSuper(n, scope);
                break;
            }
            case AWAIT: {
                scope = this.traverseAwait(n, scope);
                break;
            }
            case VOID: {
                n.setJSType(this.getNativeType(JSTypeNative.VOID_TYPE));
                scope = this.traverseChildren(n, scope);
                break;
            }
            case EXPORT: {
                TypedVar defaultExport;
                scope = this.traverseChildren(n, scope);
                if (n.getBooleanProp(Node.EXPORT_DEFAULT) && (defaultExport = TypeInference.getDeclaredVar(scope, "*default*")).isTypeInferred()) {
                    defaultExport.setType(this.getJSType(n.getOnlyChild()));
                }
                isTypeable = false;
                break;
            }
            case IMPORT_META: {
                n.setJSType(this.unknownType);
                break;
            }
            case ROOT: 
            case SCRIPT: 
            case MODULE_BODY: 
            case FUNCTION: 
            case PARAM_LIST: 
            case BLOCK: 
            case EMPTY: 
            case IF: 
            case WHILE: 
            case DO: 
            case FOR: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case BREAK: 
            case CONTINUE: 
            case TRY: 
            case CASE: 
            case DEFAULT_CASE: 
            case WITH: 
            case DEBUGGER: 
            case EXPORT_SPECS: 
            case LABEL: {
                isTypeable = false;
                break;
            }
            case DYNAMIC_IMPORT: {
                this.traverseDynamicImport(n, scope);
                break;
            }
            case TRUE: 
            case FALSE: 
            case STRINGLIT: 
            case NUMBER: 
            case BIGINT: 
            case NULL: 
            case REGEXP: 
            case TEMPLATELIT_STRING: {
                break;
            }
            default: {
                throw new IllegalStateException("Type inference doesn't know to handle token " + n.getToken());
            }
        }
        if (isTypeable && n.getJSType() == null && !TOKENS_ALLOWING_NULL_TYPES.contains((Object)n.getToken())) {
            throw new IllegalStateException("Failed to infer JSType for " + n);
        }
        return scope;
    }

    private FlowScope initializeEnhancedForScope(Node source, FlowScope output) {
        JSType newType;
        AssignmentType assignmentType;
        Node item = source.getFirstChild();
        Node obj = item.getNext();
        FlowScope informed = this.traverse(obj, output);
        if (NodeUtil.isNameDeclaration(item)) {
            item = item.getFirstChild();
            assignmentType = AssignmentType.DECLARATION;
        } else {
            assignmentType = AssignmentType.ASSIGN;
        }
        if (item.isDestructuringLhs()) {
            item = item.getFirstChild();
        }
        switch (source.getToken()) {
            case FOR_IN: {
                JSType narrowedKeyType;
                JSType iterKeyType = this.getNativeType(JSTypeNative.STRING_TYPE);
                JSType objType = this.getJSType(obj).autobox();
                JSType objIndexType = objType.getTemplateTypeMap().getResolvedTemplateType(this.registry.getObjectIndexKey());
                if (objIndexType != null && !objIndexType.isUnknownType() && !(narrowedKeyType = iterKeyType.getGreatestSubtype(objIndexType)).isEmptyType()) {
                    iterKeyType = narrowedKeyType;
                }
                newType = iterKeyType;
                break;
            }
            case FOR_OF: {
                newType = JsIterables.maybeBoxIterableOrAsyncIterable(this.getJSType(obj), this.registry).orElse(this.unknownType);
                break;
            }
            case FOR_AWAIT_OF: {
                JSType iterableType = JsIterables.maybeBoxIterableOrAsyncIterable(this.getJSType(obj), this.registry).orElse(this.unknownType);
                newType = Promises.getResolvedType(this.registry, iterableType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected source node " + source);
            }
        }
        if (item.isDestructuringPattern()) {
            informed = this.traverseDestructuringPattern(item, informed, newType, assignmentType);
        } else {
            informed = this.traverse(item, informed);
            informed = this.updateScopeForAssignment(informed, item, newType, assignmentType);
        }
        return informed;
    }

    private FlowScope traverseUnsignedRightShift(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        if (TypeInference.getBigIntPresence(this.getJSType(n.getFirstChild())) != BigIntPresence.NO_BIGINT || TypeInference.getBigIntPresence(this.getJSType(n.getLastChild())) != BigIntPresence.NO_BIGINT) {
            n.setJSType(this.getNativeType(JSTypeNative.NO_TYPE));
        } else {
            n.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
        }
        return scope;
    }

    private FlowScope traverseAssignUnsignedRightShift(Node n, FlowScope scope) {
        Node left = n.getFirstChild();
        scope = this.traverseUnsignedRightShift(n, scope);
        return this.updateScopeForAssignment(scope, left, this.getJSType(n), null, AssignmentType.ASSIGN);
    }

    private FlowScope traverseCall(Node callNode, FlowScope originalScope) {
        Preconditions.checkArgument((callNode.isCall() || callNode.isOptChainCall() ? 1 : 0) != 0, (Object)callNode);
        FlowScope scopeAfterChildren = this.traverseChildren(callNode, originalScope);
        FlowScope scopeAfterExecution = this.setCallNodeTypeAfterChildrenTraversed(callNode, scopeAfterChildren);
        return this.tightenTypesAfterAssertions(scopeAfterExecution, callNode);
    }

    private FlowScope traverseTaggedTemplateLit(Node tagTempLitNode, FlowScope originalScope) {
        Preconditions.checkArgument((boolean)tagTempLitNode.isTaggedTemplateLit(), (Object)tagTempLitNode);
        FlowScope scopeAfterChildren = this.traverseChildren(tagTempLitNode, originalScope);
        FlowScope scopeAfterExecution = this.setCallNodeTypeAfterChildrenTraversed(tagTempLitNode, scopeAfterChildren);
        if (tagTempLitNode.getJSType() == null) {
            tagTempLitNode.setJSType(this.unknownType);
        }
        return scopeAfterExecution;
    }

    private void traverseSuper(Node superNode, FlowScope currentScope) {
        ObjectType superNodeType = null;
        switch (superNode.getParent().getToken()) {
            case CALL: {
                TypedScope scope;
                for (scope = this.containerScope; scope != null && !NodeUtil.isNonArrowFunction(scope.getRootNode()); scope = scope.getParent()) {
                }
                if (scope == null) {
                    superNode.setJSType(this.unknownType);
                    return;
                }
                FunctionType enclosingFunctionType = JSType.toMaybeFunctionType(scope.getRootNode().getJSType());
                if (enclosingFunctionType == null || !enclosingFunctionType.isConstructor()) break;
                superNodeType = enclosingFunctionType.getSuperClassConstructor();
                break;
            }
            case GETPROP: 
            case GETELEM: {
                StaticTypedScope currentSyntacticScope = currentScope.getDeclarationScope();
                superNodeType = ObjectType.cast(currentSyntacticScope.getSlot("super").getType());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected parent of SUPER: " + superNode.getParent().toStringTree());
            }
        }
        superNode.setJSType(superNodeType != null ? superNodeType : this.unknownType);
    }

    private void traverseNewTarget(Node newTargetNode) {
        TypedScope scope;
        for (scope = this.containerScope; scope != null && !NodeUtil.isNonArrowFunction(scope.getRootNode()); scope = scope.getParent()) {
        }
        if (scope == null) {
            newTargetNode.setJSType(this.unknownType);
            return;
        }
        Node root = scope.getRootNode();
        Node parent = root.getParent();
        if (parent.getGrandparent().isClass()) {
            JSTypeNative type = NodeUtil.isEs6ConstructorMemberFunctionDef(parent) ? JSTypeNative.FUNCTION_TYPE : JSTypeNative.VOID_TYPE;
            newTargetNode.setJSType(this.registry.getNativeType(type));
        } else {
            newTargetNode.setJSType(this.registry.createUnionType(this.registry.getNativeType(JSTypeNative.FUNCTION_TYPE), this.registry.getNativeType(JSTypeNative.VOID_TYPE)));
        }
    }

    @CheckReturnValue
    private FlowScope traverseReturn(Node n, FlowScope scope) {
        FunctionType fnType;
        JSType type;
        scope = this.traverseChildren(n, scope);
        Node retValue = n.getFirstChild();
        if (retValue != null && (type = this.containerScope.getRootNode().getJSType()) != null && (fnType = type.toMaybeFunctionType()) != null) {
            TypeInference.inferPropertyTypesToMatchConstraint(retValue.getJSType(), fnType.getReturnType());
        }
        return scope;
    }

    @CheckReturnValue
    private FlowScope traverseCatch(Node catchNode, FlowScope scope) {
        Node catchTarget = catchNode.getFirstChild();
        if (catchTarget.isName()) {
            Node name = catchNode.getFirstChild();
            JSType type = name.getJSType();
            if (type == null) {
                type = this.unknownType;
                name.setJSType(this.unknownType);
            }
            return this.redeclareSimpleVar(scope, name, type);
        }
        if (catchTarget.isDestructuringPattern()) {
            Node pattern = catchNode.getFirstChild();
            return this.traverseDestructuringPattern(pattern, scope, this.unknownType, AssignmentType.DECLARATION);
        }
        Preconditions.checkState((boolean)catchTarget.isEmpty(), (Object)catchTarget);
        return scope;
    }

    @CheckReturnValue
    private FlowScope traverseAssign(Node n, FlowScope scope) {
        Node target = n.getFirstChild();
        Node value = n.getLastChild();
        if (target.isDestructuringPattern()) {
            scope = this.traverse(value, scope);
            JSType valueType = this.getJSType(value);
            n.setJSType(valueType);
            return this.traverseDestructuringPattern(target, scope, valueType, AssignmentType.ASSIGN);
        }
        scope = this.traverseChildren(n, scope);
        JSType valueType = this.getJSType(value);
        n.setJSType(valueType);
        return this.updateScopeForAssignment(scope, target, valueType, AssignmentType.ASSIGN);
    }

    @CheckReturnValue
    private FlowScope traverseAssignOp(Node n, FlowScope scope) {
        Node left = n.getFirstChild();
        scope = this.traverseBigIntCompatibleBinaryOperator(n, scope);
        return this.updateScopeForAssignment(scope, left, this.getJSType(n), null, AssignmentType.ASSIGN);
    }

    private static boolean isInExternFile(Node n) {
        return NodeUtil.getSourceFile(n).isExtern();
    }

    private static boolean isPossibleMixinApplication(Node lvalue, @Nullable Node rvalue) {
        if (TypeInference.isInExternFile(lvalue)) {
            return true;
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(lvalue);
        return jsdoc != null && jsdoc.isConstructor() && jsdoc.getImplementedInterfaceCount() > 0 && lvalue.isQualifiedName() && rvalue != null && rvalue.isCall();
    }

    private static void addMissingInterfaceProperties(@Nullable JSType constructor) {
        if (constructor == null || !constructor.isConstructor()) {
            return;
        }
        FunctionType f = constructor.toMaybeFunctionType();
        ObjectType proto = f.getPrototype();
        for (ObjectType interf : f.getImplementedInterfaces()) {
            for (String pname : interf.getPropertyNames()) {
                if (proto.hasProperty(pname)) continue;
                proto.defineDeclaredProperty(pname, interf.getPropertyType(pname), null);
            }
        }
    }

    @CheckReturnValue
    private FlowScope updateScopeForAssignment(FlowScope scope, Node target, JSType resultType, AssignmentType type) {
        return this.updateScopeForAssignment(scope, target, resultType, target, type);
    }

    @CheckReturnValue
    private FlowScope updateScopeForAssignment(FlowScope scope, Node target, JSType resultType, @Nullable Node updateNode, AssignmentType type) {
        Preconditions.checkNotNull((Object)resultType);
        Preconditions.checkState((updateNode == null || updateNode == target ? 1 : 0) != 0);
        JSType targetType = target.getJSType();
        Node right = NodeUtil.getRValueOfLValue(target);
        if (TypeInference.isPossibleMixinApplication(target, right)) {
            TypeInference.addMissingInterfaceProperties(targetType);
        }
        switch (target.getToken()) {
            case NAME: {
                String varName = target.getString();
                TypedVar var = TypeInference.getDeclaredVar(scope, varName);
                JSType varType = var == null ? null : var.getType();
                boolean isVarDeclaration = type == AssignmentType.DECLARATION && var != null && !var.isTypeInferred() && var.getNameNode() != null;
                boolean isTypelessConstDecl = isVarDeclaration && var.getNameNode().isName() && NodeUtil.isConstantDeclaration(var.getJSDocInfo(), var.getNameNode()) && (var.getJSDocInfo() == null || !var.getJSDocInfo().containsDeclarationExcludingTypelessConst());
                boolean isVarTypeBetter = isVarDeclaration && !resultType.isNullType() && !resultType.isVoidType() && !isTypelessConstDecl;
                scope = isVarTypeBetter ? this.redeclareSimpleVar(scope, target, varType) : this.redeclareSimpleVar(scope, target, resultType);
                if (updateNode != null) {
                    updateNode.setJSType(resultType);
                }
                if (var != null && var.isTypeInferred() && (!target.getParent().isLet() || target.hasChildren())) {
                    JSType oldType = var.getType();
                    var.setType(oldType == null ? resultType : oldType.getLeastSupertype(resultType));
                    break;
                }
                if (!isTypelessConstDecl) break;
                var.setType(resultType);
                break;
            }
            case GETPROP: {
                if (target.isQualifiedName()) {
                    ObjectType objType;
                    String qualifiedName = target.getQualifiedName();
                    boolean declaredSlotType = false;
                    JSType rawObjType = target.getFirstChild().getJSType();
                    if (rawObjType != null && (objType = ObjectType.cast(rawObjType.restrictByNotNullOrUndefined())) != null) {
                        String propName = target.getString();
                        declaredSlotType = objType.isPropertyTypeDeclared(propName);
                    }
                    JSType safeLeftType = targetType == null ? this.unknownType : targetType;
                    scope = scope.inferQualifiedSlot(target, qualifiedName, safeLeftType, resultType, declaredSlotType);
                }
                if (updateNode != null) {
                    updateNode.setJSType(resultType);
                }
                this.ensurePropertyDefined(target, resultType, scope);
                break;
            }
        }
        return scope;
    }

    private void ensurePropertyDefined(Node getprop, JSType rightType, FlowScope scope) {
        boolean propCreationInConstructor;
        String propName = getprop.getString();
        Node obj = getprop.getFirstChild();
        JSType nodeType = this.getJSType(obj);
        ObjectType objectType = ObjectType.cast(nodeType.restrictByNotNullOrUndefined());
        boolean bl = propCreationInConstructor = obj.isThis() && this.getJSType(this.containerScope.getRootNode()).isConstructor();
        if (objectType == null) {
            this.registry.registerPropertyOnType(propName, nodeType);
        } else {
            if (nodeType.isStruct() && !objectType.hasProperty(propName)) {
                boolean staticPropCreation = false;
                Node maybeAssignStm = getprop.getGrandparent();
                if (this.containerScope.isGlobal() && NodeUtil.isPrototypePropertyDeclaration(maybeAssignStm)) {
                    String propCreationFilename = maybeAssignStm.getSourceFileName();
                    Node ctor = objectType.getOwnerFunction().getSource();
                    if (ctor != null && ctor.getSourceFileName().equals(propCreationFilename)) {
                        staticPropCreation = true;
                    }
                }
                if (!propCreationInConstructor && !staticPropCreation) {
                    return;
                }
            }
            if (this.ensurePropertyDeclaredHelper(getprop, objectType, scope)) {
                return;
            }
            if (!objectType.isPropertyTypeDeclared(propName)) {
                if (objectType.hasProperty(propName) || !objectType.isInstanceType()) {
                    if ("prototype".equals(propName)) {
                        objectType.defineDeclaredProperty(propName, rightType, getprop);
                    } else {
                        objectType.defineInferredProperty(propName, rightType, getprop);
                    }
                } else if (propCreationInConstructor) {
                    objectType.defineInferredProperty(propName, rightType, getprop);
                } else {
                    this.registry.registerPropertyOnType(propName, objectType);
                }
            }
        }
    }

    private boolean ensurePropertyDeclaredHelper(Node getprop, ObjectType objectType, FlowScope scope) {
        if (getprop.isQualifiedName()) {
            String propName = getprop.getString();
            String qName = getprop.getQualifiedName();
            TypedVar var = TypeInference.getDeclaredVar(scope, qName);
            if (var != null && !var.isTypeInferred() && (propName.equals("prototype") || !objectType.hasOwnProperty(propName) && (!objectType.isInstanceType() || var.isExtern() && !objectType.isNativeObjectType()))) {
                return objectType.defineDeclaredProperty(propName, var.getType(), getprop);
            }
        }
        return false;
    }

    private FlowScope traverseDeclaration(Node n, FlowScope scope) {
        for (Node declarationChild = n.getFirstChild(); declarationChild != null; declarationChild = declarationChild.getNext()) {
            scope = this.traverseDeclarationChild(declarationChild, scope);
        }
        return scope;
    }

    private FlowScope traverseDeclarationChild(Node n, FlowScope scope) {
        if (n.isName()) {
            return this.traverseName(n, scope);
        }
        Preconditions.checkState((boolean)n.isDestructuringLhs(), (Object)n);
        scope = this.traverse(n.getSecondChild(), scope);
        return this.traverseDestructuringPattern(n.getFirstChild(), scope, this.getJSType(n.getSecondChild()), AssignmentType.DECLARATION);
    }

    private FlowScope traverseDestructuringPattern(Node pattern, FlowScope scope, JSType patternType, AssignmentType assignmentType) {
        return this.traverseDestructuringPatternHelper(pattern, scope, patternType, (flowScope, targetNode, targetType) -> {
            targetType = targetType != null ? targetType : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            return this.updateScopeForAssignment(flowScope, targetNode, targetType, assignmentType);
        });
    }

    private FlowScope traverseDestructuringPatternHelper(Node pattern, FlowScope scope, JSType patternType, TypeDeclaringCallback declarer) {
        Preconditions.checkArgument((boolean)pattern.isDestructuringPattern(), (Object)pattern);
        Preconditions.checkNotNull((Object)patternType);
        for (DestructuredTarget target : DestructuredTarget.createAllNonEmptyTargetsInPattern(this.registry, patternType, pattern)) {
            Node targetNode;
            if (target.hasComputedProperty()) {
                scope = this.traverse(target.getComputedProperty().getFirstChild(), scope);
            }
            if ((targetNode = target.getNode()).isDestructuringPattern()) {
                JSType targetType;
                if (target.hasDefaultValue()) {
                    this.traverse(target.getDefaultValue(), scope);
                }
                targetType = (targetType = target.inferType()) != null ? targetType : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                scope = this.traverseDestructuringPatternHelper(targetNode, scope, targetType, declarer);
                continue;
            }
            scope = this.traverse(targetNode, scope);
            if (target.hasDefaultValue()) {
                this.traverse(target.getDefaultValue(), scope);
            }
            scope = declarer.declareTypeInScope(scope, targetNode, target.inferType());
        }
        pattern.setJSType(patternType);
        return scope;
    }

    private FlowScope traverseName(Node n, FlowScope scope) {
        String varName = n.getString();
        Node value = n.getFirstChild();
        JSType type = n.getJSType();
        if (value != null) {
            scope = this.traverse(value, scope);
            return this.updateScopeForAssignment(scope, n, this.getJSType(value), AssignmentType.DECLARATION);
        }
        if (NodeUtil.isNameDeclaration(n.getParent()) && TypeInference.isPossibleMixinApplication(n, null)) {
            TypeInference.addMissingInterfaceProperties(type);
        }
        if (n.getParent().isLet()) {
            JSType resultType = type != null ? type : this.getNativeType(JSTypeNative.VOID_TYPE);
            scope = this.updateScopeForAssignment(scope, n, resultType, AssignmentType.DECLARATION);
            type = resultType;
        } else {
            StaticTypedSlot var = scope.getSlot(varName);
            if (var != null) {
                boolean nonLocalInferredSlot;
                boolean isInferred = var.isTypeInferred();
                boolean unflowable = isInferred && this.isUnflowable(TypeInference.getDeclaredVar(scope, varName));
                TypedVar maybeOuterVar = isInferred && this.containerScope.isLocal() ? this.containerScope.getParent().getVar(varName) : null;
                boolean bl = nonLocalInferredSlot = var.equals(maybeOuterVar) && !maybeOuterVar.isMarkedAssignedExactlyOnce();
                if (!unflowable && !nonLocalInferredSlot && (type = var.getType()) == null) {
                    type = this.unknownType;
                }
            }
        }
        n.setJSType(type);
        return scope;
    }

    private FlowScope traverseImportSpec(FlowScope scope, Node spec) {
        Node exportedName = spec.getFirstChild();
        Node localName = spec.getSecondChild();
        scope = this.traverse(localName, scope);
        exportedName.setJSType(localName.getJSType());
        return scope;
    }

    static BigIntPresence getBigIntPresence(JSType type) {
        if (type.isOnlyBigInt()) {
            return BigIntPresence.ALL_BIGINT;
        }
        EnumElementType typeAsEnumElement = type.toMaybeEnumElementType();
        if (typeAsEnumElement != null) {
            return TypeInference.getBigIntPresence(typeAsEnumElement.getPrimitiveType());
        }
        UnionType typeAsUnion = type.toMaybeUnionType();
        if (typeAsUnion != null) {
            boolean containsBigInt = false;
            boolean containsNumber = false;
            boolean containsOther = false;
            for (JSType alternate : typeAsUnion.getAlternates()) {
                if (TypeInference.getBigIntPresence(alternate) != BigIntPresence.NO_BIGINT) {
                    containsBigInt = true;
                    continue;
                }
                if (alternate.isNumber() && !alternate.isUnknownType()) {
                    containsNumber = true;
                    continue;
                }
                containsOther = true;
            }
            if (containsBigInt) {
                if (containsOther) {
                    return BigIntPresence.BIGINT_OR_OTHER;
                }
                if (containsNumber) {
                    return BigIntPresence.BIGINT_OR_NUMBER;
                }
                return BigIntPresence.ALL_BIGINT;
            }
        }
        return BigIntPresence.NO_BIGINT;
    }

    private FlowScope traverseUnaryPlus(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        BigIntPresence bigintPresenceInOperand = TypeInference.getBigIntPresence(this.getJSType(n.getFirstChild()));
        if (bigintPresenceInOperand != BigIntPresence.NO_BIGINT) {
            n.setJSType(this.getNativeType(JSTypeNative.NO_TYPE));
        } else {
            n.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
        }
        return scope;
    }

    private FlowScope traverseBigIntCompatibleUnaryOperator(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        switch (TypeInference.getBigIntPresence(this.getJSType(n.getFirstChild()))) {
            case ALL_BIGINT: {
                n.setJSType(this.getNativeType(JSTypeNative.BIGINT_TYPE));
                break;
            }
            case NO_BIGINT: {
                n.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
                break;
            }
            case BIGINT_OR_NUMBER: 
            case BIGINT_OR_OTHER: {
                n.setJSType(this.getNativeType(JSTypeNative.BIGINT_NUMBER));
            }
        }
        return scope;
    }

    private FlowScope traverseBigIntCompatibleBinaryOperator(Node n, FlowScope scope) {
        BigIntPresence rightBigIntPresence;
        scope = this.traverseChildren(n, scope);
        BigIntPresence leftBigIntPresence = TypeInference.getBigIntPresence(this.getJSType(n.getFirstChild()));
        if (leftBigIntPresence != (rightBigIntPresence = TypeInference.getBigIntPresence(this.getJSType(n.getLastChild())))) {
            n.setJSType(this.getNativeType(JSTypeNative.NO_TYPE));
        } else {
            switch (leftBigIntPresence) {
                case NO_BIGINT: {
                    n.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
                    break;
                }
                case ALL_BIGINT: {
                    n.setJSType(this.getNativeType(JSTypeNative.BIGINT_TYPE));
                    break;
                }
                case BIGINT_OR_NUMBER: {
                    n.setJSType(this.getNativeType(JSTypeNative.BIGINT_NUMBER));
                    break;
                }
                case BIGINT_OR_OTHER: {
                    n.setJSType(this.getNativeType(JSTypeNative.NO_TYPE));
                }
            }
        }
        return scope;
    }

    private FlowScope traverseClass(Node n, FlowScope scope) {
        Node member;
        scope = this.traverse(n.getSecondChild(), scope);
        Node classMembers = NodeUtil.getClassMembers(n);
        for (member = classMembers.getFirstChild(); member != null; member = member.getNext()) {
            if (!member.isComputedProp() && !member.isComputedFieldDef()) continue;
            scope = this.traverse(member.getFirstChild(), scope);
        }
        for (member = classMembers.getFirstChild(); member != null; member = member.getNext()) {
            scope = this.traverseClassMemberRhs(member, scope);
        }
        return scope;
    }

    private FlowScope traverseClassMemberRhs(Node member, FlowScope scope) {
        switch (member.getToken()) {
            case MEMBER_FIELD_DEF: 
            case COMPUTED_FIELD_DEF: {
                Node rhs = TypeInference.getRhsOfField(member);
                if (rhs != null) {
                    TypedScope computedFieldDefTypedScope = this.scopeCreator.createScope(member);
                    FlowScope computedFieldDefFlowScope = scope.withSyntacticScope(computedFieldDefTypedScope);
                    FlowScope rhsScope = this.traverse(rhs, computedFieldDefFlowScope).withSyntacticScope(scope.getDeclarationScope());
                    if (member.isStaticMember()) {
                        return rhsScope;
                    }
                }
                return scope;
            }
            case BLOCK: 
            case MEMBER_FUNCTION_DEF: 
            case COMPUTED_PROP: 
            case GETTER_DEF: 
            case SETTER_DEF: {
                return scope;
            }
        }
        throw new AssertionError();
    }

    private static @Nullable Node getRhsOfField(Node fieldNode) {
        switch (fieldNode.getToken()) {
            case MEMBER_FIELD_DEF: {
                if (fieldNode.hasOneChild()) {
                    return fieldNode.getFirstChild();
                }
                return null;
            }
            case COMPUTED_FIELD_DEF: {
                if (fieldNode.hasTwoChildren()) {
                    return fieldNode.getSecondChild();
                }
                return null;
            }
        }
        throw new AssertionError();
    }

    private FlowScope traverseArrayLiteral(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        n.setJSType(this.registry.createTemplatizedType(this.registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE), this.getNativeType(JSTypeNative.UNKNOWN_TYPE)));
        return scope;
    }

    private FlowScope traverseObjectLiteral(Node n, FlowScope scope) {
        JSType type = n.getJSType();
        Preconditions.checkNotNull((Object)type);
        boolean spreadOperatorSeen = false;
        for (Node name = n.getFirstChild(); name != null; name = name.getNext()) {
            spreadOperatorSeen |= name.isSpread();
            scope = this.traverseChildren(name, scope);
        }
        ObjectType objectType = ObjectType.cast(type);
        if (objectType == null || n.getBooleanProp(Node.REFLECTED_OBJECT) || objectType.isEnumType()) {
            return scope;
        }
        String qObjName = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(n));
        for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
            if (key.isComputedProp()) continue;
            if (key.isSpread()) {
                n.setJSType(this.registry.getNativeType(JSTypeNative.OBJECT_TYPE));
                break;
            }
            String memberName = NodeUtil.getObjectOrClassLitKeyName(key);
            if (memberName != null) {
                JSType oldType;
                JSType rawValueType = key.getFirstChild().getJSType();
                JSType valueType = TypeCheck.getObjectLitKeyTypeFromValueType(key, rawValueType);
                if (valueType == null) {
                    valueType = this.unknownType;
                }
                if (!spreadOperatorSeen || !n.getJSType().isNativeObjectType()) {
                    objectType.defineInferredProperty(memberName, valueType, key);
                }
                if (qObjName == null || !key.isStringKey()) continue;
                String qKeyName = qObjName + "." + memberName;
                TypedVar var = TypeInference.getDeclaredVar(scope, qKeyName);
                JSType jSType = oldType = var == null ? null : var.getType();
                if (var != null && var.isTypeInferred()) {
                    var.setType(oldType == null ? valueType : oldType.getLeastSupertype(oldType));
                }
                scope = scope.inferQualifiedSlot(key, qKeyName, oldType == null ? this.unknownType : oldType, valueType, false);
                continue;
            }
            n.setJSType(this.unknownType);
        }
        return scope;
    }

    private FlowScope traverseAdd(Node n, FlowScope scope) {
        Node left = n.getFirstChild();
        Node right = left.getNext();
        scope = this.traverseChildren(n, scope);
        JSType leftType = left.getJSType();
        JSType rightType = right.getJSType();
        JSType type = this.unknownType;
        if (leftType != null && rightType != null) {
            boolean leftIsUnknown = leftType.isUnknownType();
            boolean rightIsUnknown = rightType.isUnknownType();
            if (!leftIsUnknown && leftType.isString() || !rightIsUnknown && rightType.isString()) {
                type = this.getNativeType(JSTypeNative.STRING_TYPE);
            } else {
                if (TypeInference.getBigIntPresence(leftType) != BigIntPresence.NO_BIGINT || TypeInference.getBigIntPresence(rightType) != BigIntPresence.NO_BIGINT) {
                    return this.traverseBigIntCompatibleBinaryOperator(n, scope);
                }
                type = leftIsUnknown || rightIsUnknown ? this.unknownType : (this.isAddedAsNumber(leftType) && this.isAddedAsNumber(rightType) ? this.getNativeType(JSTypeNative.NUMBER_TYPE) : this.getNativeType(JSTypeNative.NUMBER_STRING));
            }
        }
        n.setJSType(type);
        if (n.isAssignAdd()) {
            scope = this.updateScopeForAssignment(scope, left, type, AssignmentType.ASSIGN);
        }
        return scope;
    }

    private boolean isAddedAsNumber(JSType type) {
        return type.isSubtypeOf(this.numberAdditionSupertype);
    }

    private FlowScope traverseHook(Node n, FlowScope scope) {
        Node condition = n.getFirstChild();
        Node trueNode = condition.getNext();
        Node falseNode = n.getLastChild();
        scope = this.traverse(condition, scope);
        FlowScope trueScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, scope, Outcome.TRUE);
        FlowScope falseScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, scope, Outcome.FALSE);
        this.traverse(trueNode, trueScope);
        this.traverse(falseNode, falseScope);
        JSType trueType = trueNode.getJSType();
        JSType falseType = falseNode.getJSType();
        if (trueType != null && falseType != null) {
            n.setJSType(trueType.getLeastSupertype(falseType));
        } else {
            n.setJSType(this.unknownType);
        }
        return scope;
    }

    private FlowScope traverseNullishCoalesce(Node n, FlowScope scope) {
        Preconditions.checkArgument((n.isNullishCoalesce() || n.isAssignNullishCoalesce() ? 1 : 0) != 0);
        Node left = n.getFirstChild();
        Node right = n.getLastChild();
        scope = this.traverse(left, scope);
        FlowScope rightScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(left, scope, Outcome.NULLISH);
        FlowScope scopeAfterTraverseRight = this.traverse(right, rightScope);
        JSType leftType = left.getJSType();
        JSType rightType = right.getJSType();
        JSType type = this.unknownType;
        if (leftType != null) {
            if (!leftType.isNullable() && !leftType.isVoidable()) {
                type = leftType;
            } else if (rightType != null) {
                type = this.registry.createUnionType(leftType.restrictByNotNullOrUndefined(), rightType);
                scope = this.join(scope, scopeAfterTraverseRight);
                if (n.isAssignNullishCoalesce()) {
                    scope = this.updateScopeForAssignment(scope, left, type, AssignmentType.ASSIGN);
                }
            }
        }
        n.setJSType(type);
        return scope;
    }

    private FlowScope setCallNodeTypeAfterChildrenTraversed(Node n, FlowScope scopeAfterChildren) {
        if (n.isCall() && NodeUtil.isExpressionResultUsed(n) && ModuleImportResolver.isGoogModuleDependencyCall(n)) {
            Node calleeNode = n.getFirstChild();
            if (calleeNode.matchesQualifiedName(GOOG_REQUIREDYNAMIC_NAME)) {
                n.setJSType(Promises.wrapInIThenable(this.registry, this.getGoogModuleDependencyCallResultType(n)));
            } else {
                n.setJSType(this.getGoogModuleDependencyCallResultType(n));
            }
            return scopeAfterChildren;
        }
        Node left = n.getFirstChild();
        JSType functionType = this.getJSType(left).restrictByNotNullOrUndefined();
        if (left.isSuper()) {
            return this.traverseInstantiation(n, functionType, scopeAfterChildren);
        }
        if (functionType.isFunctionType()) {
            FunctionType fnType = functionType.toMaybeFunctionType();
            n.setJSType(fnType.getReturnType());
            this.backwardsInferenceFromCallSite(n, fnType, scopeAfterChildren);
        } else if (functionType.equals(this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE))) {
            n.setJSType(this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE));
        } else if (left.getJSType() != null && left.getJSType().isUnknownType()) {
            n.setJSType(this.unknownType);
        }
        return scopeAfterChildren;
    }

    private @Nullable JSType getGoogModuleDependencyCallResultType(Node callNode) {
        String moduleId = callNode.getSecondChild().getString();
        Module module = this.compiler.getModuleMap().getClosureModule(moduleId);
        if (module == null) {
            return null;
        }
        ScopedName name = this.moduleImportResolver.getClosureNamespaceTypeFromCall(callNode);
        if (name != null) {
            TypedVar otherVar;
            TypedScope otherModuleScope = this.scopeCreator.getNodeToScopeMapper().apply(name.getScopeRoot());
            TypedVar typedVar = otherVar = otherModuleScope != null ? (TypedVar)otherModuleScope.getSlot(name.getName()) : null;
            if (otherVar != null) {
                return otherVar.getType();
            }
            if (otherModuleScope != null && module.metadata().moduleType() == ModuleMetadataMap.ModuleType.GOOG_PROVIDE) {
                return otherModuleScope.getTypeThroughNamespace(moduleId);
            }
        }
        return this.unknownType;
    }

    private FlowScope tightenTypesAfterAssertions(FlowScope scope, Node callNode) {
        Node left = callNode.getFirstChild();
        Node firstParam = left.getNext();
        if (firstParam == null) {
            return scope;
        }
        CodingConvention.AssertionFunctionSpec assertionFunctionSpec = this.assertionFunctionLookup.lookupByCallee(left);
        if (assertionFunctionSpec == null) {
            return scope;
        }
        Node assertedNode = assertionFunctionSpec.getAssertedArg(firstParam);
        if (assertedNode == null) {
            return scope;
        }
        String assertedNodeName = assertedNode.getQualifiedName();
        switch (assertionFunctionSpec.getAssertionKind()) {
            case TRUTHY: {
                scope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(assertedNode, scope, Outcome.TRUE);
                JSType truthyType = this.getJSType(assertedNode).restrictByNotNullOrUndefined();
                callNode.setJSType(truthyType);
                break;
            }
            case MATCHES_RETURN_TYPE: {
                FunctionType callType = JSType.toMaybeFunctionType(left.getJSType());
                JSType assertedType = callType != null ? callType.getReturnType() : this.unknownType;
                JSType type = this.getJSType(assertedNode);
                JSType narrowed = assertedType.isUnknownType() || type.isUnknownType() ? assertedType : type.getGreatestSubtype(assertedType);
                callNode.setJSType(narrowed);
                if (assertedNodeName == null || !type.differsFrom(narrowed)) break;
                scope = this.narrowScope(scope, assertedNode, narrowed);
            }
        }
        return scope;
    }

    private FlowScope narrowScope(FlowScope scope, Node node, JSType narrowed) {
        if (node.isThis()) {
            return scope;
        }
        if (node.isGetProp()) {
            return scope.inferQualifiedSlot(node, node.getQualifiedName(), this.getJSType(node), narrowed, false);
        }
        return this.redeclareSimpleVar(scope, node, narrowed);
    }

    private void backwardsInferenceFromCallSite(Node n, FunctionType fnType, FlowScope scope) {
        boolean updatedFnType = this.inferTemplatedTypesForCall(n, fnType, scope);
        if (updatedFnType) {
            fnType = n.getFirstChild().getJSType().toMaybeFunctionType();
        }
        this.updateTypeOfArguments(n, fnType);
        this.updateBind(n);
    }

    private void updateBind(Node n) {
        JSType thisType;
        CodingConvention.Bind bind = this.compiler.getCodingConvention().describeFunctionBind(n, false, true);
        if (bind == null) {
            return;
        }
        Node target = bind.target;
        FunctionType callTargetFn = this.getJSType(target).restrictByNotNullOrUndefined().toMaybeFunctionType();
        if (callTargetFn == null) {
            return;
        }
        if (bind.thisValue != null && target.isFunction() && (thisType = this.getJSType(bind.thisValue)).toObjectType() != null && !thisType.isUnknownType() && callTargetFn.getTypeOfThis().isUnknownType()) {
            callTargetFn = callTargetFn.toBuilder().withTypeOfThis(thisType.toObjectType()).withSourceNode(null).buildAndResolve();
            target.setJSType(callTargetFn);
        }
        FunctionType returnType = callTargetFn.getBindReturnType(bind.getBoundParameterCount() + 1);
        FunctionType bindType = this.getJSType(n.getFirstChild()).toMaybeFunctionType();
        if (bindType != null && n.getFirstChild() != target) {
            bindType = bindType.toBuilder().withReturnType(returnType).withSourceNode(null).buildAndResolve();
            n.getFirstChild().setJSType(bindType);
        }
        n.setJSType(returnType);
    }

    private void updateTypeOfArguments(Node n, FunctionType fnType) {
        Preconditions.checkState((boolean)NodeUtil.isInvocation(n), (Object)n);
        UnmodifiableIterator parameters = fnType.getParameters().iterator();
        if (n.isTaggedTemplateLit()) {
            if (!parameters.hasNext()) {
                return;
            }
            parameters.next();
        }
        Iterator<Node> arguments = NodeUtil.getInvocationArgsAsIterable(n).iterator();
        while (parameters.hasNext() && arguments.hasNext()) {
            Node iArgument = arguments.next();
            JSType iArgumentType = this.getJSType(iArgument);
            FunctionType.Parameter iParameter = (FunctionType.Parameter)parameters.next();
            JSType iParameterType = iParameter.getJSType() != null ? iParameter.getJSType() : this.unknownType;
            TypeInference.inferPropertyTypesToMatchConstraint(iArgumentType, iParameterType);
            FunctionType restrictedParameter = null;
            if (iParameterType.isUnionType()) {
                UnionType union = iParameterType.toMaybeUnionType();
                for (JSType alternative : union.getAlternates()) {
                    if (!alternative.isFunctionType()) continue;
                    restrictedParameter = alternative.toMaybeFunctionType();
                    break;
                }
            } else {
                restrictedParameter = iParameterType.toMaybeFunctionType();
            }
            if (restrictedParameter == null || !iArgument.isFunction() || !iArgumentType.isFunctionType()) continue;
            FunctionType argFnType = iArgumentType.toMaybeFunctionType();
            JSDocInfo argJsdoc = iArgument.getJSDocInfo();
            boolean declared = argJsdoc != null && argJsdoc.containsDeclaration() || NodeUtil.functionHasInlineJsdocs(iArgument);
            iArgument.setJSType(this.matchFunction(restrictedParameter, argFnType, declared));
        }
    }

    private FunctionType matchFunction(FunctionType expectedType, FunctionType currentType, boolean declared) {
        if (declared) {
            if (currentType.getTypeOfThis().isUnknownType() && !expectedType.getTypeOfThis().isUnknownType()) {
                return currentType.toBuilder().withTypeOfThis(expectedType.getTypeOfThis()).buildAndResolve();
            }
        } else if (currentType.getMaxArity() <= expectedType.getMaxArity()) {
            return expectedType;
        }
        return currentType;
    }

    private Map<String, JSType> buildTypeVariables(Map<TemplateType, JSType> inferredTypes) {
        LinkedHashMap<String, JSType> typeVars = new LinkedHashMap<String, JSType>();
        for (Map.Entry<TemplateType, JSType> e : inferredTypes.entrySet()) {
            if (e.getKey().isTypeTransformation()) continue;
            typeVars.put(e.getKey().getReferenceName(), e.getValue());
        }
        return typeVars;
    }

    private Map<TemplateType, JSType> evaluateTypeTransformations(ImmutableList<TemplateType> templateTypes, Map<TemplateType, JSType> inferredTypes, FlowScope scope) {
        Map<String, JSType> typeVars = null;
        LinkedHashMap<TemplateType, JSType> result = null;
        TypeTransformation ttlObj = null;
        for (TemplateType type : templateTypes) {
            if (!type.isTypeTransformation()) continue;
            if (ttlObj == null) {
                ttlObj = new TypeTransformation(this.compiler, scope.getDeclarationScope());
                typeVars = this.buildTypeVariables(inferredTypes);
                result = new LinkedHashMap<TemplateType, JSType>();
            }
            JSType transformedType = ttlObj.eval(type.getTypeTransformation(), (ImmutableMap<String, JSType>)ImmutableMap.copyOf(typeVars));
            result.put(type, transformedType);
            typeVars.put(type.getReferenceName(), transformedType);
        }
        return result;
    }

    private boolean inferTemplatedTypesForCall(Node n, FunctionType fnType, FlowScope scope) {
        ImmutableList<TemplateType> keys = fnType.getTemplateTypeMap().getTemplateKeys();
        if (keys.isEmpty()) {
            return false;
        }
        ImmutableMap<TemplateType, JSType> bindings = new InvocationTemplateTypeMatcher(this.registry, fnType, scope.getTypeOfThis(), n).match();
        LinkedHashMap<TemplateType, JSType> inferred = new LinkedHashMap<TemplateType, JSType>();
        for (TemplateType key : keys) {
            inferred.put(key, (JSType)bindings.getOrDefault((Object)key, (Object)this.unknownType));
        }
        inferred.replaceAll((k, v) -> v.isSubtypeOf(k.getBound()) ? v : k.getBound());
        Map<TemplateType, JSType> typeTransformations = this.evaluateTypeTransformations(keys, inferred, scope);
        if (typeTransformations != null) {
            inferred.putAll(typeTransformations);
        }
        TemplateTypeReplacer replacer = TemplateTypeReplacer.forInference(this.registry, inferred);
        Node callTarget = n.getFirstChild();
        FunctionType replacementFnType = fnType.visit(replacer).toMaybeFunctionType();
        Preconditions.checkNotNull((Object)replacementFnType);
        callTarget.setJSType(replacementFnType);
        n.setJSType(replacementFnType.getReturnType());
        return replacer.hasMadeReplacement();
    }

    private FlowScope traverseNew(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        Node constructor = n.getFirstChild();
        JSType constructorType = constructor.getJSType();
        return this.traverseInstantiation(n, constructorType, scope);
    }

    private FlowScope traverseInstantiation(Node n, JSType ctorType, FlowScope scope) {
        if (ctorType == null || ctorType.isUnknownType()) {
            n.setJSType(this.unknownType);
            return scope;
        }
        FunctionType ctorFnType = (ctorType = ctorType.restrictByNotNullOrUndefined()).toMaybeFunctionType();
        if (ctorFnType == null && ctorType instanceof FunctionType) {
            ctorFnType = (FunctionType)ctorType;
        }
        if (ctorFnType == null || !ctorFnType.isConstructor()) {
            n.setJSType(this.unknownType);
            return scope;
        }
        this.backwardsInferenceFromCallSite(n, ctorFnType, scope);
        ObjectType instantiatedType = ctorFnType.getInstanceType();
        if (ctorFnType != this.registry.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE) && ctorFnType.hasAnyTemplateTypes()) {
            if (instantiatedType.isTemplatizedType()) {
                instantiatedType = instantiatedType.toMaybeTemplatizedType().getRawType();
            }
            ImmutableMap<TemplateType, JSType> inferredTypes = new InvocationTemplateTypeMatcher(this.registry, ctorFnType, scope.getTypeOfThis(), n).match();
            instantiatedType = this.registry.createTemplatizedType(instantiatedType, (Map<TemplateType, JSType>)inferredTypes).toMaybeObjectType();
        }
        n.setJSType(instantiatedType != null ? instantiatedType : this.unknownType);
        return scope;
    }

    private BooleanOutcomePair traverseAnd(Node n, FlowScope scope) {
        Node left = n.getFirstChild();
        BooleanOutcomePair leftOutcome = this.traverseWithinShortCircuitingBinOp(left, scope);
        return this.traverseShortCircuitingBinOp(n, left, leftOutcome);
    }

    private FlowScope traverseChildren(Node n, FlowScope scope) {
        for (Node el = n.getFirstChild(); el != null; el = el.getNext()) {
            scope = this.traverse(el, scope);
        }
        return scope;
    }

    private FlowScope traverseGetElem(Node n, FlowScope originalScope) {
        FlowScope executedScope = this.traverseChildren(n, originalScope);
        return this.setGetElemNodeTypeAfterChildrenTraversed(n, executedScope);
    }

    private FlowScope setGetElemNodeTypeAfterChildrenTraversed(Node n, FlowScope scopeAfterChildren) {
        Preconditions.checkArgument((n.isGetElem() || n.isOptChainGetElem() ? 1 : 0) != 0);
        this.inferGetElemType(n);
        scopeAfterChildren = this.tightenTypeAfterDereference(n.getFirstChild(), scopeAfterChildren);
        return scopeAfterChildren;
    }

    private void inferGetElemType(Node n) {
        Node indexKey = n.getLastChild();
        JSType indexType = this.getJSType(indexKey);
        JSType inferredType = this.unknownType;
        if (!indexType.isSymbolValueType()) {
            JSType type = this.getJSType(n.getFirstChild()).restrictByNotNullOrUndefined();
            UnionType.Builder argumentTypes = UnionType.builder(this.registry);
            ImmutableList<JSType> alternates = type.isUnionType() ? type.toMaybeUnionType().getAlternates() : ImmutableList.of((Object)type);
            for (JSType option : alternates) {
                TemplateTypeMap typeMap = option.getTemplateTypeMap();
                if (!typeMap.hasTemplateType(this.registry.getObjectElementKey())) {
                    argumentTypes = null;
                    break;
                }
                argumentTypes.addAlternate(typeMap.getResolvedTemplateType(this.registry.getObjectElementKey()));
            }
            inferredType = argumentTypes == null ? null : argumentTypes.build();
        }
        n.setJSType(inferredType != null ? inferredType : this.unknownType);
    }

    private FlowScope traverseGetProp(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        return this.setGetPropNodeTypeAfterChildrenTraversed(n, scope);
    }

    private FlowScope setGetPropNodeTypeAfterChildrenTraversed(Node n, FlowScope scopeAfterChildren) {
        Preconditions.checkArgument((n.isGetProp() || n.isOptChainGetProp() ? 1 : 0) != 0);
        Node objNode = n.getFirstChild();
        n.setJSType(this.getPropertyType(objNode.getJSType(), n.getString(), n, scopeAfterChildren));
        return this.tightenTypeAfterDereference(n.getFirstChild(), scopeAfterChildren);
    }

    private FlowScope setOptChainNodeTypeAfterChildrenTraversed(Node n, FlowScope scopeAfterChildren) {
        switch (n.getToken()) {
            case OPTCHAIN_GETPROP: {
                return this.setGetPropNodeTypeAfterChildrenTraversed(n, scopeAfterChildren);
            }
            case OPTCHAIN_GETELEM: {
                return this.setGetElemNodeTypeAfterChildrenTraversed(n, scopeAfterChildren);
            }
            case OPTCHAIN_CALL: {
                return this.setCallNodeTypeAfterChildrenTraversed(n, scopeAfterChildren);
            }
        }
        throw new IllegalStateException("Illegal token inside finishTraversingOptChain");
    }

    private FlowScope traverseOptChain(Node n, FlowScope scope) {
        Preconditions.checkArgument((boolean)NodeUtil.isOptChainNode(n));
        if (NodeUtil.isEndOfOptChainSegment(n)) {
            Node startOfChain = NodeUtil.getStartOfOptChainSegment(n);
            OptChainInfo optChainInfo = new OptChainInfo(n, startOfChain);
            this.optChainArrayDeque.addFirst(optChainInfo);
        }
        FlowScope lhsScope = this.traverse(n.getFirstChild(), scope);
        if (n.isOptionalChainStart()) {
            this.optChainArrayDeque.peekFirst().unconditionalScope = lhsScope;
        }
        FlowScope aboutToExecuteScope = lhsScope;
        for (Node nextChild = n.getSecondChild(); nextChild != null; nextChild = nextChild.getNext()) {
            aboutToExecuteScope = this.traverse(nextChild, aboutToExecuteScope);
        }
        FlowScope executedScope = this.setOptChainNodeTypeAfterChildrenTraversed(n, aboutToExecuteScope);
        if (n.getJSType() == null) {
            n.setJSType(this.unknownType);
        }
        if (NodeUtil.isEndOfOptChainSegment(n)) {
            Node startOfChain = NodeUtil.getStartOfOptChainSegment(n);
            OptChainInfo currentChain = this.optChainArrayDeque.removeFirst();
            Preconditions.checkState((currentChain.endOfChain == n ? 1 : 0) != 0);
            Preconditions.checkState((currentChain.startOfChain == startOfChain ? 1 : 0) != 0);
            Node startNode = (Node)Preconditions.checkNotNull((Object)startOfChain.getFirstChild());
            return this.updateTypeWhenEndOfOptChain(n, startNode, currentChain, executedScope);
        }
        return executedScope;
    }

    private FlowScope updateTypeWhenEndOfOptChain(Node optChain, Node startNode, OptChainInfo currentChain, FlowScope executedScope) {
        JSType startType = this.getJSType(startNode);
        if (startType.isUnknownType()) {
            optChain.setJSType(this.unknownType);
            return this.join(executedScope, currentChain.unconditionalScope);
        }
        if (startType.isNullType() || startType.isVoidType()) {
            optChain.setJSType(this.registry.getNativeType(JSTypeNative.VOID_TYPE));
            return currentChain.unconditionalScope;
        }
        if (!startType.isNullable()) {
            return executedScope;
        }
        optChain.setJSType(this.registry.createUnionType(this.registry.getNativeType(JSTypeNative.VOID_TYPE), optChain.getJSType()));
        FlowScope unexecutedScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(startNode, currentChain.unconditionalScope, Outcome.NULLISH);
        return this.join(executedScope, unexecutedScope);
    }

    private static void inferPropertyTypesToMatchConstraint(JSType type, JSType constraint) {
        if (type == null || constraint == null) {
            return;
        }
        type.matchConstraint(constraint);
    }

    private FlowScope tightenTypeAfterDereference(Node n, FlowScope scope) {
        JSType narrowed;
        JSType type;
        if (n.isQualifiedName() && !(type = this.getJSType(n)).equals(narrowed = type.restrictByNotNullOrUndefined())) {
            scope = this.narrowScope(scope, n, narrowed);
        }
        return scope;
    }

    private JSType getPropertyType(JSType objType, String propName, Node n, FlowScope scope) {
        ObjectType regType;
        JSType foundType;
        JSType varType;
        StaticTypedSlot var;
        JSType propertyType = null;
        boolean isLocallyInferred = false;
        String qualifiedName = n.getQualifiedName();
        StaticTypedSlot staticTypedSlot = var = qualifiedName != null ? scope.getSlot(qualifiedName) : null;
        if (var != null && (varType = var.getType()) != null) {
            boolean isDeclared = !var.isTypeInferred();
            boolean bl = isLocallyInferred = var != TypeInference.getDeclaredVar(scope, qualifiedName);
            if (isDeclared || isLocallyInferred) {
                propertyType = varType;
            }
        }
        if (propertyType == null && objType != null && (foundType = objType.findPropertyType(propName)) != null) {
            propertyType = foundType;
        }
        if ((propertyType == null || propertyType.isUnknownType()) && qualifiedName != null && (regType = ObjectType.cast(this.registry.getType(scope.getDeclarationScope(), qualifiedName))) != null) {
            propertyType = regType.getConstructor();
        }
        if (propertyType == null) {
            return this.unknownType;
        }
        if (propertyType.equals(this.unknownType) && isLocallyInferred) {
            return this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
        }
        return propertyType;
    }

    private BooleanOutcomePair traverseOr(Node n, FlowScope scope) {
        Node left = n.getFirstChild();
        BooleanOutcomePair leftOutcome = this.traverseWithinShortCircuitingBinOp(left, scope);
        return this.traverseShortCircuitingBinOp(n, left, leftOutcome);
    }

    private FlowScope traverseShortCircuitingBinOpAssignment(Node n, FlowScope scope) {
        Node left = n.getFirstChild();
        boolean nIsAnd = n.isAssignAnd();
        BooleanOutcomePair leftOutcome = this.traverseWithinShortCircuitingBinOp(left, scope);
        BooleanOutcomePair outcome = this.traverseShortCircuitingBinOp(n, left, leftOutcome);
        FlowScope outcomeJoinedFlowScope = outcome.getJoinedFlowScope();
        if (leftOutcome.toBooleanOutcomes == BooleanLiteralSet.get(!nIsAnd)) {
            return outcomeJoinedFlowScope;
        }
        return this.updateScopeForAssignment(outcomeJoinedFlowScope, n.getFirstChild(), n.getJSType(), AssignmentType.ASSIGN);
    }

    private BooleanOutcomePair traverseShortCircuitingBinOp(Node n, Node left, BooleanOutcomePair leftOutcome) {
        BooleanOutcomePair outcome;
        JSType type;
        Preconditions.checkArgument((n.isAnd() || n.isOr() || n.isAssignAnd() || n.isAssignOr() ? 1 : 0) != 0);
        boolean nIsAnd = n.isAnd() || n.isAssignAnd();
        Node right = n.getLastChild();
        JSType leftType = left.getJSType();
        FlowScope rightScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(left, leftOutcome.getOutcomeFlowScope(left.getToken(), nIsAnd), Outcome.forBoolean(nIsAnd));
        BooleanOutcomePair rightOutcome = this.traverseWithinShortCircuitingBinOp(right, rightScope);
        JSType rightType = right.getJSType();
        if (leftType != null && rightType != null) {
            leftType = leftType.getRestrictedTypeGivenOutcome(Outcome.forBoolean(!nIsAnd));
            if (leftOutcome.toBooleanOutcomes == BooleanLiteralSet.get(!nIsAnd)) {
                type = leftType;
                outcome = leftOutcome;
            } else {
                type = leftType.getLeastSupertype(rightType);
                outcome = new BooleanOutcomePair(TypeInference.joinBooleanOutcomes(nIsAnd, leftOutcome.toBooleanOutcomes, rightOutcome.toBooleanOutcomes), TypeInference.joinBooleanOutcomes(nIsAnd, leftOutcome.booleanValues, rightOutcome.booleanValues), leftOutcome.getJoinedFlowScope(), rightOutcome.getJoinedFlowScope());
            }
            if (outcome.booleanValues == BooleanLiteralSet.EMPTY && this.getNativeType(JSTypeNative.BOOLEAN_TYPE).isSubtypeOf(type) && type.isUnionType()) {
                type = type.toMaybeUnionType().getRestrictedUnion(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
            }
        } else {
            type = this.unknownType;
            outcome = new BooleanOutcomePair(BooleanLiteralSet.BOTH, BooleanLiteralSet.BOTH, leftOutcome.getJoinedFlowScope(), rightOutcome.getJoinedFlowScope());
        }
        n.setJSType(type);
        return outcome;
    }

    private BooleanOutcomePair traverseWithinShortCircuitingBinOp(Node n, FlowScope scope) {
        switch (n.getToken()) {
            case AND: {
                return this.traverseAnd(n, scope);
            }
            case OR: {
                return this.traverseOr(n, scope);
            }
        }
        scope = this.traverse(n, scope);
        return this.newBooleanOutcomePair(n.getJSType(), scope);
    }

    private FlowScope traverseAwait(Node await, FlowScope scope) {
        scope = this.traverseChildren(await, scope);
        Node expr = await.getFirstChild();
        JSType exprType = this.getJSType(expr);
        await.setJSType(Promises.getResolvedType(this.registry, exprType));
        return scope;
    }

    private FlowScope traverseDynamicImport(Node dynamicImport, FlowScope scope) {
        JSType templateType = this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        ModuleMap moduleMap = this.compiler.getModuleMap();
        Node importSpecifier = dynamicImport.getFirstChild();
        CompilerInput input = this.compiler.getInput(NodeUtil.getInputId(dynamicImport));
        if (importSpecifier.isStringLit() && moduleMap != null && input != null) {
            Module targetModule;
            ModuleLoader.ModulePath targetPath = input.getPath().resolveJsModule(importSpecifier.getString(), importSpecifier.getSourceFileName(), importSpecifier.getLineno(), importSpecifier.getCharno());
            Module module = targetModule = targetPath != null ? moduleMap.getModule(targetPath) : null;
            if (targetModule != null) {
                Node scriptNode = targetModule.metadata().rootNode();
                if (scriptNode.hasOneChild() && scriptNode.getFirstChild().isModuleBody()) {
                    JSType exportNamespaceType;
                    JSType jSType = exportNamespaceType = scriptNode != null ? scriptNode.getOnlyChild().getJSType() : null;
                    if (exportNamespaceType != null) {
                        templateType = exportNamespaceType;
                    }
                } else {
                    Node moduleName = NodeUtil.findPreorder(scriptNode, (Predicate<Node>)((Predicate)node -> node.matchesQualifiedName(targetPath.toModuleName())), (Predicate<Node>)Predicates.alwaysTrue());
                    if (moduleName != null && moduleName.getJSType() != null) {
                        templateType = moduleName.getJSType();
                    }
                }
            }
        }
        dynamicImport.setJSType(this.registry.createTemplatizedType(this.registry.getNativeObjectType(JSTypeNative.PROMISE_TYPE), templateType));
        return this.traverseChildren(dynamicImport, scope);
    }

    private static BooleanLiteralSet joinBooleanOutcomes(boolean isAnd, BooleanLiteralSet left, BooleanLiteralSet right) {
        return right.union(left.intersection(BooleanLiteralSet.get(!isAnd)));
    }

    private BooleanOutcomePair newBooleanOutcomePair(JSType jsType, FlowScope flowScope) {
        if (jsType == null) {
            return new BooleanOutcomePair(BooleanLiteralSet.BOTH, BooleanLiteralSet.BOTH, flowScope, flowScope);
        }
        return new BooleanOutcomePair(jsType.getPossibleToBooleanOutcomes(), this.registry.getNativeType(JSTypeNative.BOOLEAN_TYPE).isSubtypeOf(jsType) ? BooleanLiteralSet.BOTH : BooleanLiteralSet.EMPTY, flowScope, flowScope);
    }

    @CheckReturnValue
    private FlowScope redeclareSimpleVar(FlowScope scope, Node nameNode, JSType varType) {
        Preconditions.checkState((boolean)nameNode.isName(), (Object)nameNode);
        String varName = nameNode.getString();
        if (varType == null) {
            varType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (this.isUnflowable(TypeInference.getDeclaredVar(scope, varName))) {
            return scope;
        }
        return scope.inferSlotType(varName, varType);
    }

    private boolean isUnflowable(TypedVar v) {
        return v != null && v.isLocal() && v.isMarkedEscaped() && ((TypedScope)v.getScope()).getClosestContainerScope() == this.containerScope;
    }

    private JSType getJSType(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.unknownType;
        }
        return jsType;
    }

    private JSType getNativeType(JSTypeNative typeId) {
        return this.registry.getNativeType(typeId);
    }

    private static TypedVar getDeclaredVar(FlowScope scope, String name) {
        return ((TypedScope)scope.getDeclarationScope()).getVar(name);
    }

    static interface TypeDeclaringCallback {
        public FlowScope declareTypeInScope(FlowScope var1, Node var2, @Nullable JSType var3);
    }

    private final class BooleanOutcomePair {
        final BooleanLiteralSet toBooleanOutcomes;
        final BooleanLiteralSet booleanValues;
        final FlowScope leftScope;
        final FlowScope rightScope;
        @Nullable FlowScope joinedScope = null;

        BooleanOutcomePair(BooleanLiteralSet toBooleanOutcomes, BooleanLiteralSet booleanValues, FlowScope leftScope, FlowScope rightScope) {
            this.toBooleanOutcomes = toBooleanOutcomes;
            this.booleanValues = booleanValues;
            this.leftScope = leftScope;
            this.rightScope = rightScope;
        }

        FlowScope getJoinedFlowScope() {
            if (this.joinedScope == null) {
                this.joinedScope = this.leftScope == this.rightScope ? this.rightScope : TypeInference.this.join(this.leftScope, this.rightScope);
            }
            return this.joinedScope;
        }

        FlowScope getOutcomeFlowScope(Token nodeType, boolean outcome) {
            if (nodeType == Token.AND && outcome || nodeType == Token.OR && !outcome) {
                return this.rightScope;
            }
            return this.getJoinedFlowScope();
        }
    }

    private static enum AssignmentType {
        DECLARATION,
        ASSIGN;

    }

    public static enum BigIntPresence {
        NO_BIGINT,
        ALL_BIGINT,
        BIGINT_OR_NUMBER,
        BIGINT_OR_OTHER;

    }

    private static class OptChainInfo {
        private final Node endOfChain;
        private final Node startOfChain;
        private @Nullable FlowScope unconditionalScope;

        OptChainInfo(Node endOfChain, Node startOfChain) {
            this.endOfChain = endOfChain;
            this.startOfChain = startOfChain;
            this.unconditionalScope = null;
        }
    }
}

