/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Msg;
import java.util.Map;
import java.util.regex.Pattern;
import org.jspecify.nullness.Nullable;

class RhinoErrorReporter {
    static final DiagnosticType PARSE_ERROR = DiagnosticType.error("JSC_PARSE_ERROR", "Parse error. {0}");
    static final DiagnosticType TYPE_PARSE_ERROR = DiagnosticType.warning("JSC_TYPE_PARSE_ERROR", "{0}");
    static final DiagnosticType UNRECOGNIZED_TYPE_ERROR = DiagnosticType.warning("JSC_UNRECOGNIZED_TYPE_ERROR", "{0}");
    static final DiagnosticType UNRECOGNIZED_TYPEOF_ERROR = DiagnosticType.warning("JSC_UNRECOGNIZED_TYPEOF_ERROR", "{0}");
    static final DiagnosticType CYCLIC_INHERITANCE_ERROR = DiagnosticType.warning("JSC_CYCLIC_INHERITANCE_ERROR", "{0}");
    static final DiagnosticType JSDOC_MISSING_BRACES_WARNING = DiagnosticType.disabled("JSC_JSDOC_MISSING_BRACES_WARNING", "{0}");
    static final DiagnosticType JSDOC_MISSING_TYPE_WARNING = DiagnosticType.disabled("JSC_JSDOC_MISSING_TYPE_WARNING", "{0}");
    static final DiagnosticType JSDOC_IMPORT_TYPE_WARNING = DiagnosticType.disabled("JSC_JSDOC_IMPORT_TYPE_WARNING", "{0}");
    static final DiagnosticType TOO_MANY_TEMPLATE_PARAMS = DiagnosticType.disabled("JSC_TOO_MANY_TEMPLATE_PARAMS", "{0}");
    static final DiagnosticType TRAILING_COMMA = DiagnosticType.error("JSC_TRAILING_COMMA", "Parse error. IE8 (and below) will parse trailing commas in array and object literals incorrectly. If you are targeting newer versions of JS, set the appropriate language_in option.");
    static final DiagnosticType DUPLICATE_PARAM = DiagnosticType.error("JSC_DUPLICATE_PARAM", "Parse error. {0}");
    static final DiagnosticType DUPLICATE_VISIBILITY = DiagnosticType.warning("JSC_DUPLICATE_VISIBILITY", "{0}");
    static final DiagnosticType UNNECESSARY_ESCAPE = DiagnosticType.disabled("JSC_UNNECESSARY_ESCAPE", "Parse error. {0}");
    static final DiagnosticType INVALID_PARAM = DiagnosticType.warning("JSC_INVALID_PARAM", "Parse error. {0}");
    static final DiagnosticType BAD_JSDOC_ANNOTATION = DiagnosticType.warning("JSC_BAD_JSDOC_ANNOTATION", "Parse error. {0}");
    static final DiagnosticType INVALID_ES3_PROP_NAME = DiagnosticType.warning("JSC_INVALID_ES3_PROP_NAME", "Keywords and reserved words are not allowed as unquoted property names in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.");
    static final DiagnosticType PARSE_TREE_TOO_DEEP = DiagnosticType.error("JSC_PARSE_TREE_TOO_DEEP", "Parse tree too deep.");
    static final DiagnosticType INVALID_OCTAL_LITERAL = DiagnosticType.warning("JSC_INVALID_OCTAL_LITERAL", "This style of octal literal is not supported in strict mode.");
    static final DiagnosticType STRING_CONTINUATION = DiagnosticType.disabled("JSC_STRING_CONTINUATION", "{0}");
    static final DiagnosticType LANGUAGE_FEATURE = DiagnosticType.error("JSC_LANGUAGE_FEATURE", "{0}.");
    static final DiagnosticType UNSUPPORTED_LANGUAGE_FEATURE = DiagnosticType.error("JSC_UNSUPPORTED_LANGUAGE_FEATURE", "{0}.");
    static final DiagnosticType UNSUPPORTED_BOUNDED_GENERIC_TYPES = DiagnosticType.error("JSC_UNSUPPORTED_BOUNDED_GENERIC_TYPES", "Bounded generic semantics are currently still in development");
    static final DiagnosticType BOUNDED_GENERIC_TYPE_ERROR = DiagnosticType.error("JSC_BOUNDED_GENERIC_TYPE_ERROR", "Bounded generic type error. {0} assigned to template type {1} is not a subtype of bound {2}");
    private static final ImmutableMap<Pattern, DiagnosticType> typeMap = ImmutableMap.builder().put((Object)Pattern.compile("Trailing comma is not legal in an ECMA-262 object initializer"), (Object)TRAILING_COMMA).put((Object)RhinoErrorReporter.replacePlaceHolders("Duplicate parameter name \"{0}\""), (Object)DUPLICATE_PARAM).put((Object)RhinoErrorReporter.replacePlaceHolders(Msg.JSDOC_EXTRA_VISIBILITY.format()), (Object)DUPLICATE_VISIBILITY).put((Object)Pattern.compile("Unnecessary escape:.*"), (Object)UNNECESSARY_ESCAPE).put((Object)Pattern.compile("^invalid param name.*"), (Object)INVALID_PARAM).put((Object)RhinoErrorReporter.replacePlaceHolders(Msg.BAD_JSDOC_TAG.format()), (Object)BAD_JSDOC_ANNOTATION).put((Object)Pattern.compile("^Keywords and reserved words are not allowed as unquoted property.*"), (Object)INVALID_ES3_PROP_NAME).put((Object)Pattern.compile("^Too many template parameters\n.*"), (Object)TOO_MANY_TEMPLATE_PARAMS).put((Object)Pattern.compile(".*Type annotations should have curly braces.*"), (Object)JSDOC_MISSING_BRACES_WARNING).put((Object)Pattern.compile("Missing type declaration\\."), (Object)JSDOC_MISSING_TYPE_WARNING).put((Object)Pattern.compile(".*Unknown type.*"), (Object)UNRECOGNIZED_TYPE_ERROR).put((Object)Pattern.compile(".*Unknown type.*\n.*"), (Object)UNRECOGNIZED_TYPE_ERROR).put((Object)Pattern.compile("^Missing type for `typeof` value.*"), (Object)UNRECOGNIZED_TYPEOF_ERROR).put((Object)Pattern.compile("^Cycle detected in inheritance chain of type .*"), (Object)CYCLIC_INHERITANCE_ERROR).put((Object)Pattern.compile("^Bad type annotation. Import in typedef.*"), (Object)JSDOC_IMPORT_TYPE_WARNING).put((Object)Pattern.compile("^Bad type annotation.*"), (Object)TYPE_PARSE_ERROR).put((Object)Pattern.compile("constructed type must be an object type"), (Object)TYPE_PARSE_ERROR).put((Object)Pattern.compile("Too deep recursion while parsing"), (Object)PARSE_TREE_TOO_DEEP).put((Object)Pattern.compile("^Octal .*literal.*"), (Object)INVALID_OCTAL_LITERAL).put((Object)Pattern.compile("^String continuations.*"), (Object)STRING_CONTINUATION).put((Object)Pattern.compile("^This language feature is only supported for .*"), (Object)LANGUAGE_FEATURE).put((Object)Pattern.compile("^This language feature is not currently supported by the compiler: .*"), (Object)UNSUPPORTED_LANGUAGE_FEATURE).put((Object)Pattern.compile("Bounded generic semantics are currently still in development"), (Object)UNSUPPORTED_BOUNDED_GENERIC_TYPES).put((Object)Pattern.compile("^Bounded generic type error.*"), (Object)BOUNDED_GENERIC_TYPE_ERROR).buildOrThrow();
    private final ErrorHandler internalReporter;

    private static Pattern replacePlaceHolders(String s) {
        s = Pattern.quote(s);
        return Pattern.compile(s.replaceAll("\\{\\d+\\}", "\\\\E.*\\\\Q"));
    }

    private RhinoErrorReporter(ErrorHandler internalReporter) {
        this.internalReporter = internalReporter;
    }

    public static ErrorReporter forOldRhino(ErrorHandler internalReporter) {
        return new OldRhinoErrorReporter(internalReporter);
    }

    void warningAtLine(String message, String sourceName, int line, int lineOffset) {
        this.internalReporter.report(null, RhinoErrorReporter.makeError(message, sourceName, line, lineOffset, CheckLevel.WARNING));
    }

    void errorAtLine(String message, String sourceName, int line, int lineOffset) {
        this.internalReporter.report(null, RhinoErrorReporter.makeError(message, sourceName, line, lineOffset, CheckLevel.ERROR));
    }

    protected static @Nullable DiagnosticType mapError(String message) {
        for (Map.Entry entry : typeMap.entrySet()) {
            if (!((Pattern)entry.getKey()).matcher(message).matches()) continue;
            return (DiagnosticType)entry.getValue();
        }
        return null;
    }

    private static JSError makeError(String message, String sourceName, int line, int lineOffset, CheckLevel defaultLevel) {
        DiagnosticType type = RhinoErrorReporter.mapError(message);
        JSError.Builder builder = JSError.builder(type != null ? type : PARSE_ERROR, message).setSourceLocation(sourceName, line, lineOffset);
        if (type == null) {
            builder.setLevel(defaultLevel);
        }
        return builder.build();
    }

    private static class OldRhinoErrorReporter
    extends RhinoErrorReporter
    implements ErrorReporter {
        private OldRhinoErrorReporter(ErrorHandler internalReporter) {
            super(internalReporter);
        }

        @Override
        public void error(String message, String sourceName, int line, int lineOffset) {
            super.errorAtLine(message, sourceName, line, lineOffset);
        }

        @Override
        public void warning(String message, String sourceName, int line, int lineOffset) {
            super.warningAtLine(message, sourceName, line, lineOffset);
        }
    }
}

