/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SynthesizeExplicitConstructors;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jspecify.nullness.Nullable;

public final class RewriteClassMembers
implements NodeTraversal.ScopedCallback,
CompilerPass {
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final SynthesizeExplicitConstructors ctorCreator;
    private final Deque<ClassRecord> classStack;
    private static final String COMP_FIELD_VAR = "$jscomp$compfield$";
    private static final String STATIC_FIELD_NAME = "$jscomp$static$init$";
    private static final String STATIC_BLOCK_NAME = "$jscomp$static$block$";

    public RewriteClassMembers(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.ctorCreator = new SynthesizeExplicitConstructors(compiler);
        this.classStack = new ArrayDeque<ClassRecord>();
    }

    @Override
    public void process(Node externs, Node root) {
        MakeDeclaredNamesUnique renamer = MakeDeclaredNamesUnique.builder().build();
        NodeTraversal.traverseRoots(this.compiler, renamer, externs, root);
        NodeTraversal.traverse(this.compiler, root, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, root, FeatureSet.Feature.PUBLIC_CLASS_FIELDS, FeatureSet.Feature.CLASS_STATIC_BLOCK);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(n);
                return scriptFeatures == null || scriptFeatures.contains(FeatureSet.Feature.PUBLIC_CLASS_FIELDS) || scriptFeatures.contains(FeatureSet.Feature.CLASS_STATIC_BLOCK);
            }
            case CLASS: {
                Node classNameNode = NodeUtil.getNameNode(n);
                Preconditions.checkState((classNameNode != null ? 1 : 0) != 0, (String)"Class missing a name: %s", (Object)n);
                Node classInsertionPoint = this.getStatementDeclaringClass(n, classNameNode);
                Preconditions.checkState((classInsertionPoint != null ? 1 : 0) != 0, (String)"Class was not extracted: %s", (Object)n);
                Preconditions.checkState((n.getFirstChild().isEmpty() || classNameNode.matchesQualifiedName(n.getFirstChild()) ? 1 : 0) != 0, (String)"Class name shadows variable declaring the class: %s", (Object)n);
                this.classStack.push(new ClassRecord(n, classNameNode, classInsertionPoint));
                break;
            }
            case COMPUTED_FIELD_DEF: {
                Preconditions.checkState((!this.classStack.isEmpty() ? 1 : 0) != 0);
                if (NodeUtil.canBeSideEffected(n.getFirstChild())) {
                    this.classStack.peek().computedPropMembers.add(n);
                }
                this.classStack.peek().enterField(n);
                break;
            }
            case MEMBER_FIELD_DEF: {
                Preconditions.checkState((!this.classStack.isEmpty() ? 1 : 0) != 0);
                this.classStack.peek().enterField(n);
                break;
            }
            case BLOCK: {
                if (!NodeUtil.isClassStaticBlock(n)) break;
                Preconditions.checkState((!this.classStack.isEmpty() ? 1 : 0) != 0);
                this.classStack.peek().recordStaticBlock(n);
                break;
            }
            case COMPUTED_PROP: {
                if (!n.getParent().isClassMembers()) break;
                Preconditions.checkState((!this.classStack.isEmpty() ? 1 : 0) != 0);
                if (!NodeUtil.canBeSideEffected(n.getFirstChild())) break;
                this.classStack.peek().computedPropMembers.add(n);
                break;
            }
        }
        return true;
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Node scopeRoot = t.getScopeRoot();
        if (NodeUtil.isFunctionBlock(scopeRoot) && NodeUtil.isEs6Constructor(scopeRoot.getParent())) {
            this.classStack.peek().recordConstructorScope(t.getScope());
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case CLASS: {
                this.visitClass(t, n);
                break;
            }
        }
    }

    private void visitClass(NodeTraversal t, Node classNode) {
        ClassRecord currClassRecord = this.classStack.remove();
        Preconditions.checkState((currClassRecord.classNode == classNode ? 1 : 0) != 0, (String)"unexpected node: %s", (Object)classNode);
        if (currClassRecord.cannotConvert) {
            return;
        }
        this.rewriteSideEffectedComputedProp(t, currClassRecord);
        this.rewriteInstanceMembers(t, currClassRecord);
        this.rewriteStaticMembers(t, currClassRecord);
    }

    private void extractExpressionFromCompField(NodeTraversal t, ClassRecord record, Node memberField) {
        Preconditions.checkArgument((memberField.isComputedFieldDef() || memberField.isComputedProp() ? 1 : 0) != 0, (Object)memberField);
        Node compExpression = memberField.removeFirstChild();
        Node compFieldVar = this.astFactory.createSingleVarNameDeclaration(this.generateUniqueCompFieldVarName(t), compExpression).srcrefTreeIfMissing(record.classNode);
        Node compFieldName = compFieldVar.getFirstChild();
        memberField.addChildToFront(compFieldName.cloneNode());
        compFieldVar.insertBefore(record.insertionPointBeforeClass);
        compFieldVar.srcrefTreeIfMissing(record.classNode);
    }

    private String generateUniqueCompFieldVarName(NodeTraversal t) {
        return COMP_FIELD_VAR + this.compiler.getUniqueIdSupplier().getUniqueId(t.getInput());
    }

    private String generateUniqueStaticMethodName(NodeTraversal t, Node staticMember, boolean isStaticBlock) {
        String prefix = isStaticBlock ? STATIC_BLOCK_NAME : STATIC_FIELD_NAME;
        String uniqueName = prefix + this.compiler.getUniqueIdSupplier().getUniqueId(t.getInput());
        if (staticMember.isMemberFieldDef()) {
            uniqueName = uniqueName + "$" + staticMember.getString();
        }
        return uniqueName;
    }

    private void rewriteSideEffectedComputedProp(NodeTraversal t, ClassRecord record) {
        Deque<Node> computedPropMembers = record.computedPropMembers;
        if (computedPropMembers.isEmpty()) {
            return;
        }
        while (!computedPropMembers.isEmpty()) {
            Node computedPropMember = computedPropMembers.remove();
            this.extractExpressionFromCompField(t, record, computedPropMember);
        }
        t.reportCodeChange();
    }

    private void rewriteInstanceMembers(NodeTraversal t, ClassRecord record) {
        Deque<Node> instanceMembers = record.instanceMembers;
        if (instanceMembers.isEmpty()) {
            return;
        }
        this.ctorCreator.synthesizeClassConstructorIfMissing(t, record.classNode);
        Node ctor = NodeUtil.getEs6ClassConstructorMemberFunctionDef(record.classNode);
        Node ctorBlock = ctor.getFirstChild().getLastChild();
        Node insertionPoint = this.addTemporaryInsertionPoint(ctorBlock);
        while (!instanceMembers.isEmpty()) {
            Node instanceMember = instanceMembers.remove();
            Preconditions.checkState((instanceMember.isMemberFieldDef() || instanceMember.isComputedFieldDef() ? 1 : 0) != 0, (Object)instanceMember);
            Node thisNode = this.astFactory.createThisForEs6ClassMember(instanceMember);
            Node transpiledNode = instanceMember.isMemberFieldDef() ? this.convNonCompFieldToGetProp(thisNode, instanceMember.detach()) : this.convCompFieldToGetElem(thisNode, instanceMember.detach());
            transpiledNode.insertBefore(insertionPoint);
        }
        insertionPoint.detach();
        t.reportCodeChange();
        t.reportCodeChange(ctorBlock);
    }

    private void rewriteStaticMembers(NodeTraversal t, ClassRecord record) {
        Deque<Node> staticMembers = record.staticMembers;
        Node insertionPoint = this.addTemporaryInsertionPointAfterNode(record.insertionPointAfterClass);
        while (!staticMembers.isEmpty()) {
            Node transpiledNode;
            Node staticMember = staticMembers.remove();
            Node nameToUse = record.createNewNameReferenceNode().srcrefTree(staticMember);
            Node staticMethodInsertionPoint = this.addTemporaryInsertionPointAfterNode(staticMember);
            switch (staticMember.getToken()) {
                case BLOCK: {
                    Node blockNode = staticMember.detach();
                    Node callNode = this.convBlockToStaticMethod(t, nameToUse, staticMethodInsertionPoint, blockNode, null, staticMember, true);
                    transpiledNode = this.astFactory.exprResult(callNode).srcrefTreeIfMissing(staticMember);
                    break;
                }
                case MEMBER_FIELD_DEF: {
                    if (!staticMember.hasChildren()) {
                        transpiledNode = this.convStaticMethodToCall(nameToUse, staticMember.detach(), null);
                        break;
                    }
                    Node blockNode = this.createBlockNodeWithReturn(staticMember.removeFirstChild());
                    Node callNode = this.convBlockToStaticMethod(t, nameToUse, staticMethodInsertionPoint, blockNode, blockNode.getJSType(), staticMember, false);
                    transpiledNode = this.convStaticMethodToCall(nameToUse, staticMember.detach(), callNode);
                    break;
                }
                case COMPUTED_FIELD_DEF: {
                    Node callNode;
                    Node blockNode;
                    if (staticMember.hasChildren() && staticMember.getChildCount() > 1) {
                        blockNode = this.createBlockNodeWithReturn(staticMember.getLastChild().detach());
                        callNode = this.convBlockToStaticMethod(t, nameToUse, staticMethodInsertionPoint, blockNode, blockNode.getJSType(), staticMember, false);
                        transpiledNode = this.convStaticMethodToCall(nameToUse, staticMember.detach(), callNode);
                        break;
                    }
                    transpiledNode = this.convStaticMethodToCall(nameToUse, staticMember.detach(), null);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(staticMember));
                }
            }
            staticMethodInsertionPoint.detach();
            transpiledNode.insertBefore(insertionPoint);
            t.reportCodeChange();
        }
        insertionPoint.detach();
    }

    private Node convNonCompFieldToGetProp(Node receiver, Node noncomputedField) {
        Preconditions.checkArgument((boolean)noncomputedField.isMemberFieldDef());
        Preconditions.checkArgument((noncomputedField.getParent() == null ? 1 : 0) != 0, (Object)noncomputedField);
        Preconditions.checkArgument((receiver.getParent() == null ? 1 : 0) != 0, (Object)receiver);
        Node getProp = this.astFactory.createGetProp(receiver, noncomputedField.getString(), AstFactory.type(noncomputedField));
        Node fieldValue = noncomputedField.getFirstChild();
        Node result = fieldValue != null ? this.astFactory.createAssignStatement(getProp, fieldValue.detach()) : this.astFactory.exprResult(getProp);
        result.srcrefTreeIfMissing(noncomputedField);
        return result;
    }

    private Node convStaticMethodToCall(Node receiver, Node staticMember, Node callNode) {
        Preconditions.checkArgument((staticMember.isMemberFieldDef() || staticMember.isComputedFieldDef() ? 1 : 0) != 0);
        Preconditions.checkArgument((staticMember.getParent() == null ? 1 : 0) != 0, (Object)staticMember);
        Preconditions.checkArgument((receiver.getParent() == null ? 1 : 0) != 0, (Object)receiver);
        Node getPropOrElem = staticMember.isMemberFieldDef() ? this.astFactory.createGetProp(receiver, staticMember.getString(), AstFactory.type(staticMember)).srcrefTreeIfMissing(staticMember) : this.astFactory.createGetElem(receiver, staticMember.removeFirstChild());
        Node result = callNode != null ? this.astFactory.createAssignStatement(getPropOrElem, callNode) : this.astFactory.exprResult(getPropOrElem);
        result.srcrefTreeIfMissing(staticMember);
        return result;
    }

    private Node convBlockToStaticMethod(NodeTraversal t, Node receiver, Node insertionPoint, Node blockNode, JSType returnType, Node staticMember, boolean isStaticBlock) {
        Preconditions.checkArgument((boolean)blockNode.isBlock());
        Preconditions.checkArgument((blockNode.getParent() == null ? 1 : 0) != 0, (Object)blockNode);
        Preconditions.checkArgument((receiver.getParent() == null ? 1 : 0) != 0, (Object)receiver);
        Node functionNode = this.astFactory.createZeroArgFunction("", blockNode, returnType).srcrefTreeIfMissing(staticMember);
        this.compiler.reportChangeToChangeScope(functionNode);
        String uniqueStaticMethodName = this.generateUniqueStaticMethodName(t, staticMember, isStaticBlock);
        Node methodNode = this.astFactory.createMemberFunctionDef(uniqueStaticMethodName, functionNode).srcrefTreeIfMissing(staticMember);
        methodNode.setStaticMember(true);
        methodNode.insertBefore(insertionPoint);
        this.compiler.reportChangeToEnclosingScope(methodNode);
        Node getPropNode = this.astFactory.createGetProp(receiver.cloneTree(), methodNode.getString(), AstFactory.type(methodNode)).srcrefTreeIfMissing(staticMember);
        return this.astFactory.createCall(getPropNode, AstFactory.type(methodNode.getFirstChild()), new Node[0]);
    }

    private Node convCompFieldToGetElem(Node receiver, Node computedField) {
        Preconditions.checkArgument((boolean)computedField.isComputedFieldDef(), (Object)computedField);
        Preconditions.checkArgument((computedField.getParent() == null ? 1 : 0) != 0, (Object)computedField);
        Preconditions.checkArgument((receiver.getParent() == null ? 1 : 0) != 0, (Object)receiver);
        Node getElem = this.astFactory.createGetElem(receiver, computedField.removeFirstChild());
        Node fieldValue = computedField.getLastChild();
        Node result = fieldValue != null ? this.astFactory.createAssignStatement(getElem, fieldValue.detach()) : this.astFactory.exprResult(getElem);
        result.srcrefTreeIfMissing(computedField);
        return result;
    }

    private Node createBlockNodeWithReturn(Node returnValue) {
        Node returnNode = this.astFactory.createReturn(returnValue);
        return this.astFactory.createBlock(returnNode);
    }

    private Node addTemporaryInsertionPoint(Node ctorBlock) {
        Node tempNode = IR.empty();
        for (Node stmt = ctorBlock.getFirstChild(); stmt != null; stmt = stmt.getNext()) {
            if (!NodeUtil.isExprCall(stmt) || !stmt.getFirstFirstChild().isSuper()) continue;
            tempNode.insertAfter(stmt);
            return tempNode;
        }
        ctorBlock.addChildToFront(tempNode);
        return tempNode;
    }

    private Node addTemporaryInsertionPointAfterNode(Node node) {
        Node tempNode = IR.empty();
        tempNode.insertAfter(node);
        return tempNode;
    }

    private @Nullable Node getStatementDeclaringClass(Node classNode, Node classNameNode) {
        if (NodeUtil.isClassDeclaration(classNode)) {
            Preconditions.checkState((boolean)NodeUtil.isStatement(classNode));
            return classNode;
        }
        Node parent = classNode.getParent();
        if (parent.isName()) {
            Preconditions.checkState((parent == classNameNode ? 1 : 0) != 0);
            Preconditions.checkState((boolean)NodeUtil.isStatement(classNameNode.getParent()));
            return classNameNode.getParent();
        }
        if (parent.isAssign() && parent.getFirstChild() == classNameNode && parent.getParent().isExprResult()) {
            Preconditions.checkState((boolean)NodeUtil.isStatement(classNameNode.getGrandparent()));
            return classNameNode.getGrandparent();
        }
        return null;
    }

    private static final class ClassRecord {
        boolean cannotConvert;
        final Deque<Node> instanceMembers = new ArrayDeque<Node>();
        final Deque<Node> staticMembers = new ArrayDeque<Node>();
        final Deque<Node> computedPropMembers = new ArrayDeque<Node>();
        ImmutableSet<Var> constructorVars = ImmutableSet.of();
        final Node classNode;
        final Node classNameNode;
        final Node insertionPointBeforeClass;
        final Node insertionPointAfterClass;

        ClassRecord(Node classNode, Node classNameNode, Node classInsertionPoint) {
            this.classNode = classNode;
            this.classNameNode = classNameNode;
            this.insertionPointBeforeClass = classInsertionPoint;
            this.insertionPointAfterClass = classInsertionPoint;
        }

        void enterField(Node field) {
            Preconditions.checkArgument((field.isComputedFieldDef() || field.isMemberFieldDef() ? 1 : 0) != 0);
            if (field.isStaticMember()) {
                this.staticMembers.add(field);
            } else {
                this.instanceMembers.add(field);
            }
        }

        void recordStaticBlock(Node block) {
            Preconditions.checkArgument((boolean)NodeUtil.isClassStaticBlock(block));
            this.staticMembers.add(block);
        }

        void recordConstructorScope(Scope s) {
            Preconditions.checkArgument((boolean)s.isFunctionBlockScope(), (Object)s);
            Preconditions.checkState((boolean)this.constructorVars.isEmpty(), this.constructorVars);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(s.getAllSymbols());
            Scope argsScope = s.getParent();
            builder.addAll(argsScope.getAllSymbols());
            this.constructorVars = builder.build();
        }

        Node createNewNameReferenceNode() {
            if (this.classNameNode.isName()) {
                return this.classNameNode.cloneNode();
            }
            return this.classNameNode.cloneTree();
        }
    }
}

