/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.BasicBlock;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.Scope;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

public final class ReferenceCollection
implements Iterable<Reference>,
Serializable {
    List<Reference> references = new ArrayList<Reference>();

    @Override
    public Iterator<Reference> iterator() {
        return this.references.iterator();
    }

    void add(Reference reference) {
        this.references.add(reference);
    }

    boolean isWellDefined() {
        int size = this.references.size();
        if (size == 0) {
            return false;
        }
        Reference init = this.getInitializingReference();
        if (init == null) {
            return false;
        }
        Preconditions.checkState((boolean)this.references.get(0).isDeclaration());
        BasicBlock initBlock = init.getBasicBlock();
        for (int i = 1; i < size; ++i) {
            if (initBlock.provablyExecutesBefore(this.references.get(i).getBasicBlock())) continue;
            return false;
        }
        return true;
    }

    boolean isEscaped() {
        Scope hoistScope = null;
        for (Reference ref : this.references) {
            if (hoistScope == null) {
                hoistScope = (Scope)ref.getScope().getClosestHoistScope();
                continue;
            }
            if (hoistScope == ref.getScope().getClosestHoistScope()) continue;
            return true;
        }
        return false;
    }

    private boolean isInitializingDeclarationAt(int index) {
        Reference maybeInit = this.references.get(index);
        return maybeInit.isInitializingDeclaration();
    }

    private boolean isInitializingAssignmentAt(int index) {
        Reference maybeDecl;
        if (index < this.references.size() && index > 0 && ((maybeDecl = this.references.get(index - 1)).isVarDeclaration() || maybeDecl.isLetDeclaration())) {
            Preconditions.checkState((!maybeDecl.isInitializingDeclaration() ? 1 : 0) != 0);
            Reference maybeInit = this.references.get(index);
            if (maybeInit.isSimpleAssignmentToName()) {
                return true;
            }
        }
        return false;
    }

    @Nullable Reference getInitializingReference() {
        if (this.isInitializingDeclarationAt(0)) {
            return this.references.get(0);
        }
        if (this.isInitializingAssignmentAt(1) && this.areInSameFile(0, 1)) {
            return this.references.get(1);
        }
        return null;
    }

    private boolean areInSameFile(int ref0, int ref1) {
        return Objects.equals(this.references.get(ref0).getInputId(), this.references.get(ref1).getInputId());
    }

    @Nullable Reference getInitializingReferenceForConstants() {
        int size = this.references.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isInitializingDeclarationAt(i) && !this.isInitializingAssignmentAt(i)) continue;
            return this.references.get(i);
        }
        return null;
    }

    boolean isAssignedOnceInLifetime() {
        Reference ref = this.getOneAndOnlyAssignment();
        if (ref == null) {
            return false;
        }
        for (BasicBlock block = ref.getBasicBlock(); block != null; block = block.getParent()) {
            if (block.isFunction()) {
                if (((Scope)ref.getSymbol().getScope()).getClosestHoistScope() == ref.getScope().getClosestHoistScope()) break;
                return false;
            }
            if (!block.isLoop()) continue;
            return false;
        }
        return true;
    }

    @Nullable Reference getOneAndOnlyAssignment() {
        Reference assignment = null;
        int size = this.references.size();
        for (int i = 0; i < size; ++i) {
            Reference ref = this.references.get(i);
            if (!ref.isLvalue() && !ref.isInitializingDeclaration()) continue;
            if (assignment == null) {
                assignment = ref;
                continue;
            }
            return null;
        }
        return assignment;
    }

    boolean isNeverAssigned() {
        int size = this.references.size();
        for (int i = 0; i < size; ++i) {
            Reference ref = this.references.get(i);
            if (!ref.isLvalue() && !ref.isInitializingDeclaration()) continue;
            return false;
        }
        return true;
    }

    boolean firstReferenceIsAssigningDeclaration() {
        int size = this.references.size();
        return size > 0 && this.references.get(0).isInitializingDeclaration();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("initRef", (Object)this.getInitializingReference()).add("references", this.references).add("wellDefined", this.isWellDefined()).add("assignedOnce", this.isAssignedOnceInLifetime()).toString();
    }
}

