/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CompilerInputProvider;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.rhino.HamtPMap;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.PMap;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.StaticTypedRef;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import org.jspecify.nullness.Nullable;

class LinkedFlowScope
implements FlowScope {
    private final CompilerInputProvider inputProvider;
    private final PMap<TypedScope, OverlayScope> scopes;
    private final TypedScope functionScope;
    private final TypedScope syntacticScope;
    private static final PMap<String, OverlaySlot> EMPTY_SLOTS = HamtPMap.empty();

    private LinkedFlowScope(CompilerInputProvider inputProvider, PMap<TypedScope, OverlayScope> scopes, TypedScope syntacticScope, TypedScope functionScope) {
        this.inputProvider = inputProvider;
        this.scopes = scopes;
        this.syntacticScope = syntacticScope;
        this.functionScope = functionScope;
    }

    private PMap<TypedScope, OverlayScope> trimScopes(TypedScope scope) {
        int thatDepth;
        TypedScope thisScope = this.syntacticScope;
        TypedScope thatScope = scope;
        int thisDepth = thisScope.getDepth();
        PMap<TypedScope, OverlayScope> result = this.scopes;
        for (thatDepth = thatScope.getDepth(); thatDepth > thisDepth; --thatDepth) {
            thatScope = thatScope.getParent();
        }
        while (thisDepth > thatDepth) {
            result = result.minus(thisScope);
            thisScope = thisScope.getParent();
            --thisDepth;
        }
        while (thisScope != thatScope && thisScope != null && thatScope != null) {
            result = result.minus(thisScope);
            thisScope = thisScope.getParent();
            thatScope = thatScope.getParent();
        }
        return result;
    }

    private boolean flowsFromBottom() {
        return this.functionScope.isBottom();
    }

    public static LinkedFlowScope createEntryLattice(CompilerInputProvider inputProvider, TypedScope scope) {
        return new LinkedFlowScope(inputProvider, HamtPMap.empty(), scope, scope);
    }

    @Override
    public LinkedFlowScope inferSlotType(String symbol, JSType type) {
        OverlayScope scope = this.getOverlayScopeForName(symbol, true);
        OverlayScope newScope = scope.infer(symbol, type);
        PMap<TypedScope, OverlayScope> newScopes = !newScope.slots.isEmpty() ? this.scopes.plus(scope.scope, newScope) : this.scopes.minus(scope.scope);
        return newScopes != this.scopes ? new LinkedFlowScope(this.inputProvider, newScopes, this.syntacticScope, this.functionScope) : this;
    }

    @Override
    public LinkedFlowScope inferQualifiedSlot(Node node, String symbol, JSType bottomType, JSType inferredType, boolean declared) {
        JSType declaredType;
        if (this.functionScope.isGlobal()) {
            return this;
        }
        TypedVar v = this.syntacticScope.getVar(symbol);
        if (v == null && !this.functionScope.isBottom()) {
            TypedVar rootVar = this.syntacticScope.getVar(LinkedFlowScope.getRootOfQualifiedName(symbol));
            TypedScope rootScope = rootVar != null ? (TypedScope)rootVar.getScope() : (TypedScope)this.syntacticScope.getGlobalScope();
            v = rootScope.declare(symbol, node, bottomType, this.inputProvider.getInput(NodeUtil.getInputId(node)), !declared);
        }
        JSType jSType = declaredType = v != null ? v.getType() : null;
        if (v != null) {
            if (!v.isTypeInferred()) {
                if (declaredType == null || !inferredType.isSubtypeOf(declaredType) || declaredType.isSubtypeOf(inferredType) || inferredType.equals(declaredType)) {
                    return this;
                }
            } else if (declaredType != null && !inferredType.isSubtypeOf(declaredType)) {
                v.setType(v.getType().getLeastSupertype(inferredType));
            }
        }
        return this.inferSlotType(symbol, inferredType);
    }

    @Override
    public JSType getTypeOfThis() {
        return this.syntacticScope.getTypeOfThis();
    }

    @Override
    public Node getRootNode() {
        return this.syntacticScope.getRootNode();
    }

    @Override
    public StaticTypedScope getParentScope() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StaticTypedSlot getSlot(String name) {
        TypedVar var = this.syntacticScope.getVar(name);
        OverlayScope scope = var == null ? this.getOverlayScopeForName(name, false) : this.getOverlayScopeForScope((TypedScope)var.getScope(), false);
        return scope != null ? scope.getSlot(name) : var;
    }

    private static String getRootOfQualifiedName(String name) {
        int index = name.indexOf(46);
        return index < 0 ? name : name.substring(0, index);
    }

    private OverlayScope getOverlayScopeForName(String name, boolean create) {
        TypedVar rootVar = this.syntacticScope.getVar(LinkedFlowScope.getRootOfQualifiedName(name));
        TypedScope scope = rootVar != null ? (TypedScope)rootVar.getScope() : null;
        scope = scope != null ? scope : this.functionScope;
        return this.getOverlayScopeForScope(scope, create);
    }

    private OverlayScope getOverlayScopeForScope(TypedScope scope, boolean create) {
        OverlayScope overlay = this.scopes.get(scope);
        if (overlay == null && create) {
            overlay = new OverlayScope(scope);
        }
        return overlay;
    }

    @Override
    public StaticTypedSlot getOwnSlot(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FlowScope withSyntacticScope(StaticTypedScope scope) {
        TypedScope typedScope = (TypedScope)scope;
        return scope != this.syntacticScope ? new LinkedFlowScope(this.inputProvider, this.trimScopes(typedScope), typedScope, this.functionScope) : this;
    }

    @Override
    public TypedScope getDeclarationScope() {
        return this.syntacticScope;
    }

    static TypedScope getCommonParentDeclarationScope(LinkedFlowScope left, LinkedFlowScope right) {
        if (left.flowsFromBottom()) {
            return right.syntacticScope;
        }
        if (right.flowsFromBottom()) {
            return left.syntacticScope;
        }
        return left.syntacticScope.getCommonParent(right.syntacticScope);
    }

    public boolean equals(Object other) {
        if (!(other instanceof LinkedFlowScope)) {
            return false;
        }
        LinkedFlowScope that = (LinkedFlowScope)other;
        return this.functionScope == that.functionScope && this.scopes.equivalent(that.scopes, LinkedFlowScope::equalScopes);
    }

    private static boolean equalScopes(OverlayScope left, OverlayScope right) {
        if (left == right) {
            return true;
        }
        return left.slots.equivalent(right.slots, LinkedFlowScope::equalSlots);
    }

    private static boolean equalSlots(StaticTypedSlot slotA, StaticTypedSlot slotB) {
        return slotA == slotB || !slotA.getType().differsFrom(slotB.getType());
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    private static PMap<TypedScope, OverlayScope> join(LinkedFlowScope linkedA, LinkedFlowScope linkedB, TypedScope commonParent) {
        return linkedA.trimScopes(commonParent).reconcile(linkedB.trimScopes(commonParent), (scopeKey, scopeA, scopeB) -> {
            TypedScope bestScope;
            TypedScope typedScopeA;
            PMap<String, OverlaySlot> slotsB;
            PMap<String, OverlaySlot> slotsA = scopeA != null ? scopeA.slots : EMPTY_SLOTS;
            PMap<String, OverlaySlot> pMap = slotsB = scopeB != null ? scopeB.slots : EMPTY_SLOTS;
            TypedScope typedScope = linkedA.flowsFromBottom() ? null : (typedScopeA = scopeA != null ? scopeA.scope : scopeB.scope);
            TypedScope typedScopeB = linkedB.flowsFromBottom() ? null : (scopeB != null ? scopeB.scope : scopeA.scope);
            TypedScope typedScope2 = bestScope = typedScopeA != null ? typedScopeA : typedScopeB;
            bestScope = bestScope != null ? bestScope : (scopeA != null ? scopeA.scope : scopeB.scope);
            return new OverlayScope(bestScope, slotsA.reconcile(slotsB, (slotKey, slotA, slotB) -> {
                String name;
                String string = name = slotA != null ? slotA.getName() : slotB.getName();
                if (slotB == null || slotB.getType() == null) {
                    JSType fnSlotType;
                    TypedVar fnSlot = typedScopeB != null ? (TypedVar)typedScopeB.getSlot(name) : null;
                    JSType jSType = fnSlotType = fnSlot != null ? fnSlot.getType() : null;
                    if (fnSlotType == null || JSCompObjects.identical(fnSlotType, slotA.getType())) {
                        return slotA;
                    }
                    JSType joinedType = slotA.getType().getLeastSupertype(fnSlotType);
                    return JSCompObjects.identical(joinedType, slotA.getType()) ? slotA : new OverlaySlot(name, joinedType);
                }
                if (slotA == null || slotA.getType() == null) {
                    JSType fnSlotType;
                    TypedVar fnSlot = typedScopeA != null ? (TypedVar)typedScopeA.getSlot(name) : null;
                    JSType jSType = fnSlotType = fnSlot != null ? fnSlot.getType() : null;
                    if (fnSlotType == null || JSCompObjects.identical(fnSlotType, slotB.getType())) {
                        return slotB;
                    }
                    JSType joinedType = slotB.getType().getLeastSupertype(fnSlotType);
                    return JSCompObjects.identical(joinedType, slotB.getType()) ? slotB : new OverlaySlot(name, joinedType);
                }
                if (JSCompObjects.identical(slotA.getType(), slotB.getType())) {
                    return slotA;
                }
                JSType joinedType = slotA.getType().getLeastSupertype(slotB.getType());
                return JSCompObjects.identical(joinedType, slotA.getType()) ? slotA : new OverlaySlot(name, joinedType);
            }));
        });
    }

    private static class OverlayScope {
        final TypedScope scope;
        final PMap<String, OverlaySlot> slots;

        OverlayScope(TypedScope scope) {
            this.scope = (TypedScope)Preconditions.checkNotNull((Object)scope);
            this.slots = EMPTY_SLOTS;
        }

        OverlayScope(TypedScope scope, PMap<String, OverlaySlot> slots) {
            this.scope = (TypedScope)Preconditions.checkNotNull((Object)scope);
            this.slots = slots;
        }

        OverlayScope infer(String name, JSType type) {
            OverlaySlot slot = this.slots.get(name);
            if (slot != null && JSCompObjects.identical(type, slot.type)) {
                return this;
            }
            return new OverlayScope(this.scope, this.slots.plus(name, new OverlaySlot(name, type)));
        }

        StaticTypedSlot getSlot(String name) {
            OverlaySlot slot = this.slots.get(name);
            return slot != null ? slot : (StaticTypedSlot)this.scope.getSlot(name);
        }
    }

    private static class OverlaySlot
    implements StaticTypedSlot {
        final String name;
        final JSType type;

        OverlaySlot(String name, JSType type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public JSType getType() {
            return this.type;
        }

        @Override
        public boolean isTypeInferred() {
            return true;
        }

        @Override
        public StaticTypedRef getDeclaration() {
            return null;
        }

        @Override
        public JSDocInfo getJSDocInfo() {
            return null;
        }

        @Override
        public StaticTypedScope getScope() {
            throw new UnsupportedOperationException();
        }
    }

    static class FlowScopeJoinOp
    implements DataFlowAnalysis.FlowJoiner<FlowScope> {
        @Nullable LinkedFlowScope result = null;
        final CompilerInputProvider inputProvider;

        FlowScopeJoinOp(CompilerInputProvider inputProvider) {
            this.inputProvider = inputProvider;
        }

        @Override
        public void joinFlow(FlowScope input) {
            LinkedFlowScope linkedInput = (LinkedFlowScope)input;
            if (this.result == null) {
                this.result = linkedInput;
                return;
            }
            if (this.result.scopes == linkedInput.scopes && this.result.functionScope == linkedInput.functionScope) {
                return;
            }
            TypedScope common = LinkedFlowScope.getCommonParentDeclarationScope(this.result, linkedInput);
            this.result = new LinkedFlowScope(this.inputProvider, LinkedFlowScope.join(this.result, linkedInput, common), common, this.result.flowsFromBottom() ? linkedInput.functionScope : this.result.functionScope);
        }

        @Override
        public FlowScope finish() {
            return this.result;
        }
    }
}

