/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.InvocationsCallback;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.nullness.Nullable;

class InlineSimpleMethods
implements CompilerPass {
    private final Set<String> nonInlineableProperties = new LinkedHashSet<String>();
    private final SetMultimap<String, Node> methodDefinitions = LinkedHashMultimap.create();
    private final AbstractCompiler compiler;
    private final AstAnalyzer astAnalyzer;

    InlineSimpleMethods(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astAnalyzer = compiler.getAstAnalyzer();
        this.nonInlineableProperties.addAll((Collection<String>)compiler.getExternProperties());
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized(), (Object)this.compiler.getLifeCycleStage());
        Preconditions.checkState((boolean)this.methodDefinitions.isEmpty());
        Preconditions.checkState((externs != null ? 1 : 0) != 0);
        NodeTraversal.traverseRoots(this.compiler, new GatherSignatures(), externs, root);
        NodeTraversal.traverse(this.compiler, root, new InlineTrivialAccessors());
    }

    private static boolean isPropertyTree(Node expectedGetprop) {
        if (!expectedGetprop.isGetProp()) {
            return false;
        }
        Node getpropLhs = expectedGetprop.getFirstChild();
        return getpropLhs.isThis() || InlineSimpleMethods.isPropertyTree(getpropLhs);
    }

    private static void replaceThis(Node expectedGetprop, Node replacement) {
        Node leftChild = expectedGetprop.getFirstChild();
        if (leftChild.isThis()) {
            leftChild.replaceWith(replacement);
        } else {
            InlineSimpleMethods.replaceThis(leftChild, replacement);
        }
    }

    private static @Nullable Node returnedExpression(Node fn) {
        Node expectedBlock = NodeUtil.getFunctionBody(fn);
        if (!expectedBlock.hasOneChild()) {
            return null;
        }
        Node expectedReturn = expectedBlock.getFirstChild();
        if (!expectedReturn.isReturn()) {
            return null;
        }
        if (!expectedReturn.hasOneChild()) {
            return null;
        }
        return expectedReturn.getOnlyChild();
    }

    private static boolean isEmptyMethod(Node fn) {
        return NodeUtil.isEmptyBlock(NodeUtil.getFunctionBody(fn));
    }

    private boolean allDefinitionsEquivalent(Set<Node> definitions) {
        Node first = null;
        for (Node n : definitions) {
            if (first == null) {
                first = n;
                continue;
            }
            if (this.compiler.areNodesEqualForInlining(first, n)) continue;
            return false;
        }
        return true;
    }

    private boolean anyDefinitionsNoInline(Set<Node> definitions) {
        for (Node n : definitions) {
            JSDocInfo jsDocInfo = NodeUtil.getBestJSDocInfo(n.getParent());
            if (jsDocInfo == null || !jsDocInfo.isNoInline()) continue;
            return true;
        }
        return false;
    }

    private void inlinePropertyReturn(Node call, Node returnedValue) {
        Node getProp = returnedValue.cloneTree();
        InlineSimpleMethods.replaceThis(getProp, call.getFirstChild().removeFirstChild());
        call.replaceWith(getProp);
        this.compiler.reportChangeToEnclosingScope(getProp);
    }

    private void inlineConstReturn(Node call, Node returnedValue) {
        Node retValue = returnedValue.cloneTree();
        call.replaceWith(retValue);
        this.compiler.reportChangeToEnclosingScope(retValue);
    }

    private void inlineEmptyMethod(NodeTraversal t, Node parent, Node call) {
        if (NodeUtil.isExprCall(parent)) {
            parent.replaceWith(IR.empty());
            NodeUtil.markFunctionsDeleted(parent, this.compiler);
        } else {
            Node srcLocation = call;
            call.replaceWith(NodeUtil.newUndefinedNode(srcLocation));
            NodeUtil.markFunctionsDeleted(call, this.compiler);
        }
        t.reportCodeChange();
    }

    private boolean argsMayHaveSideEffects(Node call) {
        for (Node currentChild = call.getSecondChild(); currentChild != null; currentChild = currentChild.getNext()) {
            if (!this.astAnalyzer.mayHaveSideEffects(currentChild)) continue;
            return true;
        }
        return false;
    }

    private void addPossibleSignature(String name, Node node) {
        if (node != null && node.isFunction()) {
            this.addSignature(name, node);
        } else {
            this.nonInlineableProperties.add(name);
        }
    }

    private void addSignature(String name, Node function) {
        if (this.nonInlineableProperties.contains(name)) {
            return;
        }
        this.methodDefinitions.put((Object)name, (Object)function);
    }

    private static @Nullable String getPropName(Node getPropElem) {
        if (getPropElem.isGetProp()) {
            return getPropElem.getString();
        }
        if (getPropElem.getSecondChild().isStringLit()) {
            return getPropElem.getSecondChild().getString();
        }
        return null;
    }

    private class GatherSignatures
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherSignatures() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case GETPROP: 
                case GETELEM: {
                    String name = InlineSimpleMethods.getPropName(n);
                    if (name == null) {
                        return;
                    }
                    if (name.equals("prototype")) {
                        this.processPrototypeParent(parent);
                        break;
                    }
                    if (!parent.isAssign() || !n.isFirstChildOf(parent)) break;
                    InlineSimpleMethods.this.addPossibleSignature(name, n.getNext());
                    break;
                }
                case OBJECTLIT: 
                case CLASS_MEMBERS: {
                    block10: for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                        switch (key.getToken()) {
                            case MEMBER_FUNCTION_DEF: 
                            case MEMBER_FIELD_DEF: 
                            case STRING_KEY: {
                                InlineSimpleMethods.this.addPossibleSignature(key.getString(), key.getFirstChild());
                                continue block10;
                            }
                            case SETTER_DEF: 
                            case GETTER_DEF: {
                                InlineSimpleMethods.this.nonInlineableProperties.add(key.getString());
                                continue block10;
                            }
                            case COMPUTED_PROP: 
                            case OBJECT_SPREAD: 
                            case COMPUTED_FIELD_DEF: {
                                continue block10;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected " + n.getToken() + " key: " + key);
                            }
                        }
                    }
                    break;
                }
                case CALL: {
                    if (!InlineSimpleMethods.this.compiler.getCodingConvention().isPropertyRenameFunction(n.getFirstChild())) break;
                    InlineSimpleMethods.this.nonInlineableProperties.add(n.getSecondChild().getString());
                    break;
                }
            }
        }

        private void processPrototypeParent(Node n) {
            switch (n.getToken()) {
                case GETPROP: 
                case GETELEM: {
                    Node grandparent = n.getGrandparent();
                    String name = InlineSimpleMethods.getPropName(n);
                    if (name == null || !grandparent.isAssign()) break;
                    Node assignee = grandparent.getSecondChild();
                    InlineSimpleMethods.this.addPossibleSignature(name, assignee);
                    break;
                }
            }
        }
    }

    private class InlineTrivialAccessors
    extends InvocationsCallback {
        private InlineTrivialAccessors() {
        }

        @Override
        void visit(NodeTraversal t, Node callNode, Node parent, String callName) {
            if (InlineSimpleMethods.this.nonInlineableProperties.contains(callName)) {
                return;
            }
            Set definitions = InlineSimpleMethods.this.methodDefinitions.get((Object)callName);
            if (definitions == null || definitions.isEmpty()) {
                return;
            }
            if (definitions.size() > 1 && !InlineSimpleMethods.this.allDefinitionsEquivalent(definitions)) {
                InlineSimpleMethods.this.nonInlineableProperties.add(callName);
                return;
            }
            if (InlineSimpleMethods.this.anyDefinitionsNoInline(definitions)) {
                InlineSimpleMethods.this.nonInlineableProperties.add(callName);
                return;
            }
            Node firstDefinition = (Node)definitions.iterator().next();
            if (!InlineSimpleMethods.this.argsMayHaveSideEffects(callNode) && !NodeUtil.referencesSuper(callNode)) {
                Node returned = InlineSimpleMethods.returnedExpression(firstDefinition);
                if (returned != null) {
                    if (InlineSimpleMethods.isPropertyTree(returned) && !firstDefinition.isArrowFunction()) {
                        InlineSimpleMethods.this.inlinePropertyReturn(callNode, returned);
                    } else if (NodeUtil.isLiteralValue(returned, false) && !InlineSimpleMethods.this.astAnalyzer.mayHaveSideEffects(callNode.getFirstChild())) {
                        InlineSimpleMethods.this.inlineConstReturn(callNode, returned);
                    }
                } else if (InlineSimpleMethods.isEmptyMethod(firstDefinition) && !InlineSimpleMethods.this.astAnalyzer.mayHaveSideEffects(callNode.getFirstChild())) {
                    InlineSimpleMethods.this.inlineEmptyMethod(t, parent, callNode);
                }
            }
        }
    }
}

