/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.deps.ModuleNames;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jspecify.nullness.Nullable;

public final class Es6ExtractClasses
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final String CLASS_DECL_VAR = "$classdecl$var";
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final ExpressionDecomposer expressionDecomposer;
    private int classDeclVarCounter = 0;

    Es6ExtractClasses(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.expressionDecomposer = compiler.createDefaultExpressionDecomposer();
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.compiler.getAllowableFeatures().contains(FeatureSet.Feature.ARROW_FUNCTIONS)) {
            NodeTraversal.traverse(this.compiler, root, new NormalizeArrows());
        }
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        NodeTraversal.traverseRoots(this.compiler, new SelfReferenceRewriter(), externs, root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isClass() && this.shouldExtractClass(n)) {
            this.extractClass(t, n);
        }
    }

    private boolean shouldExtractClass(Node classNode) {
        Node parent = classNode.getParent();
        boolean isAnonymous = classNode.getFirstChild().isEmpty();
        if (NodeUtil.isClassDeclaration(classNode) || isAnonymous && parent.isName() || isAnonymous && parent.isAssign() && parent.getFirstChild().isQualifiedName() && parent.getParent().isExprResult()) {
            return false;
        }
        if (this.expressionDecomposer.canExposeExpression(classNode) == ExpressionDecomposer.DecompositionType.UNDECOMPOSABLE) {
            this.wrapClassDefInsideIIFE(classNode, parent);
        }
        return true;
    }

    private void wrapClassDefInsideIIFE(Node n, Node parent) {
        Preconditions.checkState((boolean)n.isClass());
        Node returnBlock = this.astFactory.createBlock(this.astFactory.createReturn(n.detach())).srcref(n);
        Node arrowFn = IR.arrowFunction(IR.name(""), IR.paramList(new Node[0]), returnBlock).srcref(n);
        arrowFn.setColor(StandardColors.UNKNOWN);
        Node iife = this.astFactory.createCallWithUnknownType(arrowFn, new Node[0]).srcrefTreeIfMissing(n);
        parent.addChildToBack(iife);
        NodeUtil.addFeatureToScript(NodeUtil.getEnclosingScript(n), FeatureSet.Feature.ARROW_FUNCTIONS, this.compiler);
        this.compiler.reportChangeToEnclosingScope(iife);
    }

    private void extractClass(NodeTraversal t, Node classNode) {
        Node expr;
        if (this.expressionDecomposer.canExposeExpression(classNode) == ExpressionDecomposer.DecompositionType.DECOMPOSABLE) {
            this.expressionDecomposer.maybeExposeExpression(classNode);
        }
        Node parent = classNode.getParent();
        String name = ModuleNames.fileToJsIdentifier(classNode.getStaticSourceFile().getName()) + CLASS_DECL_VAR + this.classDeclVarCounter++;
        JSDocInfo info = NodeUtil.getBestJSDocInfo(classNode);
        Node statement = NodeUtil.getEnclosingStatement(parent);
        Node classNameLhs = this.astFactory.createConstantName(name, AstFactory.type(classNode));
        Node classNameRhs = classNameLhs.cloneTree();
        classNode.replaceWith(classNameRhs);
        Node classDeclaration = IR.constNode(classNameLhs, classNode).srcrefTreeIfMissing(classNode);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        classDeclaration.setJSDocInfo(JSDocInfo.Builder.maybeCopyFrom(info).build());
        classDeclaration.insertBefore(statement);
        if (NodeUtil.isNameDeclaration(statement) && statement.hasOneChild() && statement.getOnlyChild() == parent) {
            this.addAtConstructor(statement);
        } else if (statement.isExprResult() && (expr = statement.getOnlyChild()).isAssign() && expr.getFirstChild().isQualifiedName() && expr.getSecondChild() == classNameRhs) {
            this.addAtConstructor(expr);
        }
        this.compiler.reportChangeToEnclosingScope(classDeclaration);
    }

    private void addAtConstructor(Node node) {
        JSDocInfo.Builder builder = JSDocInfo.Builder.maybeCopyFrom(node.getJSDocInfo());
        builder.recordConstructor();
        node.setJSDocInfo(builder.build());
    }

    private final class NormalizeArrows
    extends NodeTraversal.AbstractPostOrderCallback {
        private NormalizeArrows() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, @Nullable Node parent) {
            switch (n.getToken()) {
                case FUNCTION: {
                    this.visitFunction(n);
                    break;
                }
            }
        }

        void visitFunction(Node n) {
            Preconditions.checkState((boolean)n.isFunction(), (Object)n);
            if (n.isFunction() && !NodeUtil.getFunctionBody(n).isBlock()) {
                Node returnValue = NodeUtil.getFunctionBody(n);
                Node body = IR.block(IR.returnNode(returnValue.detach()));
                body.srcrefTreeIfMissing(returnValue);
                n.addChildToBack(body);
                Es6ExtractClasses.this.compiler.reportChangeToEnclosingScope(body);
            }
        }
    }

    private class SelfReferenceRewriter
    implements NodeTraversal.Callback {
        private final Deque<ClassDescription> classStack = new ArrayDeque<ClassDescription>();

        private SelfReferenceRewriter() {
        }

        private boolean needsInnerNameRewriting(Node classNode, Node parent) {
            Preconditions.checkArgument((boolean)classNode.isClass());
            return classNode.getFirstChild().isName() && parent.isName();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isClass() && this.needsInnerNameRewriting(n, parent)) {
                this.classStack.addFirst(new ClassDescription(n.getFirstChild(), parent.getString()));
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CLASS: {
                    if (!this.needsInnerNameRewriting(n, parent)) break;
                    this.classStack.removeFirst();
                    n.getFirstChild().replaceWith(IR.empty().srcref(n.getFirstChild()));
                    Es6ExtractClasses.this.compiler.reportChangeToEnclosingScope(n);
                    break;
                }
                case NAME: {
                    this.maybeUpdateClassSelfRef(t, n);
                    break;
                }
            }
        }

        private void maybeUpdateClassSelfRef(NodeTraversal t, Node nameNode) {
            for (ClassDescription klass : this.classStack) {
                Var var;
                if (nameNode == klass.nameNode || !nameNode.matchesQualifiedName(klass.nameNode) || (var = (Var)t.getScope().getVar(nameNode.getString())) == null || var.getNameNode() != klass.nameNode) continue;
                Node newNameNode = Es6ExtractClasses.this.astFactory.createName(klass.outerName, AstFactory.type(nameNode)).srcref(nameNode);
                nameNode.replaceWith(newNameNode);
                Es6ExtractClasses.this.compiler.reportChangeToEnclosingScope(newNameNode);
                return;
            }
        }

        private class ClassDescription {
            final Node nameNode;
            final String outerName;

            ClassDescription(Node nameNode, String outerName) {
                this.nameNode = nameNode;
                this.outerName = outerName;
            }
        }
    }
}

