/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CrossChunkReferenceCollector;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

class CrossChunkCodeMotion
implements CompilerPass {
    private @Nullable LogFile cccmLog;
    private final AbstractCompiler compiler;
    private final JSChunkGraph graph;
    private final Map<JSChunk, Node> moduleInsertionPointMap = new LinkedHashMap<JSChunk, Node>();
    private final boolean parentModuleCanSeeSymbolsDeclaredInChildren;

    CrossChunkCodeMotion(AbstractCompiler compiler, JSChunkGraph graph, boolean parentModuleCanSeeSymbolsDeclaredInChildren) {
        this.compiler = compiler;
        this.graph = graph;
        this.parentModuleCanSeeSymbolsDeclaredInChildren = parentModuleCanSeeSymbolsDeclaredInChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Node externs, Node root) {
        try (LogFile logFile = this.compiler.createOrReopenIndexedLog(this.getClass(), "cccm.log", new String[0]);){
            this.cccmLog = logFile;
            this.cccmLog.log("doing cccm");
            if (this.graph.getChunkCount() > 1) {
                CrossChunkReferenceCollector referenceCollector = new CrossChunkReferenceCollector(this.compiler, new SyntacticScopeCreator(this.compiler));
                referenceCollector.process(root);
                Collection<GlobalSymbol> globalSymbols = new GlobalSymbolCollector().collectGlobalSymbols(referenceCollector);
                this.moveGlobalSymbols(globalSymbols);
                this.addInstanceofGuards(globalSymbols);
            } else {
                this.cccmLog.log("only one chunk exists");
            }
        }
        finally {
            this.cccmLog = null;
        }
    }

    private void addInstanceofGuards(Collection<GlobalSymbol> globalSymbols) {
        for (GlobalSymbol globalSymbol : globalSymbols) {
            for (InstanceofReference instanceofReference : globalSymbol.instanceofReferencesToGuard) {
                if (globalSymbol.declarationsCoverModule(instanceofReference.getChunk())) continue;
                this.addGuardToInstanceofReference(instanceofReference.getReference().getNode());
            }
        }
    }

    private void moveGlobalSymbols(Collection<GlobalSymbol> globalSymbols) {
        for (GlobalSymbolCycle globalSymbolCycle : new OrderAndCombineGlobalSymbols(globalSymbols).orderAndCombine()) {
            globalSymbolCycle.moveDeclarationStatements();
        }
    }

    private void addGuardToInstanceofReference(Node referenceNode) {
        Preconditions.checkState((boolean)this.isUnguardedInstanceofReference(referenceNode), (String)"instanceof Reference is already guarded: %s", (Object)referenceNode);
        Node instanceofNode = (Node)Preconditions.checkNotNull((Object)referenceNode.getParent());
        Node referenceForTypeOf = referenceNode.cloneNode();
        Node tmp = IR.block();
        instanceofNode.replaceWith(tmp);
        Node and = IR.and(new Node(Token.EQ, IR.string("function"), new Node(Token.TYPEOF, referenceForTypeOf)), instanceofNode);
        and.srcrefTreeIfMissing(instanceofNode);
        tmp.replaceWith(and);
        this.compiler.reportChangeToEnclosingScope(and);
    }

    private boolean isUndefinedTypeofGuardReference(Node reference) {
        Node maybeTypeofGuard = reference.getGrandparent();
        if (maybeTypeofGuard != null && this.isExistenceTypeofGuardFor(maybeTypeofGuard, reference)) {
            Node andNode = maybeTypeofGuard.getParent();
            return andNode != null && andNode.isAnd() && this.isInstanceofFor(andNode.getLastChild(), reference);
        }
        return false;
    }

    private boolean isExistenceTypeofGuardFor(Node expression, Node reference) {
        if (expression.isNE() || expression.isSHNE()) {
            Node undefinedString = expression.getFirstChild();
            Node typeofNode = expression.getLastChild();
            return undefinedString.isStringLit() && undefinedString.getString().equals("undefined") && typeofNode.isTypeOf() && typeofNode.getFirstChild().isEquivalentTo(reference);
        }
        if (expression.isEQ() || expression.isSHEQ()) {
            Node functionString = expression.getFirstChild();
            Node typeofNode = expression.getLastChild();
            return functionString.isStringLit() && functionString.getString().equals("function") && typeofNode.isTypeOf() && typeofNode.getFirstChild().isEquivalentTo(reference);
        }
        return false;
    }

    private boolean isGuardedInstanceofReference(Node reference) {
        Node instanceofNode = reference.getParent();
        if (this.isInstanceofFor(instanceofNode, reference)) {
            Node andNode = instanceofNode.getParent();
            return andNode != null && andNode.isAnd() && this.isExistenceTypeofGuardFor(andNode.getFirstChild(), reference);
        }
        return false;
    }

    private boolean isUnguardedInstanceofReference(Node reference) {
        Node instanceofNode = reference.getParent();
        if (this.isInstanceofFor(instanceofNode, reference)) {
            return !this.isGuardedInstanceofReference(reference);
        }
        return false;
    }

    private boolean isInstanceofFor(Node expression, Node reference) {
        return expression.isInstanceOf() && expression.getLastChild().isEquivalentTo(reference);
    }

    private class GlobalSymbolCollector {
        final Map<Var, GlobalSymbol> globalSymbolforVar = new LinkedHashMap<Var, GlobalSymbol>();
        final Deque<GlobalSymbol> symbolStack = new ArrayDeque<GlobalSymbol>();

        private GlobalSymbolCollector() {
        }

        Collection<GlobalSymbol> collectGlobalSymbols(CrossChunkReferenceCollector referenceCollector) {
            for (CrossChunkReferenceCollector.TopLevelStatement statement : referenceCollector.getTopLevelStatements()) {
                if (statement.isDeclarationStatement()) {
                    this.processDeclarationStatement(statement);
                    continue;
                }
                this.processImmovableStatement(statement);
            }
            return this.symbolStack;
        }

        private void processImmovableStatement(CrossChunkReferenceCollector.TopLevelStatement statement) {
            for (Reference ref : statement.getNonDeclarationReferences()) {
                this.processImmovableReference(ref, statement.getChunk());
            }
        }

        private void processImmovableReference(Reference ref, JSChunk chunk) {
            GlobalSymbol globalSymbol = this.getGlobalSymbol(ref.getSymbol());
            if (CrossChunkCodeMotion.this.parentModuleCanSeeSymbolsDeclaredInChildren) {
                Node n = ref.getNode();
                if (CrossChunkCodeMotion.this.isGuardedInstanceofReference(n) || CrossChunkCodeMotion.this.isUndefinedTypeofGuardReference(n)) {
                    return;
                }
                if (CrossChunkCodeMotion.this.isUnguardedInstanceofReference(n)) {
                    ImmovableInstanceofReference instanceofReference = new ImmovableInstanceofReference(chunk, ref);
                    globalSymbol.instanceofReferencesToGuard.push(instanceofReference);
                    return;
                }
            }
            globalSymbol.addImmovableReference(chunk);
        }

        private void processDeclarationStatement(CrossChunkReferenceCollector.TopLevelStatement statement) {
            GlobalSymbol declaredSymbol = this.getGlobalSymbol(statement.getDeclaredNameReference().getSymbol());
            DeclarationStatementGroup dsg = declaredSymbol.addDeclarationStatement(statement);
            this.processDeclarationStatementContainedReferences(statement, declaredSymbol, dsg);
        }

        private void processDeclarationStatementContainedReferences(CrossChunkReferenceCollector.TopLevelStatement statement, GlobalSymbol declaredSymbol, DeclarationStatementGroup dsg) {
            for (Reference ref : statement.getNonDeclarationReferences()) {
                GlobalSymbol refSymbol = this.getGlobalSymbol(ref.getSymbol());
                if (refSymbol.equals(declaredSymbol)) continue;
                if (CrossChunkCodeMotion.this.parentModuleCanSeeSymbolsDeclaredInChildren) {
                    Node n = ref.getNode();
                    if (CrossChunkCodeMotion.this.isGuardedInstanceofReference(n) || CrossChunkCodeMotion.this.isUndefinedTypeofGuardReference(n)) continue;
                    if (CrossChunkCodeMotion.this.isUnguardedInstanceofReference(n)) {
                        MovableInstanceofReference instanceofReference = new MovableInstanceofReference(dsg, ref);
                        refSymbol.instanceofReferencesToGuard.push(instanceofReference);
                        continue;
                    }
                }
                dsg.addReferenceToGlobalSymbol(refSymbol);
                refSymbol.addReferringGlobalSymbol(declaredSymbol);
            }
        }

        private GlobalSymbol getGlobalSymbol(Var var) {
            GlobalSymbol globalSymbol = this.globalSymbolforVar.get(var);
            if (globalSymbol == null) {
                globalSymbol = new GlobalSymbol(var);
                this.globalSymbolforVar.put(var, globalSymbol);
                this.symbolStack.push(globalSymbol);
            }
            return globalSymbol;
        }
    }

    private class GlobalSymbol {
        final Var var;
        final Deque<DeclarationStatementGroup> dsgStack = new ArrayDeque<DeclarationStatementGroup>();
        final BitSet modulesWithImmovableReferences;
        final Set<GlobalSymbol> referencingGlobalSymbols;
        final Deque<InstanceofReference> instanceofReferencesToGuard;
        int preorderNumber;
        boolean hasBeenAssignedToAStronglyConnectedComponent;
        boolean isMoveDeclarationStatementsDone;

        GlobalSymbol(Var var) {
            this.modulesWithImmovableReferences = new BitSet(CrossChunkCodeMotion.this.graph.getChunkCount());
            this.referencingGlobalSymbols = new LinkedHashSet<GlobalSymbol>();
            this.instanceofReferencesToGuard = new ArrayDeque<InstanceofReference>();
            this.preorderNumber = -1;
            this.hasBeenAssignedToAStronglyConnectedComponent = false;
            this.isMoveDeclarationStatementsDone = false;
            this.var = var;
        }

        public String toString() {
            return this.var.getName();
        }

        void addImmovableReference(JSChunk chunk) {
            this.modulesWithImmovableReferences.set(chunk.getIndex());
        }

        DeclarationStatementGroup addDeclarationStatement(CrossChunkReferenceCollector.TopLevelStatement statement) {
            DeclarationStatementGroup statementDsg;
            JSChunk chunk = statement.getChunk();
            DeclarationStatementGroup lastDsg = this.dsgStack.peek();
            if (lastDsg == null) {
                lastDsg = new DeclarationStatementGroup(this, chunk);
                this.dsgStack.push(lastDsg);
            }
            if (chunk.equals(lastDsg.currentChunk)) {
                statementDsg = lastDsg;
            } else {
                statementDsg = new DeclarationStatementGroup(this, chunk);
                this.dsgStack.push(statementDsg);
            }
            statementDsg.statementStack.push(statement);
            return statementDsg;
        }

        void addReferringGlobalSymbol(GlobalSymbol declaredSymbol) {
            this.referencingGlobalSymbols.add(declaredSymbol);
        }

        boolean declarationsCoverModule(JSChunk chunk) {
            for (DeclarationStatementGroup dsg : this.dsgStack) {
                if (!chunk.equals(dsg.currentChunk) && !CrossChunkCodeMotion.this.graph.dependsOn(chunk, dsg.currentChunk)) continue;
                return true;
            }
            return false;
        }
    }

    static interface InstanceofReference {
        public JSChunk getChunk();

        public Reference getReference();
    }

    private class OrderAndCombineGlobalSymbols {
        final Collection<GlobalSymbol> inputSymbols;
        final Deque<GlobalSymbol> componentContents = new ArrayDeque<GlobalSymbol>();
        final Deque<GlobalSymbol> componentRoots = new ArrayDeque<GlobalSymbol>();
        final Deque<GlobalSymbolCycle> stronglyConnectedSymbols;
        int preorderCounter = 0;

        OrderAndCombineGlobalSymbols(Collection<GlobalSymbol> dsgs) {
            this.inputSymbols = dsgs;
            this.stronglyConnectedSymbols = new ArrayDeque<GlobalSymbolCycle>(dsgs.size());
        }

        Deque<GlobalSymbolCycle> orderAndCombine() {
            for (GlobalSymbol globalSymbol : this.inputSymbols) {
                if (globalSymbol.preorderNumber >= 0) continue;
                this.processGlobalSymbol(globalSymbol);
            }
            return this.stronglyConnectedSymbols;
        }

        void processGlobalSymbol(GlobalSymbol symbol) {
            Preconditions.checkState((symbol.preorderNumber < 0 ? 1 : 0) != 0, (String)"already processed: %s", (Object)symbol);
            symbol.preorderNumber = this.preorderCounter++;
            this.componentRoots.push(symbol);
            this.componentContents.push(symbol);
            for (GlobalSymbol referringSymbol : symbol.referencingGlobalSymbols) {
                if (referringSymbol.preorderNumber < 0) {
                    this.processGlobalSymbol(referringSymbol);
                    continue;
                }
                if (referringSymbol.hasBeenAssignedToAStronglyConnectedComponent) continue;
                while (this.componentRoots.peek().preorderNumber > referringSymbol.preorderNumber) {
                    this.componentRoots.pop();
                }
            }
            if (this.componentRoots.peek().equals(symbol)) {
                GlobalSymbol connectedSymbol;
                this.componentRoots.pop();
                GlobalSymbolCycle cycle = new GlobalSymbolCycle();
                do {
                    connectedSymbol = this.componentContents.pop();
                    cycle.addSymbol(connectedSymbol);
                    connectedSymbol.hasBeenAssignedToAStronglyConnectedComponent = true;
                } while (!connectedSymbol.equals(symbol));
                this.stronglyConnectedSymbols.add(cycle);
            }
        }
    }

    private class GlobalSymbolCycle {
        final Deque<GlobalSymbol> symbols = new ArrayDeque<GlobalSymbol>();

        private GlobalSymbolCycle() {
        }

        void addSymbol(GlobalSymbol symbol) {
            this.symbols.add(symbol);
        }

        void moveDeclarationStatements() {
            for (GlobalSymbol symbol : this.symbols) {
                Preconditions.checkState((!symbol.isMoveDeclarationStatementsDone ? 1 : 0) != 0, (String)"duplicate attempt to move %s", (Object)symbol);
            }
            BitSet modulesWithImmovableReferences = new BitSet(CrossChunkCodeMotion.this.graph.getChunkCount());
            List<DeclarationStatementGroupCycle> cyclesLatestFirst = this.getDsgCyclesLatestFirst();
            for (DeclarationStatementGroupCycle dsgCycle : cyclesLatestFirst) {
                for (GlobalSymbol symbol : this.symbols) {
                    modulesWithImmovableReferences.or(symbol.modulesWithImmovableReferences);
                }
                dsgCycle.moveToPreferredChunk(modulesWithImmovableReferences);
            }
            for (GlobalSymbol symbol : this.symbols) {
                symbol.isMoveDeclarationStatementsDone = true;
            }
        }

        List<DeclarationStatementGroupCycle> getDsgCyclesLatestFirst() {
            ArrayList<DeclarationStatementGroupCycle> cyclesLatestFirst = new ArrayList<DeclarationStatementGroupCycle>();
            Deque<DeclarationStatementGroup> dsgsLatestFirst = this.getDsgsLatestFirst();
            DeclarationStatementGroupCycle cycle = null;
            for (DeclarationStatementGroup dsg : dsgsLatestFirst) {
                if (cycle == null || !cycle.currentChunk.equals(dsg.currentChunk)) {
                    cycle = new DeclarationStatementGroupCycle(this, dsg.currentChunk);
                    cyclesLatestFirst.add(cycle);
                }
                cycle.dsgs.add(dsg);
            }
            return cyclesLatestFirst;
        }

        private Deque<DeclarationStatementGroup> getDsgsLatestFirst() {
            ArrayDeque<DeclarationStatementGroup> resultStack = new ArrayDeque<DeclarationStatementGroup>();
            block0: for (GlobalSymbol symbol : this.symbols) {
                ArrayDeque<DeclarationStatementGroup> stack1 = resultStack;
                ArrayDeque<DeclarationStatementGroup> stack2 = new ArrayDeque<DeclarationStatementGroup>(symbol.dsgStack);
                resultStack = new ArrayDeque(stack1.size() + stack2.size());
                while (true) {
                    if (stack1.isEmpty()) {
                        resultStack.addAll(stack2);
                        continue block0;
                    }
                    if (stack2.isEmpty()) {
                        resultStack.addAll(stack1);
                        continue block0;
                    }
                    DeclarationStatementGroup dsg1 = (DeclarationStatementGroup)stack1.peek();
                    DeclarationStatementGroup dsg2 = (DeclarationStatementGroup)stack2.peek();
                    if (dsg1.currentChunk.getIndex() > dsg2.currentChunk.getIndex()) {
                        resultStack.add((DeclarationStatementGroup)stack1.pop());
                        Preconditions.checkState((stack1.isEmpty() || ((DeclarationStatementGroup)stack1.peek()).currentChunk.getIndex() <= dsg1.currentChunk.getIndex() ? 1 : 0) != 0, (Object)"DSG stacks are out of order.");
                        continue;
                    }
                    resultStack.add((DeclarationStatementGroup)stack2.pop());
                    Preconditions.checkState((stack2.isEmpty() || ((DeclarationStatementGroup)stack2.peek()).currentChunk.getIndex() <= dsg2.currentChunk.getIndex() ? 1 : 0) != 0, (Object)"DSG stacks are out of order.");
                }
            }
            return resultStack;
        }
    }

    private static class MovableInstanceofReference
    implements InstanceofReference {
        final DeclarationStatementGroup containingDsg;
        final Reference reference;

        MovableInstanceofReference(DeclarationStatementGroup containingDsg, Reference reference) {
            this.containingDsg = containingDsg;
            this.reference = reference;
        }

        @Override
        public JSChunk getChunk() {
            return this.containingDsg.currentChunk;
        }

        @Override
        public Reference getReference() {
            return this.reference;
        }
    }

    private static class ImmovableInstanceofReference
    implements InstanceofReference {
        final JSChunk chunk;
        final Reference reference;

        ImmovableInstanceofReference(JSChunk chunk, Reference reference) {
            this.chunk = chunk;
            this.reference = reference;
        }

        @Override
        public JSChunk getChunk() {
            return this.chunk;
        }

        @Override
        public Reference getReference() {
            return this.reference;
        }
    }

    private class DeclarationStatementGroupCycle {
        final JSChunk currentChunk;
        final Deque<DeclarationStatementGroup> dsgs;

        DeclarationStatementGroupCycle(GlobalSymbolCycle globalSymbolCycle, JSChunk currentChunk) {
            this.currentChunk = currentChunk;
            this.dsgs = new ArrayDeque<DeclarationStatementGroup>();
        }

        void moveToPreferredChunk(BitSet modulesWithImmovableReferences) {
            JSChunk preferredChunk = this.getPreferredChunk(modulesWithImmovableReferences);
            if (!preferredChunk.equals(this.currentChunk)) {
                if (CrossChunkCodeMotion.this.cccmLog.isLogging()) {
                    CrossChunkCodeMotion.this.cccmLog.log("start DSG Cycle move");
                    for (String globalSymbolName : this.getGlobalSymbolNames()) {
                        CrossChunkCodeMotion.this.cccmLog.log(() -> SimpleFormat.format("Moving DSG for %s from chunk %s to chunk %s", globalSymbolName, this.currentChunk, preferredChunk));
                    }
                }
                this.moveStatementsToModule(preferredChunk);
            }
            for (DeclarationStatementGroup dsg : this.dsgs) {
                dsg.currentChunk = preferredChunk;
                dsg.makeReferencesImmovable();
            }
        }

        private ImmutableList<String> getGlobalSymbolNames() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (DeclarationStatementGroup dsg : this.dsgs) {
                builder.add((Object)dsg.declaredGlobalSymbol.var.getName());
            }
            return builder.build();
        }

        private void moveStatementsToModule(JSChunk preferredChunk) {
            Node destParent = CrossChunkCodeMotion.this.moduleInsertionPointMap.computeIfAbsent(preferredChunk, CrossChunkCodeMotion.this.compiler::getNodeForCodeInsertion);
            Deque<CrossChunkReferenceCollector.TopLevelStatement> statementsLastFirst = this.getStatementsLastFirst();
            for (CrossChunkReferenceCollector.TopLevelStatement statement : statementsLastFirst) {
                Node statementNode = statement.getStatementNode();
                CrossChunkCodeMotion.this.compiler.reportChangeToEnclosingScope(statementNode);
                Node originalScript = NodeUtil.getEnclosingScript(statementNode);
                statementNode.detach();
                destParent.addChildToFront(statementNode);
                NodeUtil.addFeaturesToScript(destParent, NodeUtil.getFeatureSetOfScript(originalScript), CrossChunkCodeMotion.this.compiler);
                CrossChunkCodeMotion.this.compiler.reportChangeToEnclosingScope(statementNode);
            }
        }

        private Deque<CrossChunkReferenceCollector.TopLevelStatement> getStatementsLastFirst() {
            ArrayDeque<CrossChunkReferenceCollector.TopLevelStatement> result = new ArrayDeque<CrossChunkReferenceCollector.TopLevelStatement>();
            block0: for (DeclarationStatementGroup dsg : this.dsgs) {
                ArrayDeque<CrossChunkReferenceCollector.TopLevelStatement> stack1 = new ArrayDeque<CrossChunkReferenceCollector.TopLevelStatement>(dsg.statementStack);
                ArrayDeque<CrossChunkReferenceCollector.TopLevelStatement> stack2 = result;
                result = new ArrayDeque(stack1.size() + stack2.size());
                while (true) {
                    if (stack1.isEmpty()) {
                        result.addAll(stack2);
                        continue block0;
                    }
                    if (stack2.isEmpty()) {
                        result.addAll(stack1);
                        continue block0;
                    }
                    CrossChunkReferenceCollector.TopLevelStatement s1 = (CrossChunkReferenceCollector.TopLevelStatement)stack1.peek();
                    CrossChunkReferenceCollector.TopLevelStatement s2 = (CrossChunkReferenceCollector.TopLevelStatement)stack2.peek();
                    if (s1.getOriginalOrder() > s2.getOriginalOrder()) {
                        result.add((CrossChunkReferenceCollector.TopLevelStatement)stack1.pop());
                        Preconditions.checkState((stack1.isEmpty() || ((CrossChunkReferenceCollector.TopLevelStatement)stack1.peek()).getOriginalOrder() < s1.getOriginalOrder() ? 1 : 0) != 0, (Object)"Statements are recorded in the wrong order.");
                        continue;
                    }
                    result.add((CrossChunkReferenceCollector.TopLevelStatement)stack2.pop());
                    Preconditions.checkState((stack2.isEmpty() || ((CrossChunkReferenceCollector.TopLevelStatement)stack2.peek()).getOriginalOrder() < s2.getOriginalOrder() ? 1 : 0) != 0, (Object)"Statements are recorded in the wrong order.");
                }
            }
            return result;
        }

        private JSChunk getPreferredChunk(BitSet modulesWithImmovableReferences) {
            if (modulesWithImmovableReferences.isEmpty()) {
                return this.currentChunk;
            }
            if (!this.allStatementsCanMove()) {
                return this.currentChunk;
            }
            return CrossChunkCodeMotion.this.graph.getSmallestCoveringSubtree(this.currentChunk, modulesWithImmovableReferences);
        }

        boolean allStatementsCanMove() {
            for (DeclarationStatementGroup dsg : this.dsgs) {
                if (dsg.allStatementsCanMove()) continue;
                return false;
            }
            return true;
        }
    }

    private static class DeclarationStatementGroup {
        final GlobalSymbol declaredGlobalSymbol;
        final Set<GlobalSymbol> referencedGlobalSymbols = new LinkedHashSet<GlobalSymbol>();
        JSChunk currentChunk;
        final Deque<CrossChunkReferenceCollector.TopLevelStatement> statementStack = new ArrayDeque<CrossChunkReferenceCollector.TopLevelStatement>();

        DeclarationStatementGroup(GlobalSymbol declaredGlobalSymbol, JSChunk currentChunk) {
            this.declaredGlobalSymbol = declaredGlobalSymbol;
            this.currentChunk = currentChunk;
        }

        boolean allStatementsCanMove() {
            for (CrossChunkReferenceCollector.TopLevelStatement s : this.statementStack) {
                if (s.isMovableDeclaration()) continue;
                return false;
            }
            return true;
        }

        void addReferenceToGlobalSymbol(GlobalSymbol refSymbol) {
            this.referencedGlobalSymbols.add(refSymbol);
        }

        void makeReferencesImmovable() {
            this.declaredGlobalSymbol.addImmovableReference(this.currentChunk);
            for (GlobalSymbol symbol : this.referencedGlobalSymbols) {
                Preconditions.checkState((!symbol.isMoveDeclarationStatementsDone ? 1 : 0) != 0, (String)"symbol %s moved before referring symbol %s", (Object)symbol, (Object)this.declaredGlobalSymbol);
                symbol.addImmovableReference(this.currentChunk);
            }
        }
    }
}

