/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeReplacer;
import com.google.javascript.rhino.jstype.TypeStringBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

public final class TemplatizedType
extends ProxyObjectType {
    private static final JSTypeClass TYPE_CLASS = JSTypeClass.TEMPLATIZED;
    private final ImmutableList<JSType> templateTypes;
    private final boolean isSpecializedOnlyWithUnknown;
    private final TemplateTypeReplacer replacer;

    TemplatizedType(JSTypeRegistry registry, ObjectType objectType, ImmutableList<JSType> templateTypes) {
        super(registry, objectType, objectType.getTemplateTypeMap().copyFilledWithValues(templateTypes));
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean maybeIsSpecializedOnlyWithUnknown = true;
        for (TemplateType newlyFilledTemplateKey : objectType.getTypeParameters()) {
            JSType resolvedType = this.getTemplateTypeMap().getResolvedTemplateType(newlyFilledTemplateKey);
            builder.add((Object)resolvedType);
            if (!maybeIsSpecializedOnlyWithUnknown) continue;
            maybeIsSpecializedOnlyWithUnknown = this.getNativeType(JSTypeNative.UNKNOWN_TYPE).equals(resolvedType);
        }
        this.templateTypes = builder.build();
        this.isSpecializedOnlyWithUnknown = maybeIsSpecializedOnlyWithUnknown;
        this.replacer = TemplateTypeReplacer.forPartialReplacement(registry, this.getTemplateTypeMap());
        registry.getResolver().resolveIfClosed(this, TYPE_CLASS);
    }

    @Override
    JSTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        LinkedHashSet<ObjectType> resolvedImplementedInterfaces = new LinkedHashSet<ObjectType>();
        for (ObjectType obj : this.getReferencedObjTypeInternal().getCtorImplementedInterfaces()) {
            resolvedImplementedInterfaces.add(obj.visit(this.replacer).toObjectType());
        }
        return resolvedImplementedInterfaces;
    }

    @Override
    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        LinkedHashSet<ObjectType> resolvedExtendedInterfaces = new LinkedHashSet<ObjectType>();
        for (ObjectType obj : this.getReferencedObjTypeInternal().getCtorExtendedInterfaces()) {
            resolvedExtendedInterfaces.add(obj.visit(this.replacer).toObjectType());
        }
        return resolvedExtendedInterfaces;
    }

    @Override
    void appendTo(TypeStringBuilder sb) {
        super.appendTo(sb);
        if (!this.templateTypes.isEmpty()) {
            sb.append("<").appendAll((Iterable<?>)this.templateTypes, ",").append(">");
        }
    }

    @Override
    int recursionUnsafeHashCode() {
        int baseHash = super.recursionUnsafeHashCode();
        if (this.isSpecializedOnlyWithUnknown) {
            return baseHash;
        }
        return Objects.hash(this.templateTypes, baseHash);
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseTemplatizedType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseTemplatizedType(this, that);
    }

    @Override
    public TemplatizedType toMaybeTemplatizedType() {
        return this;
    }

    @Override
    public ImmutableList<JSType> getTemplateTypes() {
        return this.templateTypes;
    }

    @Override
    public @Nullable JSType getPropertyType(String propertyName) {
        JSType result = super.getPropertyType(propertyName);
        return result == null ? null : result.visit(this.replacer);
    }

    boolean wrapsSameRawType(JSType that) {
        return that.isTemplatizedType() && this.getReferencedTypeInternal().equals(that.toMaybeTemplatizedType().getReferencedTypeInternal());
    }

    JSType getGreatestSubtypeHelper(JSType rawThat) {
        Preconditions.checkNotNull((Object)rawThat);
        if (!this.wrapsSameRawType(rawThat)) {
            if (!rawThat.isTemplatizedType()) {
                if (this.isSubtype(rawThat)) {
                    return this;
                }
                if (rawThat.isSubtypeOf(this)) {
                    return TemplatizedType.filterNoResolvedType(rawThat);
                }
            }
            if (this.isObject() && rawThat.isObject()) {
                return this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
            }
            return this.getNativeType(JSTypeNative.NO_TYPE);
        }
        TemplatizedType that = rawThat.toMaybeTemplatizedType();
        Preconditions.checkNotNull((Object)that);
        if (this.equals(that)) {
            return this;
        }
        return this.getReferencedObjTypeInternal();
    }

    @Override
    public TemplateTypeMap getTemplateTypeMap() {
        return this.templateTypeMap;
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return this.templateTypeMap.hasAnyTemplateTypesInternal();
    }

    public ObjectType getReferencedType() {
        return this.getReferencedObjTypeInternal();
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        ObjectType baseTypeBefore = this.getReferencedType();
        super.resolveInternal(reporter);
        boolean rebuild = baseTypeBefore != this.getReferencedType();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JSType type : this.templateTypes) {
            JSType resolved = type.resolve(reporter);
            rebuild |= !JSCompObjects.identical(resolved, type);
            builder.add((Object)resolved);
        }
        if (rebuild) {
            return new TemplatizedType(this.registry, this.getReferencedType(), (ImmutableList<JSType>)builder.build());
        }
        return this;
    }
}

