/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeReplacer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public final class TemplateTypeMap {
    private final ImmutableList<TemplateType> templateKeys;
    private final ImmutableList<JSType> templateValues;
    private final JSType[] resolvedTemplateValues;
    private final JSTypeRegistry registry;

    static final TemplateTypeMap createEmpty(JSTypeRegistry registry) {
        Preconditions.checkArgument((registry.getEmptyTemplateTypeMap() == null ? 1 : 0) != 0);
        return new TemplateTypeMap(registry, (ImmutableList<TemplateType>)ImmutableList.of(), (ImmutableList<JSType>)ImmutableList.of());
    }

    private TemplateTypeMap(JSTypeRegistry registry, ImmutableList<TemplateType> templateKeys, ImmutableList<JSType> templateValues) {
        Preconditions.checkNotNull(templateKeys);
        Preconditions.checkNotNull(templateValues);
        Preconditions.checkArgument((templateValues.size() <= templateKeys.size() ? 1 : 0) != 0);
        this.registry = registry;
        this.templateKeys = templateKeys;
        this.templateValues = templateValues;
        TemplateTypeReplacer replacer = TemplateTypeReplacer.forTotalReplacement(registry, this);
        int nValues = this.templateValues.size();
        int nKeys = this.templateKeys.size();
        JSType[] resolvedValues = new JSType[nKeys];
        for (int i = 0; i < nKeys; ++i) {
            if (i < nValues) {
                TemplateType templateKey = (TemplateType)this.templateKeys.get(i);
                replacer.setKeyType(templateKey);
                JSType templateValue = (JSType)this.templateValues.get(i);
                resolvedValues[i] = templateValue.visit(replacer);
                continue;
            }
            resolvedValues[i] = ((TemplateType)this.templateKeys.get(i)).getBound();
        }
        this.resolvedTemplateValues = resolvedValues;
    }

    TemplateTypeMap copyFilledWithValues(ImmutableList<JSType> values) {
        int requiredUnknownCount = this.numUnfilledTemplateKeys() - values.size();
        Preconditions.checkArgument((requiredUnknownCount >= 0 ? 1 : 0) != 0, (Object)requiredUnknownCount);
        if (this.numUnfilledTemplateKeys() == 0) {
            return this;
        }
        ArrayList<JSType> extendedValues = new ArrayList<JSType>();
        extendedValues.addAll((Collection<JSType>)this.templateValues);
        extendedValues.addAll((Collection<JSType>)values);
        this.padToSameLength(this.templateKeys, extendedValues);
        return new TemplateTypeMap(this.registry, this.templateKeys, (ImmutableList<JSType>)ImmutableList.copyOf(extendedValues));
    }

    public TemplateTypeMap copyWithExtension(TemplateTypeMap extension) {
        return this.copyWithExtension(extension.templateKeys, extension.templateValues);
    }

    public TemplateTypeMap copyWithExtension(ImmutableList<TemplateType> keys, ImmutableList<JSType> values) {
        int extendedUnfilledCount = keys.size() - values.size();
        Preconditions.checkArgument((extendedUnfilledCount >= 0 ? 1 : 0) != 0, (Object)extendedUnfilledCount);
        if (this.numUnfilledTemplateKeys() == 0 && keys.isEmpty()) {
            return this;
        }
        ImmutableList extendedKeys = ImmutableList.builder().addAll(this.templateKeys).addAll(keys).build();
        ArrayList<JSType> extendedValues = new ArrayList<JSType>();
        extendedValues.addAll((Collection<JSType>)this.templateValues);
        this.padToSameLength(this.templateKeys, extendedValues);
        extendedValues.addAll((Collection<JSType>)values);
        return new TemplateTypeMap(this.registry, (ImmutableList<TemplateType>)extendedKeys, (ImmutableList<JSType>)ImmutableList.copyOf(extendedValues));
    }

    TemplateTypeMap copyWithoutKeys(Set<TemplateType> removals) {
        ImmutableList.Builder keys = ImmutableList.builder();
        keys.addAll((Iterable)this.templateKeys.subList(0, this.templateValues.size()));
        for (int i = this.templateValues.size(); i < this.templateKeys.size(); ++i) {
            TemplateType key = (TemplateType)this.templateKeys.get(i);
            if (removals.contains(key)) continue;
            keys.add((Object)key);
        }
        if (keys.build().size() == this.templateKeys.size()) {
            return this;
        }
        return new TemplateTypeMap(this.registry, (ImmutableList<TemplateType>)keys.build(), this.templateValues);
    }

    public int size() {
        return this.templateKeys.size();
    }

    public boolean isEmpty() {
        return this.templateKeys.isEmpty();
    }

    public ImmutableList<TemplateType> getTemplateKeys() {
        return this.templateKeys;
    }

    public ImmutableList<JSType> getTemplateValues() {
        return this.templateValues;
    }

    public boolean hasTemplateKey(TemplateType templateKey) {
        int keyCount = this.templateKeys.size();
        for (int i = 0; i < keyCount; ++i) {
            TemplateType entry = (TemplateType)this.templateKeys.get(i);
            if (!JSCompObjects.identical(templateKey, entry)) continue;
            return true;
        }
        return false;
    }

    int getTemplateKeyCountThisShouldAlwaysBeOneOrZeroButIsnt(TemplateType templateKey) {
        int matches = 0;
        int keyCount = this.templateKeys.size();
        for (int i = 0; i < keyCount; ++i) {
            TemplateType entry = (TemplateType)this.templateKeys.get(i);
            if (!JSCompObjects.identical(templateKey, entry)) continue;
            ++matches;
        }
        return matches;
    }

    private int numUnfilledTemplateKeys() {
        return this.templateKeys.size() - this.templateValues.size();
    }

    public boolean hasTemplateType(TemplateType key) {
        return this.getTemplateTypeIndex(key) != -1;
    }

    JSType getUnresolvedOriginalTemplateType(TemplateType key) {
        int index = this.getTemplateTypeIndex(key);
        return index == -1 ? this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE) : (JSType)this.templateValues.get(index);
    }

    public @Nullable TemplateType getLastTemplateTypeKeyByName(String keyName) {
        int size = this.templateKeys.size();
        for (int i = size - 1; i >= 0; --i) {
            TemplateType key = (TemplateType)this.templateKeys.get(i);
            if (!key.getReferenceName().equals(keyName)) continue;
            return key;
        }
        return null;
    }

    private int getTemplateTypeIndex(TemplateType key) {
        int maxIndex = Math.min(this.templateKeys.size(), this.templateValues.size());
        for (int i = maxIndex - 1; i >= 0; --i) {
            if (!JSCompObjects.identical(this.templateKeys.get(i), key)) continue;
            return i;
        }
        return -1;
    }

    public JSType getResolvedTemplateType(TemplateType key) {
        int index = this.getTemplateTypeIndex(key);
        return index == -1 ? this.unknownIfUnbounded(key) : this.resolvedTemplateValues[index];
    }

    boolean hasAnyTemplateTypesInternal() {
        if (this.resolvedTemplateValues != null) {
            for (JSType templateValue : this.resolvedTemplateValues) {
                if (!templateValue.hasAnyTemplateTypes()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        Object s = "";
        int len = this.templateKeys.size();
        s = (String)s + "{ ";
        for (int i = 0; i < len; ++i) {
            s = (String)s + "(";
            s = (String)s + this.templateKeys.get(i);
            s = (String)s + ",";
            s = (String)s + (i < this.templateValues.size() ? this.templateValues.get(i) : "");
            s = (String)s + ",";
            s = (String)s + (this.resolvedTemplateValues != null && i < this.resolvedTemplateValues.length ? this.resolvedTemplateValues[i] : "");
            s = (String)s + ") ";
        }
        s = (String)s + "}";
        return s;
    }

    private void padToSameLength(ImmutableList<TemplateType> keys, ArrayList<JSType> builder) {
        Preconditions.checkArgument((builder.size() <= keys.size() ? 1 : 0) != 0);
        for (int i = builder.size(); i < keys.size(); ++i) {
            builder.add(this.unknownIfUnbounded((TemplateType)keys.get(i)));
        }
    }

    private JSType unknownIfUnbounded(TemplateType type) {
        return type.getBound().isUnknownType() ? this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE) : type;
    }
}

