/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import com.google.javascript.jscomp.base.JSCompDoubles;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.serialization.NodeProperty;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.NonJSDocComment;
import com.google.javascript.rhino.PropTranslator;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.RhinoStringPool;
import com.google.javascript.rhino.SimpleSourceFile;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.nullness.Nullable;

public class Node {
    private static final Prop[] PROP_VALUES = Prop.values();
    public static final Prop INCRDECR_PROP = Prop.INCRDECR;
    public static final Prop QUOTED_PROP = Prop.QUOTED;
    public static final Prop IS_CONSTANT_NAME = Prop.IS_CONSTANT_NAME;
    public static final Prop IS_NAMESPACE = Prop.IS_NAMESPACE;
    public static final Prop DIRECT_EVAL = Prop.DIRECT_EVAL;
    public static final Prop FREE_CALL = Prop.FREE_CALL;
    public static final Prop REFLECTED_OBJECT = Prop.REFLECTED_OBJECT;
    public static final Prop STATIC_MEMBER = Prop.STATIC_MEMBER;
    public static final Prop GENERATOR_FN = Prop.GENERATOR_FN;
    public static final Prop YIELD_ALL = Prop.YIELD_ALL;
    public static final Prop EXPORT_DEFAULT = Prop.EXPORT_DEFAULT;
    public static final Prop EXPORT_ALL_FROM = Prop.EXPORT_ALL_FROM;
    public static final Prop COMPUTED_PROP_METHOD = Prop.COMPUTED_PROP_METHOD;
    public static final Prop COMPUTED_PROP_GETTER = Prop.COMPUTED_PROP_GETTER;
    public static final Prop COMPUTED_PROP_SETTER = Prop.COMPUTED_PROP_SETTER;
    public static final Prop COMPUTED_PROP_VARIABLE = Prop.COMPUTED_PROP_VARIABLE;
    public static final Prop OPT_ES6_TYPED = Prop.OPT_ES6_TYPED;
    public static final Prop GENERIC_TYPE_LIST = Prop.GENERIC_TYPE;
    public static final Prop IMPLEMENTS = Prop.IMPLEMENTS;
    public static final Prop CONSTRUCT_SIGNATURE = Prop.CONSTRUCT_SIGNATURE;
    public static final Prop ACCESS_MODIFIER = Prop.ACCESS_MODIFIER;
    public static final Prop PARSE_RESULTS = Prop.PARSE_RESULTS;
    public static final Prop GOOG_MODULE = Prop.GOOG_MODULE;
    public static final Prop FEATURE_SET = Prop.FEATURE_SET;
    public static final Prop IS_TYPESCRIPT_ABSTRACT = Prop.IS_TYPESCRIPT_ABSTRACT;
    public static final Prop TRANSPILED = Prop.TRANSPILED;
    public static final Prop MODULE_ALIAS = Prop.MODULE_ALIAS;
    public static final Prop MODULE_EXPORT = Prop.MODULE_EXPORT;
    public static final Prop IS_SHORTHAND_PROPERTY = Prop.IS_SHORTHAND_PROPERTY;
    public static final Prop ES6_MODULE = Prop.ES6_MODULE;
    public static final Prop MARK_FOR_PARENTHESIZE = Prop.MARK_FOR_PARENTHESIZE;
    private transient Token token;
    private transient @Nullable Node next;
    private transient @Nullable Node previous;
    private transient @Nullable Node first;
    private transient @Nullable Node parent;
    private transient int linenoCharno = -1;
    private transient int length;
    private transient @Nullable Object jstypeOrColor;
    private transient @Nullable String originalName;
    private transient @Nullable PropListItem propListHead;
    private static final int CHARNO_BITS = 12;
    public static final int MAX_COLUMN_NUMBER = 4095;
    private static final ImmutableMap<Prop, Function<Node, Object>> PROP_MAP_FOR_EQUALITY = new ImmutableMap.Builder().put((Object)Prop.ARROW_FN, Node::isArrowFunction).put((Object)Prop.ASYNC_FN, Node::isAsyncFunction).put((Object)Prop.GENERATOR_FN, Node::isGeneratorFunction).put((Object)Prop.START_OF_OPT_CHAIN, Node::isOptionalChainStart).put((Object)Prop.STATIC_MEMBER, Node::isStaticMember).put((Object)Prop.YIELD_ALL, Node::isYieldAll).put((Object)Prop.EXPORT_DEFAULT, n -> n.getIntProp(Prop.EXPORT_DEFAULT)).put((Object)Prop.EXPORT_ALL_FROM, n -> n.getIntProp(Prop.EXPORT_ALL_FROM)).put((Object)Prop.INCRDECR, n -> n.getIntProp(Prop.INCRDECR)).put((Object)Prop.QUOTED, n -> n.getIntProp(Prop.QUOTED)).put((Object)Prop.FREE_CALL, n -> n.getBooleanProp(Prop.FREE_CALL)).put((Object)Prop.COMPUTED_PROP_METHOD, n -> n.getBooleanProp(Prop.COMPUTED_PROP_METHOD)).put((Object)Prop.COMPUTED_PROP_GETTER, n -> n.getBooleanProp(Prop.COMPUTED_PROP_GETTER)).put((Object)Prop.COMPUTED_PROP_SETTER, n -> n.getBooleanProp(Prop.COMPUTED_PROP_SETTER)).buildOrThrow();
    private static final EnumSet<Prop> PROP_MAP_FOR_EQUALITY_KEYS = EnumSet.copyOf(PROP_MAP_FOR_EQUALITY.keySet());

    public final String getNonJSDocCommentString() {
        if (this.getProp(Prop.NON_JSDOC_COMMENT) == null) {
            return "";
        }
        return ((NonJSDocComment)this.getProp(Prop.NON_JSDOC_COMMENT)).getCommentString();
    }

    public final NonJSDocComment getNonJSDocComment() {
        return (NonJSDocComment)this.getProp(Prop.NON_JSDOC_COMMENT);
    }

    public final String getTrailingNonJSDocCommentString() {
        if (this.getProp(Prop.TRAILING_NON_JSDOC_COMMENT) == null) {
            return "";
        }
        return ((NonJSDocComment)this.getProp(Prop.TRAILING_NON_JSDOC_COMMENT)).getCommentString();
    }

    public final NonJSDocComment getTrailingNonJSDocComment() {
        return (NonJSDocComment)this.getProp(Prop.TRAILING_NON_JSDOC_COMMENT);
    }

    public final Node setNonJSDocComment(NonJSDocComment comment) {
        this.putProp(Prop.NON_JSDOC_COMMENT, comment);
        return this;
    }

    public final Node setTrailingNonJSDocComment(NonJSDocComment comment) {
        this.putProp(Prop.TRAILING_NON_JSDOC_COMMENT, comment);
        return this;
    }

    public final void setIsParenthesized(boolean b) {
        Preconditions.checkState((boolean)IR.mayBeExpression(this));
        this.putBooleanProp(Prop.IS_PARENTHESIZED, b);
    }

    public final boolean getIsParenthesized() {
        return this.getBooleanProp(Prop.IS_PARENTHESIZED);
    }

    public Node(Token token) {
        this.token = token;
    }

    public Node(Token token, Node child) {
        this(token);
        this.first = child;
        child.checkDetached();
        child.previous = child;
        child.parent = this;
    }

    public Node(Token token, Node left, Node right) {
        this(token);
        this.first = left;
        left.checkDetached();
        left.next = right;
        left.previous = right;
        left.parent = this;
        right.checkDetached();
        right.previous = left;
        right.parent = this;
    }

    public Node(Token token, Node left, Node mid, Node right) {
        this(token);
        this.first = left;
        left.checkDetached();
        left.next = mid;
        left.previous = right;
        left.parent = this;
        mid.checkDetached();
        mid.next = right;
        mid.previous = left;
        mid.parent = this;
        right.checkDetached();
        right.previous = mid;
        right.parent = this;
    }

    public static Node newNumber(double number) {
        return new NumberNode(number);
    }

    public static Node newBigInt(BigInteger bigint) {
        return new BigIntNode(bigint);
    }

    public static Node newString(String str) {
        return new StringNode(Token.STRINGLIT, str);
    }

    public static Node newString(Token token, String str) {
        return new StringNode(token, str);
    }

    public static Node newTemplateLitString(String cooked, String raw) {
        return new TemplateLiteralSubstringNode(cooked, raw);
    }

    public final Token getToken() {
        return this.token;
    }

    public final void setToken(Token token) {
        this.token = token;
    }

    public final boolean hasChildren() {
        return this.first != null;
    }

    public final Node getOnlyChild() {
        Preconditions.checkState((boolean)this.hasOneChild());
        return this.first;
    }

    public final @Nullable Node getFirstChild() {
        return this.first;
    }

    public final @Nullable Node getFirstFirstChild() {
        return this.first.first;
    }

    public final @Nullable Node getSecondChild() {
        return this.first.next;
    }

    public final @Nullable Node getLastChild() {
        return this.first != null ? this.first.previous : null;
    }

    public final @Nullable Node getNext() {
        return this.next;
    }

    public final @Nullable Node getPrevious() {
        return this == this.parent.first ? null : this.previous;
    }

    public final Node getChildAtIndex(int i) {
        Node n = this.first;
        while (i > 0) {
            n = n.next;
            --i;
        }
        return n;
    }

    public final int getIndexOfChild(Node child) {
        Node n = this.first;
        int i = 0;
        while (n != null) {
            if (child == n) {
                return i;
            }
            n = n.next;
            ++i;
        }
        return -1;
    }

    public final void addChildToFront(Node child) {
        Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((child.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((child.previous == null ? 1 : 0) != 0);
        child.parent = this;
        child.next = this.first;
        if (this.first == null) {
            child.previous = child;
        } else {
            Node last;
            child.previous = last = this.first.previous;
            child.next = this.first;
            this.first.previous = child;
        }
        this.first = child;
    }

    public final void addChildToBack(Node child) {
        Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0, (String)"Cannot add already-owned child node.\nChild: %s\nExisting parent: %s\nNew parent: %s", (Object)child, (Object)child.parent, (Object)this);
        Preconditions.checkArgument((child.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((child.previous == null ? 1 : 0) != 0);
        if (this.first == null) {
            child.previous = child;
            this.first = child;
        } else {
            Node last = this.first.previous;
            last.next = child;
            child.previous = last;
            this.first.previous = child;
        }
        child.parent = this;
    }

    public final void addChildrenToFront(@Nullable Node children) {
        if (children == null) {
            return;
        }
        Preconditions.checkNotNull((Object)children.previous, (Object)children);
        Node child = children;
        while (child != null) {
            Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
            child.parent = this;
            child = child.next;
        }
        Node lastSib = children.previous;
        if (this.first != null) {
            Node last;
            children.previous = last = this.first.previous;
            lastSib.next = this.first;
            this.first.previous = lastSib;
        }
        this.first = children;
    }

    public final void addChildrenToBack(Node children) {
        this.addChildrenAfter(children, this.getLastChild());
    }

    public final void insertAfter(Node existing) {
        existing.checkAttached();
        this.checkDetached();
        Node existingParent = existing.parent;
        Node existingNext = existing.next;
        this.parent = existingParent;
        existing.next = this;
        this.previous = existing;
        if (existingNext == null) {
            existingParent.first.previous = this;
        } else {
            existingNext.previous = this;
            this.next = existingNext;
        }
    }

    public final void insertBefore(Node existing) {
        existing.checkAttached();
        this.checkDetached();
        Node existingParent = existing.parent;
        Node existingPrevious = existing.previous;
        this.parent = existingParent;
        this.next = existing;
        existing.previous = this;
        this.previous = existingPrevious;
        if (existingPrevious.next == null) {
            existingParent.first = this;
        } else {
            existingPrevious.next = this;
        }
    }

    public final void addChildrenAfter(@Nullable Node children, @Nullable Node node) {
        Node nodeAfter;
        if (children == null) {
            return;
        }
        Preconditions.checkArgument((node == null || node.parent == this ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)children.previous, (Object)children);
        if (node == null) {
            this.addChildrenToFront(children);
            return;
        }
        Node child = children;
        while (child != null) {
            Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
            child.parent = this;
            child = child.next;
        }
        Node lastSibling = children.previous;
        lastSibling.next = nodeAfter = node.next;
        if (nodeAfter == null) {
            this.first.previous = lastSibling;
        } else {
            nodeAfter.previous = lastSibling;
        }
        node.next = children;
        children.previous = node;
    }

    public final void replaceWith(Node replacement) {
        this.checkAttached();
        replacement.checkDetached();
        Node existingParent = this.parent;
        Node existingNext = this.next;
        Node existingPrevious = this.previous;
        replacement.srcrefIfMissing(this);
        this.parent = null;
        replacement.parent = existingParent;
        this.previous = null;
        replacement.previous = existingPrevious;
        if (existingPrevious.next == null) {
            existingParent.first = replacement;
        } else {
            existingPrevious.next = replacement;
        }
        if (existingNext == null) {
            existingParent.first.previous = replacement;
        } else {
            this.next = null;
            existingNext.previous = replacement;
            replacement.next = existingNext;
        }
    }

    public final Node detach() {
        this.checkAttached();
        Node existingParent = this.parent;
        Node existingNext = this.next;
        Node existingPrevious = this.previous;
        this.parent = null;
        if (existingNext == null) {
            existingParent.first.previous = existingPrevious;
        } else {
            this.next = null;
            existingNext.previous = existingPrevious;
        }
        this.previous = null;
        if (existingPrevious.next == null) {
            existingParent.first = existingNext;
        } else {
            existingPrevious.next = existingNext;
        }
        return this;
    }

    private final void checkAttached() {
        Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (String)"Has no parent: %s", (Object)this);
    }

    private final void checkDetached() {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (String)"Has parent: %s", (Object)this);
        Preconditions.checkState((this.next == null ? 1 : 0) != 0, (String)"Has next: %s", (Object)this);
        Preconditions.checkState((this.previous == null ? 1 : 0) != 0, (String)"Has previous: %s", (Object)this);
    }

    public final @Nullable Node removeFirstChild() {
        Node child = this.first;
        if (child != null) {
            child.detach();
        }
        return child;
    }

    public final @Nullable Node removeChildren() {
        Node children = this.first;
        Node child = this.first;
        while (child != null) {
            child.parent = null;
            child = child.next;
        }
        this.first = null;
        return children;
    }

    public final void detachChildren() {
        Node child = this.first;
        while (child != null) {
            Node nextChild = child.next;
            child.parent = null;
            child.next = null;
            child.previous = null;
            child = nextChild;
        }
        this.first = null;
    }

    @VisibleForTesting
    final @Nullable PropListItem lookupProperty(Prop prop) {
        byte propType = (byte)prop.ordinal();
        PropListItem x = this.propListHead;
        while (x != null && propType != x.propType) {
            x = x.next;
        }
        return x;
    }

    public final Node clonePropsFrom(Node other) {
        Preconditions.checkState((this.propListHead == null ? 1 : 0) != 0, (Object)"Node has existing properties.");
        this.propListHead = other.propListHead;
        return this;
    }

    public void validateProperties(Consumer<String> violationMessageConsumer) {
        if (this.propListHead == null) {
            return;
        }
        if (this.token == Token.ROOT) {
            violationMessageConsumer.accept("ROOT has properties");
        }
        PropListItem propListItem = this.propListHead;
        while (propListItem != null) {
            Prop prop = PROP_VALUES[propListItem.propType];
            Preconditions.checkState((prop.ordinal() == propListItem.propType ? 1 : 0) != 0, (String)"ordinal doesn't match: %s", (Object)((Object)prop));
            switch (prop) {
                case IS_PARENTHESIZED: {
                    if (IR.mayBeExpression(this)) break;
                    violationMessageConsumer.accept("non-expression is parenthesized");
                    break;
                }
                case ARROW_FN: {
                    if (this.isFunction()) break;
                    violationMessageConsumer.accept("invalid ARROW_FN prop");
                    break;
                }
                case ASYNC_FN: {
                    if (this.isFunction()) break;
                    violationMessageConsumer.accept("invalid ASYNC_FN prop");
                    break;
                }
                case SYNTHETIC: {
                    if (this.isBlock()) break;
                    violationMessageConsumer.accept("invalid SYNTHETIC prop");
                    break;
                }
                case COLOR_FROM_CAST: {
                    if (this.getColor() != null) break;
                    violationMessageConsumer.accept("COLOR_FROM_CAST with no Color");
                    break;
                }
                case START_OF_OPT_CHAIN: {
                    if (this.isOptChainCall() || this.isOptChainGetElem() || this.isOptChainGetProp()) break;
                    violationMessageConsumer.accept("START_OF_OPT_CHAIN on non-optional Node");
                    break;
                }
                case CONSTANT_VAR_FLAGS: {
                    if (this.isName() || this.isImportStar()) break;
                    violationMessageConsumer.accept("invalid CONST_VAR_FLAGS");
                    break;
                }
                case SYNTHESIZED_UNFULFILLED_NAME_DECLARATION: {
                    if (this.isVar() && this.hasOneChild() && this.getFirstChild().isName()) break;
                    violationMessageConsumer.accept("Expected all synthetic unfulfilled declarations to be `var <name>`");
                    break;
                }
            }
            propListItem = propListItem.next;
        }
    }

    private static @Nullable PropListItem rebuildListWithoutProp(@Nullable PropListItem item, Prop prop) {
        if (item == null) {
            return null;
        }
        if (item.propType == prop.ordinal()) {
            return item.next;
        }
        PropListItem result = Node.rebuildListWithoutProp(item.next, prop);
        return result == item.next ? item : item.chain(result);
    }

    public final @Nullable Object getProp(Prop propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return null;
        }
        return item.getObjectValue();
    }

    public final boolean getBooleanProp(Prop propType) {
        return this.getIntProp(propType) != 0;
    }

    private int getIntProp(Prop propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return 0;
        }
        return item.getIntValue();
    }

    public final void putProp(Prop prop, @Nullable Object value) {
        this.propListHead = Node.rebuildListWithoutProp(this.propListHead, prop);
        if (value != null) {
            this.propListHead = new ObjectPropListItem((byte)prop.ordinal(), value, this.propListHead);
        }
    }

    public final void putBooleanProp(Prop propType, boolean value) {
        this.putIntProp(propType, value ? 1 : 0);
    }

    public final void putIntProp(Prop prop, int value) {
        this.propListHead = Node.rebuildListWithoutProp(this.propListHead, prop);
        if (value != 0) {
            this.propListHead = new IntPropListItem((byte)prop.ordinal(), value, this.propListHead);
        }
    }

    static long nodePropertyToBit(NodeProperty prop) {
        return 1L << prop.getNumber();
    }

    static long setNodePropertyBit(long bitset, NodeProperty prop) {
        return bitset | Node.nodePropertyToBit(prop);
    }

    static long removeNodePropertyBit(long bitset, NodeProperty prop) {
        return bitset & (Node.nodePropertyToBit(prop) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static boolean hasNodePropertyBitSet(long bitset, NodeProperty prop) {
        return (bitset & Node.nodePropertyToBit(prop)) != 0L;
    }

    static boolean hasBitSet(long bitset, int bit) {
        return (bitset & 1L << bit) != 0L;
    }

    public final long serializeProperties() {
        long propSet = 0L;
        PropListItem propListItem = this.propListHead;
        while (propListItem != null) {
            Prop prop = PROP_VALUES[propListItem.propType];
            switch (prop) {
                case TYPE_BEFORE_CAST: {
                    propSet = Node.setNodePropertyBit(propSet, NodeProperty.COLOR_FROM_CAST);
                    break;
                }
                case CONSTANT_VAR_FLAGS: {
                    int intVal = propListItem.getIntValue();
                    if (Node.anyBitSet(intVal, 2)) {
                        propSet = Node.setNodePropertyBit(propSet, NodeProperty.IS_INFERRED_CONSTANT);
                    }
                    if (!Node.anyBitSet(intVal, 1)) break;
                    propSet = Node.setNodePropertyBit(propSet, NodeProperty.IS_DECLARED_CONSTANT);
                    break;
                }
                case SIDE_EFFECT_FLAGS: {
                    propSet = this.setNodePropertySideEffectFlags(propSet, propListItem.getIntValue());
                    break;
                }
                default: {
                    NodeProperty nodeProperty;
                    if (!(propListItem instanceof IntPropListItem) || (nodeProperty = PropTranslator.serialize(prop)) == null) break;
                    propSet = Node.setNodePropertyBit(propSet, nodeProperty);
                }
            }
            propListItem = propListItem.next;
        }
        return propSet;
    }

    private long setNodePropertySideEffectFlags(long propSet, int sideEffectFlags) {
        if (Node.anyBitSet(sideEffectFlags, 1)) {
            propSet = Node.setNodePropertyBit(propSet, NodeProperty.MUTATES_GLOBAL_STATE);
        }
        if (Node.anyBitSet(sideEffectFlags, 2)) {
            propSet = Node.setNodePropertyBit(propSet, NodeProperty.MUTATES_THIS);
        }
        if (Node.anyBitSet(sideEffectFlags, 4)) {
            propSet = Node.setNodePropertyBit(propSet, NodeProperty.MUTATES_ARGUMENTS);
        }
        if (Node.anyBitSet(sideEffectFlags, 8)) {
            propSet = Node.setNodePropertyBit(propSet, NodeProperty.THROWS);
        }
        return propSet;
    }

    public final void deserializeProperties(long propSet) {
        if (this.isRoot()) {
            Preconditions.checkState((this.propListHead == null ? 1 : 0) != 0, (Object)this.propListHead);
        } else {
            Preconditions.checkState((this.propListHead.propType == Prop.SOURCE_FILE.ordinal() ? 1 : 0) != 0, (Object)this.propListHead);
        }
        int constantVarFlags = 0;
        int sideEffectFlags = 0;
        block8: for (int i = 0; i < 63; ++i) {
            if (!Node.hasBitSet(propSet, i)) continue;
            NodeProperty nodeProperty = NodeProperty.forNumber(i);
            switch (nodeProperty) {
                case IS_DECLARED_CONSTANT: {
                    constantVarFlags |= 1;
                    continue block8;
                }
                case IS_INFERRED_CONSTANT: {
                    constantVarFlags |= 2;
                    continue block8;
                }
                case MUTATES_GLOBAL_STATE: {
                    sideEffectFlags |= 1;
                    continue block8;
                }
                case MUTATES_THIS: {
                    sideEffectFlags |= 2;
                    continue block8;
                }
                case MUTATES_ARGUMENTS: {
                    sideEffectFlags |= 4;
                    continue block8;
                }
                case THROWS: {
                    sideEffectFlags |= 8;
                    continue block8;
                }
                default: {
                    Prop prop = PropTranslator.deserialize(nodeProperty);
                    if (prop == null) {
                        throw new IllegalStateException("Can not translate " + nodeProperty + " to AST Prop");
                    }
                    this.propListHead = new IntPropListItem((byte)prop.ordinal(), 1, this.propListHead);
                }
            }
        }
        if (constantVarFlags != 0) {
            this.propListHead = new IntPropListItem((byte)Prop.CONSTANT_VAR_FLAGS.ordinal(), constantVarFlags, this.propListHead);
        }
        if (sideEffectFlags != 0) {
            this.propListHead = new IntPropListItem((byte)Prop.SIDE_EFFECT_FLAGS.ordinal(), sideEffectFlags, this.propListHead);
        }
        this.validateProperties(errorMessage -> Preconditions.checkState((errorMessage != null ? 1 : 0) != 0, (String)"deserialize error: %s: %s", (Object)errorMessage, (Object)this));
    }

    public final void setDeclaredTypeExpression(Node typeExpression) {
        this.putProp(Prop.DECLARED_TYPE_EXPR, typeExpression);
    }

    public final @Nullable Node getDeclaredTypeExpression() {
        return (Node)this.getProp(Prop.DECLARED_TYPE_EXPR);
    }

    public final void setJSTypeBeforeCast(JSType type) {
        this.putProp(Prop.TYPE_BEFORE_CAST, type);
    }

    public final @Nullable JSType getJSTypeBeforeCast() {
        return (JSType)this.getProp(Prop.TYPE_BEFORE_CAST);
    }

    public final void setColorFromTypeCast() {
        Preconditions.checkState((this.getColor() != null ? 1 : 0) != 0, (Object)"Only use on nodes with colors present");
        this.putBooleanProp(Prop.COLOR_FROM_CAST, true);
    }

    public final boolean isColorFromTypeCast() {
        return this.getBooleanProp(Prop.COLOR_FROM_CAST);
    }

    private byte[] getSortedPropTypes() {
        int count = 0;
        PropListItem x = this.propListHead;
        while (x != null) {
            ++count;
            x = x.next;
        }
        byte[] keys = new byte[count];
        PropListItem x2 = this.propListHead;
        while (x2 != null) {
            keys[--count] = x2.propType;
            x2 = x2.next;
        }
        Arrays.sort(keys);
        return keys;
    }

    public final double getDouble() {
        return ((NumberNode)this).number;
    }

    public final void setDouble(double x) {
        Preconditions.checkState((!Double.isNaN(x) ? 1 : 0) != 0, (Object)x);
        Preconditions.checkState((boolean)JSCompDoubles.isPositive(x), (Object)x);
        ((NumberNode)this).number = x;
    }

    public final BigInteger getBigInt() {
        return ((BigIntNode)this).bigint;
    }

    public final void setBigInt(BigInteger number) {
        Preconditions.checkNotNull((Object)number);
        Preconditions.checkState((number.signum() >= 0 ? 1 : 0) != 0, (Object)number);
        ((BigIntNode)this).bigint = number;
    }

    public final String getString() {
        return ((StringNode)this).str;
    }

    public final void setString(String str) {
        ((StringNode)this).str = RhinoStringPool.addOrGet(str);
    }

    public final String getRawString() {
        return ((TemplateLiteralSubstringNode)this).raw;
    }

    public final @Nullable String getCookedString() {
        return ((TemplateLiteralSubstringNode)this).cooked;
    }

    public final String toString() {
        return this.toString(true, true, true);
    }

    public final String toString(boolean printSource, boolean printAnnotations, boolean printType) {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, printSource, printAnnotations, printType);
        return sb.toString();
    }

    private void toString(StringBuilder sb, boolean printSource, boolean printAnnotations, boolean printType) {
        String typeString;
        sb.append((Object)this.token);
        if (this instanceof StringNode) {
            sb.append(' ');
            sb.append(this.getString());
        } else if (this.token == Token.FUNCTION) {
            sb.append(' ');
            if (this.first == null || this.first.token != Token.NAME) {
                sb.append("<invalid>");
            } else {
                sb.append(this.first.getString());
            }
        } else if (this.token == Token.NUMBER) {
            sb.append(' ');
            sb.append(this.getDouble());
        }
        if (printSource) {
            int lineno = this.getLineno();
            if (lineno != -1) {
                sb.append(' ');
                sb.append(lineno);
                sb.append(':');
                sb.append(this.getCharno());
                sb.append(' ');
            }
            if (this.length != 0) {
                sb.append(" [length: ");
                sb.append(this.length);
                sb.append(']');
            }
        }
        if (printAnnotations) {
            byte[] keys = this.getSortedPropTypes();
            for (int i = 0; i < keys.length; ++i) {
                Prop type = PROP_VALUES[keys[i]];
                PropListItem x = this.lookupProperty(type);
                sb.append(" [");
                sb.append(Ascii.toLowerCase((String)String.valueOf((Object)type)));
                sb.append(": ");
                sb.append(x);
                sb.append(']');
            }
            if (this.originalName != null) {
                sb.append(" [original_name: ");
                sb.append(this.originalName);
                sb.append(']');
            }
        }
        if (printType && this.jstypeOrColor != null && (typeString = this.jstypeOrColor.toString()) != null) {
            sb.append(" : ");
            sb.append(typeString);
        }
    }

    private static String createJsonPair(String name, String value) {
        return "\"" + name + "\":\"" + value + "\"";
    }

    private static String createJsonPairRawValue(String name, String value) {
        return "\"" + name + "\":" + value;
    }

    private void toJson(Appendable sb) throws IOException {
        String typeString;
        byte[] keys;
        sb.append('{');
        sb.append(Node.createJsonPair("token", this.token.toString()));
        if (this instanceof StringNode) {
            sb.append(',');
            sb.append(Node.createJsonPair("string", this.getString()));
        } else if (this.token == Token.FUNCTION) {
            sb.append(',');
            if (this.first == null || this.first.token != Token.NAME) {
                sb.append(Node.createJsonPair("functionName", "<invalid>"));
            } else {
                sb.append(Node.createJsonPair("functionName", this.first.getString()));
            }
        } else if (this.token == Token.NUMBER) {
            sb.append(',');
            sb.append(Node.createJsonPair("number", String.valueOf(this.getDouble())));
        }
        int lineno = this.getLineno();
        if (lineno != -1) {
            sb.append(',');
            sb.append("\"sourceLocation\":{");
            sb.append(Node.createJsonPairRawValue("line", String.valueOf(lineno)));
            sb.append(',');
            sb.append(Node.createJsonPairRawValue("col", String.valueOf(this.getCharno())));
            if (this.length != 0) {
                sb.append(',');
                sb.append(Node.createJsonPairRawValue("length", String.valueOf(this.length)));
            }
            sb.append("}");
        }
        if (this.originalName != null) {
            sb.append(",");
            sb.append(Node.createJsonPair("original_name", this.originalName));
        }
        if ((keys = this.getSortedPropTypes()).length != 0) {
            sb.append(",");
            sb.append("\"props\":{");
            for (int i = 0; i < keys.length; ++i) {
                Prop type = PROP_VALUES[keys[i]];
                PropListItem x = this.lookupProperty(type);
                sb.append(Node.createJsonPair(Ascii.toLowerCase((String)String.valueOf((Object)type)), x.toString().replace("\n", "\\n").replace("\"", "\\\"")));
                if (i + 1 >= keys.length) continue;
                sb.append(',');
            }
            sb.append("}");
        }
        if (this.jstypeOrColor != null && (typeString = this.jstypeOrColor.toString()) != null) {
            sb.append(',');
            sb.append(Node.createJsonPair("typeString", typeString.replace("\"", "\\\"")));
        }
        if (this.first != null) {
            sb.append(',');
            sb.append("\"children\":[");
            Node child = this.first;
            while (child != null) {
                child.toJson(sb);
                if (child.next != null) {
                    sb.append(',');
                }
                child = child.next;
            }
            sb.append("]");
        }
        sb.append('}');
    }

    @CheckReturnValue
    public final String toStringTree() {
        return this.toStringTreeImpl();
    }

    private String toStringTreeImpl() {
        try {
            StringBuilder s = new StringBuilder();
            this.appendStringTree(s);
            return s.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen\n" + e);
        }
    }

    public final void appendStringTree(Appendable appendable) throws IOException {
        Node.toStringTreeHelper(this, 0, appendable);
    }

    private static void toStringTreeHelper(Node n, int level, Appendable sb) throws IOException {
        for (int i = 0; i != level; ++i) {
            sb.append("    ");
        }
        sb.append(n.toString());
        sb.append('\n');
        Node cursor = n.first;
        while (cursor != null) {
            Node.toStringTreeHelper(cursor, level + 1, sb);
            cursor = cursor.next;
        }
    }

    public final void appendJsonTree(Appendable appendable) throws IOException {
        Node.toJsonTreeHelper(this, appendable);
    }

    private static void toJsonTreeHelper(Node n, Appendable sb) throws IOException {
        n.toJson(sb);
    }

    public final void setStaticSourceFileFrom(Node other) {
        if (other.propListHead != null && (this.propListHead == null || this.propListHead.propType == Prop.SOURCE_FILE.ordinal() && this.propListHead.next == null)) {
            PropListItem tail = other.propListHead;
            while (tail.next != null) {
                tail = tail.next;
            }
            if (tail.propType == Prop.SOURCE_FILE.ordinal()) {
                this.propListHead = tail;
                return;
            }
        }
        this.setStaticSourceFile(other.getStaticSourceFile());
    }

    public final Node setStaticSourceFile(@Nullable StaticSourceFile file) {
        this.putProp(Prop.SOURCE_FILE, file);
        return this;
    }

    public final void setSourceFileForTesting(String name) {
        this.putProp(Prop.SOURCE_FILE, new SimpleSourceFile(name, StaticSourceFile.SourceKind.STRONG));
    }

    public @Nullable String getSourceFileName() {
        StaticSourceFile file = this.getStaticSourceFile();
        return file == null ? null : file.getName();
    }

    public @Nullable StaticSourceFile getStaticSourceFile() {
        return (StaticSourceFile)this.getProp(Prop.SOURCE_FILE);
    }

    public void setInputId(InputId inputId) {
        this.putProp(Prop.INPUT_ID, inputId);
    }

    public @Nullable InputId getInputId() {
        return (InputId)this.getProp(Prop.INPUT_ID);
    }

    @Deprecated
    public final @Nullable String getOriginalName() {
        return this.originalName;
    }

    public final void setOriginalName(String s) {
        this.originalName = s == null ? null : RhinoStringPool.addOrGet(s);
    }

    public final boolean isIndexable() {
        return !this.getBooleanProp(Prop.NON_INDEXABLE);
    }

    public final void makeNonIndexable() {
        this.putBooleanProp(Prop.NON_INDEXABLE, true);
    }

    public final void makeNonIndexableRecursive() {
        this.makeNonIndexable();
        for (Node child = this.first; child != null; child = child.getNext()) {
            child.makeNonIndexableRecursive();
        }
    }

    public final boolean isFromExterns() {
        StaticSourceFile file = this.getStaticSourceFile();
        return file == null ? false : file.isExtern();
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int length) {
        this.length = length;
    }

    public final int getLineno() {
        if (this.linenoCharno == -1) {
            return -1;
        }
        return this.linenoCharno >>> 12;
    }

    public final int getCharno() {
        if (this.linenoCharno == -1) {
            return -1;
        }
        return this.linenoCharno & 0xFFF;
    }

    public final String getLocation() {
        return this.getSourceFileName() + ":" + this.getLineno() + ":" + this.getCharno();
    }

    public int getSourceOffset() {
        StaticSourceFile file = this.getStaticSourceFile();
        if (file == null) {
            return -1;
        }
        int lineno = this.getLineno();
        if (lineno == -1) {
            return -1;
        }
        return file.getLineOffset(lineno) + this.getCharno();
    }

    public final int getSourcePosition() {
        return this.linenoCharno;
    }

    public final Node setLinenoCharno(int lineno, int charno) {
        if (lineno < 0 || charno < 0) {
            this.linenoCharno = -1;
            return this;
        }
        if (charno > 4095) {
            charno = 4095;
        }
        this.linenoCharno = lineno << 12 | charno;
        return this;
    }

    @Deprecated
    public final Iterable<Node> children() {
        if (this.first == null) {
            return Collections.emptySet();
        }
        return new SiblingNodeIterable(this.first);
    }

    final @Nullable PropListItem getPropListHeadForTesting() {
        return this.propListHead;
    }

    final void setPropListHead(@Nullable PropListItem propListHead) {
        this.propListHead = propListHead;
    }

    public final @Nullable Node getParent() {
        return this.parent;
    }

    public final boolean hasParent() {
        return this.parent != null;
    }

    public final @Nullable Node getGrandparent() {
        return this.parent == null ? null : this.parent.parent;
    }

    public final @Nullable Node getAncestor(int level) {
        Node node;
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0);
        for (node = this; node != null && level-- > 0; node = node.getParent()) {
        }
        return node;
    }

    public final boolean isDescendantOf(Node node) {
        Node n = this;
        while (n != null) {
            if (n == node) {
                return true;
            }
            n = n.parent;
        }
        return false;
    }

    public final boolean isOnlyChildOf(Node possibleParent) {
        return possibleParent == this.getParent() && this.getPrevious() == null && this.getNext() == null;
    }

    public final boolean isFirstChildOf(Node possibleParent) {
        return possibleParent == this.getParent() && this.getPrevious() == null;
    }

    public final boolean isSecondChildOf(Node possibleParent) {
        Node previousNode = this.getPrevious();
        return previousNode != null && previousNode.isFirstChildOf(possibleParent);
    }

    public final AncestorIterable getAncestors() {
        return new AncestorIterable(this.getParent());
    }

    public final boolean hasOneChild() {
        return this.first != null && this.first.next == null;
    }

    public final boolean hasTwoChildren() {
        return this.first != null && this.first.next != null && this.first.next == this.getLastChild();
    }

    public final boolean hasZeroOrOneChild() {
        return this.first == this.getLastChild();
    }

    public final boolean hasMoreThanOneChild() {
        return this.first != null && this.first.next != null;
    }

    public final boolean hasXChildren(int x) {
        int c;
        Node n = this.first;
        for (c = 0; n != null && c <= x; ++c) {
            n = n.next;
        }
        return c == x;
    }

    public final int getChildCount() {
        int c = 0;
        Node n = this.first;
        while (n != null) {
            ++c;
            n = n.next;
        }
        return c;
    }

    public final boolean hasChild(Node child) {
        Node n = this.first;
        while (n != null) {
            if (child == n) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    public final boolean isEquivalentToShallow(Node node) {
        return this.isEquivalentTo(node, false, false, false, false);
    }

    public final boolean isEquivalentWithSideEffectsTo(Node node) {
        return this.isEquivalentTo(node, false, true, false, true);
    }

    public final boolean isEquivalentWithSideEffectsToShallow(Node node) {
        return this.isEquivalentTo(node, false, false, false, true);
    }

    public final boolean isEquivalentToTyped(Node node) {
        return this.isEquivalentTo(node, true, true, true, false);
    }

    public final boolean isEquivalentTo(Node node) {
        return this.isEquivalentTo(node, false, true, false, false);
    }

    final boolean isEquivalentTo(Node node, boolean compareType, boolean recurse, boolean jsDoc) {
        return this.isEquivalentTo(node, compareType, recurse, jsDoc, false);
    }

    public boolean isEquivalentTo(Node node, boolean compareType, boolean recurse, boolean jsDoc, boolean sideEffect) {
        Prop prop2;
        Node thatDte;
        if (this.token != node.token || this.getChildCount() != node.getChildCount() || this.getClass() != node.getClass()) {
            return false;
        }
        if (compareType && !Objects.equals(this.jstypeOrColor, node.jstypeOrColor)) {
            return false;
        }
        if (jsDoc && !JSDocInfo.areEquivalent(this.getJSDocInfo(), node.getJSDocInfo())) {
            return false;
        }
        Node thisDte = this.getDeclaredTypeExpression();
        if (thisDte != (thatDte = node.getDeclaredTypeExpression())) {
            if (thisDte == null || thatDte == null) {
                return false;
            }
            if (!thisDte.isEquivalentTo(thatDte, compareType, recurse, jsDoc)) {
                return false;
            }
        }
        EnumSet<Prop> propSet = EnumSet.noneOf(Prop.class);
        Object propListItem = this.propListHead;
        while (propListItem != null) {
            prop2 = PROP_VALUES[((PropListItem)propListItem).propType];
            propSet.add(prop2);
            propListItem = ((PropListItem)propListItem).next;
        }
        propListItem = node.propListHead;
        while (propListItem != null) {
            prop2 = PROP_VALUES[((PropListItem)propListItem).propType];
            propSet.add(prop2);
            propListItem = ((PropListItem)propListItem).next;
        }
        for (Prop prop2 : propSet) {
            Function getter;
            if (!PROP_MAP_FOR_EQUALITY_KEYS.contains((Object)prop2) || Objects.equals((getter = (Function)PROP_MAP_FOR_EQUALITY.get((Object)prop2)).apply(this), getter.apply(node))) continue;
            return false;
        }
        if (sideEffect) {
            if (this.getSideEffectFlags() != node.getSideEffectFlags()) {
                return false;
            }
            if (this.isUnusedParameter() != node.isUnusedParameter()) {
                return false;
            }
        }
        if (recurse) {
            Node n = this.first;
            Node n2 = node.first;
            while (n != null) {
                if (!n.isEquivalentTo(n2, compareType, recurse, jsDoc, sideEffect)) {
                    return false;
                }
                n = n.next;
                n2 = n2.next;
            }
        }
        return true;
    }

    public final @Nullable String getQualifiedName() {
        switch (this.token) {
            case NAME: {
                String name = this.getString();
                return name.isEmpty() ? null : name;
            }
            case GETPROP: {
                StringBuilder builder = this.getQualifiedNameForGetProp(0);
                return builder != null ? builder.toString() : null;
            }
            case THIS: {
                return "this";
            }
            case SUPER: {
                return "super";
            }
        }
        return null;
    }

    public final @Nullable QualifiedName getQualifiedNameObject() {
        return this.isQualifiedName() ? new QualifiedName.NodeQname(this) : null;
    }

    private @Nullable StringBuilder getQualifiedNameForGetProp(int reserve) {
        StringBuilder builder;
        String propName = this.getString();
        reserve += 1 + propName.length();
        if (this.first.isGetProp()) {
            builder = this.first.getQualifiedNameForGetProp(reserve);
            if (builder == null) {
                return null;
            }
        } else {
            String left = this.first.getQualifiedName();
            if (left == null) {
                return null;
            }
            builder = new StringBuilder(left.length() + reserve);
            builder.append(left);
        }
        builder.append('.').append(propName);
        return builder;
    }

    @Deprecated
    public final @Nullable String getOriginalQualifiedName() {
        if (this.token == Token.NAME) {
            String name = this.getOriginalName();
            if (name == null) {
                name = this.getString();
            }
            return name.isEmpty() ? null : name;
        }
        if (this.token == Token.GETPROP) {
            String left = this.getFirstChild().getOriginalQualifiedName();
            if (left == null) {
                return null;
            }
            String right = this.getOriginalName();
            if (right == null) {
                right = this.getString();
            }
            return left + "." + right;
        }
        if (this.token == Token.THIS) {
            return "this";
        }
        if (this.token == Token.SUPER) {
            return "super";
        }
        return null;
    }

    public final boolean isQualifiedName() {
        switch (this.getToken()) {
            case NAME: {
                return !this.getString().isEmpty();
            }
            case THIS: 
            case SUPER: {
                return true;
            }
            case GETPROP: {
                return this.getFirstChild().isQualifiedName();
            }
        }
        return false;
    }

    public final boolean matchesName(String name) {
        if (this.token != Token.NAME) {
            return false;
        }
        String internalString = this.getString();
        return !internalString.isEmpty() && name.equals(internalString);
    }

    public final boolean matchesName(Node n) {
        if (this.token != Token.NAME || n.token != Token.NAME) {
            return false;
        }
        String internalString = this.getString();
        return !internalString.isEmpty() && RhinoStringPool.uncheckedEquals(internalString, n.getString());
    }

    public final boolean matchesQualifiedName(String name) {
        return this.matchesQualifiedName(name, name.length());
    }

    private boolean matchesQualifiedName(String qname, int endIndex) {
        int start = qname.lastIndexOf(46, endIndex - 1) + 1;
        switch (this.getToken()) {
            case NAME: 
            case IMPORT_STAR: {
                String name = this.getString();
                return start == 0 && !name.isEmpty() && name.length() == endIndex && qname.startsWith(name);
            }
            case THIS: {
                return start == 0 && 4 == endIndex && qname.startsWith("this");
            }
            case SUPER: {
                return start == 0 && 5 == endIndex && qname.startsWith("super");
            }
            case GETPROP: {
                String prop = this.getString();
                return start > 1 && prop.length() == endIndex - start && prop.regionMatches(0, qname, start, endIndex - start) && this.getFirstChild().matchesQualifiedName(qname, start - 1);
            }
        }
        return false;
    }

    public final boolean matchesQualifiedName(Node n) {
        if (n.token != this.token) {
            return false;
        }
        switch (this.token) {
            case NAME: {
                return this.matchesName(n);
            }
            case THIS: 
            case SUPER: {
                return true;
            }
            case GETPROP: {
                return RhinoStringPool.uncheckedEquals(this.getString(), n.getString()) && this.getFirstChild().matchesQualifiedName(n.getFirstChild());
            }
        }
        return false;
    }

    public final boolean isUnscopedQualifiedName() {
        switch (this.getToken()) {
            case NAME: {
                return !this.getString().isEmpty();
            }
            case GETPROP: {
                return this.getFirstChild().isUnscopedQualifiedName();
            }
        }
        return false;
    }

    public final boolean isValidAssignmentTarget() {
        switch (this.getToken()) {
            case NAME: 
            case GETPROP: 
            case GETELEM: 
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                return true;
            }
        }
        return false;
    }

    @DoNotCall
    @GwtIncompatible
    public final Object clone() {
        throw new UnsupportedOperationException("Did you mean cloneNode?");
    }

    @CheckReturnValue
    public final Node cloneNode() {
        return this.cloneNode(false);
    }

    @CheckReturnValue
    Node cloneNode(boolean cloneTypeExprs) {
        Node clone = new Node(this.token);
        Node.copyBaseNodeFields(this, clone, cloneTypeExprs);
        return clone;
    }

    private static void copyBaseNodeFields(Node source, Node dest, boolean cloneTypeExprs) {
        JSDocInfo info;
        dest.linenoCharno = source.linenoCharno;
        dest.length = source.length;
        dest.jstypeOrColor = source.jstypeOrColor;
        dest.originalName = source.originalName;
        dest.propListHead = source.propListHead;
        if (cloneTypeExprs && (info = source.getJSDocInfo()) != null) {
            dest.setJSDocInfo(info.clone(true));
        }
    }

    @CheckReturnValue
    public final Node cloneTree() {
        return this.cloneTree(false);
    }

    @CheckReturnValue
    public final Node cloneTree(boolean cloneTypeExprs) {
        Node result = this.cloneNode(cloneTypeExprs);
        Node firstChild = null;
        Node lastChild = null;
        if (this.hasChildren()) {
            Node n2 = this.getFirstChild();
            while (n2 != null) {
                Node n2clone = n2.cloneTree(cloneTypeExprs);
                n2clone.parent = result;
                if (firstChild == null) {
                    lastChild = firstChild = n2clone;
                } else {
                    lastChild.next = n2clone;
                    n2clone.previous = lastChild;
                    lastChild = n2clone;
                }
                n2 = n2.next;
            }
            firstChild.previous = lastChild;
            lastChild.next = null;
            result.first = firstChild;
        }
        return result;
    }

    public final Node srcref(Node other) {
        this.setStaticSourceFileFrom(other);
        this.originalName = other.originalName;
        this.linenoCharno = other.linenoCharno;
        this.length = other.length;
        return this;
    }

    public final Node srcrefTree(Node other) {
        this.srcref(other);
        Node child = this.first;
        while (child != null) {
            child.srcrefTree(other);
            child = child.next;
        }
        return this;
    }

    public final Node srcrefIfMissing(Node other) {
        if (this.getStaticSourceFile() == null) {
            this.setStaticSourceFileFrom(other);
            this.linenoCharno = other.linenoCharno;
            this.length = other.length;
        }
        if (this.originalName == null) {
            this.originalName = other.originalName;
        }
        return this;
    }

    public final Node srcrefTreeIfMissing(Node other) {
        this.srcrefIfMissing(other);
        Node child = this.first;
        while (child != null) {
            child.srcrefTreeIfMissing(other);
            child = child.next;
        }
        return this;
    }

    public final @Nullable JSType getJSType() {
        return this.jstypeOrColor instanceof JSType ? (JSType)this.jstypeOrColor : null;
    }

    public final JSType getJSTypeRequired() {
        return (JSType)Preconditions.checkNotNull((Object)this.getJSType(), (String)"no jstypeOrColor: %s", (Object)this);
    }

    public final Node setJSType(@Nullable JSType x) {
        Preconditions.checkState((this.jstypeOrColor == null || this.jstypeOrColor instanceof JSType ? 1 : 0) != 0, (Object)this);
        this.jstypeOrColor = x;
        return this;
    }

    public final @Nullable Color getColor() {
        return this.jstypeOrColor instanceof Color ? (Color)this.jstypeOrColor : null;
    }

    public final Node setColor(@Nullable Color x) {
        Preconditions.checkState((this.jstypeOrColor == null || this.jstypeOrColor instanceof Color ? 1 : 0) != 0, (Object)this);
        this.jstypeOrColor = x;
        return this;
    }

    public final Node copyTypeFrom(Node other) {
        this.jstypeOrColor = other.jstypeOrColor;
        return this;
    }

    public final @Nullable JSDocInfo getJSDocInfo() {
        return (JSDocInfo)this.getProp(Prop.JSDOC_INFO);
    }

    public final Node setJSDocInfo(JSDocInfo info) {
        this.putProp(Prop.JSDOC_INFO, info);
        return this;
    }

    public final void setChangeTime(int time) {
        this.putIntProp(Prop.CHANGE_TIME, time);
    }

    public final int getChangeTime() {
        return this.getIntProp(Prop.CHANGE_TIME);
    }

    public final void setDeleted(boolean deleted) {
        this.putBooleanProp(Prop.DELETED, deleted);
    }

    public final boolean isDeleted() {
        return this.getBooleanProp(Prop.DELETED);
    }

    public final void setTypedefTypeProp(JSType type) {
        this.putProp(Prop.TYPEDEF_TYPE, type);
    }

    public final JSType getTypedefTypeProp() {
        return (JSType)this.getProp(Prop.TYPEDEF_TYPE);
    }

    public final void setUnusedParameter(boolean unused) {
        this.putBooleanProp(Prop.IS_UNUSED_PARAMETER, unused);
    }

    public final boolean isUnusedParameter() {
        return this.getBooleanProp(Prop.IS_UNUSED_PARAMETER);
    }

    public final void setShorthandProperty(boolean shorthand) {
        this.putBooleanProp(Prop.IS_SHORTHAND_PROPERTY, shorthand);
    }

    public final boolean isShorthandProperty() {
        return this.getBooleanProp(Prop.IS_SHORTHAND_PROPERTY);
    }

    public final boolean isOptionalEs6Typed() {
        return this.getBooleanProp(Prop.OPT_ES6_TYPED);
    }

    public final void setIsSyntheticBlock(boolean val) {
        Preconditions.checkState((this.token == Token.BLOCK ? 1 : 0) != 0);
        this.putBooleanProp(Prop.SYNTHETIC, val);
    }

    public final boolean isSyntheticBlock() {
        return this.getBooleanProp(Prop.SYNTHETIC);
    }

    public final void setIsSynthesizedUnfulfilledNameDeclaration(boolean val) {
        Preconditions.checkState((this.token == Token.VAR && this.hasOneChild() && this.getFirstChild().isName() ? 1 : 0) != 0, (String)"Expected all synthetic unfulfilled declarations to be `var <name>`, found %s", (Object)this);
        this.putBooleanProp(Prop.SYNTHESIZED_UNFULFILLED_NAME_DECLARATION, val);
    }

    public final boolean isSynthesizedUnfulfilledNameDeclaration() {
        return this.getBooleanProp(Prop.SYNTHESIZED_UNFULFILLED_NAME_DECLARATION);
    }

    public final void setUseStrict(boolean x) {
        this.putBooleanProp(Prop.USE_STRICT, x);
    }

    public final boolean isUseStrict() {
        return this.getBooleanProp(Prop.USE_STRICT);
    }

    public final void setIsAddedBlock(boolean val) {
        this.putBooleanProp(Prop.ADDED_BLOCK, val);
    }

    public final boolean isAddedBlock() {
        return this.getBooleanProp(Prop.ADDED_BLOCK);
    }

    public final void setStaticMember(boolean isStatic) {
        this.putBooleanProp(Prop.STATIC_MEMBER, isStatic);
    }

    public final boolean isStaticMember() {
        return this.getBooleanProp(Prop.STATIC_MEMBER);
    }

    public final void setIsGeneratorFunction(boolean isGenerator) {
        this.putBooleanProp(Prop.GENERATOR_FN, isGenerator);
    }

    public final boolean isGeneratorFunction() {
        return this.getBooleanProp(Prop.GENERATOR_FN);
    }

    public final void setGeneratorMarker(boolean isGeneratorMarker) {
        this.putBooleanProp(Prop.IS_GENERATOR_MARKER, isGeneratorMarker);
    }

    public final boolean isGeneratorMarker() {
        return this.getBooleanProp(Prop.IS_GENERATOR_MARKER);
    }

    public final void setGeneratorSafe(boolean isGeneratorSafe) {
        this.putBooleanProp(Prop.IS_GENERATOR_SAFE, isGeneratorSafe);
    }

    public final boolean isGeneratorSafe() {
        return this.getBooleanProp(Prop.IS_GENERATOR_SAFE);
    }

    public final void setIsOptionalChainStart(boolean isOptionalChainStart) {
        Preconditions.checkState((!isOptionalChainStart || this.isOptChainGetElem() || this.isOptChainGetProp() || this.isOptChainCall() ? 1 : 0) != 0, (Object)"cannot make a non-optional node the start of an optional chain.");
        this.putBooleanProp(Prop.START_OF_OPT_CHAIN, isOptionalChainStart);
    }

    public final boolean isOptionalChainStart() {
        return this.getBooleanProp(Prop.START_OF_OPT_CHAIN);
    }

    public final void setIsArrowFunction(boolean isArrow) {
        Preconditions.checkState((boolean)this.isFunction());
        this.putBooleanProp(Prop.ARROW_FN, isArrow);
    }

    public final boolean isArrowFunction() {
        return this.isFunction() && this.getBooleanProp(Prop.ARROW_FN);
    }

    public void setIsAsyncFunction(boolean isAsync) {
        Preconditions.checkState((boolean)this.isFunction());
        this.putBooleanProp(Prop.ASYNC_FN, isAsync);
    }

    public final boolean isAsyncFunction() {
        return this.isFunction() && this.getBooleanProp(Prop.ASYNC_FN);
    }

    public final boolean isAsyncGeneratorFunction() {
        return this.isAsyncFunction() && this.isGeneratorFunction();
    }

    public final void setYieldAll(boolean isGenerator) {
        this.putBooleanProp(Prop.YIELD_ALL, isGenerator);
    }

    public final boolean isYieldAll() {
        return this.getBooleanProp(Prop.YIELD_ALL);
    }

    public final void setTrailingComma(boolean hasTrailingComma) {
        this.putBooleanProp(Prop.TRAILING_COMMA, hasTrailingComma);
    }

    public final boolean hasTrailingComma() {
        return this.getBooleanProp(Prop.TRAILING_COMMA);
    }

    public final void setSideEffectFlags(int flags) {
        Preconditions.checkState((this.isCall() || this.isOptChainCall() || this.isNew() || this.isTaggedTemplateLit() ? 1 : 0) != 0, (String)"Side-effect flags can only be set on invocation nodes; got %s", (Object)this);
        this.putIntProp(Prop.SIDE_EFFECT_FLAGS, ~flags & 0xF);
    }

    public final void setSideEffectFlags(SideEffectFlags flags) {
        this.setSideEffectFlags(flags.valueOf());
    }

    public final int getSideEffectFlags() {
        return ~this.getIntProp(Prop.SIDE_EFFECT_FLAGS) & 0xF;
    }

    public final boolean isOnlyModifiesThisCall() {
        int sideEffectsBesidesMutatesThis = this.getSideEffectFlags() & 0xFFFFFFFD;
        return sideEffectsBesidesMutatesThis == 0;
    }

    public final boolean isOnlyModifiesArgumentsCall() {
        int sideEffectsBesidesMutatesArguments = this.getSideEffectFlags() & 0xFFFFFFFB;
        return sideEffectsBesidesMutatesArguments == 0;
    }

    public final boolean isNoSideEffectsCall() {
        return this.getSideEffectFlags() == 0;
    }

    public final boolean mayMutateArguments() {
        return Node.allBitsSet(this.getSideEffectFlags(), 4);
    }

    public final boolean mayMutateGlobalStateOrThrow() {
        return Node.anyBitSet(this.getSideEffectFlags(), 9);
    }

    private static boolean allBitsSet(int value, int mask) {
        return (value & mask) == mask;
    }

    private static boolean anyBitSet(int value, int mask) {
        return (value & mask) != 0;
    }

    private final int getConstantVarFlags() {
        return this.getIntProp(Prop.CONSTANT_VAR_FLAGS);
    }

    private final void setConstantVarFlag(int flag, boolean value) {
        int flags = this.getConstantVarFlags();
        flags = value ? (flags |= flag) : (flags &= ~flag);
        this.putIntProp(Prop.CONSTANT_VAR_FLAGS, flags);
    }

    public final boolean isDeclaredConstantVar() {
        Preconditions.checkState((this.isName() || this.isImportStar() ? 1 : 0) != 0, (String)"Should only be called on name or import * nodes. Found %s", (Object)this);
        return Node.anyBitSet(this.getConstantVarFlags(), 1);
    }

    public final void setDeclaredConstantVar(boolean value) {
        Preconditions.checkState((this.isName() || this.isImportStar() ? 1 : 0) != 0, (String)"Should only be called on name or import * nodes. Found %s", (Object)this);
        this.setConstantVarFlag(1, value);
    }

    public final boolean isInferredConstantVar() {
        Preconditions.checkState((this.isName() || this.isImportStar() ? 1 : 0) != 0, (String)"Should only be called on name or import * nodes. Found %s", (Object)this);
        return Node.anyBitSet(this.getConstantVarFlags(), 2);
    }

    public final void setInferredConstantVar(boolean value) {
        Preconditions.checkState((this.isName() || this.isImportStar() ? 1 : 0) != 0, (String)"Should only be called on name or import * nodes. Found %s", (Object)this);
        this.setConstantVarFlag(2, value);
    }

    public final boolean isQuotedString() {
        return this instanceof StringNode && this.getBooleanProp(Prop.QUOTED);
    }

    public final void setQuotedString() {
        Preconditions.checkState((boolean)(this instanceof StringNode), (Object)this);
        this.putBooleanProp(Prop.QUOTED, true);
    }

    public final boolean isAdd() {
        return this.token == Token.ADD;
    }

    public final boolean isSub() {
        return this.token == Token.SUB;
    }

    public final boolean isAnd() {
        return this.token == Token.AND;
    }

    public final boolean isAssignAnd() {
        return this.token == Token.ASSIGN_AND;
    }

    public final boolean isArrayLit() {
        return this.token == Token.ARRAYLIT;
    }

    public final boolean isArrayPattern() {
        return this.token == Token.ARRAY_PATTERN;
    }

    public final boolean isAssign() {
        return this.token == Token.ASSIGN;
    }

    public final boolean isAssignAdd() {
        return this.token == Token.ASSIGN_ADD;
    }

    public final boolean isNormalBlock() {
        return this.isBlock();
    }

    public final boolean isBlock() {
        return this.token == Token.BLOCK;
    }

    public final boolean isRoot() {
        return this.token == Token.ROOT;
    }

    public final boolean isAwait() {
        return this.token == Token.AWAIT;
    }

    public final boolean isBigInt() {
        return this.token == Token.BIGINT;
    }

    public final boolean isBitNot() {
        return this.token == Token.BITNOT;
    }

    public final boolean isBreak() {
        return this.token == Token.BREAK;
    }

    public final boolean isCall() {
        return this.token == Token.CALL;
    }

    public final boolean isCase() {
        return this.token == Token.CASE;
    }

    public final boolean isCast() {
        return this.token == Token.CAST;
    }

    public final boolean isCatch() {
        return this.token == Token.CATCH;
    }

    public final boolean isClass() {
        return this.token == Token.CLASS;
    }

    public final boolean isClassMembers() {
        return this.token == Token.CLASS_MEMBERS;
    }

    public final boolean isComma() {
        return this.token == Token.COMMA;
    }

    public final boolean isComputedProp() {
        return this.token == Token.COMPUTED_PROP;
    }

    public final boolean isContinue() {
        return this.token == Token.CONTINUE;
    }

    public final boolean isConst() {
        return this.token == Token.CONST;
    }

    public final boolean isDebugger() {
        return this.token == Token.DEBUGGER;
    }

    public final boolean isDec() {
        return this.token == Token.DEC;
    }

    public final boolean isDefaultCase() {
        return this.token == Token.DEFAULT_CASE;
    }

    public final boolean isDefaultValue() {
        return this.token == Token.DEFAULT_VALUE;
    }

    public final boolean isDelProp() {
        return this.token == Token.DELPROP;
    }

    public final boolean isDestructuringLhs() {
        return this.token == Token.DESTRUCTURING_LHS;
    }

    public final boolean isDestructuringPattern() {
        return this.isObjectPattern() || this.isArrayPattern();
    }

    public final boolean isDo() {
        return this.token == Token.DO;
    }

    public final boolean isEmpty() {
        return this.token == Token.EMPTY;
    }

    public final boolean isExponent() {
        return this.token == Token.EXPONENT;
    }

    public final boolean isAssignExponent() {
        return this.token == Token.ASSIGN_EXPONENT;
    }

    public final boolean isExport() {
        return this.token == Token.EXPORT;
    }

    public final boolean isExportSpec() {
        return this.token == Token.EXPORT_SPEC;
    }

    public final boolean isExportSpecs() {
        return this.token == Token.EXPORT_SPECS;
    }

    public final boolean isExprResult() {
        return this.token == Token.EXPR_RESULT;
    }

    public final boolean isFalse() {
        return this.token == Token.FALSE;
    }

    public final boolean isVanillaFor() {
        return this.token == Token.FOR;
    }

    public final boolean isForIn() {
        return this.token == Token.FOR_IN;
    }

    public final boolean isForOf() {
        return this.token == Token.FOR_OF;
    }

    public final boolean isForAwaitOf() {
        return this.token == Token.FOR_AWAIT_OF;
    }

    public final boolean isFunction() {
        return this.token == Token.FUNCTION;
    }

    public final boolean isGetterDef() {
        return this.token == Token.GETTER_DEF;
    }

    public final boolean isGetElem() {
        return this.token == Token.GETELEM;
    }

    public final boolean isGetProp() {
        return this.token == Token.GETPROP;
    }

    public final boolean isHook() {
        return this.token == Token.HOOK;
    }

    public final boolean isIf() {
        return this.token == Token.IF;
    }

    public final boolean isImport() {
        return this.token == Token.IMPORT;
    }

    public final boolean isImportMeta() {
        return this.token == Token.IMPORT_META;
    }

    public final boolean isImportStar() {
        return this.token == Token.IMPORT_STAR;
    }

    public final boolean isImportSpec() {
        return this.token == Token.IMPORT_SPEC;
    }

    public final boolean isImportSpecs() {
        return this.token == Token.IMPORT_SPECS;
    }

    public final boolean isIn() {
        return this.token == Token.IN;
    }

    public final boolean isInc() {
        return this.token == Token.INC;
    }

    public final boolean isInstanceOf() {
        return this.token == Token.INSTANCEOF;
    }

    public final boolean isInterfaceMembers() {
        return this.token == Token.INTERFACE_MEMBERS;
    }

    public final boolean isRecordType() {
        return this.token == Token.RECORD_TYPE;
    }

    public final boolean isCallSignature() {
        return this.token == Token.CALL_SIGNATURE;
    }

    public final boolean isIndexSignature() {
        return this.token == Token.INDEX_SIGNATURE;
    }

    public final boolean isLabel() {
        return this.token == Token.LABEL;
    }

    public final boolean isLabelName() {
        return this.token == Token.LABEL_NAME;
    }

    public final boolean isLet() {
        return this.token == Token.LET;
    }

    public final boolean isMemberFunctionDef() {
        return this.token == Token.MEMBER_FUNCTION_DEF;
    }

    public final boolean isMemberVariableDef() {
        return this.token == Token.MEMBER_VARIABLE_DEF;
    }

    public final boolean isMemberFieldDef() {
        return this.token == Token.MEMBER_FIELD_DEF;
    }

    public final boolean isComputedFieldDef() {
        return this.token == Token.COMPUTED_FIELD_DEF;
    }

    public final boolean isModuleBody() {
        return this.token == Token.MODULE_BODY;
    }

    public final boolean isName() {
        return this.token == Token.NAME;
    }

    public final boolean isNE() {
        return this.token == Token.NE;
    }

    public final boolean isSHNE() {
        return this.token == Token.SHNE;
    }

    public final boolean isEQ() {
        return this.token == Token.EQ;
    }

    public final boolean isSHEQ() {
        return this.token == Token.SHEQ;
    }

    public final boolean isNeg() {
        return this.token == Token.NEG;
    }

    public final boolean isNew() {
        return this.token == Token.NEW;
    }

    public final boolean isNot() {
        return this.token == Token.NOT;
    }

    public final boolean isNull() {
        return this.token == Token.NULL;
    }

    public final boolean isNullishCoalesce() {
        return this.token == Token.COALESCE;
    }

    public final boolean isAssignNullishCoalesce() {
        return this.token == Token.ASSIGN_COALESCE;
    }

    public final boolean isNumber() {
        return this.token == Token.NUMBER;
    }

    public final boolean isObjectLit() {
        return this.token == Token.OBJECTLIT;
    }

    public final boolean isObjectPattern() {
        return this.token == Token.OBJECT_PATTERN;
    }

    public final boolean isOptChainCall() {
        return this.token == Token.OPTCHAIN_CALL;
    }

    public final boolean isOptChainGetElem() {
        return this.token == Token.OPTCHAIN_GETELEM;
    }

    public final boolean isOptChainGetProp() {
        return this.token == Token.OPTCHAIN_GETPROP;
    }

    public final boolean isOr() {
        return this.token == Token.OR;
    }

    public final boolean isAssignOr() {
        return this.token == Token.ASSIGN_OR;
    }

    public final boolean isParamList() {
        return this.token == Token.PARAM_LIST;
    }

    public final boolean isRegExp() {
        return this.token == Token.REGEXP;
    }

    public final boolean isRest() {
        return this.token == Token.ITER_REST || this.token == Token.OBJECT_REST;
    }

    public final boolean isObjectRest() {
        return this.token == Token.OBJECT_REST;
    }

    public final boolean isReturn() {
        return this.token == Token.RETURN;
    }

    public final boolean isScript() {
        return this.token == Token.SCRIPT;
    }

    public final boolean isSetterDef() {
        return this.token == Token.SETTER_DEF;
    }

    public final boolean isSpread() {
        return this.token == Token.ITER_SPREAD || this.token == Token.OBJECT_SPREAD;
    }

    public final boolean isString() {
        return this.token == Token.STRINGLIT;
    }

    public final boolean isStringKey() {
        return this.token == Token.STRING_KEY;
    }

    public final boolean isStringLit() {
        return this.token == Token.STRINGLIT;
    }

    public final boolean isSuper() {
        return this.token == Token.SUPER;
    }

    public final boolean isSwitch() {
        return this.token == Token.SWITCH;
    }

    public final boolean isTaggedTemplateLit() {
        return this.token == Token.TAGGED_TEMPLATELIT;
    }

    public final boolean isTemplateLit() {
        return this.token == Token.TEMPLATELIT;
    }

    public final boolean isTemplateLitString() {
        return this.token == Token.TEMPLATELIT_STRING;
    }

    public final boolean isTemplateLitSub() {
        return this.token == Token.TEMPLATELIT_SUB;
    }

    public final boolean isThis() {
        return this.token == Token.THIS;
    }

    public final boolean isThrow() {
        return this.token == Token.THROW;
    }

    public final boolean isTrue() {
        return this.token == Token.TRUE;
    }

    public final boolean isTry() {
        return this.token == Token.TRY;
    }

    public final boolean isTypeOf() {
        return this.token == Token.TYPEOF;
    }

    public final boolean isVar() {
        return this.token == Token.VAR;
    }

    public final boolean isVoid() {
        return this.token == Token.VOID;
    }

    public final boolean isWhile() {
        return this.token == Token.WHILE;
    }

    public final boolean isWith() {
        return this.token == Token.WITH;
    }

    public final boolean isYield() {
        return this.token == Token.YIELD;
    }

    public final boolean isDeclare() {
        return this.token == Token.DECLARE;
    }

    private static final class ConstantVarFlags {
        static final int DECLARED = 1;
        static final int INFERRED = 2;

        private ConstantVarFlags() {
        }
    }

    public static final class SideEffectFlags {
        public static final int MUTATES_GLOBAL_STATE = 1;
        public static final int MUTATES_THIS = 2;
        public static final int MUTATES_ARGUMENTS = 4;
        public static final int THROWS = 8;
        private static final int USED_BITS_MASK = 15;
        public static final int NO_SIDE_EFFECTS = 0;
        public static final int ALL_SIDE_EFFECTS = 15;
        private int value = 15;

        public SideEffectFlags() {
        }

        public SideEffectFlags(int value) {
            this.value = value;
        }

        public int valueOf() {
            return this.value;
        }

        public SideEffectFlags setAllFlags() {
            this.value = 15;
            return this;
        }

        public SideEffectFlags clearAllFlags() {
            this.value = 0;
            return this;
        }

        public SideEffectFlags setMutatesGlobalState() {
            this.value |= 7;
            return this;
        }

        public SideEffectFlags setThrows() {
            this.value |= 8;
            return this;
        }

        public SideEffectFlags setMutatesThis() {
            this.value |= 2;
            return this;
        }

        public SideEffectFlags setMutatesArguments() {
            this.value |= 4;
            return this;
        }

        @DoNotCall
        public String toString() {
            StringBuilder builder = new StringBuilder("Side effects: ");
            if ((this.value & 2) != 0) {
                builder.append("this ");
            }
            if ((this.value & 1) != 0) {
                builder.append("global ");
            }
            if ((this.value & 8) != 0) {
                builder.append("throw ");
            }
            if ((this.value & 4) != 0) {
                builder.append("args ");
            }
            return builder.toString();
        }
    }

    public static final class AncestorIterable
    implements Iterable<Node> {
        private @Nullable Node cur;

        AncestorIterable(@Nullable Node cur) {
            this.cur = cur;
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return cur != null;
                }

                @Override
                public Node next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Node n = cur;
                    cur = cur.getParent();
                    return n;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class SiblingNodeIterator
    implements Iterator<Node> {
        private @Nullable Node current;

        SiblingNodeIterator(Node start) {
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Node next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Node n = this.current;
            this.current = this.current.getNext();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SiblingNodeIterable
    implements Iterable<Node> {
        private final Node start;

        SiblingNodeIterable(Node start) {
            this.start = start;
        }

        @Override
        public Iterator<Node> iterator() {
            return new SiblingNodeIterator(this.start);
        }
    }

    private static final class IntPropListItem
    extends PropListItem {
        final int intValue;

        IntPropListItem(byte propType, int intValue, @Nullable PropListItem next) {
            super(propType, next);
            this.intValue = intValue;
            Preconditions.checkState((this.intValue != 0 ? 1 : 0) != 0);
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        @Override
        public Object getObjectValue() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.intValue);
        }

        @Override
        public PropListItem chain(@Nullable PropListItem next) {
            return new IntPropListItem(this.propType, this.intValue, next);
        }
    }

    private static final class ObjectPropListItem
    extends PropListItem {
        private final Object objectValue;

        ObjectPropListItem(byte propType, Object objectValue, @Nullable PropListItem next) {
            super(propType, next);
            this.objectValue = Preconditions.checkNotNull((Object)objectValue);
        }

        @Override
        public int getIntValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getObjectValue() {
            return this.objectValue;
        }

        public String toString() {
            return String.valueOf(this.objectValue);
        }

        @Override
        public PropListItem chain(@Nullable PropListItem next) {
            return new ObjectPropListItem(this.propType, this.objectValue, next);
        }
    }

    private static abstract class PropListItem {
        final @Nullable PropListItem next;
        final byte propType;

        PropListItem(byte propType, @Nullable PropListItem next) {
            this.propType = propType;
            this.next = next;
        }

        public abstract int getIntValue();

        public abstract Object getObjectValue();

        public abstract PropListItem chain(@Nullable PropListItem var1);
    }

    private static final class TemplateLiteralSubstringNode
    extends Node {
        private final @Nullable String cooked;
        private final String raw;

        TemplateLiteralSubstringNode(@Nullable String cooked, String raw) {
            super(Token.TEMPLATELIT_STRING);
            this.cooked = cooked == null ? null : RhinoStringPool.addOrGet(cooked);
            this.raw = RhinoStringPool.addOrGet(raw);
        }

        @Override
        public boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc, boolean sideEffect) {
            if (!super.isEquivalentTo(node, compareType, recur, jsDoc, sideEffect)) {
                return false;
            }
            TemplateLiteralSubstringNode castNode = (TemplateLiteralSubstringNode)node;
            return RhinoStringPool.uncheckedEquals(this.raw, castNode.raw) && RhinoStringPool.uncheckedEquals(this.cooked, castNode.cooked);
        }

        @Override
        TemplateLiteralSubstringNode cloneNode(boolean cloneTypeExprs) {
            TemplateLiteralSubstringNode clone = new TemplateLiteralSubstringNode(this.cooked, this.raw);
            Node.copyBaseNodeFields(this, clone, cloneTypeExprs);
            return clone;
        }
    }

    private static final class StringNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private String str;

        private StringNode(Token token) {
            super(token);
        }

        StringNode(Token token, String str) {
            super(token);
            this.setString(str);
        }

        @Override
        public boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc, boolean sideEffect) {
            return super.isEquivalentTo(node, compareType, recur, jsDoc, sideEffect) && RhinoStringPool.uncheckedEquals(this.str, ((StringNode)node).str);
        }

        @Override
        StringNode cloneNode(boolean cloneTypeExprs) {
            StringNode clone = new StringNode(this.getToken());
            Node.copyBaseNodeFields(this, clone, cloneTypeExprs);
            clone.str = this.str;
            return clone;
        }
    }

    private static final class BigIntNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private BigInteger bigint;

        BigIntNode(BigInteger bigint) {
            super(Token.BIGINT);
            this.setBigInt(bigint);
        }

        @Override
        public boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc, boolean sideEffect) {
            return super.isEquivalentTo(node, compareType, recur, jsDoc, sideEffect) && this.getBigInt().equals(node.getBigInt());
        }

        @Override
        BigIntNode cloneNode(boolean cloneTypeExprs) {
            BigIntNode clone = new BigIntNode(this.bigint);
            Node.copyBaseNodeFields(this, clone, cloneTypeExprs);
            return clone;
        }
    }

    private static final class NumberNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private double number;

        NumberNode(double number) {
            super(Token.NUMBER);
            this.setDouble(number);
        }

        @Override
        public boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc, boolean sideEffect) {
            return super.isEquivalentTo(node, compareType, recur, jsDoc, sideEffect) && this.number == ((NumberNode)node).number;
        }

        @Override
        NumberNode cloneNode(boolean cloneTypeExprs) {
            NumberNode clone = new NumberNode(this.number);
            Node.copyBaseNodeFields(this, clone, cloneTypeExprs);
            return clone;
        }
    }

    static enum Prop {
        IS_PARENTHESIZED,
        NON_JSDOC_COMMENT,
        TRAILING_NON_JSDOC_COMMENT,
        JSDOC_INFO,
        INCRDECR,
        QUOTED,
        SYNTHETIC,
        ADDED_BLOCK,
        SIDE_EFFECT_FLAGS,
        IS_CONSTANT_NAME,
        IS_NAMESPACE,
        USE_STRICT,
        DIRECT_EVAL,
        FREE_CALL,
        SOURCE_FILE,
        INPUT_ID,
        CHANGE_TIME,
        REFLECTED_OBJECT,
        STATIC_MEMBER,
        GENERATOR_FN,
        ARROW_FN,
        ASYNC_FN,
        YIELD_ALL,
        EXPORT_DEFAULT,
        EXPORT_ALL_FROM,
        CONSTANT_VAR_FLAGS,
        IS_GENERATOR_MARKER,
        IS_GENERATOR_SAFE,
        COMPUTED_PROP_METHOD,
        COMPUTED_PROP_GETTER,
        COMPUTED_PROP_SETTER,
        COMPUTED_PROP_VARIABLE,
        DECLARED_TYPE_EXPR,
        TYPE_BEFORE_CAST,
        COLOR_FROM_CAST,
        OPT_ES6_TYPED,
        GENERIC_TYPE,
        IMPLEMENTS,
        CONSTRUCT_SIGNATURE,
        ACCESS_MODIFIER,
        NON_INDEXABLE,
        PARSE_RESULTS,
        GOOG_MODULE,
        FEATURE_SET,
        IS_TYPESCRIPT_ABSTRACT,
        TRANSPILED,
        DELETED,
        MODULE_ALIAS,
        IS_UNUSED_PARAMETER,
        MODULE_EXPORT,
        IS_SHORTHAND_PROPERTY,
        ES6_MODULE,
        TYPEDEF_TYPE,
        START_OF_OPT_CHAIN,
        TRAILING_COMMA,
        SYNTHESIZED_UNFULFILLED_NAME_DECLARATION,
        MARK_FOR_PARENTHESIZE;

    }
}

