/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.jspecify.nullness.Nullable;

public final class ScriptMetadata {
    private final Node script;
    private boolean supportsRequireAliases;
    private final LinkedHashMap<String, String> requireAliases = new LinkedHashMap();
    private final LinkedHashSet<String> namesInUse = new LinkedHashSet();
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');

    static ScriptMetadata create(Node script, NodeMetadata metadata) {
        return ScriptMetadata.create(script, metadata.getCompiler());
    }

    public static ScriptMetadata create(Node script, AbstractCompiler compiler) {
        Preconditions.checkArgument((boolean)script.isScript());
        ScriptMetadata toFill = new ScriptMetadata(script);
        NodeTraversal.traverse(compiler, script, new FillerCallback(toFill));
        if (!toFill.requireAliases.isEmpty()) {
            toFill.supportsRequireAliases = true;
        }
        return toFill;
    }

    private ScriptMetadata(Node script) {
        this.script = script;
    }

    Node getScript() {
        return this.script;
    }

    boolean supportsRequireAliases() {
        return this.supportsRequireAliases;
    }

    boolean usesName(String name) {
        return this.namesInUse.contains(name);
    }

    @Nullable String getAlias(String namespace) {
        return this.requireAliases.get(namespace);
    }

    void addAlias(String namespace, String alias) {
        Preconditions.checkState((boolean)this.supportsRequireAliases);
        this.namesInUse.add(alias);
        this.requireAliases.put(namespace, alias);
    }

    private static class FillerCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private static final QualifiedName GOOG_MODULE = QualifiedName.of("goog.module");
        private static final QualifiedName GOOG_REQUIRE = QualifiedName.of("goog.require");
        private static final QualifiedName GOOG_REQUIRETYPE = QualifiedName.of("goog.requireType");
        private static final QualifiedName GOOG_FORWARDDECLARE = QualifiedName.of("goog.forwardDeclare");
        private final ScriptMetadata toFill;

        public FillerCallback(ScriptMetadata toFill) {
            this.toFill = toFill;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node n, Node parent) {
            this.updateSupportsRequireAlias(n);
            this.maybeCollectRequirelikeAlias(n);
            this.maybeCollectNames(n);
        }

        private void updateSupportsRequireAlias(Node n) {
            switch (n.getToken()) {
                case MODULE_BODY: {
                    break;
                }
                case CALL: {
                    if (n.getChildCount() == 2 && GOOG_MODULE.matches(n.getFirstChild()) && n.getSecondChild().isStringLit()) break;
                    return;
                }
                default: {
                    return;
                }
            }
            this.toFill.supportsRequireAliases = true;
        }

        private void maybeCollectRequirelikeAlias(Node n) {
            if (!NodeUtil.isNameDeclaration(n)) {
                return;
            }
            Node aliasNode = n.getFirstChild();
            if (aliasNode.isDestructuringLhs()) {
                return;
            }
            Node requirelikeCall = aliasNode.getFirstChild();
            if (!this.isRequirelikeCall(requirelikeCall)) {
                return;
            }
            String alias = aliasNode.getOriginalName();
            if (alias == null) {
                alias = aliasNode.getString();
            }
            String namespace = requirelikeCall.getSecondChild().getString();
            this.toFill.requireAliases.put(namespace, alias);
        }

        private boolean isRequirelikeCall(Node call) {
            if (call == null || !call.isCall() || call.getChildCount() != 2 || !call.getSecondChild().isStringLit()) {
                return false;
            }
            Node callee = call.getFirstChild();
            return GOOG_REQUIRE.matches(callee) || GOOG_REQUIRETYPE.matches(callee) || GOOG_FORWARDDECLARE.matches(callee);
        }

        private void maybeCollectNames(Node n) {
            JSDocInfo jsdoc;
            if (n.isName()) {
                this.toFill.namesInUse.add(n.getString());
            }
            if ((jsdoc = n.getJSDocInfo()) != null) {
                for (JSTypeExpression expr : jsdoc.getTypeExpressions()) {
                    for (String type : expr.getAllTypeNames()) {
                        this.toFill.namesInUse.add((String)DOT_SPLITTER.split((CharSequence)type).iterator().next());
                    }
                }
            }
        }
    }
}

