/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.serialization.ObjectTypeProto;
import com.google.javascript.jscomp.serialization.SerializationOptions;
import com.google.javascript.jscomp.serialization.TypePointers;
import com.google.javascript.jscomp.serialization.TypePool;
import com.google.javascript.jscomp.serialization.TypeProto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.nullness.Nullable;

class ColorSerializer {
    private final SerializationOptions serializationMode;
    private final Function<String, Integer> getStringPoolIndexFn;
    private final Predicate<String> propertyFilter;
    private final HashMap<ColorId, Integer> colorIdToTypePointer = new HashMap();
    private final ArrayList<Color> colorsInSerializedOrder = new ArrayList();

    ColorSerializer(SerializationOptions serializationMode, Function<String, Integer> stringPoolIndexFn, Predicate<String> propertyFilter) {
        this.serializationMode = serializationMode;
        this.getStringPoolIndexFn = stringPoolIndexFn;
        this.propertyFilter = propertyFilter;
        for (Color color : TypePointers.OFFSET_TO_AXIOMATIC_COLOR) {
            this.addColor(color);
        }
    }

    ImmutableList<Integer> addColors(Collection<Color> colors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Color color : colors) {
            builder.add((Object)this.addColor(color));
        }
        return builder.build();
    }

    int addColor(Color color) {
        return this.colorIdToTypePointer.computeIfAbsent(color.getId(), unusedKey -> {
            int index = this.colorsInSerializedOrder.size();
            this.colorsInSerializedOrder.add(color);
            return index;
        });
    }

    TypePool generateTypePool(Function<Color, ImmutableSet<Color>> getDisambiguationSupertypesFn, @Nullable Function<Color, ImmutableSet<String>> getMismatchSourceRefsFn) {
        TypePool.Builder typePoolBuilder = TypePool.newBuilder();
        for (int i = TypePointers.untrimOffset(0); i < this.colorsInSerializedOrder.size(); ++i) {
            Color color = this.colorsInSerializedOrder.get(i);
            Integer typePointer = this.colorIdToTypePointer.get(color.getId());
            typePoolBuilder.addType(this.generateTypeProto(color));
            for (Color supertype : getDisambiguationSupertypesFn.apply(color)) {
                typePoolBuilder.addDisambiguationEdgesBuilder().setSubtype(typePointer).setSupertype(this.addColor(supertype));
            }
        }
        if (this.serializationMode != SerializationOptions.SKIP_DEBUG_INFO) {
            Preconditions.checkNotNull(getMismatchSourceRefsFn);
            TypePool.DebugInfo.Builder debugInfoBuilder = typePoolBuilder.getDebugInfoBuilder();
            LinkedHashMap<String, ArrayList> srcRefToTypePointerList = new LinkedHashMap<String, ArrayList>();
            for (Color color : this.colorsInSerializedOrder) {
                Integer typePointer = this.colorIdToTypePointer.get(color.getId());
                for (String srcRef : getMismatchSourceRefsFn.apply(color)) {
                    ArrayList typePointerList = srcRefToTypePointerList.computeIfAbsent(srcRef, key -> new ArrayList());
                    typePointerList.add(typePointer);
                }
            }
            for (Map.Entry entry : srcRefToTypePointerList.entrySet()) {
                debugInfoBuilder.addMismatchBuilder().setSourceRef((String)entry.getKey()).addAllInvolvedColor((Iterable)entry.getValue());
            }
        }
        return typePoolBuilder.build();
    }

    private TypeProto generateTypeProto(Color color) {
        TypeProto.Builder typeProtoBuilder = TypeProto.newBuilder();
        if (color.isUnion()) {
            typeProtoBuilder.getUnionBuilder().addAllUnionMember((Iterable<? extends Integer>)this.addColors((Collection<Color>)color.getUnionElements()));
        } else {
            ObjectTypeProto.Builder objectTypeProtoBuilder = typeProtoBuilder.getObjectBuilder();
            objectTypeProtoBuilder.setIsInvalidating(color.isInvalidating()).setUuid(color.getId().asByteString()).setPropertiesKeepOriginalName(color.getPropertiesKeepOriginalName()).addAllInstanceType((Iterable<? extends Integer>)this.addColors((Collection<Color>)color.getInstanceColors())).addAllPrototype((Iterable<? extends Integer>)this.addColors((Collection<Color>)color.getPrototypes())).setMarkedConstructor(color.isConstructor()).addAllOwnProperty((Iterable<? extends Integer>)this.getOwnPropertyStringPoolOffsets(color)).setClosureAssert(color.isClosureAssert());
        }
        return typeProtoBuilder.build();
    }

    private ImmutableList<Integer> getOwnPropertyStringPoolOffsets(Color color) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String ownProperty : color.getOwnProperties()) {
            if (!this.propertyFilter.test(ownProperty)) continue;
            builder.add((Object)this.getStringPoolIndexFn.apply(ownProperty));
        }
        return builder.build();
    }
}

