/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.parsing.parser.SourceFile;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;
import java.util.Objects;

final class LineNumberScanner {
    private final SourceFile sourceFile;
    private final String contents;
    private final int sourceLength;
    private int lastLine = -1;
    private int lastLineStart = -1;
    private int nextLineStart = 0;

    LineNumberScanner(SourceFile sourceFile) {
        this.sourceFile = sourceFile;
        this.contents = sourceFile.contents;
        this.sourceLength = this.contents.length();
    }

    SourcePosition getSourcePosition(int offset) {
        Preconditions.checkArgument((offset >= this.lastLineStart ? 1 : 0) != 0, (String)"Must call rewindTo before calling getSourcePosition for an earlier line (%s < %s)", (int)offset, (int)this.lastLineStart);
        while (offset >= this.nextLineStart) {
            this.advanceLine();
        }
        return new SourcePosition(this.sourceFile, offset, this.lastLine, offset - this.lastLineStart);
    }

    SourceRange getSourceRange(int startOffset, int endOffset) {
        return new SourceRange(this.getSourcePosition(startOffset), this.getSourcePosition(endOffset));
    }

    void rewindTo(SourcePosition position) {
        Preconditions.checkArgument((boolean)Objects.equals(position.source, this.sourceFile));
        if (position.offset < this.lastLineStart) {
            this.lastLine = position.line - 1;
            this.nextLineStart = position.offset - position.column;
            this.advanceLine();
        }
    }

    private void advanceLine() {
        ++this.lastLine;
        for (int index = this.lastLineStart = this.nextLineStart; index < this.sourceLength; ++index) {
            char ch = this.contents.charAt(index);
            if (!LineNumberScanner.isLineTerminator(ch)) continue;
            if (ch == '\r' && index + 1 < this.sourceLength && this.contents.charAt(index + 1) == '\n') {
                ++index;
            }
            this.nextLineStart = index + 1;
            return;
        }
        this.nextLineStart = Integer.MAX_VALUE;
    }

    private static boolean isLineTerminator(char ch) {
        switch (ch) {
            case '\n': 
            case '\r': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }
}

