/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.ClosureModuleProcessor;
import com.google.javascript.jscomp.modules.EsModuleProcessor;
import com.google.javascript.jscomp.modules.Export;
import com.google.javascript.jscomp.modules.ExportTrace;
import com.google.javascript.jscomp.modules.GoogEsImports;
import com.google.javascript.jscomp.modules.Import;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.modules.ModuleRequestResolver;
import com.google.javascript.jscomp.modules.NonEsModuleProcessor;
import com.google.javascript.jscomp.modules.ResolveExportResult;
import com.google.javascript.jscomp.modules.UnresolvedModule;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public class ModuleMapCreator
implements CompilerPass {
    public static final DiagnosticType DOES_NOT_HAVE_EXPORT = DiagnosticType.error("JSC_DOES_NOT_HAVE_EXPORT", "Requested module does not have an export \"{0}\".");
    public static final DiagnosticType DOES_NOT_HAVE_EXPORT_WITH_DETAILS = DiagnosticType.error("JSC_DOES_NOT_HAVE_EXPORT_WITH_DETAILS", "Requested module does not have an export \"{0}\".{1}");
    private final AbstractCompiler compiler;
    private final EsModuleProcessor esModuleProcessor;
    private final ClosureModuleProcessor closureModuleProcessor;
    private final NonEsModuleProcessor nonEsModuleProcessor;
    private final Map<String, UnresolvedModule> unresolvedModules;
    private final Map<String, UnresolvedModule> unresolvedModulesByClosureNamespace;
    private final ModuleMetadataMap moduleMetadataMap;

    public ModuleMapCreator(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap) {
        this.compiler = compiler;
        this.moduleMetadataMap = moduleMetadataMap;
        this.esModuleProcessor = new EsModuleProcessor(compiler);
        this.closureModuleProcessor = new ClosureModuleProcessor(compiler);
        this.nonEsModuleProcessor = new NonEsModuleProcessor();
        this.unresolvedModules = new HashMap<String, UnresolvedModule>();
        this.unresolvedModulesByClosureNamespace = new HashMap<String, UnresolvedModule>();
    }

    private ModuleMap create() {
        this.unresolvedModules.clear();
        this.unresolvedModulesByClosureNamespace.clear();
        for (ModuleMetadataMap.ModuleMetadata moduleMetadata : this.moduleMetadataMap.getAllModuleMetadata()) {
            this.process(moduleMetadata);
        }
        return this.resolve();
    }

    private ModuleMap resolve() {
        ImmutableSet toResolve;
        ModuleRequestResolverImpl requestResolver = new ModuleRequestResolverImpl();
        HashMap<String, Module> resolvedModules = new HashMap<String, Module>();
        HashMap<String, Module> resolvedClosureModules = new HashMap<String, Module>();
        do {
            toResolve = Sets.difference(this.unresolvedModules.keySet(), resolvedModules.keySet()).immutableCopy();
            for (String key : toResolve) {
                Module resolved = this.unresolvedModules.get(key).resolve(requestResolver);
                resolvedModules.put(key, resolved);
                for (String namespace : resolved.metadata().googNamespaces()) {
                    resolvedClosureModules.put(namespace, resolved);
                }
            }
        } while (!resolvedModules.keySet().containsAll(this.unresolvedModules.keySet()));
        do {
            toResolve = Sets.difference(this.unresolvedModulesByClosureNamespace.keySet(), resolvedClosureModules.keySet()).immutableCopy();
            for (String namespace : toResolve) {
                resolvedClosureModules.put(namespace, this.unresolvedModulesByClosureNamespace.get(namespace).resolve(requestResolver));
            }
        } while (!resolvedClosureModules.keySet().containsAll(this.unresolvedModulesByClosureNamespace.keySet()));
        this.unresolvedModules.clear();
        this.unresolvedModulesByClosureNamespace.clear();
        return new ModuleMap((ImmutableMap<String, Module>)ImmutableMap.copyOf(resolvedModules), (ImmutableMap<String, Module>)ImmutableMap.copyOf(resolvedClosureModules));
    }

    private void process(ModuleMetadataMap.ModuleMetadata moduleMetadata) {
        ModuleProcessor processor;
        switch (moduleMetadata.moduleType()) {
            case ES6_MODULE: {
                processor = this.esModuleProcessor;
                break;
            }
            case GOOG_MODULE: 
            case LEGACY_GOOG_MODULE: {
                processor = this.closureModuleProcessor;
                break;
            }
            default: {
                processor = this.nonEsModuleProcessor;
            }
        }
        UnresolvedModule module = processor.process(moduleMetadata, moduleMetadata.path(), moduleMetadata.rootNode());
        if (moduleMetadata.path() != null) {
            this.unresolvedModules.put(moduleMetadata.path().toModuleName(), module);
        }
        for (String namespace : moduleMetadata.googNamespaces()) {
            this.unresolvedModulesByClosureNamespace.put(namespace, module);
        }
    }

    @Override
    public void process(Node externs, Node root) {
        this.compiler.setModuleMap(this.create());
    }

    static interface ModuleProcessor {
        public UnresolvedModule process(ModuleMetadataMap.ModuleMetadata var1, ModuleLoader.ModulePath var2, Node var3);
    }

    private final class ModuleRequestResolverImpl
    implements ModuleRequestResolver {
        private ModuleRequestResolverImpl() {
        }

        private UnresolvedModule getFallbackForMissingNonClosureModule(final ModuleLoader.ModulePath path) {
            final ModuleMetadataMap.ModuleMetadata metadata = ModuleMetadataMap.ModuleMetadata.builder().rootNode(null).path(path).moduleType(ModuleMetadataMap.ModuleType.ES6_MODULE).isTestOnly(false).usesClosure(false).build();
            return new UnresolvedModule(){

                @Override
                void reset() {
                }

                @Override
                Module resolve(ModuleRequestResolver moduleRequestResolver, @Nullable String moduleSpecifier) {
                    return Module.builder().boundNames((ImmutableMap<String, Binding>)ImmutableMap.of()).namespace((ImmutableMap<String, Binding>)ImmutableMap.of()).localNameToLocalExport((ImmutableMap<String, Export>)ImmutableMap.of()).path(path).metadata(metadata).build();
                }

                @Override
                ModuleMetadataMap.ModuleMetadata metadata() {
                    return metadata;
                }

                @Override
                ImmutableSet<String> getExportedNames(ModuleRequestResolver moduleRequestResolver) {
                    return ImmutableSet.of();
                }

                @Override
                protected ImmutableSet<String> getExportedNames(ModuleRequestResolver moduleRequestResolver, Set<UnresolvedModule> visited) {
                    return ImmutableSet.of();
                }

                @Override
                ResolveExportResult resolveExport(ModuleRequestResolver moduleRequestResolver, @Nullable String moduleSpecifier, String exportName, Set<ExportTrace> resolveSet, Set<UnresolvedModule> exportStarSet) {
                    return ResolveExportResult.of(Binding.from(Export.builder().localName(exportName).moduleMetadata(metadata).modulePath(path).closureNamespace(null).build(), null));
                }
            };
        }

        private UnresolvedModule getFallbackForMissingClosureModule(String namespace) {
            return ModuleMapCreator.this.nonEsModuleProcessor.process(ModuleMetadataMap.ModuleMetadata.builder().addGoogNamespace(namespace).isTestOnly(false).moduleType(ModuleMetadataMap.ModuleType.GOOG_PROVIDE).path(null).rootNode(null).usesClosure(true).build(), null, null);
        }

        @Override
        public @Nullable UnresolvedModule resolve(Import i) {
            if (i.modulePath() == null) {
                return this.resolveForClosure(i.moduleRequest());
            }
            return this.resolve(i.moduleRequest(), i.modulePath(), i.importNode());
        }

        @Override
        public @Nullable UnresolvedModule resolve(Export e) {
            return this.resolve(e.moduleRequest(), e.modulePath(), e.exportNode());
        }

        private @Nullable UnresolvedModule resolveForClosure(String namespace) {
            return ModuleMapCreator.this.unresolvedModulesByClosureNamespace.computeIfAbsent(namespace, this::getFallbackForMissingClosureModule);
        }

        private @Nullable UnresolvedModule resolve(String moduleRequest, ModuleLoader.ModulePath modulePath, Node forLineInfo) {
            if (GoogEsImports.isGoogImportSpecifier(moduleRequest)) {
                String namespace = GoogEsImports.getClosureIdFromGoogImportSpecifier(moduleRequest);
                return this.resolveForClosure(namespace);
            }
            ModuleLoader.ModulePath requestedPath = modulePath.resolveJsModule(moduleRequest, forLineInfo.getSourceFileName(), forLineInfo.getLineno(), forLineInfo.getCharno());
            if (requestedPath == null && !ModuleMapCreator.this.unresolvedModules.containsKey((requestedPath = modulePath.resolveModuleAsPath(moduleRequest)).toModuleName())) {
                UnresolvedModule module = this.getFallbackForMissingNonClosureModule(requestedPath);
                ModuleMapCreator.this.unresolvedModules.put(requestedPath.toModuleName(), module);
                return module;
            }
            return ModuleMapCreator.this.unresolvedModules.get(requestedPath.toModuleName());
        }
    }
}

