/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.Module;
import org.jspecify.nullness.Nullable;

public final class ModuleMap {
    private final ImmutableMap<String, Module> resolvedModules;
    private final ImmutableMap<String, Module> resolvedClosureModules;

    public ModuleMap(ImmutableMap<String, Module> resolvedModules, ImmutableMap<String, Module> resolvedClosureModules) {
        this.resolvedModules = resolvedModules;
        this.resolvedClosureModules = resolvedClosureModules;
    }

    public @Nullable Module getModule(String moduleName) {
        return (Module)this.resolvedModules.get((Object)moduleName);
    }

    public @Nullable Module getModule(ModuleLoader.ModulePath path) {
        return this.getModule(path.toModuleName());
    }

    public ImmutableMap<String, Module> getModulesByPath() {
        return this.resolvedModules;
    }

    public ImmutableMap<String, Module> getModulesByClosureNamespace() {
        return this.resolvedClosureModules;
    }

    public @Nullable Module getClosureModule(String namespace) {
        return (Module)this.resolvedClosureModules.get((Object)namespace);
    }

    public static ModuleMap emptyForTesting() {
        return new ModuleMap((ImmutableMap<String, Module>)ImmutableMap.of(), (ImmutableMap<String, Module>)ImmutableMap.of());
    }
}

