/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.nullness.Nullable;

public final class CheckProvidesSorted
implements NodeTraversal.Callback {
    public static final DiagnosticType PROVIDES_NOT_SORTED = DiagnosticType.warning("JSC_PROVIDES_NOT_SORTED", "goog.provide() statements are not sorted. The correct order is:\n\n{0}\n");
    private final Mode mode;
    private final List<String> originalProvides = new ArrayList<String>();
    private @Nullable Node firstNode = null;
    private @Nullable Node lastNode = null;
    private boolean finished = false;
    private @Nullable String replacement = null;
    private boolean needsFix = false;

    public CheckProvidesSorted(Mode mode) {
        this.mode = mode;
    }

    public Node getFirstNode() {
        return this.firstNode;
    }

    public Node getLastNode() {
        return this.lastNode;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public boolean needsFix() {
        return this.needsFix;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return !this.finished && (parent == null || parent.isRoot() || parent.isScript() || parent.isModuleBody());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            this.checkCanonical(t);
            return;
        }
        if (NodeUtil.isGoogProvideCall(n) && CheckProvidesSorted.areProvideArgumentsValid(n.getFirstChild())) {
            this.originalProvides.add(CheckProvidesSorted.getNamespace(n));
            if (this.firstNode == null) {
                this.firstNode = this.lastNode = n;
            } else {
                this.lastNode = n;
            }
        } else if (!this.originalProvides.isEmpty()) {
            this.finished = true;
        }
    }

    private static boolean areProvideArgumentsValid(Node call) {
        return call.hasTwoChildren() && call.getSecondChild().isStringLit();
    }

    private static String getNamespace(Node n) {
        return n.getFirstChild().getSecondChild().getString();
    }

    private static String formatProvide(String namespace) {
        StringBuilder sb = new StringBuilder();
        sb.append("goog.provide('");
        sb.append(namespace);
        sb.append("');");
        return sb.toString();
    }

    private void checkCanonical(NodeTraversal t) {
        @Nullable ImmutableList canonicalProvides = (ImmutableList)this.originalProvides.stream().distinct().sorted().collect(ImmutableList.toImmutableList());
        if (!this.originalProvides.equals(canonicalProvides)) {
            this.needsFix = true;
            this.replacement = String.join((CharSequence)"\n", Iterables.transform((Iterable)canonicalProvides, CheckProvidesSorted::formatProvide));
            if (this.mode == Mode.COLLECT_AND_REPORT) {
                t.report(this.firstNode, PROVIDES_NOT_SORTED, this.replacement);
            }
        }
    }

    public static enum Mode {
        COLLECT_ONLY,
        COLLECT_AND_REPORT;

    }
}

