/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import org.jspecify.nullness.Nullable;

final class ClassUtil {
    private static final QualifiedName GOOG_DEFINECLASS = QualifiedName.of("goog.defineClass");

    private ClassUtil() {
    }

    static boolean isThisProp(Node getprop) {
        return ClassUtil.getClassNameOfThisProp(getprop) != null;
    }

    static String getPrototypeNameOfThisProp(Node getprop) {
        String className = (String)Preconditions.checkNotNull((Object)ClassUtil.getClassNameOfThisProp(getprop));
        return className + ".prototype." + getprop.getString();
    }

    private static @Nullable String getClassNameOfThisProp(Node getprop) {
        if (!getprop.isGetProp() || !getprop.getFirstChild().isThis()) {
            return null;
        }
        Node function = NodeUtil.getEnclosingFunction(getprop);
        if (function == null) {
            return null;
        }
        String className = ClassUtil.getClassName(function);
        if (Strings.isNullOrEmpty((String)className)) {
            return null;
        }
        return className;
    }

    static String getFullyQualifiedNameOfMethod(Node function) {
        Preconditions.checkArgument((boolean)ClassUtil.isClassMethod(function));
        String className = ClassUtil.getClassName(function);
        Preconditions.checkState((className != null && !className.isEmpty() ? 1 : 0) != 0);
        Node memberFunctionDef = function.getParent();
        String methodName = memberFunctionDef.getString();
        return memberFunctionDef.isStaticMember() ? className + "." + methodName : className + ".prototype." + methodName;
    }

    static boolean isClassMethod(Node functionNode) {
        Preconditions.checkArgument((boolean)functionNode.isFunction());
        Node parent = functionNode.getParent();
        if (parent.isMemberFunctionDef() && parent.getParent().isClassMembers()) {
            return true;
        }
        return parent.isStringKey() && parent.getParent().isObjectLit() && parent.getGrandparent().isCall() && GOOG_DEFINECLASS.matches(parent.getGrandparent().getFirstChild());
    }

    static boolean hasNamedClass(Node functionNode) {
        Preconditions.checkArgument((boolean)functionNode.isFunction());
        return ClassUtil.getClassName(functionNode) != null;
    }

    private static String getClassName(Node functionNode) {
        Preconditions.checkArgument((boolean)functionNode.isFunction());
        if (ClassUtil.isClassMethod(functionNode)) {
            Node parent = functionNode.getParent();
            if (parent.isMemberFunctionDef()) {
                Node classNode = functionNode.getGrandparent().getParent();
                Preconditions.checkState((boolean)classNode.isClass());
                return NodeUtil.getName(classNode);
            }
            Preconditions.checkState((boolean)parent.isStringKey());
            Node defineClassCall = parent.getGrandparent();
            Preconditions.checkState((boolean)defineClassCall.isCall());
            return NodeUtil.getBestLValue(defineClassCall).getQualifiedName();
        }
        return NodeUtil.getName(functionNode);
    }

    static boolean isConstructor(Node functionNode) {
        if (ClassUtil.isClassMethod(functionNode)) {
            return NodeUtil.isEs6Constructor(functionNode) || "constructor".equals(functionNode.getParent().getString());
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(functionNode);
        return jsdoc != null && jsdoc.isConstructorOrInterface();
    }
}

