/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphNode;
import java.util.Collection;
import java.util.List;

public abstract class DiGraph<N, E>
extends Graph<N, E> {
    @Override
    public abstract DiGraphNode<N, E> createNode(N var1);

    @Override
    public abstract Collection<? extends DiGraphNode<N, E>> getNodes();

    @Override
    public abstract DiGraphNode<N, E> getNode(N var1);

    @Override
    public abstract List<? extends DiGraphEdge<N, E>> getEdges();

    @Override
    public abstract List<? extends DiGraphEdge<N, E>> getEdges(N var1, N var2);

    public abstract List<? extends DiGraphEdge<N, E>> getEdgesInDirection(N var1, N var2);

    public abstract List<? extends DiGraphEdge<N, E>> getOutEdges(N var1);

    public abstract List<? extends DiGraphEdge<N, E>> getInEdges(N var1);

    public abstract List<? extends DiGraphNode<N, E>> getDirectedPredNodes(DiGraphNode<N, E> var1);

    public abstract List<? extends DiGraphNode<N, E>> getDirectedPredNodes(N var1);

    public abstract List<? extends DiGraphNode<N, E>> getDirectedSuccNodes(DiGraphNode<N, E> var1);

    public abstract List<? extends DiGraphNode<N, E>> getDirectedSuccNodes(N var1);

    public abstract void disconnectInDirection(N var1, N var2);

    public abstract boolean isConnectedInDirection(N var1, N var2);

    public abstract boolean isConnectedInDirection(N var1, E var2, N var3);

    @Override
    public boolean isConnected(N n1, N n2) {
        return this.isConnectedInDirection(n1, n2) || this.isConnectedInDirection(n2, n1);
    }

    @Override
    public boolean isConnected(N n1, E e, N n2) {
        return this.isConnectedInDirection(n1, e, n2) || this.isConnectedInDirection(n2, e, n1);
    }

    public static interface DiGraphEdge<N, E>
    extends Graph.GraphEdge<N, E> {
        public DiGraphNode<N, E> getSource();

        public DiGraphNode<N, E> getDestination();
    }

    public static interface DiGraphNode<N, E>
    extends GraphNode<N, E> {
        public List<? extends DiGraphEdge<N, E>> getOutEdges();

        public List<? extends DiGraphEdge<N, E>> getInEdges();

        public boolean hasPriority();

        public int getPriority();

        public void setPriority(int var1);
    }
}

