/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.annotations.Keep;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GatherGetterAndSetterProperties;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.disambiguate.ClusterPropagator;
import com.google.javascript.jscomp.disambiguate.ColorFindPropertyReferences;
import com.google.javascript.jscomp.disambiguate.ColorGraphBuilder;
import com.google.javascript.jscomp.disambiguate.ColorGraphNode;
import com.google.javascript.jscomp.disambiguate.ColorGraphNodeFactory;
import com.google.javascript.jscomp.disambiguate.Invalidation;
import com.google.javascript.jscomp.disambiguate.PropertyClustering;
import com.google.javascript.jscomp.disambiguate.UseSiteRenamer;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.jscomp.graph.LowestCommonAncestorFinder;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Supplier;

public final class DisambiguateProperties
implements CompilerPass {
    public static final DiagnosticType PROPERTY_INVALIDATION = DiagnosticType.error("JSC_DISAMBIGUATE2_PROPERTY_INVALIDATION", "Property ''{0}'' was required to be disambiguated but was invalidated.{1}");
    private static final Gson GSON = new Gson();
    private final AbstractCompiler compiler;
    private final ImmutableSet<String> propertiesThatMustDisambiguate;
    private final ColorRegistry registry;
    private final LinkedHashSet<Color> mayHavePropertySeenSet = new LinkedHashSet();

    public DisambiguateProperties(AbstractCompiler compiler, ImmutableSet<String> propertiesThatMustDisambiguate) {
        this.compiler = compiler;
        this.propertiesThatMustDisambiguate = propertiesThatMustDisambiguate;
        this.registry = this.compiler.getColorRegistry();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument((externs.getParent() == root.getParent() ? 1 : 0) != 0);
        ColorGraphNodeFactory flattener = ColorGraphNodeFactory.createFactory(this.registry);
        ColorFindPropertyReferences findRefs = new ColorFindPropertyReferences(flattener, this.compiler.getCodingConvention()::isPropertyRenameFunction);
        ColorGraphBuilder graphBuilder = new ColorGraphBuilder(flattener, LowestCommonAncestorFinder::new, this.registry);
        ClusterPropagator propagator = new ClusterPropagator();
        UseSiteRenamer renamer = new UseSiteRenamer(this.compiler::reportChangeToEnclosingScope);
        NodeTraversal.traverse(this.compiler, externs.getParent(), findRefs);
        final LinkedHashMap<String, PropertyClustering> propIndex = findRefs.getPropertyIndex();
        DisambiguateProperties.invalidateWellKnownProperties(propIndex);
        this.logForDiagnostics("prop_refs", new LogFile.StreamedJsonProducer(){

            @Override
            public void writeJson(JsonWriter writer) throws IOException {
                ImmutableSortedSet propRefsJson = (ImmutableSortedSet)propIndex.values().stream().map(PropertyReferenceIndexJson::new).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
                writer.beginObject();
                for (PropertyReferenceIndexJson propRef : propRefsJson) {
                    propRef.writeJson(writer);
                }
                writer.endObject();
            }
        });
        graphBuilder.addAll((Collection<ColorGraphNode>)flattener.getAllKnownTypes());
        LinkedDirectedGraph<ColorGraphNode, Object> graph = graphBuilder.build();
        for (ColorGraphNode colorGraphNode : flattener.getAllKnownTypes()) {
            if (((DiGraph)graph).getOutEdges(colorGraphNode).isEmpty() || colorGraphNode.getColor().isUnion()) continue;
            this.registerOwnDeclaredProperties(colorGraphNode, propIndex);
        }
        this.logForDiagnostics("graph", (com.google.common.base.Supplier<Object>)((com.google.common.base.Supplier)() -> graph.getNodes().stream().map(TypeNodeJson::new).sorted(Comparator.comparingInt(x -> x.index)).collect(ImmutableList.toImmutableList())));
        this.invalidateBasedOnType(flattener);
        FixedPointGraphTraversal.newTraversal(propagator).computeFixedPoint(graph);
        for (PropertyClustering prop : propIndex.values()) {
            renamer.renameUses(prop);
            if (!prop.isInvalidated() || !this.propertiesThatMustDisambiguate.contains((Object)prop.getName())) continue;
            this.compiler.report(this.createInvalidationError(prop));
        }
        this.logForDiagnostics("renaming_index", (com.google.common.base.Supplier<Object>)((com.google.common.base.Supplier)() -> DisambiguateProperties.buildRenamingIndex(propIndex, renamer)));
        this.logForDiagnostics("mismatches", (com.google.common.base.Supplier<Object>)((com.google.common.base.Supplier)() -> this.registry.getMismatchLocationsForDebugging().inverse()));
        GatherGetterAndSetterProperties.update(this.compiler, externs, root);
    }

    private JSError createInvalidationError(PropertyClustering prop) {
        String additionalContext = "";
        return JSError.make(null, -1, -1, PROPERTY_INVALIDATION, prop.getName(), additionalContext);
    }

    private static ImmutableMap<String, Object> buildRenamingIndex(LinkedHashMap<String, PropertyClustering> props, UseSiteRenamer renamer) {
        ImmutableSetMultimap<String, String> newNames = renamer.getRenamingIndex();
        return (ImmutableMap)props.values().stream().collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), PropertyClustering::getName, prop -> prop.isInvalidated() ? prop.getLastInvalidation() : ImmutableSortedSet.copyOf((Collection)newNames.get((Object)prop.getName()))));
    }

    private static void invalidateWellKnownProperties(LinkedHashMap<String, PropertyClustering> propIndex) {
        ImmutableList names = ImmutableList.of((Object)"prototype", (Object)"constructor", (Object)"then");
        for (String name : names) {
            propIndex.computeIfAbsent(name, PropertyClustering::new).invalidate(Invalidation.wellKnownProperty());
        }
    }

    private void invalidateBasedOnType(ColorGraphNodeFactory flattener) {
        for (ColorGraphNode type : flattener.getAllKnownTypes()) {
            if (type.getColor().isInvalidating()) {
                for (PropertyClustering prop : type.getAssociatedProps().keySet()) {
                    prop.invalidate(Invalidation.invalidatingType(type.getIndex()));
                }
                continue;
            }
            this.invalidateNonDeclaredPropertyAccesses(type);
        }
    }

    private void invalidateNonDeclaredPropertyAccesses(ColorGraphNode colorGraphNode) {
        Color color = colorGraphNode.getColor();
        Preconditions.checkArgument((!color.isInvalidating() ? 1 : 0) != 0, (Object)"Not applicable to invalidating types. All their properties are invalidated");
        for (PropertyClustering prop : colorGraphNode.getAssociatedProps().keySet()) {
            if (prop.isInvalidated() || this.mayHaveProperty(color, prop.getName())) continue;
            prop.invalidate(Invalidation.undeclaredAccess(colorGraphNode.getIndex()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mayHaveProperty(Color color, String propertyName) {
        try {
            if (!this.mayHavePropertySeenSet.add(color)) {
                boolean bl = false;
                return bl;
            }
            if (color.isUnion()) {
                boolean bl = color.getUnionElements().stream().anyMatch(element -> this.mayHaveProperty((Color)element, propertyName));
                return bl;
            }
            if (color.getOwnProperties().contains((Object)propertyName)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.registry.getDisambiguationSupertypes(color).stream().anyMatch(element -> this.mayHaveProperty((Color)element, propertyName));
            return bl;
        }
        finally {
            this.mayHavePropertySeenSet.remove(color);
        }
    }

    private void registerOwnDeclaredProperties(ColorGraphNode colorGraphNode, Map<String, PropertyClustering> propIndex) {
        Preconditions.checkArgument((!colorGraphNode.getColor().isUnion() ? 1 : 0) != 0);
        for (String propName : colorGraphNode.getColor().getOwnProperties()) {
            PropertyClustering prop = propIndex.get(propName);
            if (prop == null || prop.isInvalidated()) continue;
            prop.getClusters().add(colorGraphNode);
            colorGraphNode.getAssociatedProps().put(prop, ColorGraphNode.PropAssociation.TYPE_SYSTEM);
        }
    }

    private void logForDiagnostics(String name, com.google.common.base.Supplier<Object> data) {
        try (LogFile log = this.compiler.createOrReopenLog(this.getClass(), name + ".log", new String[0]);){
            log.logJson((Supplier<Object>)data);
        }
    }

    private void logForDiagnostics(String name, LogFile.StreamedJsonProducer data) {
        try (LogFile log = this.compiler.createOrReopenLog(this.getClass(), name + ".log", new String[0]);){
            log.logJson(data);
        }
    }

    private static final class TypeEdgeJson
    implements Comparable<TypeEdgeJson> {
        final int dest;
        @Keep
        final Object value;

        TypeEdgeJson(DiGraph.DiGraphEdge<ColorGraphNode, Object> e) {
            this.dest = ((ColorGraphNode)e.getDestination().getValue()).getIndex();
            this.value = e.getValue();
        }

        @Override
        public int compareTo(TypeEdgeJson x) {
            Preconditions.checkArgument((this.dest != x.dest ? 1 : 0) != 0);
            return this.dest - x.dest;
        }
    }

    private static final class TypeNodeJson {
        final int index;
        @Keep
        final boolean invalidating;
        @Keep
        final String colorId;
        @Keep
        final ImmutableSortedSet<TypeEdgeJson> edges;
        @Keep
        final ImmutableSortedMap<String, ColorGraphNode.PropAssociation> props;

        TypeNodeJson(DiGraph.DiGraphNode<ColorGraphNode, Object> n) {
            ColorGraphNode t = (ColorGraphNode)n.getValue();
            this.index = t.getIndex();
            this.colorId = t.getColor().getId().toString();
            this.invalidating = t.getColor().isInvalidating();
            this.edges = (ImmutableSortedSet)n.getOutEdges().stream().map(TypeEdgeJson::new).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
            this.props = (ImmutableSortedMap)t.getAssociatedProps().entrySet().stream().collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), e -> ((PropertyClustering)e.getKey()).getName(), Map.Entry::getValue));
        }
    }

    private static final class PropertyReferenceJson
    implements Comparable<PropertyReferenceJson> {
        final String location;
        final int receiverIndex;

        PropertyReferenceJson(Node location, ColorGraphNode receiver) {
            this.location = location.getLocation();
            this.receiverIndex = receiver.getIndex();
        }

        @Override
        public int compareTo(PropertyReferenceJson x) {
            return ComparisonChain.start().compare(this.receiverIndex, x.receiverIndex).compare((Comparable)((Object)this.location), (Comparable)((Object)x.location)).result();
        }
    }

    private static final class PropertyReferenceIndexJson
    implements Comparable<PropertyReferenceIndexJson> {
        final String name;
        final ImmutableSortedSet<PropertyReferenceJson> refs;

        PropertyReferenceIndexJson(PropertyClustering prop) {
            this.name = prop.getName();
            this.refs = prop.isInvalidated() ? ImmutableSortedSet.of() : (ImmutableSortedSet)prop.getUseSites().entrySet().stream().map(e -> new PropertyReferenceJson((Node)e.getKey(), (ColorGraphNode)e.getValue())).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
        }

        @Override
        public int compareTo(PropertyReferenceIndexJson x) {
            return this.name.compareTo(x.name);
        }

        private void writeJson(JsonWriter writer) throws IOException {
            writer.name(this.name);
            writer.beginObject();
            writer.name("name").value(this.name);
            writer.name("refs").beginArray();
            for (PropertyReferenceJson ref : this.refs) {
                GSON.toJson((Object)ref, PropertyReferenceJson.class, writer);
            }
            writer.endArray();
            writer.endObject();
        }
    }
}

