/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Strings;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.SourceCodeEscapers;
import com.google.javascript.jscomp.transpile.BaseTranspiler;
import com.google.javascript.jscomp.transpile.TranspileResult;
import com.google.javascript.jscomp.transpile.Transpiler;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.nullness.Nullable;

public final class ClosureBundler {
    private final Transpiler transpiler;
    private final Transpiler es6ModuleTranspiler;
    private final EvalMode mode;
    private final String sourceUrl;
    private final String path;
    private final boolean embedSourcemap;
    private final Map<String, String> sourceMapCache;
    private final Object minifier;

    public ClosureBundler() {
        this(Transpiler.NULL);
    }

    public ClosureBundler(Transpiler transpiler) {
        this(transpiler, BaseTranspiler.LATEST_TRANSPILER);
    }

    public ClosureBundler(Transpiler transpiler, Transpiler es6ModuleTranspiler) {
        this(transpiler, es6ModuleTranspiler, EvalMode.NORMAL, null, "unknown_source", null, new ConcurrentHashMap<String, String>(), false);
    }

    private ClosureBundler(Transpiler transpiler, Transpiler es6ModuleTranspiler, EvalMode mode, @Nullable String sourceUrl, String path, Object minifier, Map<String, String> sourceMapCache, boolean embedSourcemap) {
        this.transpiler = transpiler;
        this.mode = mode;
        this.sourceUrl = sourceUrl;
        this.path = path;
        this.sourceMapCache = sourceMapCache;
        this.es6ModuleTranspiler = es6ModuleTranspiler;
        this.minifier = minifier;
        this.embedSourcemap = embedSourcemap;
    }

    public ClosureBundler withTranspilers(Transpiler newTranspiler, Transpiler newEs6ModuleTranspiler) {
        return new ClosureBundler(newTranspiler, newEs6ModuleTranspiler, this.mode, this.sourceUrl, this.path, this.minifier, this.sourceMapCache, this.embedSourcemap);
    }

    public ClosureBundler withTranspiler(Transpiler newTranspiler) {
        return this.withTranspilers(newTranspiler, this.es6ModuleTranspiler);
    }

    public ClosureBundler withEs6ModuleTranspiler(Transpiler newEs6ModuleTranspiler) {
        return this.withTranspilers(this.transpiler, newEs6ModuleTranspiler);
    }

    public ClosureBundler disableJ2clMinifier() {
        return new ClosureBundler(this.transpiler, this.es6ModuleTranspiler, this.mode, this.sourceUrl, this.path, null, this.sourceMapCache, this.embedSourcemap);
    }

    public final ClosureBundler useEval(boolean useEval) {
        EvalMode newMode = useEval ? EvalMode.EVAL : EvalMode.NORMAL;
        return new ClosureBundler(this.transpiler, this.es6ModuleTranspiler, newMode, this.sourceUrl, this.path, this.minifier, this.sourceMapCache, this.embedSourcemap);
    }

    public final ClosureBundler withSourceUrl(String newSourceUrl) {
        return new ClosureBundler(this.transpiler, this.es6ModuleTranspiler, this.mode, newSourceUrl, this.path, this.minifier, this.sourceMapCache, this.embedSourcemap);
    }

    public final ClosureBundler withPath(String newPath) {
        return new ClosureBundler(this.transpiler, this.es6ModuleTranspiler, this.mode, this.sourceUrl, newPath, this.minifier, this.sourceMapCache, this.embedSourcemap);
    }

    public final ClosureBundler embedSourcemap() {
        return new ClosureBundler(this.transpiler, this.es6ModuleTranspiler, this.mode, this.sourceUrl, this.path, this.minifier, this.sourceMapCache, true);
    }

    public static void appendInput(Appendable out, DependencyInfo info, String contents) throws IOException {
        new ClosureBundler().appendTo(out, info, contents);
    }

    public void appendTo(Appendable out, DependencyInfo info, String content) throws IOException {
        this.appendTo(out, info, CharSource.wrap((CharSequence)content));
    }

    public void appendTo(Appendable out, DependencyInfo info, File content, Charset contentCharset) throws IOException {
        this.appendTo(out, info, Files.asCharSource((File)content, (Charset)contentCharset));
    }

    public void appendTo(Appendable out, DependencyInfo info, CharSource content) throws IOException {
        String code = content.read();
        if (info.isModule()) {
            this.mode.appendGoogModule(this.transpile(code), out, this.sourceUrl);
        } else if ("es6".equals(info.getLoadFlags().get((Object)"module")) && this.transpiler == Transpiler.NULL) {
            this.mode.appendTraditional(this.transpileEs6Module(code), out, this.sourceUrl);
        } else {
            this.mode.appendTraditional(this.transpile(code), out, this.sourceUrl);
        }
    }

    public void appendRuntimeTo(Appendable out) throws IOException {
        String runtime = this.transpiler.runtime();
        if (!runtime.isEmpty()) {
            this.mode.appendTraditional(runtime, out, null);
        }
        if (this.transpiler == Transpiler.NULL) {
            this.mode.appendTraditional(this.es6ModuleTranspiler.runtime(), out, null);
        }
        this.mode.appendTraditional("this.CLOSURE_EVAL_PREFILTER = function(s) { return s; };", out, null);
        this.mode.appendTraditional("(function(thisValue){", out, null);
        this.mode.appendTraditional("var isChrome87 = false; try {isChrome87 =  eval(trustedTypes.emptyScript) !== trustedTypes.emptyScript } catch (e) {} if (typeof trustedTypes !== 'undefined' && trustedTypes.createPolicy &&isChrome87 ) {", out, null);
        this.mode.appendTraditional("  var policy = trustedTypes.createPolicy('goog#devserver',{ createScript: function(s){ return s; }});", out, null);
        this.mode.appendTraditional("  thisValue.CLOSURE_EVAL_PREFILTER = policy.createScript.bind(policy);", out, null);
        this.mode.appendTraditional("}", out, null);
        this.mode.appendTraditional("})(this);", out, null);
    }

    public String getSourceMap(String path) {
        return Strings.nullToEmpty((String)this.sourceMapCache.get(path));
    }

    private String transpile(String s, Transpiler t) {
        TranspileResult result;
        try {
            result = t.transpile(new URI(this.path), s);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.sourceMapCache.put(this.path, result.sourceMap());
        return this.embedSourcemap ? result.embedSourcemapBase64().transpiled() : result.transpiled();
    }

    private String transpile(String s) {
        return this.transpile(s, this.transpiler);
    }

    private String transpileEs6Module(String s) {
        return this.transpile(s, this.es6ModuleTranspiler);
    }

    private static void appendSourceUrl(Appendable out, EscapeMode mode, String sourceUrl) throws IOException {
        if (sourceUrl == null) {
            return;
        }
        String toAppend = "\n//# sourceURL=" + sourceUrl + "\n";
        mode.append(toAppend, out);
    }

    private static enum EscapeMode {
        ESCAPED{

            @Override
            void append(String s, Appendable out) throws IOException {
                SourceCodeEscapers.appendWithJavascriptEscaper(s, out);
            }
        }
        ,
        NORMAL{

            @Override
            void append(String s, Appendable out) throws IOException {
                out.append(s);
            }
        };


        abstract void append(String var1, Appendable var2) throws IOException;
    }

    private static enum EvalMode {
        EVAL{

            @Override
            void appendTraditional(String s, Appendable out, String sourceUrl) throws IOException {
                out.append("eval(this.CLOSURE_EVAL_PREFILTER(\"");
                EscapeMode.ESCAPED.append(s, out);
                ClosureBundler.appendSourceUrl(out, EscapeMode.ESCAPED, sourceUrl);
                out.append("\"));\n");
            }

            @Override
            void appendGoogModule(String s, Appendable out, String sourceUrl) throws IOException {
                out.append("goog.loadModule(\"");
                EscapeMode.ESCAPED.append(s, out);
                ClosureBundler.appendSourceUrl(out, EscapeMode.ESCAPED, sourceUrl);
                out.append("\");\n");
            }
        }
        ,
        NORMAL{

            @Override
            void appendTraditional(String s, Appendable out, String sourceUrl) throws IOException {
                EscapeMode.NORMAL.append(s, out);
                ClosureBundler.appendSourceUrl(out, EscapeMode.NORMAL, sourceUrl);
            }

            @Override
            void appendGoogModule(String s, Appendable out, String sourceUrl) throws IOException {
                out.append("goog.loadModule(function(exports) {'use strict';");
                EscapeMode.NORMAL.append(s, out);
                out.append("\n;return exports;});\n");
                ClosureBundler.appendSourceUrl(out, EscapeMode.NORMAL, sourceUrl);
            }
        };


        abstract void appendTraditional(String var1, Appendable var2, @Nullable String var3) throws IOException;

        abstract void appendGoogModule(String var1, Appendable var2, String var3) throws IOException;
    }
}

