/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.nullness.Nullable;

class StripCode
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final ImmutableSet<String> stripNameSuffixes;
    private final ImmutableSet<String> stripNamePrefixes;
    private final IdentityHashMap<String, String> varsToRemove = new IdentityHashMap();
    private final String[] stripTypesList;
    private final String[] stripTypePrefixesList;
    private final String[] stripNamePrefixesLowerCaseList;
    private final String[] stripNameSuffixesLowerCaseList;
    static final DiagnosticType STRIP_TYPE_INHERIT_ERROR = DiagnosticType.error("JSC_STRIP_TYPE_INHERIT_ERROR", "Non-strip type {0} cannot inherit from strip type {1}");
    static final DiagnosticType STRIP_ASSIGNMENT_ERROR = DiagnosticType.error("JSC_STRIP_ASSIGNMENT_ERROR", "Unable to strip assignment to {0}");

    private static Stream<String> toStreamWithCollapsedVersions(String s) {
        ArrayList<String> possibleForms = new ArrayList<String>();
        possibleForms.add(s);
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '.') continue;
            chars[i] = 36;
            possibleForms.add(new String(chars));
        }
        return possibleForms.stream();
    }

    StripCode(AbstractCompiler compiler, ImmutableSet<String> stripTypes, ImmutableSet<String> stripNameSuffixes, ImmutableSet<String> stripNamePrefixes, boolean enableTweakStripping) {
        this.compiler = compiler;
        this.stripNameSuffixes = (ImmutableSet)stripNameSuffixes.stream().flatMap(StripCode::toStreamWithCollapsedVersions).collect(ImmutableSet.toImmutableSet());
        this.stripNamePrefixes = (ImmutableSet)stripNamePrefixes.stream().flatMap(StripCode::toStreamWithCollapsedVersions).collect(ImmutableSet.toImmutableSet());
        Stream<String> stripTypesStream = stripTypes.stream();
        if (enableTweakStripping) {
            stripTypesStream = Stream.concat(stripTypesStream, Stream.of("goog.tweak"));
        }
        ImmutableSet stripTypesAdjusted = (ImmutableSet)stripTypesStream.flatMap(StripCode::toStreamWithCollapsedVersions).collect(ImmutableSet.toImmutableSet());
        this.stripTypesList = (String[])stripTypesAdjusted.toArray((Object[])new String[0]);
        this.stripTypePrefixesList = (String[])stripTypesAdjusted.stream().flatMap(s -> Stream.of(s + ".", s + "$")).toArray(String[]::new);
        this.stripNamePrefixesLowerCaseList = (String[])this.stripNamePrefixes.stream().map(s -> s.toLowerCase(Locale.ROOT)).toArray(String[]::new);
        this.stripNameSuffixesLowerCaseList = (String[])this.stripNameSuffixes.stream().map(s -> s.toLowerCase(Locale.ROOT)).toArray(String[]::new);
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        try (LogFile decisionsLog = this.compiler.createOrReopenIndexedLog(this.getClass(), "decisions.log", new String[0]);){
            decisionsLog.log(new StripCodeConfigRecord());
            decisionsLog.log("\n=== decisions ===\n");
            NodeTraversal.traverse(this.compiler, root, new Strip(decisionsLog));
        }
    }

    private class Strip
    implements NodeTraversal.Callback {
        private final LogFile decisionsLog;

        private Strip(LogFile decisionsLog) {
            this.decisionsLog = decisionsLog;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CALL: 
                case NEW: {
                    if (this.isMethodOrCtorCallThatTriggersRemoval(t, n, parent)) {
                        this.decisionsLog.log(() -> "removing function call");
                        this.replaceHighestNestedCallWithNull(t, n, parent);
                        return false;
                    }
                    return true;
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case VAR: 
                case CONST: 
                case LET: {
                    this.removeVarDeclarationsByNameOrRvalue(t, n, parent);
                    break;
                }
                case NAME: {
                    this.maybeRemoveReferenceToRemovedVariable(t, n, parent);
                    break;
                }
                case ASSIGN: 
                case ASSIGN_BITOR: 
                case ASSIGN_BITXOR: 
                case ASSIGN_BITAND: 
                case ASSIGN_LSH: 
                case ASSIGN_RSH: 
                case ASSIGN_URSH: 
                case ASSIGN_ADD: 
                case ASSIGN_SUB: 
                case ASSIGN_MUL: 
                case ASSIGN_DIV: 
                case ASSIGN_MOD: {
                    this.maybeEliminateAssignmentByLvalueName(t, n, parent);
                    break;
                }
                case OBJECTLIT: {
                    this.eliminateKeysWithStripNamesFromObjLit(t, n);
                    break;
                }
                case EXPR_RESULT: {
                    this.maybeEliminateExpressionByName(n);
                    break;
                }
                case CLASS: {
                    this.maybeEliminateClassByNameOrExtends(t, n, parent);
                    break;
                }
            }
        }

        void removeVarDeclarationsByNameOrRvalue(NodeTraversal t, Node n, Node parent) {
            Node next = null;
            Node nameNode = n.getFirstChild();
            while (nameNode != null) {
                next = nameNode.getNext();
                if (!nameNode.isDestructuringLhs()) {
                    String possibleStripName;
                    Preconditions.checkState((boolean)nameNode.isName(), (Object)nameNode);
                    String name = nameNode.getString();
                    int lastDollarSign = name.lastIndexOf(36);
                    String string = possibleStripName = lastDollarSign != -1 ? name.substring(lastDollarSign + 1) : name;
                    if (this.isStripName(possibleStripName) || this.qualifiedNameBeginsWithStripType(nameNode) || this.isCallWhoseReturnValueShouldBeStripped(nameNode.getFirstChild())) {
                        StripCode.this.varsToRemove.put(name, name);
                        if (name.contains("$")) {
                            this.decisionsLog.log(() -> name + ": initialize with null (" + possibleStripName + ")");
                            if (nameNode.hasChildren()) {
                                this.replaceWithNull(nameNode.getOnlyChild());
                            } else {
                                nameNode.addChildToFront(IR.nullNode().srcref(nameNode));
                            }
                            t.reportCodeChange();
                        } else {
                            this.decisionsLog.log(() -> name + ": removing declaration");
                            nameNode.detach();
                            NodeUtil.markFunctionsDeleted(nameNode, StripCode.this.compiler);
                        }
                    }
                }
                nameNode = next;
            }
            if (!n.hasChildren()) {
                this.replaceWithEmpty(n, parent);
                t.reportCodeChange();
            }
        }

        void maybeRemoveReferenceToRemovedVariable(NodeTraversal t, Node n, Node parent) {
            switch (parent.getToken()) {
                case VAR: 
                case CONST: 
                case LET: {
                    break;
                }
                case GETPROP: 
                case GETELEM: {
                    if (parent.getFirstChild() != n || !this.isReferenceToRemovedVar(t, n)) break;
                    this.decisionsLog.log(() -> n.getString() + ": removing getelem/getprop/call chain");
                    this.replaceHighestNestedCallWithNull(t, parent, parent.getParent());
                    break;
                }
                case ASSIGN: 
                case ASSIGN_BITOR: 
                case ASSIGN_BITXOR: 
                case ASSIGN_BITAND: 
                case ASSIGN_LSH: 
                case ASSIGN_RSH: 
                case ASSIGN_URSH: 
                case ASSIGN_ADD: 
                case ASSIGN_SUB: 
                case ASSIGN_MUL: 
                case ASSIGN_DIV: 
                case ASSIGN_MOD: {
                    if (!this.isReferenceToRemovedVar(t, n)) break;
                    if (parent.getFirstChild() == n) {
                        Node grandparent = parent.getParent();
                        this.decisionsLog.log(() -> n.getQualifiedName() + ": removing assignment to stripped var");
                        if (grandparent.isExprResult()) {
                            Node greatGrandparent = grandparent.getParent();
                            this.replaceWithEmpty(grandparent, greatGrandparent);
                            t.reportCodeChange();
                            break;
                        }
                        Node rvalue = n.getNext();
                        rvalue.detach();
                        parent.replaceWith(rvalue);
                        t.reportCodeChange();
                        break;
                    }
                    this.decisionsLog.log(() -> n.getQualifiedName() + ": replacing rhs reference with null");
                    this.replaceWithNull(n);
                    t.reportCodeChange();
                    break;
                }
                case CALL: 
                case NEW: {
                    if (n.isFirstChildOf(parent) || !this.isReferenceToRemovedVar(t, n)) break;
                    this.decisionsLog.log(() -> n.getQualifiedName() + ": replacing parameter reference with null");
                    this.replaceWithNull(n);
                    t.reportCodeChange();
                    break;
                }
                case COMMA: {
                    boolean isSafeToRemove;
                    Node grandparent = parent.getParent();
                    boolean isLastChild = parent.getLastChild() == n;
                    boolean parentIsCallee = (grandparent.isCall() || grandparent.isNew()) && parent.isFirstChildOf(grandparent);
                    boolean bl = isSafeToRemove = !isLastChild || !parentIsCallee;
                    if (!isSafeToRemove || !this.isReferenceToRemovedVar(t, n)) break;
                    this.decisionsLog.log(() -> n.getQualifiedName() + ": replacing reference in comma expr with null");
                    this.replaceWithNull(n);
                    t.reportCodeChange();
                    break;
                }
                default: {
                    if (!this.isReferenceToRemovedVar(t, n)) break;
                    this.decisionsLog.log(() -> n.getQualifiedName() + ": replacing reference with null");
                    this.replaceWithNull(n);
                    t.reportCodeChange();
                }
            }
        }

        void replaceHighestNestedCallWithNull(NodeTraversal t, Node node, Node parent) {
            Node ancestor = parent;
            Node ancestorChild = node;
            while (true) {
                Node ancestorParent;
                if ((ancestorParent = ancestor.getParent()) == null) {
                    return;
                }
                if (ancestor.getFirstChild() != ancestorChild) {
                    this.replaceWithNull(ancestorChild);
                    break;
                }
                if (ancestor.isExprResult()) {
                    this.replaceWithEmpty(ancestor, ancestorParent);
                    break;
                }
                if (ancestor.isAssign()) {
                    ancestor.replaceWith(ancestor.getLastChild().detach());
                    break;
                }
                if (!NodeUtil.isNormalGet(ancestor) && !ancestor.isCall()) {
                    this.replaceWithNull(ancestorChild);
                    break;
                }
                ancestorChild = ancestor;
                ancestor = ancestorParent;
            }
            t.reportCodeChange();
        }

        void maybeEliminateAssignmentByLvalueName(NodeTraversal t, Node n, Node parent) {
            Node lvalue = n.getFirstChild();
            if (this.nameIncludesFieldNameToStrip(lvalue) || this.qualifiedNameBeginsWithStripType(lvalue)) {
                if (parent.isExprResult()) {
                    this.decisionsLog.log(() -> lvalue.getString() + ": removing assignment statement");
                    Node grandparent = parent.getParent();
                    if (grandparent != null) {
                        this.replaceWithEmpty(parent, grandparent);
                        StripCode.this.compiler.reportChangeToEnclosingScope(grandparent);
                    }
                } else {
                    t.report(n, STRIP_ASSIGNMENT_ERROR, lvalue.getQualifiedName());
                }
            }
        }

        void maybeEliminateExpressionByName(Node n) {
            Preconditions.checkArgument((boolean)n.isExprResult(), (Object)n);
            Node parent = n.getParent();
            if (parent == null) {
                return;
            }
            Node expression = n.getFirstChild();
            if (this.nameIncludesFieldNameToStrip(expression) || this.qualifiedNameBeginsWithStripType(expression)) {
                this.decisionsLog.log(() -> expression.getString() + ": removing property declaration statement");
                this.replaceWithEmpty(n, parent);
                StripCode.this.compiler.reportChangeToEnclosingScope(parent);
            }
        }

        void eliminateKeysWithStripNamesFromObjLit(NodeTraversal t, Node n) {
            Node key = n.getFirstChild();
            block3: while (key != null) {
                switch (key.getToken()) {
                    case GETTER_DEF: 
                    case SETTER_DEF: 
                    case STRING_KEY: 
                    case MEMBER_FUNCTION_DEF: {
                        if (!this.isStripName(key.getString())) break;
                        Node next = key.getNext();
                        key.detach();
                        NodeUtil.markFunctionsDeleted(key, StripCode.this.compiler);
                        key = next;
                        StripCode.this.compiler.reportChangeToEnclosingScope(n);
                        continue block3;
                    }
                }
                key = key.getNext();
            }
        }

        void maybeEliminateClassByNameOrExtends(NodeTraversal t, Node classNode, Node parent) {
            String superclassName;
            Node superclassNode;
            String className;
            Node nameNode = NodeUtil.getNameNode(classNode);
            if (nameNode != null && nameNode.isQualifiedName()) {
                className = nameNode.getQualifiedName();
                if (this.qualifiedNameBeginsWithStripType(className)) {
                    this.decisionsLog.log(() -> className + ": removing class");
                    if (NodeUtil.isStatementParent(parent)) {
                        this.replaceWithEmpty(classNode, parent);
                    } else {
                        this.replaceWithNull(classNode);
                    }
                    t.reportCodeChange();
                    return;
                }
            } else {
                className = "<anonymous>";
            }
            if ((superclassNode = classNode.getSecondChild()) != null && superclassNode.isQualifiedName() && this.qualifiedNameBeginsWithStripType(superclassName = superclassNode.getQualifiedName())) {
                t.report(classNode, STRIP_TYPE_INHERIT_ERROR, className, superclassName);
            }
        }

        boolean isCallWhoseReturnValueShouldBeStripped(@Nullable Node n) {
            if (n == null || !n.isCall() && !n.isNew() || !n.hasChildren()) {
                return false;
            }
            Node function = NodeUtil.getCallTargetResolvingIndirectCalls(n);
            return this.qualifiedNameBeginsWithStripType(function) || this.nameIncludesFieldNameToStrip(function);
        }

        boolean qualifiedNameBeginsWithStripType(Node n) {
            String name = n.getQualifiedName();
            return this.qualifiedNameBeginsWithStripType(name);
        }

        boolean qualifiedNameBeginsWithStripType(String name) {
            if (name != null) {
                for (String type : StripCode.this.stripTypesList) {
                    if (!name.equals(type)) continue;
                    this.logStripName(name, "equals strip type");
                    return true;
                }
                for (String type : StripCode.this.stripTypePrefixesList) {
                    if (!name.startsWith(type)) continue;
                    this.logStripName(name, "starts with strip type prefix");
                    return true;
                }
            }
            this.logNotAStripName(name, "does not begin with a strip type");
            return false;
        }

        boolean isReferenceToRemovedVar(NodeTraversal t, Node n) {
            return StripCode.this.varsToRemove.containsKey(n.getString());
        }

        boolean isMethodOrCtorCallThatTriggersRemoval(NodeTraversal t, Node n, Node parent) {
            Node grandparent;
            Node function = NodeUtil.getCallTargetResolvingIndirectCalls(n);
            if (function == null || !function.isQualifiedName()) {
                return false;
            }
            if (parent != null && parent.isName() && (grandparent = parent.getParent()) != null && NodeUtil.isNameDeclaration(grandparent)) {
                return false;
            }
            if (function.isName() && this.isStripName(function.getString())) {
                return true;
            }
            Node callee = function.getFirstChild();
            return this.nameIncludesFieldNameToStrip(callee) || this.nameIncludesFieldNameToStrip(function) || this.qualifiedNameBeginsWithStripType(function) || this.actsOnStripType(t, n);
        }

        boolean nameIncludesFieldNameToStrip(@Nullable Node n) {
            if (n == null) {
                return false;
            }
            if (n.isGetProp()) {
                return this.isStripName(n.getString()) || this.nameIncludesFieldNameToStrip(n.getFirstChild());
            }
            if (n.isName()) {
                String nameString = n.getString();
                if (nameString.indexOf(36) != -1) {
                    for (String part : nameString.split("\\$")) {
                        if (!this.isStripName(part)) continue;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        private boolean actsOnStripType(NodeTraversal t, Node callNode) {
            CodingConvention.SubclassRelationship classes = StripCode.this.compiler.getCodingConvention().getClassesDefinedByCall(callNode);
            if (classes != null) {
                if (this.qualifiedNameBeginsWithStripType(classes.subclassName)) {
                    this.logStripName(classes.subclassName, "class defining call");
                    return true;
                }
                if (this.qualifiedNameBeginsWithStripType(classes.superclassName)) {
                    t.report(callNode, STRIP_TYPE_INHERIT_ERROR, classes.subclassName, classes.superclassName);
                }
            }
            return false;
        }

        boolean isStripName(String name) {
            if (StripCode.this.stripNameSuffixes.contains((Object)name)) {
                this.logStripName(name, "matches a suffix");
                return true;
            }
            if (StripCode.this.stripNamePrefixes.contains((Object)name)) {
                this.logStripName(name, "matches a prefix");
                return true;
            }
            if (name.isEmpty() || Character.isUpperCase(name.charAt(0))) {
                this.logNotAStripName(name, "empty or starts with uppercase");
                return false;
            }
            String lcName = name.toLowerCase(Locale.ROOT);
            for (String stripName : StripCode.this.stripNamePrefixesLowerCaseList) {
                if (!lcName.startsWith(stripName)) continue;
                this.logStripName(name, () -> "matches lc prefix: " + stripName);
                return true;
            }
            for (String stripName : StripCode.this.stripNameSuffixesLowerCaseList) {
                if (!lcName.endsWith(stripName)) continue;
                this.logStripName(name, () -> "matches lc suffix: " + stripName);
                return true;
            }
            this.logNotAStripName(name, "no matches");
            return false;
        }

        private void logNotAStripName(String name, String reason) {
            if (this.decisionsLog.isLogging()) {
                this.decisionsLog.log(() -> name + "\tnot a strip name: " + reason);
            }
        }

        private void logStripName(String name, String reason) {
            if (this.decisionsLog.isLogging()) {
                this.decisionsLog.log(() -> name + "\tstrip name: " + reason);
            }
        }

        private void logStripName(String name, Supplier<String> reasonSupplier) {
            if (this.decisionsLog.isLogging()) {
                this.decisionsLog.log(() -> name + "\tstrip name: " + (String)reasonSupplier.get());
            }
        }

        void replaceWithNull(Node n) {
            this.decisionsLog.log(() -> "replace with null: " + n.getLocation());
            n.replaceWith(IR.nullNode());
            NodeUtil.markFunctionsDeleted(n, StripCode.this.compiler);
        }

        void replaceWithEmpty(Node n, Node parent) {
            this.decisionsLog.log(() -> "replace with empty: " + n.getLocation());
            NodeUtil.removeChild(parent, n);
            NodeUtil.markFunctionsDeleted(n, StripCode.this.compiler);
        }
    }

    private final class StripCodeConfigRecord
    implements Supplier<String> {
        private StripCodeConfigRecord() {
        }

        @Override
        public String get() {
            StringBuilder builder = new StringBuilder();
            builder.append("=== stripNameSuffixes ===\n");
            for (String stripNameSuffix : StripCode.this.stripNameSuffixes) {
                builder.append(stripNameSuffix).append("\n");
            }
            builder.append("\n");
            builder.append("=== stripNamePrefixes ===\n");
            for (String stripNamePrefix : StripCode.this.stripNamePrefixes) {
                builder.append(stripNamePrefix).append("\n");
            }
            builder.append("\n");
            builder.append("=== stripTypesList ===\n");
            for (String stripType : StripCode.this.stripTypesList) {
                builder.append(stripType).append("\n");
            }
            builder.append("\n");
            builder.append("=== stripTypePrefixesList ===\n");
            for (String stripNamePrefix : StripCode.this.stripTypePrefixesList) {
                builder.append(stripNamePrefix).append("\n");
            }
            builder.append("\n");
            return builder.toString();
        }
    }
}

