/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public final class RewriteNullishCoalesceOperator
implements NodeTraversal.Callback,
CompilerPass {
    private static final String TEMP_VAR_NAME_PREFIX = "$jscomp$nullish$tmp";
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final Supplier<String> uniqueNameIdSuppier;

    public RewriteNullishCoalesceOperator(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.uniqueNameIdSuppier = compiler.getUniqueNameIdSupplier();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, new ArrowRewriteCallBack(), externs, root);
        NodeTraversal.traverse(this.compiler, root, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, FeatureSet.Feature.NULL_COALESCE_OP, new FeatureSet.Feature[0]);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(n);
            return scriptFeatures == null || scriptFeatures.contains(FeatureSet.Feature.NULL_COALESCE_OP);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isNullishCoalesce()) {
            this.visitNullishCoalesce(t, n);
            t.reportCodeChange();
        }
    }

    private void visitNullishCoalesce(NodeTraversal t, Node n) {
        String tempVarName = TEMP_VAR_NAME_PREFIX + (String)this.uniqueNameIdSuppier.get();
        Node enclosingStatement = NodeUtil.getEnclosingStatement(n);
        Node left = n.removeFirstChild();
        Node right = n.getLastChild().detach();
        Node let = this.astFactory.createSingleLetNameDeclaration(tempVarName);
        Node assignName = this.astFactory.createName(tempVarName, AstFactory.type(left));
        Node assign = this.astFactory.createAssign(assignName, left);
        Node ne = this.astFactory.createNe(assign, this.astFactory.createNull());
        Node hookName = this.astFactory.createName(tempVarName, AstFactory.type(left));
        Node hook = this.astFactory.createHook(ne, hookName, right);
        let.srcrefTreeIfMissing(left);
        assignName.srcrefTreeIfMissing(left);
        assign.srcrefTreeIfMissing(left);
        ne.srcrefTreeIfMissing(left);
        hookName.srcrefTreeIfMissing(left);
        let.insertBefore(enclosingStatement);
        n.replaceWith(hook);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
        this.compiler.reportChangeToEnclosingScope(hook);
    }

    private class ArrowRewriteCallBack
    implements NodeTraversal.Callback {
        private ArrowRewriteCallBack() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isScript()) {
                FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(n);
                return scriptFeatures == null || scriptFeatures.contains(FeatureSet.Feature.NULL_COALESCE_OP);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isNullishCoalesce()) {
                return;
            }
            Node arrowOrBlock = NodeUtil.getEnclosingNode(n, (Predicate<Node>)((Predicate)node -> node.isArrowFunction() || node.isBlock()));
            if (arrowOrBlock != null && arrowOrBlock.isArrowFunction() && !NodeUtil.getFunctionBody(arrowOrBlock).isBlock()) {
                Node returnValue = NodeUtil.getFunctionBody(arrowOrBlock);
                Node body = IR.block(IR.returnNode(returnValue.detach()));
                body.srcrefTreeIfMissing(returnValue);
                arrowOrBlock.addChildToBack(body);
                RewriteNullishCoalesceOperator.this.compiler.reportChangeToEnclosingScope(body);
            }
        }
    }
}

