/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.List;

@GwtIncompatible(value="JsMessage")
class ReplaceMessagesForChrome
extends JsMessageVisitor {
    private final AstFactory astFactory;

    ReplaceMessagesForChrome(AbstractCompiler compiler, JsMessage.IdGenerator idGenerator) {
        super(compiler, idGenerator);
        this.astFactory = compiler.createAstFactory();
    }

    private Node getChromeI18nGetMessageNode(String messageId) {
        Node getMessage = this.astFactory.createQNameWithUnknownType("chrome.i18n.getMessage");
        return this.astFactory.createCall(getMessage, AstFactory.type(StandardColors.STRING), this.astFactory.createString(messageId));
    }

    @Override
    protected void processJsMessage(JsMessage message, JsMessageDefinition definition) {
        Node newValue = this.getNewValueNode(message, definition);
        definition.getMessageNode().replaceWith(newValue);
        this.compiler.reportChangeToEnclosingScope(newValue);
    }

    private Node getNewValueNode(JsMessage message, JsMessageDefinition definition) {
        Node newValueNode = this.getChromeI18nGetMessageNode(message.getId());
        boolean isHtml = definition.shouldEscapeLessThan();
        if (!message.jsPlaceholderNames().isEmpty() || isHtml) {
            List placeholderNames = Ordering.natural().sortedCopy(message.jsPlaceholderNames());
            Node placeholderValueArray = this.astFactory.createArraylit(new Node[0]);
            ImmutableMap<String, Node> placeholderValueMap = definition.getPlaceholderValueMap();
            for (String name : placeholderNames) {
                Node value = ((Node)Preconditions.checkNotNull((Object)((Node)placeholderValueMap.get((Object)name)))).cloneTree();
                placeholderValueArray.addChildToBack(value);
            }
            if (isHtml) {
                Node args = this.astFactory.createArraylit(this.astFactory.createString(message.getId()), placeholderValueArray);
                Node options = this.astFactory.createArraylit(this.astFactory.createObjectLit(this.astFactory.createStringKey("escapeLt", this.astFactory.createBoolean(true))));
                Node regexp = IR.regexp(this.astFactory.createString("Chrome\\/(\\d+)")).setColor(StandardColors.UNKNOWN);
                Node userAgent = this.astFactory.createQNameWithUnknownType("navigator.userAgent");
                Node version = this.astFactory.createGetElem(this.astFactory.createOr(this.astFactory.createCall(this.astFactory.createGetPropWithUnknownType(regexp, "exec"), AstFactory.type(StandardColors.ARRAY_ID), userAgent), this.astFactory.createArraylit(new Node[0])), this.astFactory.createNumber(1.0));
                Node condition = IR.ge(version, this.astFactory.createNumber(79.0)).setColor(StandardColors.BOOLEAN);
                args = this.astFactory.createCall(this.astFactory.createGetPropWithUnknownType(args, "concat"), AstFactory.type(StandardColors.ARRAY_ID), this.astFactory.createHook(condition, options, this.astFactory.createArraylit(new Node[0])));
                newValueNode = this.astFactory.createCallWithUnknownType(this.astFactory.createQNameWithUnknownType("chrome.i18n.getMessage.apply"), this.astFactory.createNull(), args);
            } else {
                newValueNode.addChildToBack(placeholderValueArray);
            }
        }
        newValueNode.srcrefTreeIfMissing(definition.getMessageNode());
        return newValueNode;
    }
}

